/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.CharConversionException;
import org.apache.xmlbeans.impl.piccolo.io.CharsetDecoder;
import org.apache.xmlbeans.impl.piccolo.xml.XMLDecoder;

public final class UTF8XMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new UTF8XMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 3;
    }

    public void reset() {
        this.sawCR = false;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int i;
        int o = 0;
        block5: for (i = 0; i < in_len && o < out_len; ++i) {
            int c = in_buf[in_off + i];
            if ((c & 0x80) != 0) {
                byte c3;
                if (++i >= in_len) {
                    result[0] = i - 1;
                    result[1] = o;
                    return;
                }
                byte c2 = in_buf[in_off + i];
                if ((c & 0xE0) == 192) {
                    if ((c2 & 0x80) != 128) {
                        throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c & 0xFF) + " 0x" + Integer.toHexString(c2 & 0xFF));
                    }
                    if (((c = (c & 0x1F) << 6 | c2 & 0x3F) & 0x780) == 0) {
                        throw new CharConversionException("2-byte UTF-8 character is overlong: 0x" + Integer.toHexString(in_buf[in_off + i - 1] & 0xFF) + " 0x" + Integer.toHexString(c2 & 0xFF));
                    }
                } else if ((c & 0xF0) == 224) {
                    if (++i >= in_len) {
                        result[0] = i - 2;
                        result[1] = o;
                        return;
                    }
                    c3 = in_buf[in_off + i];
                    if ((c2 & 0x80) != 128 || (c3 & 0x80) != 128) {
                        throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c & 0xFF) + " 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF));
                    }
                    if (((c = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F) & 0xF800) == 0) {
                        throw new CharConversionException("3-byte UTF-8 character is overlong: 0x" + Integer.toHexString(in_buf[in_off + i - 2] & 0xFF) + " 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF));
                    }
                } else {
                    if ((c & 0xF0) == 240) {
                        if (i + 2 >= in_len) {
                            result[0] = i - 2;
                            result[1] = o;
                            return;
                        }
                        c3 = in_buf[in_off + ++i];
                        byte c4 = in_buf[in_off + ++i];
                        if ((c2 & 0x80) != 128 || (c3 & 0x80) != 128 || (c4 & 0x80) != 128) {
                            throw new CharConversionException("Malformed UTF-8 character: 0x" + Integer.toHexString(c & 0xFF) + " 0x" + Integer.toHexString(c2 & 0xFF) + " 0x" + Integer.toHexString(c3 & 0xFF) + " 0x" + Integer.toHexString(c4 & 0xFF));
                        }
                        if ((c = (c & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F) < 65536 || c > 0x10FFFF) {
                            throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                        }
                        out_buf[out_off + o++] = (char)((c -= 65536) >> 10 | 0xD800);
                        out_buf[out_off + o++] = (char)(c & 0x3FF | 0xDC00);
                        this.sawCR = false;
                        continue;
                    }
                    throw new CharConversionException("Characters larger than 4 bytes are not supported: byte 0x" + Integer.toHexString(c & 0xFF) + " implies a length of more than 4 bytes");
                }
                if (c >= 55296 && c < 57344 || c == 65534 || c == 65535) {
                    throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
            if (c >= 32) {
                this.sawCR = false;
                out_buf[out_off + o++] = (char)c;
                continue;
            }
            switch (c) {
                case 10: {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case 13: {
                    this.sawCR = true;
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case 9: {
                    out_buf[out_off + o++] = 9;
                    continue block5;
                }
                default: {
                    throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                }
            }
        }
        result[0] = i;
        result[1] = o;
    }

    public void decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        byte c;
        int i;
        int o = 0;
        block5: for (i = 0; i < in_len && o < out_len && ((c = in_buf[in_off + i]) & 0x80) == 0; ++i) {
            if (c >= 32) {
                this.sawCR = false;
                out_buf[out_off + o++] = (char)c;
                if (c != 62) continue;
                break;
            }
            switch (c) {
                case 10: {
                    if (this.sawCR) {
                        this.sawCR = false;
                        continue block5;
                    }
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case 13: {
                    this.sawCR = true;
                    out_buf[out_off + o++] = 10;
                    continue block5;
                }
                case 9: {
                    out_buf[out_off + o++] = 9;
                    continue block5;
                }
            }
        }
        result[0] = ++i;
        result[1] = o;
    }
}

