/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.Extensionconfig;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.config.NameSet;
import org.apache.xmlbeans.impl.config.SchemaConfig;

public class InterfaceExtension {
    private NameSet _xbeanSet;
    private Class _interface;
    private Class _delegateToClass;
    private String _delegateToClassName;
    private Method[] _interfaceMethods;
    private Method[] _delegateToMethods;
    static final /* synthetic */ boolean $assertionsDisabled;

    static InterfaceExtension newInstance(NameSet xbeanSet, Extensionconfig.Interface intfXO) {
        InterfaceExtension result = new InterfaceExtension();
        result._xbeanSet = xbeanSet;
        result._interface = InterfaceExtension.validateInterface(intfXO.getName(), intfXO);
        if (result._interface == null) {
            SchemaConfig.error("Interface '" + intfXO.getStaticHandler() + "' not found.", intfXO);
            return null;
        }
        result._delegateToClassName = intfXO.getStaticHandler();
        result._delegateToClass = InterfaceExtension.validateClass(result._delegateToClassName, intfXO);
        if (result._delegateToClass == null) {
            SchemaConfig.warning("Handler class '" + intfXO.getStaticHandler() + "' not found on classpath, skip validation.", intfXO);
            return result;
        }
        if (!result.validateMethods(intfXO)) {
            return null;
        }
        return result;
    }

    private static Class validateInterface(String intfStr, XmlObject loc) {
        return InterfaceExtension.validateJava(intfStr, true, loc);
    }

    static Class validateClass(String clsStr, XmlObject loc) {
        return InterfaceExtension.validateJava(clsStr, false, loc);
    }

    static Class validateJava(String clsStr, boolean isInterface, XmlObject loc) {
        String ent = isInterface ? "Interface" : "Class";
        try {
            Class<?> cls = Class.forName(clsStr);
            if (isInterface && !cls.isInterface() || !isInterface && cls.isInterface()) {
                SchemaConfig.error("'" + clsStr + "' must be " + (isInterface ? "an interface" : "a class") + ".", loc);
            }
            if (!Modifier.isPublic(cls.getModifiers())) {
                SchemaConfig.error(ent + " '" + clsStr + "' is not public.", loc);
            }
            return cls;
        }
        catch (ClassNotFoundException e) {
            SchemaConfig.error(ent + " '" + clsStr + "' not found.", loc);
            return null;
        }
    }

    private boolean validateMethods(XmlObject loc) {
        if (!$assertionsDisabled && this._delegateToClass == null) {
            throw new AssertionError((Object)"Delegate to class handler expected.");
        }
        boolean valid = true;
        this._interfaceMethods = this._interface.getMethods();
        this._delegateToMethods = new Method[this._interfaceMethods.length];
        for (int i = 0; i < this._interfaceMethods.length; ++i) {
            valid &= this.validateMethod(i, this._interfaceMethods[i], loc);
        }
        return valid;
    }

    private boolean validateMethod(int index, Method method, XmlObject loc) {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        Class[] delegateParams = new Class[paramTypes.length + 1];
        delegateParams[0] = XmlObject.class;
        for (int i = 1; i < delegateParams.length; ++i) {
            delegateParams[i] = paramTypes[i - 1];
        }
        Method handlerMethod = null;
        try {
            handlerMethod = this._delegateToClass.getMethod(methodName, delegateParams);
            Class<?>[] intfExceptions = method.getExceptionTypes();
            Class<?>[] delegateExceptions = handlerMethod.getExceptionTypes();
            if (delegateExceptions.length != intfExceptions.length) {
                SchemaConfig.error("Handler method '" + this._delegateToClass.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")' must declare the same exceptions as the interface method '" + this._interface.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(paramTypes), loc);
                return false;
            }
            for (int i = 0; i < delegateExceptions.length; ++i) {
                if (delegateExceptions[i] == intfExceptions[i]) continue;
                SchemaConfig.error("Handler method '" + this._delegateToClass.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")' must declare the same exceptions as the interface method '" + this._interface.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(paramTypes), loc);
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            SchemaConfig.error("Handler class '" + this._delegateToClass.getName() + "' does not contain method " + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")", loc);
            return false;
        }
        catch (SecurityException e) {
            SchemaConfig.error("Security violation for class '" + this._interface.getName() + "' accesing method " + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")", loc);
            return false;
        }
        if (!Modifier.isPublic(handlerMethod.getModifiers()) || !Modifier.isStatic(handlerMethod.getModifiers())) {
            SchemaConfig.error("Method '" + this._delegateToClass.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")' must be declared public and static.", loc);
            return false;
        }
        if (!returnType.equals(handlerMethod.getReturnType())) {
            SchemaConfig.error("Return type for method '" + handlerMethod.getReturnType() + " " + this._delegateToClass.getName() + "." + methodName + "(" + InterfaceExtension.listTypes(delegateParams) + ")' does not match the return type of the interface method :'" + returnType + "'.", loc);
            return false;
        }
        this._delegateToMethods[index] = method;
        return true;
    }

    private static String listTypes(Class[] types) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            if (i > 0) {
                result.append(", ");
            }
            result.append(InterfaceExtension.emitType(type));
        }
        return result.toString();
    }

    public static String emitType(Class cls) {
        if (cls.isArray()) {
            return InterfaceExtension.emitType(cls.getComponentType()) + "[]";
        }
        return cls.getName().replace('$', '.');
    }

    public boolean contains(String fullJavaName) {
        return this._xbeanSet.contains(fullJavaName);
    }

    public String getInterfaceName() {
        return this._interface.getName();
    }

    public String getInterfaceNameForJavaSource() {
        return InterfaceExtension.emitType(this._interface);
    }

    public String getHandlerNameForJavaSource() {
        if (this._delegateToClass == null) {
            return null;
        }
        return InterfaceExtension.emitType(this._delegateToClass);
    }

    public int getInterfaceMethodCount() {
        return this._interfaceMethods.length;
    }

    public String getInterfaceMethodName(int methodIndex) {
        return this._interfaceMethods[methodIndex].getName();
    }

    public Method getInterfaceMethod(int methodIndex) {
        return this._interfaceMethods[methodIndex];
    }

    public String getInterfaceMethodDecl(int methodIndex) {
        StringBuffer sb = new StringBuffer();
        Method m = this._interfaceMethods[methodIndex];
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            sb.append(i == 0 ? "" : ", ");
            sb.append(InterfaceExtension.emitType(paramType) + " p" + i);
        }
        StringBuffer exceptions = new StringBuffer();
        Class<?>[] excClasses = m.getExceptionTypes();
        for (int i = 0; i < excClasses.length; ++i) {
            exceptions.append((i == 0 ? " throws " : ", ") + InterfaceExtension.emitType(excClasses[i]));
        }
        return "public " + InterfaceExtension.emitType(m.getReturnType()) + " " + m.getName() + "(" + sb.toString() + ")" + exceptions.toString();
    }

    public String getInterfaceMethodImpl(int methodIndex) {
        StringBuffer sb = new StringBuffer();
        if (!Void.TYPE.equals(this._interfaceMethods[methodIndex].getReturnType())) {
            sb.append("return ");
        }
        sb.append(this._delegateToClassName + "." + this._delegateToMethods[methodIndex].getName() + "(this");
        int paramCount = this._interfaceMethods[methodIndex].getParameterTypes().length;
        for (int i = 0; i < paramCount; ++i) {
            sb.append(", p" + i);
        }
        sb.append(");");
        return sb.toString();
    }

    static {
        $assertionsDisabled = !InterfaceExtension.class.desiredAssertionStatus();
    }
}

