/*
 * Decompiled with CFR 0.152.
 */
package repackage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.common.StringUtils;
import org.apache.xmlbeans.impl.regex.Match;
import org.apache.xmlbeans.impl.regex.RegularExpression;

public class Repackager {
    private List _fromPackages = new ArrayList();
    private List _toPackages = new ArrayList();
    private RegularExpression[] _fromPatterns;
    private String[] _toPackageNames;

    public Repackager(String repackageSpecs) {
        boolean swapped;
        String[] repackages = StringUtils.split(repackageSpecs, ';');
        do {
            swapped = false;
            int i = 1;
            while (i < repackages.length) {
                String spec1 = repackages[i - 1];
                String spec2 = repackages[i];
                if (spec1.indexOf(58) < spec2.indexOf(58)) {
                    repackages[i - 1] = spec2;
                    repackages[i] = spec1;
                    swapped = true;
                }
                ++i;
            }
        } while (swapped);
        int i = 0;
        while (i < repackages.length) {
            String spec = repackages[i];
            int j = spec.indexOf(58);
            if (j < 0 || spec.indexOf(58, j + 1) >= 0) {
                throw new RuntimeException("Illegal repackage specification: " + spec);
            }
            String from = spec.substring(0, j);
            String to = spec.substring(j + 1);
            this._fromPackages.add(StringUtils.split(from, '.'));
            this._toPackages.add(StringUtils.split(to, '.'));
            ++i;
        }
        this._fromPatterns = new RegularExpression[this._fromPackages.size() * 2];
        this._toPackageNames = new String[this._fromPackages.size() * 2];
        this.addPatterns('.', 0);
        this.addPatterns('/', this._fromPackages.size());
    }

    void addPatterns(char sep, int off) {
        int i = 0;
        while (i < this._fromPackages.size()) {
            List from = (List)this._fromPackages.get(i);
            List to = (List)this._toPackages.get(i);
            String pattern = "";
            int j = 0;
            while (j < from.size()) {
                if (j > 0) {
                    pattern = pattern + "\\" + sep;
                }
                pattern = pattern + from.get(j);
                ++j;
            }
            String toPackage = "";
            int j2 = 0;
            while (j2 < to.size()) {
                if (j2 > 0) {
                    toPackage = toPackage + sep;
                }
                toPackage = toPackage + to.get(j2);
                ++j2;
            }
            this._fromPatterns[off + i] = new RegularExpression(pattern);
            this._toPackageNames[off + i] = toPackage;
            ++i;
        }
    }

    public void repackage(StringBuffer sb) {
        int i = 0;
        while (i < this._fromPatterns.length) {
            Match matcher = new Match();
            boolean matches = this._fromPatterns[i].matches(sb.toString());
            if (matches) {
                StringUtils.replaceAll(matcher, sb, this._toPackageNames[i]);
            }
            ++i;
        }
    }

    public List getFromPackages() {
        return this._fromPackages;
    }

    public List getToPackages() {
        return this._toPackages;
    }

    public static String dirForPath(String path) {
        return new File(path).getParent();
    }
}

