/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.util;

import java.io.UnsupportedEncodingException;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable = new byte[255];
    private static byte[] lookUpHexAlphabet = new byte[16];

    static boolean isHex(byte octect) {
        return hexNumberTable[octect] != -1;
    }

    public static String bytesToString(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        return new String(HexBin.encode(binaryData));
    }

    public static byte[] stringToBytes(String hexEncoded) {
        return HexBin.decode(hexEncoded.getBytes());
    }

    public static byte[] encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        byte[] encodedData = new byte[lengthEncode];
        int i = 0;
        while (i < lengthData) {
            encodedData[i * 2] = lookUpHexAlphabet[binaryData[i] >> 4 & 0xF];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[binaryData[i] & 0xF];
            ++i;
        }
        return encodedData;
    }

    public static byte[] decode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            if (!HexBin.isHex(binaryData[i * 2]) || !HexBin.isHex(binaryData[i * 2 + 1])) {
                return null;
            }
            decodedData[i] = (byte)(hexNumberTable[binaryData[i * 2]] << 4 | hexNumberTable[binaryData[i * 2 + 1]]);
            ++i;
        }
        return decodedData;
    }

    public static String decode(String binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] decoded = null;
        try {
            try {
                decoded = HexBin.decode(binaryData.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Object var4_3 = null;
                return decoded == null ? null : new String(decoded);
            }
            Object var4_2 = null;
            return decoded == null ? null : new String(decoded);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return decoded == null ? null : new String(decoded);
        }
    }

    public static String encode(String binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] encoded = null;
        try {
            try {
                encoded = HexBin.encode(binaryData.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Object var4_3 = null;
                return encoded == null ? null : new String(encoded);
            }
            Object var4_2 = null;
            return encoded == null ? null : new String(encoded);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return encoded == null ? null : new String(encoded);
        }
    }

    static {
        int i = 0;
        while (i < 255) {
            HexBin.hexNumberTable[i] = -1;
            ++i;
        }
        int i2 = 57;
        while (i2 >= 48) {
            HexBin.hexNumberTable[i2] = (byte)(i2 - 48);
            --i2;
        }
        int i3 = 70;
        while (i3 >= 65) {
            HexBin.hexNumberTable[i3] = (byte)(i3 - 65 + 10);
            --i3;
        }
        int i4 = 102;
        while (i4 >= 97) {
            HexBin.hexNumberTable[i4] = (byte)(i4 - 97 + 10);
            --i4;
        }
        int i5 = 0;
        while (i5 < 10) {
            HexBin.lookUpHexAlphabet[i5] = (byte)(48 + i5);
            ++i5;
        }
        int i6 = 10;
        while (i6 <= 15) {
            HexBin.lookUpHexAlphabet[i6] = (byte)(65 + i6 - 10);
            ++i6;
        }
    }
}

