/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.internal.xmlbeans.wsdlsubst.DefinitionsDocument;
import org.apache.internal.xmlbeans.wsdlsubst.TImport;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.IOUtil;
import org.apache.xmlbeans.impl.common.SequencedHashMap;
import org.apache.xmlbeans.impl.tool.CodeGenUtil;
import org.w3.x2001.xmlSchema.ImportDocument;
import org.w3.x2001.xmlSchema.IncludeDocument;
import org.w3.x2001.xmlSchema.SchemaDocument;

public class SchemaCopy {
    private static final XmlOptions loadOptions = new XmlOptions().setLoadSubstituteNamespaces(Collections.singletonMap("http://schemas.xmlsoap.org/wsdl/", "http://www.apache.org/internal/xmlbeans/wsdlsubst"));

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: schemacopy sourceurl [targetfile]");
            return;
        }
        URL source = null;
        URL target = null;
        try {
            source = new URL(args[0]);
        }
        catch (Exception e) {
            System.err.println("Badly formed URL " + source);
            return;
        }
        if (args.length < 2) {
            try {
                URL dir = new File(".").getCanonicalFile().toURL();
                String lastPart = source.getPath();
                lastPart = lastPart.substring(lastPart.lastIndexOf(47) + 1);
                target = CodeGenUtil.resolve(dir, lastPart);
            }
            catch (Exception e) {
                System.err.println("Cannot canonicalize current directory");
                return;
            }
        }
        try {
            target = new URL(args[1]);
            if (!target.getProtocol().equals("file")) {
                target = null;
            }
        }
        catch (Exception e) {
            target = null;
        }
        if (target == null) {
            try {
                target = new File(args[1]).getCanonicalFile().toURL();
            }
            catch (Exception e) {
                System.err.println("Cannot canonicalize current directory");
                return;
            }
        }
        Map thingsToCopy = SchemaCopy.findAllRelative(source, target);
        SchemaCopy.copyAll(thingsToCopy, true);
    }

    private static void copyAll(Map uriMap, boolean stdout) {
        Iterator i = uriMap.keySet().iterator();
        while (i.hasNext()) {
            URL source = (URL)i.next();
            URL target = (URL)uriMap.get(source);
            try {
                IOUtil.copyCompletely(source, target);
            }
            catch (Exception e) {
                if (!stdout) continue;
                System.out.println("Could not copy " + source + " -> " + target);
                continue;
            }
            if (!stdout) continue;
            System.out.println("Copied " + source + " -> " + target);
        }
    }

    public static Map findAllRelative(URL source, URL target) {
        SequencedHashMap result = new SequencedHashMap();
        result.put(source, target);
        LinkedList<URL> process = new LinkedList<URL>();
        process.add(source);
        while (!process.isEmpty()) {
            URL nextSource = (URL)process.removeFirst();
            URL nextTarget = (URL)result.get(nextSource);
            Map nextResults = SchemaCopy.findRelativeInOne(nextSource, nextTarget);
            Iterator i = nextResults.keySet().iterator();
            while (i.hasNext()) {
                URL newSource = (URL)i.next();
                if (result.containsKey(newSource)) continue;
                result.put(newSource, nextResults.get(newSource));
                process.add(newSource);
            }
        }
        return result;
    }

    private static Map findRelativeInOne(URL source, URL target) {
        try {
            XmlObject xobj = XmlObject.Factory.parse(source, loadOptions);
            XmlCursor xcur = xobj.newCursor();
            xcur.toFirstChild();
            SequencedHashMap result = new SequencedHashMap();
            if (xobj instanceof SchemaDocument) {
                SchemaCopy.putMappingsFromSchema(result, source, target, ((SchemaDocument)xobj).getSchema());
            } else if (xobj instanceof DefinitionsDocument) {
                SchemaCopy.putMappingsFromWsdl(result, source, target, ((DefinitionsDocument)xobj).getDefinitions());
            }
            return result;
        }
        catch (Exception exception) {
            return Collections.EMPTY_MAP;
        }
    }

    private static void putNewMapping(Map result, URL origSource, URL origTarget, String literalURL) {
        if (literalURL == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(literalURL);
        }
        catch (MalformedURLException mue) {
            url = null;
        }
        if (url != null) {
            return;
        }
        URL newSource = CodeGenUtil.resolve(origSource, literalURL);
        URL newTarget = CodeGenUtil.resolve(origTarget, literalURL);
        if (newSource != null && newTarget != null) {
            result.put(newSource, newTarget);
        }
    }

    private static void putMappingsFromSchema(Map result, URL source, URL target, SchemaDocument.Schema schema) {
        ImportDocument.Import[] imports = schema.getImportArray();
        int i = 0;
        while (i < imports.length) {
            SchemaCopy.putNewMapping(result, source, target, imports[i].getSchemaLocation());
            ++i;
        }
        IncludeDocument.Include[] includes = schema.getIncludeArray();
        int i2 = 0;
        while (i2 < includes.length) {
            SchemaCopy.putNewMapping(result, source, target, includes[i2].getSchemaLocation());
            ++i2;
        }
    }

    private static void putMappingsFromWsdl(Map result, URL source, URL target, DefinitionsDocument.Definitions wdoc) {
        XmlObject[] types = wdoc.getTypesArray();
        int i = 0;
        while (i < types.length) {
            SchemaDocument.Schema[] schemas = (SchemaDocument.Schema[])types[i].selectPath("declare namespace xs='http://www.w3.org/2001/XMLSchema' xs:schema");
            int j = 0;
            while (j < schemas.length) {
                SchemaCopy.putMappingsFromSchema(result, source, target, schemas[j]);
                ++j;
            }
            ++i;
        }
        TImport[] imports = wdoc.getImportArray();
        int i2 = 0;
        while (i2 < imports.length) {
            SchemaCopy.putNewMapping(result, source, target, imports[i2].getLocation());
            ++i2;
        }
    }
}

