/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import org.apache.xmlbeans.XmlBeans;

public final class Text {
    char[] _buf;
    int _gap;
    int _gapLen;

    int length() {
        return this.bufLen() - this._gapLen;
    }

    private int bufLen() {
        return this._buf == null ? 0 : this._buf.length;
    }

    private void copy(char[] newBuf) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._buf != null && newBuf.length >= this.length());
        }
        System.arraycopy(this._buf, 0, newBuf, 0, this._gap);
        int lenAfterGap = this._buf.length - this._gap - this._gapLen;
        System.arraycopy(this._buf, this._gap + this._gapLen, newBuf, newBuf.length - lenAfterGap, lenAfterGap);
    }

    void resize(int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(cch > this._gapLen);
        }
        int newSize = this.length() + cch;
        int newLen = this._buf == null ? 1024 : this._buf.length * 2;
        while (newLen < newSize) {
            newLen *= 2;
        }
        char[] newBuf = new char[newLen];
        if (this._buf != null) {
            this.copy(newBuf);
            this._gapLen += newBuf.length - this._buf.length;
        } else {
            this._gapLen += newBuf.length;
        }
        this._buf = newBuf;
    }

    void trim() {
        if (this._buf != null && this._gapLen != 0) {
            char[] newBuf = new char[this.length()];
            this.copy(newBuf);
            this._buf = newBuf;
            this._gap = 0;
            this._gapLen = 0;
        }
    }

    void move(int pos, Text src, int srcPos, int cch) {
        this.insert(pos, src, srcPos, cch);
        if (src == this && srcPos >= pos) {
            srcPos += cch;
        }
        src.remove(srcPos, cch);
    }

    void insert(int pos, Object txt, int off, int cch) {
        if (txt != null) {
            if (txt instanceof String) {
                this.insert(pos, (String)txt, off, cch);
            } else if (txt instanceof Text) {
                this.insert(pos, (Text)txt, off, cch);
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(txt instanceof char[]);
                }
                this.insert(pos, (char[])txt, off, cch);
            }
        }
    }

    void insert(int pos, Text src, int srcPos, int cch) {
        if (cch > 0) {
            if (cch > this._gapLen) {
                this.resize(cch);
            }
            this.moveGap(pos);
            if (srcPos + cch < src._gap) {
                System.arraycopy(src._buf, srcPos, this._buf, this._gap, cch);
            } else if (srcPos >= src._gap) {
                System.arraycopy(src._buf, srcPos + src._gapLen, this._buf, this._gap, cch);
            } else {
                int leftLen = src._gap - srcPos;
                System.arraycopy(src._buf, srcPos, this._buf, this._gap, leftLen);
                System.arraycopy(src._buf, src._gap + src._gapLen, this._buf, this._gap + leftLen, cch - leftLen);
            }
            this._gap += cch;
            this._gapLen -= cch;
        }
    }

    void insert(int pos, char[] chars, int off, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(chars != this._buf);
            XmlBeans.assertTrue(pos >= 0 && pos <= this.length());
        }
        if (cch > 0) {
            if (cch > this._gapLen) {
                this.resize(cch);
            }
            this.moveGap(pos);
            System.arraycopy(chars, off, this._buf, this._gap, cch);
            this._gap += cch;
            this._gapLen -= cch;
        }
    }

    void insert(int pos, String s) {
        this.insert(pos, s, 0, s.length());
    }

    void insert(int pos, String s, int off, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pos >= 0 && pos <= this.length());
        }
        if (cch > 0) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(off >= 0 && off < s.length());
                XmlBeans.assertTrue(cch <= s.length() - off);
            }
            if (cch > this._gapLen) {
                this.resize(cch);
            }
            this.moveGap(pos);
            s.getChars(off, off + cch, this._buf, this._gap);
            this._gap += cch;
            this._gapLen -= cch;
        }
    }

    void remove(int pos, int cch) {
        this.remove(pos, cch, null, 0);
    }

    void remove(int pos, int cch, char[] retBuf, int off) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pos >= 0 && pos + cch <= this.length());
        }
        this.moveGap(pos);
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(retBuf == null || retBuf.length - off >= cch);
        }
        if (cch > 0 && retBuf != null) {
            System.arraycopy(this._buf, this._gap + this._gapLen, retBuf, off, cch);
        }
        this._gapLen += cch;
    }

    void moveGap(int pos) {
        if (pos < this._gap) {
            System.arraycopy(this._buf, pos, this._buf, pos + this._gapLen, this._gap - pos);
        } else if (pos > this._gap) {
            System.arraycopy(this._buf, this._gap + this._gapLen, this._buf, this._gap, pos - this._gap);
        }
        this._gap = pos;
    }

    int unObscure(int pos, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(cch >= 0);
            XmlBeans.assertTrue(pos >= 0 && pos + cch <= this.length());
        }
        if (cch > 0 && pos < this._gap && pos + cch > this._gap) {
            this.moveGap(pos + cch);
        }
        return pos < this._gap ? pos : pos + this._gapLen;
    }

    void fetch(StringBuffer sb, int pos, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pos >= 0 && pos + cch <= this.length());
        }
        if (cch == 0) {
            return;
        }
        if (pos + cch <= this._gap) {
            sb.append(this._buf, pos, cch);
        } else if (pos >= this._gap) {
            sb.append(this._buf, pos + this._gapLen, cch);
        } else {
            sb.append(this._buf, pos, this._gap - pos);
            sb.append(this._buf, this._gap + this._gapLen, cch - this._gap + pos);
        }
    }

    String fetch(int pos, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pos >= 0 && pos + cch <= this.length());
        }
        if (cch == 0) {
            return "";
        }
        if (pos + cch <= this._gap) {
            return new String(this._buf, pos, cch);
        }
        if (pos >= this._gap) {
            return new String(this._buf, pos + this._gapLen, cch);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._buf, pos, this._gap - pos);
        sb.append(this._buf, this._gap + this._gapLen, cch - this._gap + pos);
        return sb.toString();
    }

    void fetch(char[] buf, int off, int pos, int cch) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(off >= 0);
            XmlBeans.assertTrue(pos >= 0 && pos + cch <= this.length());
            XmlBeans.assertTrue(buf.length - off >= cch);
        }
        if (cch == 0) {
            return;
        }
        if (pos + cch <= this._gap) {
            System.arraycopy(this._buf, pos, buf, off, cch);
        } else if (pos >= this._gap) {
            System.arraycopy(this._buf, pos + this._gapLen, buf, off, cch);
        } else {
            int chunk = this._gap - pos;
            System.arraycopy(this._buf, pos, buf, off, chunk);
            System.arraycopy(this._buf, this._gap + this._gapLen, buf, off + chunk, cch - chunk);
        }
    }

    public String toString() {
        return this.fetch(0, this.length());
    }
}

