/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.common.Chars;
import org.apache.xmlbeans.impl.common.EncodingMap;
import org.apache.xmlbeans.impl.common.GenericXmlInputStream;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.SequencedHashMap;
import org.apache.xmlbeans.impl.common.ValidatorListener;
import org.apache.xmlbeans.impl.common.XmlEventBase;
import org.apache.xmlbeans.impl.common.XmlNameImpl;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Root;
import org.apache.xmlbeans.impl.store.Splay;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.xml.stream.Attribute;
import org.apache.xmlbeans.xml.stream.AttributeIterator;
import org.apache.xmlbeans.xml.stream.ChangePrefixMapping;
import org.apache.xmlbeans.xml.stream.CharacterData;
import org.apache.xmlbeans.xml.stream.Comment;
import org.apache.xmlbeans.xml.stream.EndDocument;
import org.apache.xmlbeans.xml.stream.EndElement;
import org.apache.xmlbeans.xml.stream.EndPrefixMapping;
import org.apache.xmlbeans.xml.stream.Location;
import org.apache.xmlbeans.xml.stream.ProcessingInstruction;
import org.apache.xmlbeans.xml.stream.StartDocument;
import org.apache.xmlbeans.xml.stream.StartElement;
import org.apache.xmlbeans.xml.stream.StartPrefixMapping;
import org.apache.xmlbeans.xml.stream.XMLEvent;
import org.apache.xmlbeans.xml.stream.XMLName;
import org.apache.xmlbeans.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Saver
implements NamespaceManager {
    private static ThreadLocal _threadDocumentBuilderFactory = new ThreadLocal(){

        protected Object initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
    };
    protected StringBuffer _text;
    protected StringBuffer _sb;
    protected boolean _skipContainerFinish;
    protected SequencedHashMap _attrs;
    private HashSet _attrNames;
    private final boolean _inner;
    private final Root _root;
    private final Splay _top;
    private final long _version;
    protected boolean _wantDupAttrs;
    protected boolean _wantFragTest;
    protected boolean _needsFrag;
    protected QName _fragment;
    protected QName _docElem;
    protected QName _synthElem;
    protected boolean _saveNamespacesFirst;
    protected boolean _useDefaultNamespace;
    private boolean _prettyPrint;
    private int _prettyIndent;
    private int _prettyOffset;
    private Splay _splay;
    private int _pos;
    private boolean _preProcess;
    private boolean _postProcess;
    private boolean _postPop;
    private Splay _endSplay;
    private ArrayList _namespaceStack;
    private int _currentMapping;
    private HashMap _uriMap;
    private HashMap _prefixMap;
    private boolean _firstPush;
    private String _initialDefaultUri;
    private Map _preComputedNamespaces;
    private String _filterProcinst;
    private Map _suggestedPrefixes;
    protected static String _newLine = System.getProperty("line.separator");

    private final Object saverMonitor() {
        return this._root;
    }

    Saver(Root r, Splay s, int p, XmlOptions options) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(Root.dv > 0 || s.getRootSlow() == r);
            XmlBeans.assertTrue(p < s.getEndPos());
        }
        this._root = r;
        this._top = this._splay = s;
        this._pos = p;
        this._version = r.getVersion();
        this._sb = new StringBuffer();
        this._attrs = new SequencedHashMap();
        this._attrNames = new HashSet();
        this._firstPush = true;
        this._namespaceStack = new ArrayList();
        this._uriMap = new HashMap();
        this._prefixMap = new HashMap();
        this.addMapping("xml", "http://www.w3.org/XML/1998/namespace");
        options = XmlOptions.maskNull(options);
        if (options.hasOption("SAVE_IMPLICIT_NAMESPACES")) {
            Map m = (Map)options.get("SAVE_IMPLICIT_NAMESPACES");
            Iterator i = m.keySet().iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                this.addMapping(prefix, (String)m.get(prefix));
            }
        }
        if (options.hasOption("SAVE_SUGGESTED_PREFIXES")) {
            this._suggestedPrefixes = (Map)options.get("SAVE_SUGGESTED_PREFIXES");
        }
        if (this.getNamespaceForPrefix("") == null) {
            this._initialDefaultUri = new String("");
            this.addMapping("", this._initialDefaultUri);
        }
        this._saveNamespacesFirst = options.hasOption("SAVE_NAMESPACES_FIRST");
        this._prettyPrint = options.hasOption("SAVE_PRETTY_PRINT");
        if (this._prettyPrint) {
            this._prettyIndent = 2;
            if (options.hasOption("SAVE_PRETTY_PRINT_INDENT")) {
                this._prettyIndent = (Integer)options.get("SAVE_PRETTY_PRINT_INDENT");
            }
            if (options.hasOption("SAVE_PRETTY_PRINT_OFFSET")) {
                this._prettyOffset = (Integer)options.get("SAVE_PRETTY_PRINT_OFFSET");
            }
        }
        if (options.hasOption("SAVE_AGGRESSIVE_NAMESPACES") && !(this instanceof SynthNamespaceSaver)) {
            SynthNamespaceSaver saver = new SynthNamespaceSaver(r, s, p, options);
            while (saver.process()) {
            }
            if (!saver._synthNamespaces.isEmpty()) {
                this._preComputedNamespaces = saver._synthNamespaces;
            }
        }
        this._useDefaultNamespace = options.hasOption("SAVE_USE_DEFAULT_NAMESPACE");
        if (options.hasOption("SAVE_FILTER_PROCINST")) {
            this._filterProcinst = (String)options.get("SAVE_FILTER_PROCINST");
        }
        this._fragment = options.hasOption("SAVE_USE_OPEN_FRAGMENT") ? Splay._openuriFragment : Splay._xmlFragment;
        boolean bl = this._inner = options.hasOption("SAVE_INNER") && !options.hasOption("SAVE_OUTER");
        if (this._inner && !this._top.isDoc()) {
            this._synthElem = this._fragment;
        } else if (options.hasOption("SAVE_SYNTHETIC_DOCUMENT_ELEMENT")) {
            this._fragment = this._synthElem = (QName)options.get("SAVE_SYNTHETIC_DOCUMENT_ELEMENT");
            if (this._synthElem == null) {
                throw new IllegalArgumentException("Null synthetic element");
            }
        }
        this._preProcess = true;
    }

    protected final void checkSaverVersion() {
        if (this._version != this._root.getVersion()) {
            throw new ConcurrentModificationException("Document changed during save");
        }
    }

    protected final Root getSaverRoot() {
        return this._root;
    }

    protected final Map getUriMap() {
        return this._uriMap;
    }

    protected final Map getPrefixMap() {
        return this._prefixMap;
    }

    protected abstract void emitXmlnsFragment(Splay var1);

    protected abstract void emitAttrFragment(Splay var1);

    protected abstract void emitTextFragment(Splay var1, int var2, int var3);

    protected abstract void emitCommentFragment(Splay var1);

    protected abstract void emitProcinstFragment(Splay var1);

    protected abstract void emitDocType(String var1, String var2, String var3);

    protected abstract void emitComment(Splay var1);

    protected abstract void emitTextAfter(Splay var1, int var2, int var3);

    protected abstract void emitEnd(Splay var1, QName var2);

    protected abstract void emitProcinst(Splay var1);

    protected abstract void emitContainer(Splay.Container var1, QName var2);

    protected void syntheticNamespace(String prefix, String uri, boolean considerCreatingDefault) {
    }

    final String text() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._text != null);
        }
        return this._text.toString();
    }

    final boolean noText() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._text != null || this._sb.length() == 0);
            XmlBeans.assertTrue(this._text == null || this._text == this._sb);
        }
        return this._text == null;
    }

    final void clearText() {
        this._text = null;
        this._sb.delete(0, this._sb.length());
    }

    static final void spaces(StringBuffer sb, int offset, int count) {
        while (count-- > 0) {
            sb.insert(offset, ' ');
        }
    }

    static final void trim(StringBuffer sb) {
        int i = 0;
        while (i < sb.length()) {
            if (!Splay.isWhiteSpace(sb.charAt(i))) break;
            ++i;
        }
        sb.delete(0, i);
        i = sb.length();
        while (i > 0) {
            if (!Splay.isWhiteSpace(sb.charAt(i - 1))) break;
            --i;
        }
        sb.delete(i, sb.length());
    }

    protected final boolean process() {
        Object object = this.saverMonitor();
        synchronized (object) {
            boolean bl;
            this.checkSaverVersion();
            if (this._preProcess) {
                this._preProcess = false;
                Splay s = this._splay;
                int p = this._pos;
                this._splay = null;
                this._pos = 0;
                if (p == 0 && s.isFinish() || s.isLeaf() && p == s.getPosLeafEnd()) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(this._splay == null);
                    }
                    this.processTextFragment(null, 0, 0);
                    boolean bl2 = true;
                    return bl2;
                }
                if (p > 0) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(!s.isLeaf() || p != s.getPosLeafEnd());
                    }
                    this.processTextFragment(s, p, s.getPostCch(p));
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(this._splay == null);
                    }
                    boolean bl3 = true;
                    return bl3;
                }
                if (this._inner && (s.isAttr() || s.isComment() || s.isProcinst())) {
                    this.processTextFragment(s, 0, s.getCchValue());
                    boolean bl4 = true;
                    return bl4;
                }
                if (s.isXmlns()) {
                    this.processXmlnsFragment(s);
                    boolean bl5 = true;
                    return bl5;
                }
                if (s.isAttr()) {
                    this.processAttrFragment(s);
                    boolean bl6 = true;
                    return bl6;
                }
                if (s.isComment()) {
                    this.processCommentFragment(s);
                    boolean bl7 = true;
                    return bl7;
                }
                if (s.isProcinst()) {
                    if (this._filterProcinst != null && s.getLocal().equals(this._filterProcinst)) {
                        this.processTextFragment(null, 0, 0);
                        boolean bl8 = true;
                        return bl8;
                    }
                    this.processProcinstFragment(s);
                    boolean bl9 = true;
                    return bl9;
                }
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(s.isContainer());
                }
                this._splay = s;
                Splay splay = this._endSplay = s.isContainer() ? s.getFinishSplay() : s;
            }
            if (this._postPop) {
                this.popMappings();
                this._postPop = false;
            }
            if (this._postProcess) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._splay != null);
                }
                boolean emitted = false;
                if (this._splay == this._endSplay) {
                    this._splay = null;
                } else {
                    Splay s = this._splay;
                    this._splay = this._splay.nextNonAttrSplay();
                    if (this._skipContainerFinish) {
                        if (XmlBeans.ASSERTS) {
                            XmlBeans.assertTrue(s.isBegin() && !s.isLeaf() && s.getCchAfter() == 0);
                            XmlBeans.assertTrue(this._splay.isFinish());
                        }
                        Splay splay = this._splay = this._splay == this._endSplay ? null : this._splay.nextSplay();
                    }
                    if (this._skipContainerFinish || s.isLeaf()) {
                        if (XmlBeans.ASSERTS) {
                            XmlBeans.assertTrue(!this._postPop);
                        }
                        this._postPop = true;
                    }
                    if (!s.isDoc()) {
                        if (XmlBeans.ASSERTS) {
                            XmlBeans.assertTrue(this.noText());
                        }
                        int cchAfter = s.getCchAfter();
                        if (this._prettyPrint) {
                            Splay.Container p;
                            Splay.Container stop;
                            this._text = this._sb;
                            if (cchAfter > 0) {
                                Root r = this.getSaverRoot();
                                r._text.fetch(this._text, s.getCpForPos(r, s.getPosAfter()), cchAfter);
                                Saver.trim(this._text);
                            }
                            if (!(stop = (Splay.Container)this._top).isDoc()) {
                                stop = stop.getContainer();
                            }
                            Splay.Container c = s.getContainer(s.getPosAfter());
                            if (this._text.length() > 0) {
                                p = c;
                                while (p != stop) {
                                    Saver.spaces(this._text, 0, this._prettyIndent);
                                    p = p.getContainer();
                                }
                                if (this._prettyIndent >= 0) {
                                    this._text.insert(0, _newLine);
                                    Saver.spaces(this._text, 1, this._prettyOffset);
                                }
                            }
                            if (this._prettyIndent >= 0) {
                                this._text.append(_newLine);
                                Saver.spaces(this._text, this._text.length(), this._prettyOffset);
                            }
                            p = c;
                            if (s.nextNonAttrSplay().isEnd()) {
                                p = p.getContainer();
                            }
                            while (p != null && p != stop) {
                                Saver.spaces(this._text, this._text.length(), this._prettyIndent);
                                p = p.getContainer();
                            }
                        }
                        boolean bl10 = this._text == null ? cchAfter > 0 : this._text.length() > 0;
                        if (bl10) {
                            this.emitTextAfter(s, s.getPosAfter(), cchAfter);
                            emitted = true;
                        }
                        this.clearText();
                    }
                }
                this._postProcess = false;
                if (emitted) {
                    bl = true;
                    return bl;
                }
                if (this._postPop) {
                    this.popMappings();
                    this._postPop = false;
                }
            }
            if (this._splay == null) {
                boolean bl11 = false;
                return bl11;
            }
            if (this._version != this.getSaverRoot().getVersion()) {
                throw new IllegalStateException("Document changed");
            }
            this._skipContainerFinish = false;
            switch (this._splay.getKind()) {
                case 0: 
                case 1: {
                    this.processContainer((Splay.Container)this._splay);
                    break;
                }
                case 5: 
                case 6: {
                    this.processEnd(this._splay);
                    break;
                }
                case 3: {
                    this.emitComment(this._splay);
                    break;
                }
                case 4: {
                    if (this._filterProcinst != null && this._splay.getLocal().equals(this._filterProcinst)) break;
                    this.emitProcinst(this._splay);
                    break;
                }
                default: {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(false, "Unexpected splay kind " + this._splay.getKind());
                    }
                    bl = false;
                    return bl;
                }
            }
            this._postProcess = true;
            bl = true;
            return bl;
        }
    }

    private final void processContainer(Splay.Container c) {
        String nameUri;
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(c.isDoc() || c.isBegin());
        }
        QName name = this._synthElem != null && c == this._top ? this._synthElem : (c.isBegin() ? c.getName() : null);
        String string = nameUri = name == null ? null : name.getNamespaceURI();
        if (c.isDoc()) {
            String systemId = this._root._props.getDoctypeSystemId();
            String docTypeName = this._root._props.getDoctypeName();
            if (systemId != null || docTypeName != null) {
                if (docTypeName == null && name != null) {
                    docTypeName = name.getLocalPart();
                }
                if (docTypeName == null) {
                    XmlCursor xc = this._root.createCursor();
                    if (xc.toFirstChild()) {
                        docTypeName = xc.getName().getLocalPart();
                    }
                    xc.dispose();
                }
                if (docTypeName == null && this._fragment != null) {
                    docTypeName = this._fragment.getLocalPart();
                }
                String publicId = this._root._props.getDoctypePublicId();
                this.emitDocType(docTypeName, publicId, systemId);
            }
        }
        boolean ensureDefaultEmpty = name != null && nameUri.length() == 0;
        this.pushMappings(c, ensureDefaultEmpty);
        if (name != null) {
            this.ensureMapping(nameUri, null, !ensureDefaultEmpty, false);
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.noText());
        }
        if (c.isInvalid()) {
            this._text = this._sb.append(c.peekType().build_text(this));
        }
        this._attrs.clear();
        this._attrNames.clear();
        Splay s = c.nextSplay();
        while (s.isAttr()) {
            if (s.isNormalAttr() && (this._wantDupAttrs || !this._attrNames.contains(s.getName()))) {
                this._attrNames.add(s.getName());
                this.ensureMapping(s.getUri(), null, false, true);
                String invalidValue = null;
                if (s.isInvalid()) {
                    invalidValue = s.peekType().build_text(this);
                }
                this._attrs.put(s, invalidValue);
            }
            s = s.nextSplay();
        }
        if (this._prettyPrint && (c.isDoc() || c.isLeaf())) {
            if (this._text == null) {
                Root r = this.getSaverRoot();
                this._text = this._sb;
                r._text.fetch(this._text, r.getCp(c), c.isLeaf() ? c.getCchValue() : c.getCch());
            }
            Saver.trim(this._text);
            if (c.isDoc()) {
                Saver.spaces(this._text, 0, this._prettyOffset);
                if (this._text.length() > this._prettyOffset && this._prettyIndent >= 0) {
                    this._text.insert(0, _newLine);
                    Saver.spaces(this._text, 1, this._prettyOffset);
                    this._text.append(_newLine);
                    Saver.spaces(this._text, this._text.length(), this._prettyOffset);
                }
            }
        }
        if (this._wantFragTest && name == null) {
            if (this._text != null && !Splay.isWhiteSpace(this._text) || !c.isAfterWhiteSpace(this.getSaverRoot())) {
                this._needsFrag = true;
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(!c.isLeaf());
                }
                Splay s2 = c.nextSplay();
                if (c.isLeaf() || s2.isAttr() || this.hasMappings()) {
                    this._needsFrag = true;
                } else {
                    boolean sawBegin = false;
                    Splay cEnd = c.getFinishSplay();
                    while (s2 != cEnd) {
                        if (s2.isBegin()) {
                            if (sawBegin) {
                                this._needsFrag = true;
                                break;
                            }
                            sawBegin = true;
                            s2 = s2.getFinishSplay();
                        }
                        if (!s2.isAfterWhiteSpace(this.getSaverRoot())) {
                            this._needsFrag = true;
                            break;
                        }
                        s2 = s2.nextSplay();
                    }
                    if (!sawBegin) {
                        this._needsFrag = true;
                    }
                }
            }
        }
        if (this._preComputedNamespaces != null && (name != null || this._needsFrag)) {
            Iterator i = this._preComputedNamespaces.keySet().iterator();
            while (i.hasNext()) {
                String uri;
                this.ensureMapping(uri, null, this._preComputedNamespaces.get(uri = (String)i.next()) != null && !ensureDefaultEmpty, false);
            }
            this._preComputedNamespaces = null;
        }
        if (this._wantFragTest) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(name != null || c.isDoc() && this._synthElem == null);
            }
            if (name == null) {
                if (this._needsFrag) {
                    name = this._fragment;
                    this.ensureFragmentNamespace();
                    this._docElem = name;
                }
            } else if (c.isDoc()) {
                this._docElem = name;
            }
        }
        this.emitContainer(c, name);
        this.clearText();
    }

    private void processEnd(Splay s) {
        boolean isRoot;
        QName name;
        Splay.Container c = s.getContainer();
        QName qName = this._synthElem != null && c == this._top ? this._synthElem : (name = c.isBegin() ? c.getName() : null);
        if (this._wantFragTest && name == null && (!(isRoot = s.isRoot()) || this._docElem != null)) {
            name = isRoot ? this._docElem : (s.isEnd() ? s.getContainer() : s).getName();
        }
        this.emitEnd(this._splay, name);
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(!this._postPop);
        }
        this._postPop = true;
    }

    private final void pushFragmentMappings(Splay s) {
        this.pushMappings(s == null ? null : s.getContainer(), this._fragment.getNamespaceURI().length() == 0);
        this.ensureFragmentNamespace();
    }

    private final void processXmlnsFragment(Splay s) {
        if (s.getLocal().length() == 0) {
            this.pushFragmentMappings(null);
            this._text = this._sb;
            this.emitTextFragment(s, 0, 0);
        } else {
            this.pushFragmentMappings(null);
            this.ensureMapping(s.getUri(), s.getLocal(), false, true);
            this.emitXmlnsFragment(s);
        }
    }

    private final void processCommentFragment(Splay s) {
        this.pushFragmentMappings(null);
        this.emitCommentFragment(s);
    }

    private final void processProcinstFragment(Splay s) {
        this.pushFragmentMappings(null);
        this.emitProcinstFragment(s);
    }

    private final void processAttrFragment(Splay s) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(s.isNormalAttr());
        }
        this.pushFragmentMappings(s);
        this.ensureMapping(s.getUri(), null, false, true);
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.noText());
        }
        if (s.isInvalid()) {
            this._text = this._sb.append(s.peekType().build_text(this));
        }
        this.emitAttrFragment(s);
        this.clearText();
    }

    private final void processTextFragment(Splay s, int p, int cch) {
        Splay.Container c = null;
        if (this._text != null && this._text.length() > 0 || s != null && cch > 0) {
            c = s.getContainer(p);
        }
        this.pushFragmentMappings(c);
        this.emitTextFragment(s, p, cch);
    }

    boolean hasMappings() {
        int i = this._namespaceStack.size();
        return i > 0 && this._namespaceStack.get(i - 1) != null;
    }

    void iterateMappings() {
        this._currentMapping = this._namespaceStack.size();
        while (this._currentMapping > 0 && this._namespaceStack.get(this._currentMapping - 1) != null) {
            this._currentMapping -= 8;
        }
    }

    boolean hasMapping() {
        return this._currentMapping < this._namespaceStack.size();
    }

    void nextMapping() {
        this._currentMapping += 8;
    }

    String mappingPrefix() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.hasMapping());
        }
        return (String)this._namespaceStack.get(this._currentMapping + 6);
    }

    String mappingUri() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.hasMapping());
        }
        return (String)this._namespaceStack.get(this._currentMapping + 7);
    }

    String mappingPrevPrefixUri() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.hasMapping());
        }
        return (String)this._namespaceStack.get(this._currentMapping + 5);
    }

    private final void pushMappings(Splay.Container c, boolean ensureDefaultEmpty) {
        this._namespaceStack.add(null);
        while (c != null) {
            Splay s = c.nextSplay();
            while (s.isAttr()) {
                block9: {
                    if (s.isXmlns()) {
                        Splay.Xmlns x = (Splay.Xmlns)s;
                        String prefix = x.getLocal();
                        String uri = x.getUri();
                        if (!ensureDefaultEmpty || prefix.length() != 0 || uri.length() <= 0) {
                            this.iterateMappings();
                            while (this.hasMapping()) {
                                if (!this.mappingPrefix().equals(prefix)) {
                                    this.nextMapping();
                                    continue;
                                }
                                break block9;
                            }
                            this.addMapping(prefix, uri);
                        }
                    }
                }
                s = s.nextSplay();
            }
            if (!this._firstPush) break;
            c = c.getContainer();
        }
        if (ensureDefaultEmpty) {
            String defaultUri = (String)this._prefixMap.get("");
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(defaultUri != null);
            }
            if (defaultUri.length() > 0) {
                this.addMapping("", "");
            }
        }
        this._firstPush = false;
    }

    private final void dumpMappings() {
        int i = this._namespaceStack.size();
        while (i > 0) {
            if (this._namespaceStack.get(i - 1) == null) {
                System.out.println("----------------");
                --i;
                continue;
            }
            System.out.print("Mapping: ");
            System.out.print(this._namespaceStack.get(i - 2));
            System.out.print(" -> ");
            System.out.print(this._namespaceStack.get(i - 1));
            System.out.println();
            System.out.print("Prefix Undo: ");
            System.out.print(this._namespaceStack.get(i - 4));
            System.out.print(" -> ");
            System.out.print(this._namespaceStack.get(i - 3));
            System.out.println();
            System.out.print("Uri Rename: ");
            System.out.print(this._namespaceStack.get(i - 5));
            System.out.print(" -> ");
            System.out.print(this._namespaceStack.get(i - 6));
            System.out.println();
            System.out.print("UriUndo: ");
            System.out.print(this._namespaceStack.get(i - 7));
            System.out.print(" -> ");
            System.out.print(this._namespaceStack.get(i - 8));
            System.out.println();
            System.out.println();
            i -= 8;
        }
    }

    private final void addMapping(String prefix, String uri) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(uri != null);
            XmlBeans.assertTrue(prefix != null);
        }
        String renameUri = (String)this._prefixMap.get(prefix);
        String renamePrefix = null;
        if (renameUri != null) {
            if (renameUri.equals(uri)) {
                renameUri = null;
            } else {
                int i = this._namespaceStack.size();
                while (i > 0) {
                    if (this._namespaceStack.get(i - 1) == null) {
                        --i;
                        continue;
                    }
                    if (this._namespaceStack.get(i - 7).equals(renameUri) && ((renamePrefix = (String)this._namespaceStack.get(i - 8)) == null || !renamePrefix.equals(prefix))) break;
                    i -= 8;
                }
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(i > 0);
                }
            }
        }
        this._namespaceStack.add(this._uriMap.get(uri));
        this._namespaceStack.add(uri);
        if (renameUri != null) {
            this._namespaceStack.add(this._uriMap.get(renameUri));
            this._namespaceStack.add(renameUri);
        } else {
            this._namespaceStack.add(null);
            this._namespaceStack.add(null);
        }
        this._namespaceStack.add(prefix);
        this._namespaceStack.add(this._prefixMap.get(prefix));
        this._namespaceStack.add(prefix);
        this._namespaceStack.add(uri);
        this._uriMap.put(uri, prefix);
        this._prefixMap.put(prefix, uri);
        if (renameUri != null) {
            this._uriMap.put(renameUri, renamePrefix);
        }
    }

    private final void popMappings() {
        int i;
        while ((i = this._namespaceStack.size()) != 0) {
            if (this._namespaceStack.get(i - 1) == null) {
                this._namespaceStack.remove(i - 1);
                break;
            }
            Object oldUri = this._namespaceStack.get(i - 7);
            Object oldPrefix = this._namespaceStack.get(i - 8);
            if (oldPrefix == null) {
                this._uriMap.remove(oldUri);
            } else {
                this._uriMap.put(oldUri, oldPrefix);
            }
            oldPrefix = this._namespaceStack.get(i - 4);
            oldUri = this._namespaceStack.get(i - 3);
            if (oldUri == null) {
                this._prefixMap.remove(oldPrefix);
            } else {
                this._prefixMap.put(oldPrefix, oldUri);
            }
            String uri = (String)this._namespaceStack.get(i - 5);
            if (uri != null) {
                this._uriMap.put(uri, this._namespaceStack.get(i - 6));
            }
            this._namespaceStack.remove(i - 1);
            this._namespaceStack.remove(i - 2);
            this._namespaceStack.remove(i - 3);
            this._namespaceStack.remove(i - 4);
            this._namespaceStack.remove(i - 5);
            this._namespaceStack.remove(i - 6);
            this._namespaceStack.remove(i - 7);
            this._namespaceStack.remove(i - 8);
        }
    }

    protected final String getUriMapping(String uri) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._uriMap.get(uri) != null);
        }
        return (String)this._uriMap.get(uri);
    }

    protected final boolean tryPrefix(String prefix) {
        if (prefix == null || Splay.beginsWithXml(prefix)) {
            return false;
        }
        String existingUri = (String)this._prefixMap.get(prefix);
        return existingUri == null || prefix.length() <= 0 && existingUri == this._initialDefaultUri;
    }

    protected final String ensureMapping(String uri, String candidatePrefix, boolean considerCreatingDefault, boolean mustHavePrefix) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(uri != null);
            XmlBeans.assertTrue(candidatePrefix == null || candidatePrefix.length() > 0);
        }
        if (uri.length() == 0) {
            return null;
        }
        String prefix = (String)this._uriMap.get(uri);
        if (!(prefix == null || prefix.length() <= 0 && mustHavePrefix)) {
            return prefix;
        }
        if (candidatePrefix == null || !this.tryPrefix(candidatePrefix)) {
            if (this._suggestedPrefixes != null && this._suggestedPrefixes.containsKey(uri) && this.tryPrefix((String)this._suggestedPrefixes.get(uri))) {
                candidatePrefix = (String)this._suggestedPrefixes.get(uri);
            } else if (considerCreatingDefault && this._useDefaultNamespace && this.tryPrefix("")) {
                candidatePrefix = "";
            } else {
                String basePrefix;
                candidatePrefix = basePrefix = QNameHelper.suggestPrefix(uri);
                int i = 1;
                while (!this.tryPrefix(candidatePrefix)) {
                    candidatePrefix = basePrefix + i;
                    ++i;
                }
            }
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(candidatePrefix != null);
        }
        this.syntheticNamespace(candidatePrefix, uri, considerCreatingDefault);
        this.addMapping(candidatePrefix, uri);
        return candidatePrefix;
    }

    public final String find_prefix_for_nsuri(String uri, String prefix) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(uri != null);
            XmlBeans.assertTrue(prefix == null || prefix.length() > 0);
        }
        boolean emptyUri = uri.length() == 0;
        return this.ensureMapping(uri, prefix, emptyUri, !emptyUri);
    }

    public final String getNamespaceForPrefix(String prefix) {
        if (prefix != null && prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return (String)this._prefixMap.get(prefix);
    }

    protected final String ensureFragmentNamespace() {
        if (this._fragment.getNamespaceURI().length() == 0) {
            return "";
        }
        return this.ensureMapping(this._fragment.getNamespaceURI(), "frag", false, false);
    }

    static {
        if (_newLine == null) {
            _newLine = "\n";
        }
    }

    static final class DomSaver
    extends Saver {
        Document _doc;
        Node _currentNode;
        boolean _createDoc;

        DomSaver(Root r, Splay s, int p, boolean createDoc, XmlOptions options) {
            super(r, s, p, options);
            this._createDoc = createDoc;
        }

        Node exportDom() throws Exception {
            Node result;
            this._doc = ((DocumentBuilder)_threadDocumentBuilderFactory.get()).newDocument();
            if (this._createDoc) {
                this._currentNode = this._doc;
                result = this._currentNode;
            } else {
                DocumentFragment frag = this._doc.createDocumentFragment();
                this._currentNode = frag;
                result = this._currentNode;
            }
            while (this.process()) {
            }
            return result;
        }

        protected void emitContainer(Splay.Container c, QName name) {
            Root r = this.getSaverRoot();
            if (c.isDoc()) {
                if (this.hasMappings()) {
                    throw new IllegalStateException("Namespace attribute not associated with an element");
                }
                Splay s = c.nextSplay();
                while (s.isAttr()) {
                    if (s.isNormalAttr()) {
                        throw new IllegalStateException("Attribute not associated with an element");
                    }
                    s = s.nextSplay();
                }
                String text = null;
                if (this._text != null) {
                    if (this._text.length() > 0) {
                        text = this.text();
                    }
                } else if (c.getCch() > 0) {
                    text = r._text.fetch(0, c.getCch());
                }
                if (text != null && this._currentNode != this._doc) {
                    this._currentNode.insertBefore(this._doc.createTextNode(text), null);
                }
            } else {
                String prefix;
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isBegin());
                }
                String qname = c.getLocal();
                if (c.getUri().length() > 0 && (prefix = this.getUriMapping(c.getUri())).length() > 0) {
                    qname = prefix + ":" + qname;
                }
                Element e = this._doc.createElementNS(c.getUri(), qname);
                this._currentNode.insertBefore(e, null);
                this.iterateMappings();
                while (this.hasMapping()) {
                    String prefix2 = this.mappingPrefix();
                    qname = prefix2.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
                    e.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, this.mappingUri());
                    this.nextMapping();
                }
                Iterator i = this._attrs.keySet().iterator();
                while (i.hasNext()) {
                    String prefix3;
                    Splay s = (Splay)i.next();
                    qname = s.getLocal();
                    if (s.getUri().length() > 0 && (prefix3 = this.getUriMapping(s.getUri())).length() > 0) {
                        qname = prefix3 + ":" + qname;
                    }
                    String invalidAttrValue = (String)this._attrs.get(s);
                    e.setAttributeNS(s.getUri(), qname, invalidAttrValue == null ? s.getText(r) : invalidAttrValue);
                }
                if (c.isLeaf()) {
                    String text = null;
                    if (this._text != null) {
                        if (this._text.length() > 0) {
                            text = this.text();
                        }
                    } else if (c.getCchValue() > 0) {
                        text = r._text.fetch(c.getCpForPos(r, 1), c.getCchValue());
                    }
                    if (text != null) {
                        e.insertBefore(this._doc.createTextNode(text), null);
                    }
                } else {
                    this._currentNode = e;
                }
            }
        }

        protected void emitEnd(Splay s, QName name) {
            this._currentNode = this._currentNode.getParentNode();
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(cch > 0);
            }
            Root r = this.getSaverRoot();
            String text = null;
            if (this._text != null) {
                if (this._text.length() > 0) {
                    text = this.text();
                }
            } else if (cch > 0) {
                text = r._text.fetch(s.getCpForPos(r, p), cch);
            }
            if (this._currentNode != this._doc) {
                this._currentNode.insertBefore(this._doc.createTextNode(text), null);
            }
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
        }

        protected void emitComment(Splay s) {
            Root r = this.getSaverRoot();
            this._currentNode.insertBefore(this._doc.createComment(r._text.fetch(s.getCpForPos(r, 0), s.getCchValue())), null);
        }

        protected void emitProcinst(Splay s) {
            Root r = this.getSaverRoot();
            this._currentNode.insertBefore(this._doc.createProcessingInstruction(s.getLocal(), r._text.fetch(s.getCpForPos(r, 0), s.getCchValue())), null);
        }

        protected void emitXmlnsFragment(Splay s) {
            throw new IllegalStateException("Cannot create a node for a namespace attribute");
        }

        protected void emitAttrFragment(Splay s) {
            throw new IllegalStateException("Cannot create a node for a attribute");
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
            if (s != null) {
                Root r = this.getSaverRoot();
                this._currentNode.insertBefore(this._doc.createTextNode(this._text != null ? this._text.toString() : (s != null ? r._text.fetch(s.getCpForPos(r, p), cch) : "")), null);
            }
        }

        protected void emitCommentFragment(Splay s) {
            Root r = this.getSaverRoot();
            this._currentNode.insertBefore(this._doc.createComment(r._text.fetch(s.getCpForPos(r, 0), s.getCchValue())), null);
        }

        protected void emitProcinstFragment(Splay s) {
            Root r = this.getSaverRoot();
            this._currentNode.insertBefore(this._doc.createProcessingInstruction(s.getLocal(), r._text.fetch(s.getCpForPos(r, 0), s.getCchValue())), null);
        }
    }

    static final class SaxSaver
    extends Saver {
        private AttributesImpl _attributes = new AttributesImpl();
        private SAXException _saxException;
        private ContentHandler _contentHandler;
        private LexicalHandler _lexicalhandler;

        SaxSaver(Root r, Splay s, int p, XmlOptions options, ContentHandler contentHandler, LexicalHandler lexicalhandler) throws SAXException {
            super(r, s, p, options);
            this._wantFragTest = true;
            this._contentHandler = contentHandler;
            this._lexicalhandler = lexicalhandler;
            this._contentHandler.startDocument();
            try {
                while (this.process()) {
                }
            }
            catch (SaverSAXException e) {
                throw e._saxException;
            }
            this._contentHandler.endDocument();
        }

        private void throwSaxException(SAXException e) {
            throw new SaverSAXException(e);
        }

        protected void emitContainer(Splay.Container c, QName name) {
            if (c.isBegin()) {
                this.emitContainerHelper(c, name, null, null);
                if (c.isLeaf()) {
                    int cch;
                    int n = cch = this._text == null ? c.getCchValue() : this._text.length();
                    if (cch > 0) {
                        if (this._text == null) {
                            this.emitCharacters(c, 0, cch);
                        } else {
                            this.emitCharacters(this._text);
                        }
                    }
                    this.emitEndElement(c.getName());
                }
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isDoc());
                }
                if (name != null) {
                    this.emitContainerHelper(c, name, null, null);
                }
                if (this._text == null) {
                    this.emitCharacters(c, 0, c.getCch());
                } else {
                    this.emitCharacters(this._text);
                }
            }
        }

        private void emitAttrHelper(Splay s, String value) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(s.isNormalAttr());
            }
            String local = s.getLocal();
            String uri = s.getUri();
            this._attributes.addAttribute(s.getUri(), s.getLocal(), this.getPrefixedName(s.getName()), "CDATA", value == null ? s.getText(this.getSaverRoot()) : value);
        }

        private void addNamespaceAttr(String prefix, String uri) {
            try {
                this._contentHandler.startPrefixMapping(prefix, uri);
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
            if (prefix.length() == 0) {
                this._attributes.addAttribute("", "", "xmlns", "CDATA", uri);
            } else {
                this._attributes.addAttribute("", "", "xmlns:" + prefix, "CDATA", uri);
            }
        }

        private void emitNamespacesHelper() {
            this.iterateMappings();
            while (this.hasMapping()) {
                this.addNamespaceAttr(this.mappingPrefix(), this.mappingUri());
                this.nextMapping();
            }
        }

        private void emitContainerHelper(Splay.Container c, QName name, Splay extraAttr, StringBuffer extraAttrText) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(name != null);
            }
            this._attributes.clear();
            if (this._saveNamespacesFirst) {
                this.emitNamespacesHelper();
            }
            Iterator i = this._attrs.keySet().iterator();
            while (i.hasNext()) {
                Splay s = (Splay)i.next();
                this.emitAttrHelper(s, (String)this._attrs.get(s));
            }
            if (extraAttr != null) {
                this.emitAttrHelper(extraAttr, extraAttrText == null ? null : extraAttrText.toString());
            }
            if (!this._saveNamespacesFirst) {
                this.emitNamespacesHelper();
            }
            this.emitElement(name, this.getPrefixedName(name));
        }

        private void emitCharacters(char[] buf, int off, int cch) {
            try {
                this._contentHandler.characters(buf, off, cch);
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
        }

        private void emitCharacters(Splay s, int p, int cch) {
            this.emitCharacters(s.getCpForPos(this.getSaverRoot(), p), cch);
        }

        private void emitCharacters(int cp, int cch) {
            if (cch == 0) {
                return;
            }
            this.emitCharacters(this.getSaverRoot()._text._buf, this.getSaverRoot()._text.unObscure(cp, cch), cch);
        }

        private void emitCharacters(StringBuffer sb) {
            if (sb.length() == 0) {
                return;
            }
            String text = sb.toString();
            this.emitCharacters(text.toCharArray(), 0, text.length());
        }

        private void emitEndElement(QName name) {
            try {
                this._contentHandler.endElement(name.getNamespaceURI(), name.getLocalPart(), this.getPrefixedName(name));
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
            this.iterateMappings();
            while (this.hasMapping()) {
                try {
                    this._contentHandler.endPrefixMapping(this.mappingPrefix());
                }
                catch (SAXException e) {
                    this.throwSaxException(e);
                }
                this.nextMapping();
            }
        }

        private void endNamespaces() {
            try {
                int i = 0;
                while (i < this._attributes.getLength()) {
                    String qn = this._attributes.getQName(i);
                    if (qn.startsWith("xmlns")) {
                        int j = qn.indexOf(58);
                        if (j >= 0) {
                            this._contentHandler.endPrefixMapping(qn.substring(j + 1));
                        } else {
                            this._contentHandler.endPrefixMapping("");
                        }
                    }
                    ++i;
                }
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
        }

        private String getPrefixedName(QName name) {
            String ns = name.getNamespaceURI();
            String lp = name.getLocalPart();
            if (ns.length() == 0) {
                return lp;
            }
            String prefix = this.getUriMapping(ns);
            if (prefix.length() == 0) {
                return lp;
            }
            return prefix + ":" + lp;
        }

        private void emitElement(QName name, String prefixedName) {
            try {
                this._contentHandler.startElement(name.getNamespaceURI(), name.getLocalPart(), this.getPrefixedName(name), this._attributes);
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
        }

        protected void emitEnd(Splay s, QName name) {
            if (name != null) {
                this.emitEndElement(name);
            }
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
            if (this._text == null) {
                this.emitCharacters(s, p, cch);
            } else {
                this.emitCharacters(this._text);
            }
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
            if (this._lexicalhandler != null) {
                try {
                    this._lexicalhandler.startDTD(doctypeName, publicID, systemID);
                    this._lexicalhandler.endDTD();
                }
                catch (SAXException e) {
                    this.throwSaxException(e);
                }
            }
        }

        protected void emitComment(Splay s) {
            if (this._lexicalhandler != null) {
                int cp = this.getSaverRoot().getCp(s);
                int cch = s.getCchValue();
                try {
                    this._lexicalhandler.comment(this.getSaverRoot()._text._buf, this.getSaverRoot()._text.unObscure(cp, cch), cch);
                }
                catch (SAXException e) {
                    this.throwSaxException(e);
                }
            }
        }

        protected void emitProcinst(Splay s) {
            try {
                this._contentHandler.processingInstruction(s.getLocal(), s.getText(this.getSaverRoot()));
            }
            catch (SAXException e) {
                this.throwSaxException(e);
            }
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
            this.emitContainerHelper(null, this._fragment, null, null);
            if (this._text != null) {
                if (this._text.length() > 0) {
                    this.emitCharacters(this._text);
                }
            } else if (s != null && cch > 0) {
                this.emitCharacters(s, p, cch);
            }
            this.emitEndElement(this._fragment);
        }

        protected void emitXmlnsFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null);
            this.emitEndElement(this._fragment);
        }

        protected void emitAttrFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, s, this._text);
            this.emitEndElement(this._fragment);
        }

        protected void emitCommentFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null);
            this.emitComment(s);
            this.emitEndElement(this._fragment);
        }

        protected void emitProcinstFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null);
            this.emitProcinst(s);
            this.emitEndElement(this._fragment);
        }

        private class SaverSAXException
        extends RuntimeException {
            SAXException _saxException;

            SaverSAXException(SAXException e) {
                this._saxException = e;
            }
        }
    }

    static final class ValidatorSaver
    extends Saver
    implements ValidatorListener.Event {
        private ValidatorListener _vEventSink;
        private Splay _startSplay;
        private boolean _emittedText;
        private QName _name;
        private Splay _xsiType;
        private Splay _xsiNil;
        private Splay _xsiLoc;
        private Splay _xsiNoLoc;
        private String _eventText;
        private Splay _sText;
        private int _pText;
        private Splay _sLoc;
        private int _pLoc;
        private boolean _hasText;

        ValidatorSaver(Root r, Splay s, int p, XmlOptions options, ValidatorListener vEventSink) {
            super(r, s, p, options);
            this._wantDupAttrs = true;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(p == 0);
            }
            this._startSplay = s;
            this._vEventSink = vEventSink;
            while (this.process()) {
            }
        }

        protected void emitXmlnsFragment(Splay s) {
            throw new IllegalStateException();
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
            throw new IllegalStateException();
        }

        protected void emitCommentFragment(Splay s) {
            throw new IllegalStateException();
        }

        protected void emitProcinstFragment(Splay s) {
            throw new IllegalStateException();
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
            if (this._text == null) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(cch > 0);
                }
                this.emitEvent(3, s, p, null, s, p);
            } else {
                this.emitEvent(3, s, p, null, this.text());
            }
        }

        protected void emitEnd(Splay s, QName name) {
            this.emitEvent(2, s, 0);
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
        }

        protected void emitComment(Splay s) {
            if (s.getCchAfter() > 0) {
                this.emitEvent(3, s, 0, null, s, 1);
            }
        }

        protected void emitProcinst(Splay s) {
            if (s.getCchAfter() > 0) {
                this.emitEvent(3, s, 0, null, s, 1);
            }
        }

        protected void emitAttrFragment(Splay s) {
            this.emitEvent(1, s, 0, null);
            if (this._text != null) {
                if (this._text.length() > 0) {
                    this.emitEvent(3, s, 0, null, this.text());
                }
            } else if (s.getCch() > 0) {
                this.emitEvent(3, s, 0, null, s, 0);
            }
            this.emitEvent(2, s, 0);
        }

        protected void emitContainer(Splay.Container c, QName name) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._xsiNoLoc == null);
                XmlBeans.assertTrue(this._xsiLoc == null);
                XmlBeans.assertTrue(this._xsiType == null);
                XmlBeans.assertTrue(this._xsiNil == null);
            }
            Splay s = c.nextSplay();
            while (s.isAttr()) {
                if (s.isXsiAttr()) {
                    String local = s.getLocal();
                    if (local.equals("type")) {
                        this._xsiType = s;
                    } else if (local.equals("nil")) {
                        this._xsiNil = s;
                    } else if (local.equals("schemaLocation")) {
                        this._xsiLoc = s;
                    } else if (local.equals("noNamespaceSchemaLocation")) {
                        this._xsiNoLoc = s;
                    }
                }
                s = s.nextSplay();
            }
            this.emitEvent(1, c, 0, c == this._startSplay ? null : name);
            this._xsiNil = null;
            this._xsiType = null;
            this._xsiLoc = null;
            this._xsiNoLoc = null;
            Iterator i = this._attrs.keySet().iterator();
            while (i.hasNext()) {
                String local;
                Splay s2 = (Splay)i.next();
                if (s2.isXsiAttr() && ((local = s2.getLocal()).equals("type") || local.equals("nil") || local.equals("schemaLocation") || local.equals("noNamespaceSchemaLocation"))) continue;
                String invalidAttrValue = (String)this._attrs.get(s2);
                if (invalidAttrValue == null) {
                    this.emitEvent(4, s2, 0, s2.getName(), s2, 0);
                    continue;
                }
                this.emitEvent(4, s2, 0, s2.getName(), invalidAttrValue);
            }
            this.emitEvent(5, c, 0);
            if (c.isDoc()) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isDoc());
                }
                if (this._text != null) {
                    if (this._text.length() > 0) {
                        this.emitEvent(3, c, 1, null, this.text());
                    }
                } else if (c.getCch() > 0) {
                    this.emitEvent(3, c, 1, null, c, 1);
                }
            } else if (c.isLeaf()) {
                int cch;
                int n = cch = this._text != null ? this._text.length() : c.getCchValue();
                if (cch > 0) {
                    if (this._text != null) {
                        this.emitEvent(3, c, 1, null, this.text());
                    } else {
                        this.emitEvent(3, c, 1, null, c, 1);
                    }
                }
                this.emitEvent(2, c, c.getPosLeafEnd());
            }
        }

        protected void emitEvent(int kind, Splay sLoc, int pLoc) {
            this.emitEvent(kind, sLoc, pLoc, null, null, 0, null);
        }

        protected void emitEvent(int kind, Splay sLoc, int pLoc, QName name) {
            this.emitEvent(kind, sLoc, pLoc, name, null, 0, null);
        }

        protected void emitEvent(int kind, Splay sLoc, int pLoc, QName name, String text) {
            this.emitEvent(kind, sLoc, pLoc, name, null, 0, text);
        }

        protected void emitEvent(int kind, Splay sLoc, int pLoc, QName name, Splay sText, int pText) {
            this.emitEvent(kind, sLoc, pLoc, name, sText, pText, null);
        }

        protected void emitEvent(int kind, Splay sLoc, int pLoc, QName name, Splay sText, int pText, String text) {
            boolean hasText;
            if (kind == 3 && this._emittedText) {
                return;
            }
            boolean bl = hasText = text != null || sText != null;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(!hasText || kind == 4 || kind == 3);
                XmlBeans.assertTrue(kind != 4 || hasText);
                XmlBeans.assertTrue(kind != 3 || hasText);
                XmlBeans.assertTrue(kind != 4 || name != null);
            }
            this._name = name;
            this._sText = sText;
            this._pText = pText;
            this._eventText = text;
            this._hasText = hasText;
            this._sLoc = sLoc;
            this._pLoc = pLoc;
            this._vEventSink.nextEvent(kind, this);
            this._emittedText = kind == 3;
        }

        public XmlCursor getLocationAsCursor() {
            this.checkSaverVersion();
            return new Cursor(this.getSaverRoot(), this._sLoc, this._pLoc);
        }

        public boolean getXsiType(Chars chars) {
            if (this._xsiType == null) {
                return false;
            }
            this.setChars(chars, 1, null, this._xsiType, 0);
            return true;
        }

        public boolean getXsiNil(Chars chars) {
            if (this._xsiNil == null) {
                return false;
            }
            this.setChars(chars, 1, null, this._xsiNil, 0);
            return true;
        }

        public boolean getXsiLoc(Chars chars) {
            if (this._xsiLoc == null) {
                return false;
            }
            this.setChars(chars, 1, null, this._xsiLoc, 0);
            return true;
        }

        public boolean getXsiNoLoc(Chars chars) {
            if (this._xsiNoLoc == null) {
                return false;
            }
            this.setChars(chars, 1, null, this._xsiNoLoc, 0);
            return true;
        }

        public QName getName() {
            return this._name;
        }

        /*
         * Unable to fully structure code
         */
        private void setChars(Chars chars, int wsr, String string, Splay sText, int pText) {
            block21: {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(string != null || sText != null);
                }
                this.checkSaverVersion();
                r = this.getSaverRoot();
                chars.buffer = null;
                chars.string = null;
                if (string != null) {
                    chars.string = string;
                } else if (pText == 0) {
                    chars.buffer = r._text._buf;
                    chars.length = sText.getCch();
                    chars.offset = r._text.unObscure(r.getCp(sText), chars.length);
                } else if (pText == 1 && sText.isLeaf()) {
                    chars.buffer = r._text._buf;
                    chars.length = sText.getCchValue();
                    chars.offset = r._text.unObscure(r.getCp(sText), chars.length);
                } else {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(pText == sText.getPosAfter());
                    }
                    moreText = false;
                    t = sText.nextNonAttrSplay();
                    while (t.isComment() || t.isProcinst()) {
                        if (t.getCchAfter() > 0) {
                            moreText = true;
                            break;
                        }
                        t = t.nextSplay();
                    }
                    if (!moreText) {
                        chars.buffer = r._text._buf;
                        chars.length = sText.getCchAfter();
                        chars.offset = r._text.unObscure(sText.getCpForPos(r, pText), chars.length);
                    } else {
                        sb = new StringBuffer();
                        cch = sText.getCchAfter();
                        off = r._text.unObscure(sText.getCpForPos(r, pText), cch);
                        sb.append(r._text._buf, off, cch);
                        t = sText.nextNonAttrSplay();
                        while (t.isComment() || t.isProcinst()) {
                            if (t.getCchAfter() > 0) {
                                cch = t.getCchAfter();
                                off = r._text.unObscure(t.getCpForPos(r, 1), cch);
                                sb.append(r._text._buf, off, cch);
                            }
                            t = t.nextSplay();
                        }
                        chars.length = sb.length();
                        chars.buffer = new char[chars.length];
                        chars.offset = 0;
                        sb.getChars(0, chars.length, chars.buffer, 0);
                    }
                }
                if (wsr == 1) break block21;
                str = chars.asString();
                sb = new StringBuffer();
                state = -1;
                nSpaces = 0;
                cch = str.length();
                i = 0;
                while (i < cch) {
                    ch = str.charAt(i);
                    if (ch == '\n' || ch == '\r' || ch == '\t') {
                        ch = ' ';
                    }
                    if (wsr != 3) ** GOTO lbl77
                    if (ch == ' ') {
                        if (state != -1) {
                            ++nSpaces;
                        }
                    } else {
                        if (nSpaces > 1) {
                            nSpaces = 1;
                        }
                        while (nSpaces > 0) {
                            sb.append(' ');
                            --nSpaces;
                        }
                        state = 0;
lbl77:
                        // 2 sources

                        sb.append(ch);
                    }
                    ++i;
                }
                chars.string = sb.toString();
                chars.buffer = null;
            }
        }

        public void getText(Chars chars) {
            this.getText(chars, 1);
        }

        public void getText(Chars chars, int wsr) {
            if (!this._hasText) {
                throw new RuntimeException("No text for this event");
            }
            this.setChars(chars, wsr, this._eventText, this._sText, this._pText);
        }

        public boolean textIsWhitespace() {
            Chars chars = new Chars();
            this.getText(chars);
            String s = chars.asString();
            int i = 0;
            while (i < s.length()) {
                switch (s.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }

    static final class XmlInputStreamImpl
    extends GenericXmlInputStream {
        private XmlInputStreamSaver _xmlInputStreamSaver;

        XmlInputStreamImpl(Root r, Splay s, int p, XmlOptions options) {
            this._xmlInputStreamSaver = new XmlInputStreamSaver(r, s, p, options);
            this._xmlInputStreamSaver.process();
        }

        protected XMLEvent nextEvent() throws XMLStreamException {
            return this._xmlInputStreamSaver.dequeue();
        }
    }

    static final class XmlInputStreamSaver
    extends Saver {
        private XmlEventImpl _in;
        private XmlEventImpl _out;

        XmlInputStreamSaver(Root r, Splay s, int p, XmlOptions options) {
            super(r, s, p, options);
        }

        XMLEvent dequeue() throws XMLStreamException {
            if (this._out == null && !this.process()) {
                return null;
            }
            if (this._out == null) {
                return null;
            }
            XmlEventImpl e = this._out;
            this._out = this._out._next;
            if (this._out == null) {
                this._in = null;
            }
            return e;
        }

        private void enqueue(XmlEventImpl e) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(e._next == null);
            }
            if (this._in == null) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._out == null);
                }
                this._out = this._in = e;
            } else {
                this._in._next = e;
                this._in = e;
            }
        }

        protected void emitXmlnsFragment(Splay s) {
            throw new IllegalStateException("Can't stream an attribute");
        }

        protected void emitText(Splay s, int p, int cch) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(cch > 0);
            }
            this.enqueue(new CharacterDataImpl(this.getSaverRoot(), s, p, null));
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
            if (this._text != null) {
                if (this._text.length() > 0) {
                    this.emitText(s, p, cch);
                }
                return;
            }
            if (s != null && cch > 0) {
                this.emitText(s, p, cch);
            }
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
            if (this._text == null) {
                this.emitText(s, p, cch);
            } else {
                this.enqueue(new CharacterDataImpl(this.getSaverRoot(), s, -1, this.text()));
            }
        }

        protected void emitEndPrefixMappings() {
            Root r = this.getSaverRoot();
            this.iterateMappings();
            while (this.hasMapping()) {
                String prevPrefixUri = this.mappingPrevPrefixUri();
                if (prevPrefixUri == null) {
                    this.enqueue(new EndPrefixMappingImpl(r, this.mappingPrefix()));
                } else {
                    this.enqueue(new ChangePrefixMappingImpl(r, this.mappingPrefix(), this.mappingUri(), prevPrefixUri));
                }
                this.nextMapping();
            }
        }

        protected void emitEnd(Splay s, QName name) {
            Root r = this.getSaverRoot();
            if (s.isRoot()) {
                this.enqueue(new EndDocumentImpl(r, s));
            } else if (s.isEnd()) {
                this.enqueue(new EndElementImpl(r, s, name, this.getUriMap()));
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(s.isLeaf());
                }
                this.enqueue(new EndElementImpl(r, s, name, this.getUriMap()));
            }
            this.emitEndPrefixMappings();
        }

        protected void emitCommentFragment(Splay s) {
            this.emitComment(s);
        }

        protected void emitProcinstFragment(Splay s) {
            this.emitProcinst(s);
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
        }

        protected void emitComment(Splay s) {
            this.enqueue(new CommentImpl(this.getSaverRoot(), s));
        }

        protected void emitProcinst(Splay s) {
            this.enqueue(new ProcessingInstructionImpl(this.getSaverRoot(), s));
        }

        protected void emitAttrFragment(Splay s) {
            throw new IllegalStateException("Can't stream an attribute");
        }

        protected void emitContainer(Splay.Container c, QName name) {
            Root r = this.getSaverRoot();
            this.iterateMappings();
            while (this.hasMapping()) {
                this.enqueue(new StartPrefixMappingImpl(r, this.mappingPrefix(), this.mappingUri()));
                this.nextMapping();
            }
            if (c.isDoc()) {
                this.enqueue(new StartDocumentImpl(r, c));
            }
            if (name != null) {
                this.enqueue(new StartElementImpl(r, c, name, this));
            }
            if (c.isDoc()) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isDoc());
                }
                if (this._text != null) {
                    if (this._text.length() > 0) {
                        this.enqueue(new CharacterDataImpl(r, c, -1, this.text()));
                    }
                } else if (c.getCch() > 0) {
                    this.enqueue(new CharacterDataImpl(r, c, 1, null));
                }
            } else if (c.isLeaf()) {
                if (this._text != null) {
                    if (this._text.length() > 0) {
                        this.enqueue(new CharacterDataImpl(r, c, -1, this.text()));
                    }
                } else if (c.getCchValue() > 0) {
                    this.enqueue(new CharacterDataImpl(r, c, 1, null));
                }
                this.enqueue(new EndElementImpl(r, c, name, this.getUriMap()));
                this.emitEndPrefixMappings();
            }
        }

        private static XMLName computeName(QName n, Map uriMap) {
            String uri = n.getNamespaceURI();
            if (uri.length() == 0) {
                uri = null;
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(n.getLocalPart().length() > 0);
                XmlBeans.assertTrue(uri == null || uriMap.containsKey(uri), "Problem uri " + uri);
            }
            String prefix = null;
            if (uri != null && (prefix = (String)uriMap.get(uri)) != null && prefix.length() == 0) {
                prefix = null;
            }
            return new XmlNameImpl(uri, n.getLocalPart(), prefix);
        }

        private static class ProcessingInstructionImpl
        extends XmlEventImpl
        implements ProcessingInstruction {
            ProcessingInstructionImpl(Root r, Splay s) {
                super(8, r, s);
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(s.isProcinst());
                }
            }

            public String getTarget() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this.getSplay().getLocal();
                    return string;
                }
            }

            public String getData() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    Splay s = this.getSplay();
                    String string = s.getCch() == 0 ? null : s.getText(this.getRoot());
                    return string;
                }
            }
        }

        private static class CommentImpl
        extends XmlEventImpl
        implements Comment {
            CommentImpl(Root r, Splay s) {
                super(32, r, s);
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(s.isComment());
                }
            }

            public String getContent() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    Splay s = this.getSplay();
                    String string = s.getCch() == 0 ? null : s.getText(this.getRoot());
                    return string;
                }
            }

            public boolean hasContent() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = this.getSplay().getCch() > 0;
                    return bl;
                }
            }
        }

        private static class EndDocumentImpl
        extends XmlEventImpl
        implements EndDocument {
            EndDocumentImpl(Root r, Splay s) {
                super(512, r, s);
            }
        }

        private static class EndElementImpl
        extends XmlEventImpl
        implements EndElement {
            private XMLName _name;

            EndElementImpl(Root r, Splay s, QName name, Map uriMap) {
                super(4, r, s);
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(s.isLeaf() || s.isEnd());
                }
                if (name == null) {
                    if (s.isEnd()) {
                        s = s.getContainer();
                    }
                    name = s.getName();
                }
                this._name = XmlInputStreamSaver.computeName(name, uriMap);
            }

            public boolean hasName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = true;
                    return bl;
                }
            }

            public XMLName getName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    XMLName xMLName = this._name;
                    return xMLName;
                }
            }
        }

        private static class CharacterDataImpl
        extends XmlEventImpl
        implements CharacterData {
            private int _pos;
            private String _charData;

            CharacterDataImpl(Root r, Splay s, int p, String charData) {
                super(16, r, s);
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(p > 0 || charData != null && charData.length() > 0);
                }
                this._pos = p;
                this._charData = charData;
            }

            public String getContent() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    Splay s = this.getSplay();
                    if (this._pos == -1) {
                        String string = this._charData;
                        return string;
                    }
                    Root r = this.getRoot();
                    String string = r._text.fetch(s.getCpForPos(r, this._pos), s.getPostCch(this._pos));
                    return string;
                }
            }

            public boolean hasContent() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = true;
                    return bl;
                }
            }
        }

        private static class EndPrefixMappingImpl
        extends XmlEventImpl
        implements EndPrefixMapping {
            private String _prefix;

            EndPrefixMappingImpl(Root r, String prefix) {
                super(2048, r, null);
                this._prefix = prefix;
            }

            public String getPrefix() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._prefix;
                    return string;
                }
            }
        }

        private static class ChangePrefixMappingImpl
        extends XmlEventImpl
        implements ChangePrefixMapping {
            private String _oldUri;
            private String _newUri;
            private String _prefix;

            ChangePrefixMappingImpl(Root r, String prefix, String oldUri, String newUri) {
                super(4096, r, null);
                this._oldUri = oldUri;
                this._newUri = newUri;
                this._prefix = prefix;
            }

            public String getOldNamespaceUri() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._oldUri;
                    return string;
                }
            }

            public String getNewNamespaceUri() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._newUri;
                    return string;
                }
            }

            public String getPrefix() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._prefix;
                    return string;
                }
            }
        }

        private static class StartPrefixMappingImpl
        extends XmlEventImpl
        implements StartPrefixMapping {
            private String _prefix;
            private String _uri;

            StartPrefixMappingImpl(Root r, String prefix, String uri) {
                super(1024, r, null);
                this._prefix = prefix;
                this._uri = uri;
            }

            public String getNamespaceUri() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._uri;
                    return string;
                }
            }

            public String getPrefix() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this._prefix;
                    return string;
                }
            }
        }

        private static class StartElementImpl
        extends XmlEventImpl
        implements StartElement {
            private XMLName _name;
            private Map _prefixMap;
            private AttributeImpl _attributes;
            private AttributeImpl _namespaces;

            StartElementImpl(Root r, Splay s, QName name, Saver saver) {
                super(2, r, s);
                this._name = XmlInputStreamSaver.computeName(name, saver.getUriMap());
                this._prefixMap = saver.getPrefixMap();
                AttributeImpl lastAttr = null;
                Iterator i = saver._attrs.keySet().iterator();
                while (i.hasNext()) {
                    Splay a = (Splay)i.next();
                    NormalAttributeImpl attr = new NormalAttributeImpl(r, a, (String)saver._attrs.get(a), saver.getUriMap());
                    if (this._attributes == null) {
                        this._attributes = attr;
                    } else {
                        lastAttr._next = attr;
                    }
                    lastAttr = attr;
                }
                lastAttr = null;
                saver.iterateMappings();
                while (saver.hasMapping()) {
                    XmlnsAttributeImpl attr = new XmlnsAttributeImpl(r, saver.mappingPrefix(), saver.mappingUri(), saver.getUriMap());
                    if (this._namespaces == null) {
                        this._namespaces = attr;
                    } else {
                        lastAttr._next = attr;
                    }
                    lastAttr = attr;
                    saver.nextMapping();
                }
            }

            public boolean hasName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = true;
                    return bl;
                }
            }

            public XMLName getName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    XMLName xMLName = this._name;
                    return xMLName;
                }
            }

            public AttributeIterator getAttributes() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    AttributeIteratorImpl attributeIteratorImpl = new AttributeIteratorImpl(this.getRoot(), this._attributes, null);
                    return attributeIteratorImpl;
                }
            }

            public AttributeIterator getNamespaces() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    AttributeIteratorImpl attributeIteratorImpl = new AttributeIteratorImpl(this.getRoot(), null, this._namespaces);
                    return attributeIteratorImpl;
                }
            }

            public AttributeIterator getAttributesAndNamespaces() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    AttributeIteratorImpl attributeIteratorImpl = new AttributeIteratorImpl(this.getRoot(), this._attributes, this._namespaces);
                    return attributeIteratorImpl;
                }
            }

            public Attribute getAttributeByName(XMLName xmlName) {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    AttributeImpl a = this._attributes;
                    while (a != null) {
                        if (xmlName.equals(a.getName())) {
                            AttributeImpl attributeImpl = a;
                            return attributeImpl;
                        }
                        a = a._next;
                    }
                    Attribute attribute = null;
                    return attribute;
                }
            }

            public String getNamespaceUri(String prefix) {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = (String)this._prefixMap.get(prefix == null ? "" : prefix);
                    return string;
                }
            }

            public Map getNamespaceMap() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    Map map = this._prefixMap;
                    return map;
                }
            }

            private static class NormalAttributeImpl
            extends AttributeImpl {
                private String _value;
                private Splay _splay;

                NormalAttributeImpl(Root r, Splay s, String value, Map uriMap) {
                    super(r);
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(s.isNormalAttr());
                    }
                    this._splay = s;
                    this._value = value;
                    this._name = XmlInputStreamSaver.computeName(s.getName(), uriMap);
                }

                public String getValue() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        String string = this._value != null ? this._value : this._splay.getText(this._root);
                        return string;
                    }
                }
            }

            private static class XmlnsAttributeImpl
            extends AttributeImpl {
                private String _uri;

                XmlnsAttributeImpl(Root r, String prefix, String uri, Map uriMap) {
                    super(r);
                    String local;
                    this._uri = uri;
                    if (prefix.length() == 0) {
                        prefix = null;
                        local = "xmlns";
                    } else {
                        local = prefix;
                        prefix = "xmlns";
                    }
                    this._name = new XmlNameImpl(null, local, prefix);
                }

                public String getValue() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        String string = this._uri;
                        return string;
                    }
                }
            }

            private static abstract class AttributeImpl
            implements Attribute {
                AttributeImpl _next;
                protected XMLName _name;
                protected Root _root;
                private long _version;

                public Object monitor() {
                    return this._root;
                }

                AttributeImpl(Root r) {
                    this._root = r;
                    this._version = r.getVersion();
                }

                public XMLName getName() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        XMLName xMLName = this._name;
                        return xMLName;
                    }
                }

                public String getType() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        String string = "CDATA";
                        return string;
                    }
                }

                public XMLName getSchemaType() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        XMLName xMLName = null;
                        return xMLName;
                    }
                }

                protected final void checkVersion() {
                    if (this._version != this._root.getVersion()) {
                        throw new IllegalStateException("Document changed");
                    }
                }

                public abstract String getValue();
            }

            private static class AttributeIteratorImpl
            implements AttributeIterator {
                private Root _root;
                private long _version;
                private AttributeImpl _attributes;
                private AttributeImpl _namespaces;

                public Object monitor() {
                    return this._root;
                }

                AttributeIteratorImpl(Root r, AttributeImpl attributes, AttributeImpl namespaces) {
                    this._root = r;
                    this._version = r.getVersion();
                    this._attributes = attributes;
                    this._namespaces = namespaces;
                }

                public Attribute next() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        AttributeImpl attr = null;
                        if (this._attributes != null) {
                            attr = this._attributes;
                            this._attributes = attr._next;
                        } else if (this._namespaces != null) {
                            attr = this._namespaces;
                            this._namespaces = attr._next;
                        }
                        AttributeImpl attributeImpl = attr;
                        return attributeImpl;
                    }
                }

                public boolean hasNext() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        boolean bl = this._attributes != null || this._namespaces != null;
                        return bl;
                    }
                }

                public Attribute peek() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        if (this._attributes != null) {
                            AttributeImpl attributeImpl = this._attributes;
                            return attributeImpl;
                        }
                        if (this._namespaces != null) {
                            AttributeImpl attributeImpl = this._namespaces;
                            return attributeImpl;
                        }
                        Attribute attribute = null;
                        return attribute;
                    }
                }

                public void skip() {
                    Object object = this.monitor();
                    synchronized (object) {
                        this.checkVersion();
                        if (this._attributes != null) {
                            this._attributes = this._attributes._next;
                        } else if (this._namespaces != null) {
                            this._namespaces = this._namespaces._next;
                        }
                    }
                }

                private final void checkVersion() {
                    if (this._version != this._root.getVersion()) {
                        throw new IllegalStateException("Document changed");
                    }
                }
            }
        }

        private static class StartDocumentImpl
        extends XmlEventImpl
        implements StartDocument {
            StartDocumentImpl(Root r, Splay s) {
                super(256, r, s);
            }

            public String getSystemId() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this.getRoot()._props.getDoctypeSystemId();
                    return string;
                }
            }

            public String getCharacterEncodingScheme() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this.getRoot()._props.getEncoding();
                    return string;
                }
            }

            public boolean isStandalone() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = this.getRoot()._standAlone;
                    return bl;
                }
            }

            public String getVersion() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    String string = this.getRoot()._props.getVersion();
                    return string;
                }
            }
        }

        private static abstract class XmlEventImpl
        extends XmlEventBase {
            private Root _root;
            private Splay _splay;
            private long _version;
            XmlEventImpl _next;

            public Object monitor() {
                return this._root;
            }

            XmlEventImpl(int type, Root r, Splay s) {
                super(type);
                this._root = r;
                this._splay = s;
                this._version = this._root.getVersion();
            }

            public XMLName getName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    XMLName xMLName = null;
                    return xMLName;
                }
            }

            public XMLName getSchemaType() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    throw new RuntimeException("NYI");
                }
            }

            public boolean hasName() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    boolean bl = false;
                    return bl;
                }
            }

            public final Location getLocation() {
                Object object = this.monitor();
                synchronized (object) {
                    this.checkVersion();
                    Location location = null;
                    return location;
                }
            }

            protected final void checkVersion() {
                if (this._version != this._root.getVersion()) {
                    throw new ConcurrentModificationException("Document changed");
                }
            }

            protected final Root getRoot() {
                return this._root;
            }

            protected final Splay getSplay() {
                return this._splay;
            }
        }
    }

    static final class InputStreamSaver
    extends InputStream {
        private OutputStreamImpl _byteBuffer;
        private TextSaver _textSaver;
        private OutputStreamWriter _converter;

        InputStreamSaver(Root r, Splay s, int p, XmlOptions options) {
            String javaEncoding;
            String ianaEncoding;
            options = XmlOptions.maskNull(options);
            this._byteBuffer = new OutputStreamImpl();
            String encoding = null;
            if (r._props.getEncoding() != null) {
                encoding = EncodingMap.getIANA2JavaMapping(r._props.getEncoding());
            }
            if (options.hasOption("CHARACTER_ENCODING")) {
                encoding = (String)options.get("CHARACTER_ENCODING");
            }
            if (encoding != null && (ianaEncoding = EncodingMap.getJava2IANAMapping(encoding)) != null) {
                encoding = ianaEncoding;
            }
            if (encoding == null) {
                encoding = EncodingMap.getJava2IANAMapping("UTF8");
            }
            if ((javaEncoding = EncodingMap.getIANA2JavaMapping(encoding)) == null) {
                throw new IllegalStateException("Unknown encoding: " + encoding);
            }
            try {
                this._converter = new OutputStreamWriter((OutputStream)this._byteBuffer, javaEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new XmlRuntimeException(e);
            }
            this._textSaver = new TextSaver(r, s, p, options, encoding);
        }

        public int read() {
            return this._byteBuffer.read();
        }

        public int read(byte[] bbuf, int off, int len) {
            return this._byteBuffer.read(bbuf, off, len);
        }

        private int ensure(int cbyte) {
            if (cbyte <= 0) {
                cbyte = 1;
            }
            int bytesAvailable = this._byteBuffer.getAvailable();
            while (bytesAvailable < cbyte) {
                if (this._textSaver.write(this._converter, 2048) < 2048) break;
                bytesAvailable = this._byteBuffer.getAvailable();
            }
            bytesAvailable = this._byteBuffer.getAvailable();
            if (bytesAvailable == 0) {
                return 0;
            }
            return bytesAvailable;
        }

        private final class OutputStreamImpl
        extends OutputStream {
            private static final int _initialBufSize = 4096;
            int _free;
            int _in;
            int _out;
            byte[] _buf;

            private OutputStreamImpl() {
            }

            int read() {
                if (InputStreamSaver.this.ensure(1) == 0) {
                    return -1;
                }
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this.getAvailable() > 0);
                }
                byte bite = this._buf[this._out];
                this._out = (this._out + 1) % this._buf.length;
                ++this._free;
                return bite;
            }

            int read(byte[] bbuf, int off, int len) {
                int n = InputStreamSaver.this.ensure(len);
                if (n == 0) {
                    return -1;
                }
                if (bbuf == null || len <= 0) {
                    return 0;
                }
                if (n < len) {
                    len = n;
                }
                if (this._out < this._in) {
                    System.arraycopy(this._buf, this._out, bbuf, off, len);
                } else {
                    int chunk = this._buf.length - this._out;
                    if (chunk >= len) {
                        System.arraycopy(this._buf, this._out, bbuf, off, len);
                    } else {
                        System.arraycopy(this._buf, this._out, bbuf, off, chunk);
                        System.arraycopy(this._buf, 0, bbuf, off + chunk, len - chunk);
                    }
                }
                this._out = (this._out + len) % this._buf.length;
                this._free += len;
                return len;
            }

            int getAvailable() {
                return this._buf == null ? 0 : this._buf.length - this._free;
            }

            public void write(int bite) {
                if (this._free == 0) {
                    this.resize(1);
                }
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._free > 0);
                }
                this._buf[this._in] = (byte)bite;
                this._in = (this._in + 1) % this._buf.length;
                --this._free;
            }

            public void write(byte[] buf, int off, int cbyte) {
                int chunk;
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(cbyte >= 0);
                }
                if (cbyte == 0) {
                    return;
                }
                if (this._free < cbyte) {
                    this.resize(cbyte);
                }
                if (this._in == this._out) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(this.getAvailable() == 0);
                        XmlBeans.assertTrue(this._free == this._buf.length - this.getAvailable());
                    }
                    this._out = 0;
                    this._in = 0;
                }
                if (this._in <= this._out || cbyte < (chunk = this._buf.length - this._in)) {
                    System.arraycopy(buf, off, this._buf, this._in, cbyte);
                    this._in += cbyte;
                } else {
                    System.arraycopy(buf, off, this._buf, this._in, chunk);
                    System.arraycopy(buf, off + chunk, this._buf, 0, cbyte - chunk);
                    this._in = (this._in + cbyte) % this._buf.length;
                }
                this._free -= cbyte;
            }

            void resize(int cbyte) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(cbyte > this._free);
                }
                int newLen = this._buf == null ? 4096 : this._buf.length * 2;
                int used = this.getAvailable();
                while (newLen - used < cbyte) {
                    newLen *= 2;
                }
                byte[] newBuf = new byte[newLen];
                if (used > 0) {
                    if (this._out == this._in) {
                        System.arraycopy(this._buf, 0, newBuf, 0, used);
                    } else if (this._in > this._out) {
                        System.arraycopy(this._buf, this._out, newBuf, 0, used);
                    } else {
                        System.arraycopy(this._buf, this._out, newBuf, 0, used - this._in);
                        System.arraycopy(this._buf, 0, newBuf, used - this._in, this._in);
                    }
                    this._out = 0;
                    this._in = used;
                    this._free += newBuf.length - this._buf.length;
                } else {
                    this._free += newBuf.length;
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(this._in == 0 && this._out == 0);
                    }
                }
                this._buf = newBuf;
            }
        }
    }

    static final class TextReader
    extends Reader {
        private TextSaver _textSaver;

        TextReader(Root r, Splay s, int p, XmlOptions options) {
            this._textSaver = new TextSaver(r, s, p, options, null);
        }

        public void close() throws IOException {
        }

        public boolean ready() throws IOException {
            return true;
        }

        public int read() throws IOException {
            return this._textSaver.read();
        }

        public int read(char[] cbuf) throws IOException {
            return this._textSaver.read(cbuf, 0, cbuf == null ? 0 : cbuf.length);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return this._textSaver.read(cbuf, off, len);
        }
    }

    static final class TextSaver
    extends Saver {
        private static final int _initialBufSize = 4096;
        private int _lastEmitIn;
        private int _lastEmitCch;
        private int _free;
        private int _in;
        private int _out;
        private char[] _buf;

        TextSaver(Root r, Splay s, int p, XmlOptions options, String encoding) {
            super(r, s, p, options);
            this._wantFragTest = true;
            if (encoding != null) {
                String version = r._props.getVersion();
                if (version == null) {
                    version = "1.0";
                }
                this.emit("<?xml version=\"");
                this.emit(version);
                this.emit("\" encoding=\"" + encoding + "\"?>" + _newLine);
            }
        }

        protected void emitContainer(Splay.Container c, QName name) {
            if (c.isBegin()) {
                this.emitContainerHelper(c, name, null, null, false);
                if (c.isLeaf()) {
                    int cch;
                    int n = cch = this._text == null ? c.getCchValue() : this._text.length();
                    if (cch > 0) {
                        this.emit('>');
                        if (this._text == null) {
                            this.emit(this.getSaverRoot().getCp(c), cch);
                        } else {
                            this.emit(this._text);
                        }
                        this.entitizeContent();
                        this.emit("</");
                        this.emitName(name);
                    } else {
                        this.emit('/');
                    }
                } else {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(!c.isLeaf());
                    }
                    if (c.getCchAfter() == 0 && c.nextNonAttrSplay().isEnd()) {
                        this.emit('/');
                        this._skipContainerFinish = true;
                    }
                }
                this.emit('>');
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isDoc());
                }
                if (name != null) {
                    this.emitContainerHelper(c, name, null, null, true);
                }
                if (this._text == null) {
                    this.emit(this.getSaverRoot().getCp(c), c.getCch());
                } else {
                    this.emit(this._text);
                }
                this.entitizeContent();
            }
        }

        private void emitAttrHelper(Splay s, String invalidValue) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(s.isNormalAttr());
            }
            this.emit(' ');
            this.emitName(s.getName());
            this.emit("=\"");
            if (invalidValue != null) {
                this.emit(invalidValue);
            } else {
                this.emit(this.getSaverRoot().getCp(s), s.getCch());
            }
            this.entitizeAttrValue();
            this.emit('\"');
        }

        private void emitNamespacesHelper() {
            this.iterateMappings();
            while (this.hasMapping()) {
                this.emit(' ');
                this.emitXmlns(this.mappingPrefix(), this.mappingUri());
                this.nextMapping();
            }
        }

        private void emitContainerHelper(Splay.Container c, QName name, Splay extraAttr, StringBuffer extraAttrText, boolean close) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(name != null);
            }
            this.emit('<');
            this.emitName(name);
            if (this._saveNamespacesFirst) {
                this.emitNamespacesHelper();
            }
            if (c != null) {
                Iterator i = this._attrs.keySet().iterator();
                while (i.hasNext()) {
                    Splay s = (Splay)i.next();
                    this.emitAttrHelper(s, (String)this._attrs.get(s));
                }
            }
            if (extraAttr != null) {
                this.emitAttrHelper(extraAttr, extraAttrText == null ? null : extraAttrText.toString());
            }
            if (!this._saveNamespacesFirst) {
                this.emitNamespacesHelper();
            }
            if (close) {
                this.emit('>');
            }
        }

        protected void emitText(Splay s, int p, int cch) {
            this.emit(s.getCpForPos(this.getSaverRoot(), p), cch);
            this.entitizeContent();
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
            if (this._text == null) {
                this.emitText(s, p, cch);
            } else {
                this.emit(this._text);
                this.entitizeContent();
            }
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
            this.emitContainerHelper(null, this._fragment, null, null, false);
            if (this._text != null) {
                if (this._text.length() > 0) {
                    this.emit(">");
                    this.emit(this._text);
                    this.emitEndHelper(this._fragment);
                    return;
                }
            } else if (s != null && cch > 0) {
                this.emit(">");
                this.emitText(s, p, cch);
                this.emitEndHelper(this._fragment);
                return;
            }
            this.emit("/>");
        }

        protected void emitAttrFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, s, this._text, false);
            this.emit("/>");
        }

        protected void emitXmlnsFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null, false);
            this.emit("/>");
        }

        protected void emitCommentFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null, true);
            this.emitComment(s);
            this.emitEndHelper(this._fragment);
        }

        protected void emitProcinstFragment(Splay s) {
            this.emitContainerHelper(null, this._fragment, null, null, true);
            this.emitProcinst(s);
            this.emitEndHelper(this._fragment);
        }

        protected void emitXmlns(String prefix, String uri) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(prefix != null);
                XmlBeans.assertTrue(uri != null);
            }
            this.emit("xmlns");
            if (prefix.length() > 0) {
                this.emit(":");
                this.emit(prefix);
            }
            this.emit("=\"");
            this.emit(uri);
            this.entitizeAttrValue();
            this.emit('\"');
        }

        protected void emitEndHelper(QName name) {
            this.emit("</");
            this.emitName(name);
            this.emit('>');
        }

        protected void emitEnd(Splay s, QName name) {
            if (name != null) {
                this.emitEndHelper(name);
            }
        }

        private void emitLiteral(String literal) {
            if (literal.indexOf("\"") < 0) {
                this.emit("\"");
                this.emit(literal);
                this.emit("\"");
            } else {
                this.emit("'");
                this.emit(literal);
                this.emit("'");
            }
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(doctypeName != null);
            }
            this.emit("<!DOCTYPE ");
            this.emit(doctypeName);
            if (publicID == null && systemID != null) {
                this.emit(" SYSTEM ");
                this.emitLiteral(systemID);
            } else if (publicID != null) {
                this.emit(" PUBLIC ");
                this.emitLiteral(publicID);
                this.emit(" ");
                this.emitLiteral(systemID);
            }
            this.emit(">" + _newLine);
        }

        protected void emitComment(Splay s) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(s.isComment());
            }
            this.emit("<!--");
            this.emit(this.getSaverRoot().getCp(s), s.getCchValue());
            this.entitizeComment();
            this.emit("-->");
        }

        protected void emitProcinst(Splay s) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(s.isProcinst());
            }
            this.emit("<?");
            this.emit(s.getLocal());
            if (s.getCchValue() > 0) {
                this.emit(" ");
                this.emit(this.getSaverRoot().getCp(s), s.getCchValue());
                this.entitizeProcinst();
            }
            this.emit("?>");
        }

        private int ensure(int cch) {
            if (cch <= 0) {
                cch = 1;
            }
            int available = this.getAvailable();
            while (available < cch) {
                if (!this.process()) break;
                available = this.getAvailable();
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(available == this.getAvailable());
            }
            if (available == 0) {
                return 0;
            }
            return available;
        }

        private void emitName(QName name) {
            String prefix;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(name != null);
            }
            String uri = name.getNamespaceURI();
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(uri != null);
            }
            if (uri.length() != 0 && (prefix = this.getUriMapping(uri)).length() > 0) {
                this.emit(prefix);
                this.emit(":");
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(name.getLocalPart().length() > 0);
            }
            this.emit(name.getLocalPart());
        }

        private boolean preEmit(int cch) {
            int used;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(cch >= 0);
            }
            this._lastEmitCch = cch;
            if (cch == 0) {
                return true;
            }
            if (this._free < cch) {
                this.resize(cch, -1);
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(cch <= this._free);
            }
            if ((used = this.getAvailable()) == 0) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._in == this._out);
                    XmlBeans.assertTrue(this._free == this._buf.length);
                }
                this._out = 0;
                this._in = 0;
            }
            this._lastEmitIn = this._in;
            this._free -= cch;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
            }
            return false;
        }

        private void emit(String s) {
            int chunk;
            int cch;
            int n = cch = s == null ? 0 : s.length();
            if (this.preEmit(cch)) {
                return;
            }
            if (this._in <= this._out || cch < (chunk = this._buf.length - this._in)) {
                s.getChars(0, cch, this._buf, this._in);
                this._in += cch;
            } else {
                s.getChars(0, chunk, this._buf, this._in);
                s.getChars(chunk, cch, this._buf, 0);
                this._in = (this._in + cch) % this._buf.length;
            }
        }

        private void emit(StringBuffer sb) {
            int chunk;
            int cch;
            int n = cch = sb == null ? 0 : sb.length();
            if (this.preEmit(cch)) {
                return;
            }
            if (this._in <= this._out || cch < (chunk = this._buf.length - this._in)) {
                sb.getChars(0, cch, this._buf, this._in);
                this._in += cch;
            } else {
                sb.getChars(0, chunk, this._buf, this._in);
                sb.getChars(chunk, cch, this._buf, 0);
                this._in = (this._in + cch) % this._buf.length;
            }
        }

        private void emit(int cp, int cch) {
            this.emit(this.getSaverRoot()._text._buf, this.getSaverRoot()._text.unObscure(cp, cch), cch);
        }

        private void emit(char ch) {
            this.preEmit(1);
            this._buf[this._in] = ch;
            this._in = (this._in + 1) % this._buf.length;
        }

        private void emit(char[] buf, int off, int cch) {
            int chunk;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(cch >= 0);
            }
            if (this.preEmit(cch)) {
                return;
            }
            if (this._in <= this._out || cch < (chunk = this._buf.length - this._in)) {
                System.arraycopy(buf, off, this._buf, this._in, cch);
                this._in += cch;
            } else {
                System.arraycopy(buf, off, this._buf, this._in, chunk);
                System.arraycopy(buf, off + chunk, this._buf, 0, cch - chunk);
                this._in = (this._in + cch) % this._buf.length;
            }
        }

        private void entitizeContent() {
            if (this._lastEmitCch == 0) {
                return;
            }
            int i = this._lastEmitIn;
            int n = this._buf.length;
            boolean hasOutOfRange = false;
            int count = 0;
            int cch = this._lastEmitCch;
            while (cch > 0) {
                char ch = this._buf[i];
                if (ch == '<' || ch == '&') {
                    ++count;
                } else if (this.isBadChar(ch)) {
                    hasOutOfRange = true;
                }
                if (++i == n) {
                    i = 0;
                }
                --cch;
            }
            if (count == 0 && !hasOutOfRange) {
                return;
            }
            i = this._lastEmitIn;
            if (this._lastEmitCch > 32 && count > 5 && count * 100 / this._lastEmitCch > 1) {
                boolean lastWasBracket = this._buf[i] == ']';
                i = this.replace(i, "<![CDATA[" + this._buf[i]);
                boolean secondToLastWasBracket = lastWasBracket;
                boolean bl = lastWasBracket = this._buf[i] == ']';
                if (++i == this._buf.length) {
                    i = 0;
                }
                int cch2 = this._lastEmitCch;
                while (cch2 > 0) {
                    char ch = this._buf[i];
                    i = ch == '>' && secondToLastWasBracket && lastWasBracket ? this.replace(i, "&gt;") : (this.isBadChar(ch) ? this.replace(i, "?") : ++i);
                    secondToLastWasBracket = lastWasBracket;
                    boolean bl2 = lastWasBracket = ch == ']';
                    if (i == this._buf.length) {
                        i = 0;
                    }
                    --cch2;
                }
                this.emit("]]>");
            } else {
                int cch3 = this._lastEmitCch;
                while (cch3 > 0) {
                    char ch = this._buf[i];
                    i = ch == '<' ? this.replace(i, "&lt;") : (ch == '&' ? this.replace(i, "&amp;") : (this.isBadChar(ch) ? this.replace(i, "?") : ++i));
                    if (i == this._buf.length) {
                        i = 0;
                    }
                    --cch3;
                }
            }
        }

        private void entitizeAttrValue() {
            if (this._lastEmitCch == 0) {
                return;
            }
            int i = this._lastEmitIn;
            int cch = this._lastEmitCch;
            while (cch > 0) {
                char ch = this._buf[i];
                i = ch == '<' ? this.replace(i, "&lt;") : (ch == '&' ? this.replace(i, "&amp;") : (ch == '\"' ? this.replace(i, "&quot;") : ++i));
                if (i == this._buf.length) {
                    i = 0;
                }
                --cch;
            }
        }

        private void entitizeComment() {
            if (this._lastEmitCch == 0) {
                return;
            }
            int i = this._lastEmitIn;
            boolean lastWasDash = false;
            int cch = this._lastEmitCch;
            while (cch > 0) {
                char ch = this._buf[i];
                if (this.isBadChar(ch)) {
                    i = this.replace(i, "?");
                } else if (ch == '-') {
                    if (lastWasDash) {
                        i = this.replace(i, " ");
                        lastWasDash = false;
                    } else {
                        lastWasDash = true;
                        ++i;
                    }
                } else {
                    lastWasDash = false;
                    ++i;
                }
                if (i == this._buf.length) {
                    i = 0;
                }
                --cch;
            }
            if (this._buf[this._lastEmitIn + this._lastEmitCch - 1] == '-') {
                int n = this.replace(this._lastEmitIn + this._lastEmitCch - 1, " ");
            }
        }

        private void entitizeProcinst() {
            if (this._lastEmitCch == 0) {
                return;
            }
            int i = this._lastEmitIn;
            boolean lastWasQuestion = false;
            int cch = this._lastEmitCch;
            while (cch > 0) {
                char ch = this._buf[i];
                if (this.isBadChar(ch)) {
                    i = this.replace(i, "?");
                }
                if (ch == '>') {
                    i = lastWasQuestion ? this.replace(i, " ") : ++i;
                    lastWasQuestion = false;
                } else {
                    lastWasQuestion = ch == '?';
                    ++i;
                }
                if (i == this._buf.length) {
                    i = 0;
                }
                --cch;
            }
        }

        private boolean isBadChar(char ch) {
            return !(ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff' || ch == '\t' || ch == '\n' || ch == '\r');
        }

        private int replace(int i, String replacement) {
            int dCch;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(replacement.length() > 0);
            }
            if ((dCch = replacement.length() - 1) == 0) {
                this._buf[i] = replacement.charAt(0);
                return i + 1;
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
            }
            if (dCch > this._free) {
                i = this.resize(dCch, i);
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
                XmlBeans.assertTrue(this._free >= dCch);
                XmlBeans.assertTrue(this.getAvailable() > 0);
            }
            if (this._out > this._in && i >= this._out) {
                System.arraycopy(this._buf, this._out, this._buf, this._out - dCch, i - this._out);
                this._out -= dCch;
                i -= dCch;
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(i < this._in);
                }
                System.arraycopy(this._buf, i, this._buf, i + dCch, this._in - i);
                this._in += dCch;
            }
            replacement.getChars(0, dCch + 1, this._buf, i);
            this._free -= dCch;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
            }
            return i + dCch + 1;
        }

        int getAvailable() {
            return this._buf == null ? 0 : this._buf.length - this._free;
        }

        private int resize(int cch, int i) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
                XmlBeans.assertTrue(cch > 0);
                XmlBeans.assertTrue(cch > this._free);
            }
            int newLen = this._buf == null ? 4096 : this._buf.length * 2;
            int used = this.getAvailable();
            while (newLen - used < cch) {
                newLen *= 2;
            }
            char[] newBuf = new char[newLen];
            if (used > 0) {
                if (this._in > this._out) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(i == -1 || i >= this._out && i < this._in);
                    }
                    System.arraycopy(this._buf, this._out, newBuf, 0, used);
                    i -= this._out;
                } else {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(i == -1 || i >= this._out || i < this._in);
                    }
                    System.arraycopy(this._buf, this._out, newBuf, 0, used - this._in);
                    System.arraycopy(this._buf, 0, newBuf, used - this._in, this._in);
                    i = i >= this._out ? i - this._out : i + this._out;
                }
                this._out = 0;
                this._in = used;
                this._free += newBuf.length - this._buf.length;
            } else {
                this._free += newBuf.length;
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._in == 0 && this._out == 0);
                    XmlBeans.assertTrue(i == -1);
                }
            }
            this._buf = newBuf;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
            }
            return i;
        }

        public int read() {
            if (this.ensure(1) == 0) {
                return -1;
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this.getAvailable() > 0);
            }
            char ch = this._buf[this._out];
            this._out = (this._out + 1) % this._buf.length;
            ++this._free;
            return ch;
        }

        public int read(char[] cbuf, int off, int len) {
            int n = this.ensure(len);
            if (n == 0) {
                return -1;
            }
            if (cbuf == null || len <= 0) {
                return 0;
            }
            if (n < len) {
                len = n;
            }
            if (this._out < this._in) {
                System.arraycopy(this._buf, this._out, cbuf, off, len);
            } else {
                int chunk = this._buf.length - this._out;
                if (chunk >= len) {
                    System.arraycopy(this._buf, this._out, cbuf, off, len);
                } else {
                    System.arraycopy(this._buf, this._out, cbuf, off, chunk);
                    System.arraycopy(this._buf, 0, cbuf, off + chunk, len - chunk);
                }
            }
            this._out = (this._out + len) % this._buf.length;
            this._free += len;
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._free >= 0);
            }
            return len;
        }

        public int write(Writer writer, int cchMin) {
            int charsAvailable;
            while (this.getAvailable() < cchMin) {
                if (!this.process()) break;
            }
            if ((charsAvailable = this.getAvailable()) > 0) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._out == 0);
                }
                try {
                    writer.write(this._buf, 0, charsAvailable);
                    writer.flush();
                }
                catch (IOException e) {
                    throw new XmlRuntimeException(e);
                }
                this._free += charsAvailable;
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._free >= 0);
                }
                this._in = 0;
            }
            return charsAvailable;
        }

        public String saveToString() {
            int available;
            while (this.process()) {
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this._out == 0);
            }
            return (available = this.getAvailable()) == 0 ? "" : new String(this._buf, this._out, available);
        }
    }

    static final class SynthNamespaceSaver
    extends Saver {
        Map _synthNamespaces = new SequencedHashMap();

        SynthNamespaceSaver(Root r, Splay s, int p, XmlOptions options) {
            super(r, s, p, options);
        }

        protected void syntheticNamespace(String prefix, String uri, boolean considerCreatingDefault) {
            this._synthNamespaces.put(uri, considerCreatingDefault ? "useDefault" : null);
        }

        protected void emitXmlnsFragment(Splay s) {
        }

        protected void emitAttrFragment(Splay s) {
        }

        protected void emitTextFragment(Splay s, int p, int cch) {
        }

        protected void emitCommentFragment(Splay s) {
        }

        protected void emitProcinstFragment(Splay s) {
        }

        protected void emitComment(Splay s) {
        }

        protected void emitTextAfter(Splay s, int p, int cch) {
        }

        protected void emitEnd(Splay s, QName name) {
        }

        protected void emitProcinst(Splay s) {
        }

        protected void emitContainer(Splay.Container c, QName name) {
        }

        protected void emitDocType(String doctypeName, String publicID, String systemID) {
        }
    }
}

