/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.common.GlobalLock;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.store.CursorData;
import org.apache.xmlbeans.impl.store.Path;
import org.apache.xmlbeans.impl.store.Root;
import org.apache.xmlbeans.impl.store.Saver;
import org.apache.xmlbeans.impl.store.Splay;
import org.apache.xmlbeans.impl.store.Type;
import org.apache.xmlbeans.xml.stream.XMLInputStream;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class Cursor
implements XmlCursor,
Root.ChangeListener {
    private static final XmlOptions _toStringOptions = Cursor.buildPrettyOptions();
    CursorData _data;

    Cursor(Root r, Splay s) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(s != null);
        }
        this._data = CursorData.getOne(r);
        this.set(s);
    }

    Cursor(Root r, Splay s, int p) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(s != null);
        }
        this._data = CursorData.getOne(r);
        this.set(s, p);
    }

    public Object monitor() {
        return this.getRoot();
    }

    Root getRoot() {
        return this._data._goober.getRoot();
    }

    Splay getSplay() {
        return this._data._goober.getSplay();
    }

    int getPos() {
        return this._data._goober.getPos();
    }

    void set(Splay s, int p) {
        this._data._goober.set(s, p);
    }

    void set(Splay s) {
        this._data._goober.set(s, 0);
    }

    void set(int p) {
        this._data._goober.set(p);
    }

    void set(Splay.Goober g) {
        this._data._goober.set(g);
    }

    int getPostCch() {
        int p = this.getPos();
        if (p == 0) {
            return 0;
        }
        Splay s = this.getSplay();
        int pa = s.getPosAfter();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(p >= pa || s.isLeaf());
        }
        return p >= pa ? s.getCchAfter() - p + pa : s.getPosLeafEnd() - p;
    }

    int getPreCch() {
        Splay sOrig = this.getSplay();
        int pOrig = this.getPos();
        int n = this.toPrevChar(-1);
        this.set(sOrig, pOrig);
        return n;
    }

    private void checkDisposed() {
        Cursor.checkDisposed(this);
    }

    private static void checkDisposed(Cursor c) {
        if (c.isDisposed()) {
            throw new IllegalStateException("Cursor has been disposed");
        }
    }

    boolean isDisposed() {
        return this._data == null;
    }

    public void dispose() {
        Object object = this.monitor();
        synchronized (object) {
            if (!this.isDisposed()) {
                this._data.release(true);
                this._data = null;
            }
        }
    }

    public XmlObject getObject() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Root r = this.getRoot();
            if (this.getPos() > 0) {
                XmlObject xmlObject = null;
                return xmlObject;
            }
            Splay s = this.getSplay();
            if (!s.isTypeable()) {
                XmlObject xmlObject = null;
                return xmlObject;
            }
            Type t = s.getType(r);
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(t != null);
            }
            XmlObject result = t.getXmlObject();
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(result != null);
            }
            XmlObject xmlObject = result;
            return xmlObject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean toCursor(XmlCursor moveTo) {
        boolean bl;
        if (moveTo == null) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        if (this.monitor() == moveTo.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.toCursorImpl(moveTo);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = moveTo.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        bl = this.toCursorImpl(moveTo);
                    }
                }
                Object var9_9 = null;
                if (!acquired) return bl;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return bl;
    }

    private boolean toCursorImpl(XmlCursor moveTo) {
        this.checkDisposed();
        Cursor c = null;
        if (moveTo instanceof Cursor) {
            c = (Cursor)moveTo;
            Cursor.checkDisposed(c);
            if (c.getRoot() != this.getRoot()) {
                c = null;
            }
        }
        if (c == null) {
            return false;
        }
        this.set(c._data._goober);
        return true;
    }

    public XmlDocumentProperties documentProperties() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            XmlDocumentProperties xmlDocumentProperties = this.getRoot().documentProperties();
            return xmlDocumentProperties;
        }
    }

    public XmlCursor newCursor() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Cursor cursor = new Cursor(this.getRoot(), this.getSplay(), this.getPos());
            return cursor;
        }
    }

    public boolean toBookmark(XmlCursor.XmlBookmark bm) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (bm == null) {
                boolean bl = false;
                return bl;
            }
            if (!(bm._currentMark instanceof Splay.Annotation)) {
                boolean bl = false;
                return bl;
            }
            Splay.Annotation a = (Splay.Annotation)bm._currentMark;
            if (a.getRoot() != this.getRoot()) {
                boolean bl = false;
                return bl;
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(a.getSplay() != null);
            }
            this.set(a);
            boolean bl = true;
            return bl;
        }
    }

    public XmlCursor.XmlBookmark toNextBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                XmlCursor.XmlBookmark xmlBookmark = null;
                return xmlBookmark;
            }
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            XmlCursor.TokenType tt = this.currentTokenType();
            if (tt.isText()) {
                this.toNextChar(1);
                tt = this.currentTokenType();
            } else {
                tt = this.toNextToken();
                if (tt.isNone()) {
                    this.set(sOrig, pOrig);
                    XmlCursor.XmlBookmark xmlBookmark = null;
                    return xmlBookmark;
                }
            }
            do {
                int postCch;
                XmlCursor.XmlBookmark bm;
                if ((bm = this.getBookmark(key)) != null) {
                    XmlCursor.XmlBookmark xmlBookmark = bm;
                    return xmlBookmark;
                }
                if (!tt.isText() || (postCch = this.getPostCch()) <= 1) continue;
                Splay s = this.getSplay();
                int p = this.getPos();
                int d = postCch;
                Splay.Goober g = s.firstGoober();
                while (g != null) {
                    XmlCursor.XmlBookmark mark;
                    int dist;
                    if (g.isAnnotation() && (dist = g.getPos() - p) > 1 && dist < d && (mark = g.getBookmark()) != null && mark.getKey().equals(key)) {
                        bm = mark;
                        d = dist;
                    }
                    g = s.nextGoober(g);
                }
                if (bm == null) continue;
                this.set(s, p + d);
                XmlCursor.XmlBookmark xmlBookmark = bm;
                return xmlBookmark;
            } while (!(tt = this.toNextToken()).isNone());
            this.set(sOrig, pOrig);
            XmlCursor.XmlBookmark xmlBookmark = null;
            return xmlBookmark;
        }
    }

    public XmlCursor.XmlBookmark toPrevBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                XmlCursor.XmlBookmark xmlBookmark = null;
                return xmlBookmark;
            }
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            XmlCursor.TokenType tt = this.prevTokenType();
            if (tt.isText()) {
                this.toPrevChar(1);
                tt = this.prevTokenType();
            } else {
                if (this.toPrevToken().isNone()) {
                    this.set(sOrig, pOrig);
                    XmlCursor.XmlBookmark xmlBookmark = null;
                    return xmlBookmark;
                }
                tt = this.prevTokenType();
            }
            while (true) {
                int preCch;
                XmlCursor.XmlBookmark bm;
                if ((bm = this.getBookmark(key)) != null) {
                    XmlCursor.XmlBookmark xmlBookmark = bm;
                    return xmlBookmark;
                }
                if (tt.isText() && (preCch = this.getPreCch()) > 1) {
                    int p;
                    Splay s;
                    if (this.getPos() == 0) {
                        s = this.getSplay().prevNonAttrSplay();
                        p = s.getEndPos();
                    } else {
                        s = this.getSplay();
                        p = this.getPos();
                    }
                    int d = preCch;
                    Splay.Goober g = s.firstGoober();
                    while (g != null) {
                        XmlCursor.XmlBookmark mark;
                        int dist;
                        if (g.isAnnotation() && (dist = p - g.getPos()) > 1 && dist < d && (mark = g.getBookmark()) != null && mark.getKey().equals(key)) {
                            bm = mark;
                            d = dist;
                        }
                        g = s.nextGoober(g);
                    }
                    if (bm != null) {
                        this.set(s, p - d);
                        XmlCursor.XmlBookmark xmlBookmark = bm;
                        return xmlBookmark;
                    }
                }
                if (tt.isText()) {
                    this.toPrevChar(-1);
                    tt = this.prevTokenType();
                    continue;
                }
                if (this.toPrevToken().isNone()) {
                    this.set(sOrig, pOrig);
                    XmlCursor.XmlBookmark xmlBookmark = null;
                    return xmlBookmark;
                }
                tt = this.prevTokenType();
            }
        }
    }

    public XmlCursor.TokenType currentTokenType() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            XmlCursor.TokenType tokenType = this.getSplay().getTokenType(this.getPos());
            return tokenType;
        }
    }

    public boolean isStartdoc() {
        return this.currentTokenType().isStartdoc();
    }

    public boolean isEnddoc() {
        return this.currentTokenType().isEnddoc();
    }

    public boolean isStart() {
        return this.currentTokenType().isStart();
    }

    public boolean isEnd() {
        return this.currentTokenType().isEnd();
    }

    public boolean isText() {
        return this.currentTokenType().isText();
    }

    public boolean isAttr() {
        return this.currentTokenType().isAttr();
    }

    public boolean isNamespace() {
        return this.currentTokenType().isNamespace();
    }

    public boolean isComment() {
        return this.currentTokenType().isComment();
    }

    public boolean isProcinst() {
        return this.currentTokenType().isProcinst();
    }

    public boolean isContainer() {
        return this.currentTokenType().isContainer();
    }

    public boolean isFinish() {
        return this.currentTokenType().isFinish();
    }

    public boolean isAnyAttr() {
        return this.currentTokenType().isAnyAttr();
    }

    public XmlCursor.TokenType prevTokenType() {
        Object object = this.monitor();
        synchronized (object) {
            XmlCursor.TokenType tt;
            this.checkDisposed();
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            if (this.toPrevChar(1) == 1) {
                tt = XmlCursor.TokenType.TEXT;
            } else {
                tt = this.toPrevToken();
                if (!tt.isNone()) {
                    tt = this.currentTokenType();
                }
            }
            this.set(sOrig, pOrig);
            XmlCursor.TokenType tokenType = tt;
            return tokenType;
        }
    }

    public XmlCursor.TokenType toNextToken() {
        Object object = this.monitor();
        synchronized (object) {
            Splay os;
            this.checkDisposed();
            Splay s = os = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isRoot()) {
                    XmlCursor.TokenType tokenType = XmlCursor.TokenType.NONE;
                    return tokenType;
                }
                if (s.isContainer()) {
                    Splay t = s.nextSplay();
                    if (t.isAttr()) {
                        this.set(t, 0);
                        XmlCursor.TokenType tokenType = this.currentTokenType();
                        return tokenType;
                    }
                    s.ensureContentValid();
                }
                if (s.getMaxPos() > 0) {
                    p = 1;
                } else {
                    s = s.nextSplay();
                    p = 0;
                }
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(p > 0);
                    XmlBeans.assertTrue(!s.isRoot());
                }
                if (p >= s.getPosAfter() && s.getCchAfter() > 0) {
                    s = s.nextSplay();
                    p = 0;
                } else {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(s.isLeaf());
                        XmlBeans.assertTrue(p < s.getPosAfter());
                    }
                    if (p != s.getPosLeafEnd()) {
                        p = s.getPosLeafEnd();
                    } else if (s.getCchAfter() > 0) {
                        p = s.getPosAfter();
                    } else {
                        s = s.nextSplay();
                        p = 0;
                    }
                }
            }
            if (p == 0) {
                if (!s.isAttr() && os.isAttr()) {
                    Splay t = os.prevNonAttrSplay();
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(t.isContainer());
                    }
                    t.ensureContentValid();
                    if (t.getMaxPos() > 0) {
                        s = t;
                        p = 1;
                    }
                } else if (s.isAttr() && !os.isAttr() && os.getMaxPos() > 0) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(os.isContainer());
                    }
                    s = s.nextNonAttrSplay();
                }
            }
            this.set(s, p);
            XmlCursor.TokenType tokenType = this.currentTokenType();
            return tokenType;
        }
    }

    public XmlCursor.TokenType toPrevToken() {
        Object object = this.monitor();
        synchronized (object) {
            Object t;
            this.checkDisposed();
            Object s = this.getSplay();
            int p = this.getPos();
            if (p == 1 && ((Splay)s).isInvalid()) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(((Splay)s).isLeaf());
                }
                p += ((Splay)s).ensureContentValid();
            }
            if (p == 1 && ((Splay)s).isContainer() && ((Splay)(t = ((Splay)s).nextSplay())).isAttr()) {
                s = t;
                t = ((Splay)t).nextSplay();
                while (((Splay)t).isAttr()) {
                    s = t;
                    t = ((Splay)t).nextSplay();
                }
                this.set((Splay)s, 0);
                XmlCursor.TokenType tokenType = this.currentTokenType();
                return tokenType;
            }
            if (p == 0 && !((Splay)s).isAttr()) {
                if (((Splay)s).isDoc()) {
                    t = XmlCursor.TokenType.NONE;
                    return t;
                }
                Splay t2 = ((Splay)s).prevSplay();
                if (t2.isAttr()) {
                    t2 = t2.prevNonAttrSplay();
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(t2.isContainer());
                    }
                    if (t2.isDoc()) {
                        t2.ensureContentValid();
                    }
                    if (t2.getMaxPos() > 0) {
                        this.set(t2, t2.getCchAfter() > 0 ? t2.getPosAfter() : t2.getMaxPos());
                        XmlCursor.TokenType tokenType = this.currentTokenType();
                        return tokenType;
                    }
                }
            }
            if (((Splay)s).isAttr()) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(p == 0);
                }
                if (!((Splay)(t = ((Splay)s).prevSplay())).isAttr()) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(((Splay)t).isContainer());
                    }
                    this.set((Splay)t, 0);
                    XmlCursor.TokenType tokenType = this.currentTokenType();
                    return tokenType;
                }
            }
            if (p == 0) {
                if (((Splay)s).isDoc()) {
                    t = XmlCursor.TokenType.NONE;
                    return t;
                }
                if (((Splay)(s = ((Splay)s).prevSplay())).isDoc()) {
                    ((Splay)s).ensureContentValid();
                }
                p = ((Splay)s).getCchAfter() > 0 ? ((Splay)s).getPosAfter() : ((Splay)s).getMaxPos();
            } else {
                int posAfter;
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(p > 0);
                    XmlBeans.assertTrue(!((Splay)s).isRoot());
                }
                if (p >= (posAfter = ((Splay)s).getPosAfter())) {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(((Splay)s).getCchAfter() > 0);
                    }
                    p = posAfter - 1;
                } else {
                    if (XmlBeans.ASSERTS) {
                        XmlBeans.assertTrue(((Splay)s).isValid());
                        XmlBeans.assertTrue(((Splay)s).isLeaf());
                    }
                    p = p > 1 && p == posAfter - 1 ? 1 : 0;
                }
            }
            this.set((Splay)s, p);
            XmlCursor.TokenType tokenType = this.currentTokenType();
            return tokenType;
        }
    }

    public void insertChars(String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc() || s.isAttr()) {
                    throw new IllegalStateException("Invalid location for text");
                }
                s = s.prevNonAttrSplay();
                p = s.getEndPos();
            }
            if (text == null) {
                return;
            }
            int cch = text.length();
            if (cch > 0) {
                s.insertChars(p, this.getRoot(), text, 0, cch);
            }
        }
    }

    private static void validateLocalName(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("QName is null");
        }
        Cursor.validateLocalName(name.getLocalPart());
    }

    private static void validateLocalName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        if (!XMLChar.isValidNCName(name)) {
            throw new IllegalArgumentException("Name is not valid");
        }
    }

    private static void validatePrefix(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Prefix is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Prefix is empty");
        }
        if (Splay.beginsWithXml(name)) {
            throw new IllegalArgumentException("Prefix begins with 'xml'");
        }
        if (!XMLChar.isValidNCName(name)) {
            throw new IllegalArgumentException("Prefix is not valid");
        }
    }

    private void insertAttribute(QName name, String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Attr(name), value);
        }
    }

    public void insertAttribute(String name) {
        this.insertAttributeWithValue(name, null, null);
    }

    public void insertAttribute(String name, String uri) {
        this.insertAttributeWithValue(name, uri, null);
    }

    public void insertAttributeWithValue(String name, String value) {
        this.insertAttributeWithValue(name, null, value);
    }

    public void insertAttributeWithValue(String name, String uri, String value) {
        Cursor.validateLocalName(name);
        this.insertAttribute(new QName(uri, name), value);
    }

    public void insertAttribute(QName name) {
        Cursor.validateLocalName(name);
        this.insertAttribute(name, null);
    }

    public void insertAttributeWithValue(QName name, String value) {
        Cursor.validateLocalName(name);
        this.insertAttribute(name, value);
    }

    public void insertNamespace(String prefix, String namespace) {
        Object object = this.monitor();
        synchronized (object) {
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() > 0) {
                Cursor.validatePrefix(prefix);
            }
            if (namespace == null) {
                namespace = "";
            }
            if (namespace.length() == 0 && prefix.length() > 0) {
                throw new IllegalArgumentException("Can't map a prefix to no namespace");
            }
            this.insert(new Splay.Xmlns(new QName(namespace, prefix)), null);
        }
    }

    public void insertComment(String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Comment(), value);
        }
    }

    public void insertProcInst(String target, String value) {
        Cursor.validateLocalName(target);
        if (Splay.beginsWithXml(target) && target.length() == 3) {
            throw new IllegalArgumentException("Target begins with 'xml'");
        }
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Procinst(target), value);
        }
    }

    public void insertElement(String name) {
        this.insertElementWithText(name, null, null);
    }

    public void insertElementWithText(String name, String text) {
        this.insertElementWithText(name, null, text);
    }

    public void insertElement(String name, String uri) {
        this.insertElementWithText(name, uri, null);
    }

    public void insertElement(QName name) {
        this.insertElementWithText(name, null);
    }

    public void beginElement(QName name) {
        this.insertElement(name);
        this.toPrevToken();
    }

    public void beginElement(String name) {
        this.insertElement(name);
        this.toPrevToken();
    }

    public void beginElement(String name, String uri) {
        this.insertElement(name, uri);
        this.toPrevToken();
    }

    public void insertElementWithText(QName name, String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Cursor.validateLocalName(name.getLocalPart());
            Splay.Begin b = new Splay.Begin(name, null);
            b.toggleIsLeaf();
            this.insert(b, text);
        }
    }

    public void insertElementWithText(String name, String uri, String text) {
        this.insertElementWithText(new QName(uri, name), text);
    }

    void insert(Splay sInsert, String value) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(!this.isDisposed());
            XmlBeans.assertTrue(Root.dv > 0 || sInsert.getRootSlow() == null);
            XmlBeans.assertTrue(sInsert.getCch() == 0);
        }
        if (value != null) {
            sInsert.adjustCch(value.length());
        }
        Splay s = this.getSplay();
        int p = this.getPos();
        sInsert.checkInsertionValidity(0, s, p, false);
        if (value != null) {
            s.insert(this.getRoot(), p, sInsert, value, 0, value.length(), true);
        } else {
            s.insert(this.getRoot(), p, sInsert, null, 0, 0, true);
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this.validate());
        }
    }

    public String getTextValue() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || s.isFinish() || s.isXmlns()) {
                throw new IllegalStateException("Can't get text value, current token can have no text value");
            }
            String string = this.getSplay().getText(this.getRoot());
            return string;
        }
    }

    public int getTextValue(char[] buf, int off, int cch) {
        String s = this.getTextValue();
        int n = s.length();
        if (n > cch) {
            n = cch;
        }
        if (n <= 0) {
            return 0;
        }
        s.getChars(0, n, buf, off);
        return n;
    }

    public void setTextValue(String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p > 0 || s.isXmlns() || s.isFinish()) {
                throw new IllegalStateException("Can't set text value, current token can have no text value");
            }
            s.setText(this.getRoot(), text, 0, text == null ? 0 : text.length());
        }
    }

    public void setTextValue(char[] buf, int off, int len) {
        this.setTextValue(String.copyValueOf(buf, off, len));
    }

    public String getChars() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int cch = -1;
            int postCch = this.getPostCch();
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            String string = this.getRoot()._text.fetch(this.getSplay().getCpForPos(this.getRoot(), this.getPos()), cch);
            return string;
        }
    }

    public int getChars(char[] buf, int off, int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int postCch = this.getPostCch();
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            if (buf == null || off >= buf.length) {
                int n = 0;
                return n;
            }
            if (buf.length - off < cch) {
                cch = buf.length - off;
            }
            this.getRoot()._text.fetch(buf, off, this.getSplay().getCpForPos(this.getRoot(), this.getPos()), cch);
            int n = cch;
            return n;
        }
    }

    public void setBookmark(XmlCursor.XmlBookmark annotation) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (annotation == null) {
                return;
            }
            this.clearBookmark(annotation.getKey());
            Splay.Annotation a = new Splay.Annotation(this.getRoot(), annotation);
            if (a._key == null) {
                throw new IllegalArgumentException("Annotation key is null");
            }
            a.set(this._data._goober);
            annotation._currentMark = a;
        }
    }

    public XmlCursor.XmlBookmark getBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                XmlCursor.XmlBookmark xmlBookmark = null;
                return xmlBookmark;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                Splay.Annotation a;
                XmlCursor.XmlBookmark xa;
                if (g.getKind() == 2 && g.getPos() == p && (xa = (a = (Splay.Annotation)g).getXmlBookmark()) != null && a._key.equals(key)) {
                    XmlCursor.XmlBookmark xmlBookmark = xa;
                    return xmlBookmark;
                }
                g = s.nextGoober(g);
            }
            XmlCursor.XmlBookmark xmlBookmark = null;
            return xmlBookmark;
        }
    }

    public void clearBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                return;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                Splay.Annotation a;
                XmlCursor.XmlBookmark xa;
                if (g.getKind() == 2 && g.getPos() == p && (xa = (a = (Splay.Annotation)g).getXmlBookmark()) != null && a._key.equals(key)) {
                    g.set(null, 0);
                    return;
                }
                g = s.nextGoober(g);
            }
        }
    }

    public void getAllBookmarkRefs(Collection listToFill) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (listToFill == null) {
                return;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                if (g.getKind() == 2 && g.getPos() == p) {
                    listToFill.add(((Splay.Annotation)g).getXmlBookmark());
                }
                g = s.nextGoober(g);
            }
        }
    }

    public boolean hasNextToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(!this.getSplay().isRoot() || this.getPos() == 0);
            }
            boolean bl = !this.getSplay().isRoot();
            return bl;
        }
    }

    public boolean hasPrevToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            boolean bl = !this.getSplay().isDoc() || this.getPos() > 0;
            return bl;
        }
    }

    public QName getName() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this.getPos() > 0) {
                QName qName = null;
                return qName;
            }
            Splay s = this.getSplay();
            switch (s.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    QName qName = s.getName();
                    return qName;
                }
            }
            QName qName = null;
            return qName;
        }
    }

    public void setName(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (name == null) {
                throw new IllegalArgumentException("Name is null");
            }
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isBegin() && !s.isAttr() && !s.isProcinst()) {
                throw new IllegalStateException("Can't set name here: " + this.currentTokenType());
            }
            if (s.isProcinst()) {
                Cursor.validatePrefix(name.getLocalPart());
                if (name.getNamespaceURI().length() > 0) {
                    throw new IllegalArgumentException("Procinst name must have no URI");
                }
            } else if (s.isXmlns()) {
                if (name.getLocalPart().length() > 0) {
                    Cursor.validatePrefix(name.getLocalPart());
                }
            } else {
                Cursor.validateLocalName(name.getLocalPart());
            }
            s.setName(this.getRoot(), name);
        }
    }

    public int toNextChar(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            int maxCch = this.getPostCch();
            if (maxCch == 0 || cch == 0) {
                int n = 0;
                return n;
            }
            if (cch < 0 || cch > maxCch) {
                cch = maxCch;
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(p + cch <= s.getEndPos());
            }
            if (p + cch == s.getEndPos()) {
                this.toNextToken();
            } else {
                this.set(p + cch);
            }
            int n = cch;
            return n;
        }
    }

    public int toPrevChar(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay sText = s;
            int pText = p;
            int maxCch = 0;
            if (p == 0) {
                if (!s.isDoc() && !s.isAttr()) {
                    sText = s.prevNonAttrSplay();
                    pText = sText.getEndPos();
                    maxCch = sText.getCchAfter();
                }
            } else if (s.isLeaf() && p <= s.getPosLeafEnd()) {
                int dCch = s.ensureContentValid();
                pText = p += dCch;
                maxCch = p - 1;
            } else {
                maxCch = p - s.getPosAfter();
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(pText <= sText.getEndPos());
            }
            if (maxCch == 0 || cch == 0) {
                int n = 0;
                return n;
            }
            if (cch < 0 || cch > maxCch) {
                cch = maxCch;
            }
            this.set(sText, pText - cch);
            int n = cch;
            return n;
        }
    }

    public void toEndDoc() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.set(this.getRoot(), 0);
        }
    }

    public void toStartDoc() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.set(this.getRoot()._doc, 0);
        }
    }

    public XmlCursor.TokenType toFirstContentToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                XmlCursor.TokenType tokenType = XmlCursor.TokenType.NONE;
                return tokenType;
            }
            s.ensureContentValid();
            if (s.getCch() > 0 || s.isLeaf()) {
                this.set(1);
            } else {
                this.set(s.nextNonAttrSplay(), 0);
            }
            XmlCursor.TokenType tokenType = this.currentTokenType();
            return tokenType;
        }
    }

    public XmlCursor.TokenType toEndToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                XmlCursor.TokenType tokenType = XmlCursor.TokenType.NONE;
                return tokenType;
            }
            if (s.isLeaf()) {
                this.set(s.getPosLeafEnd());
            } else {
                this.set(s.getFinishSplay());
            }
            XmlCursor.TokenType tokenType = this.currentTokenType();
            return tokenType;
        }
    }

    public boolean toParent() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0 && s.isDoc()) {
                boolean bl = false;
                return bl;
            }
            this.set(s.getContainer(p), 0);
            boolean bl = true;
            return bl;
        }
    }

    public boolean toNextSibling() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc()) {
                    boolean bl = false;
                    return bl;
                }
                if (s.isBegin()) {
                    s = s.getFinishSplay().nextSplay();
                }
            } else {
                if (s.isLeaf() && p <= s.getPosLeafEnd()) {
                    boolean bl = false;
                    return bl;
                }
                s = s.nextSplay();
            }
            while (!s.isBegin()) {
                if (s.isFinish()) {
                    boolean bl = false;
                    return bl;
                }
                s = s.nextSplay();
            }
            this.set(s, 0);
            boolean bl = true;
            return bl;
        }
    }

    public boolean toNextSibling(String name) {
        return this.toNextSibling(new QName(name));
    }

    public boolean toNextSibling(String namespace, String name) {
        return this.toNextSibling(new QName(namespace, name));
    }

    public boolean toNextSibling(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            while (this.toNextSibling()) {
                if (!this.getName().equals(name)) continue;
                boolean bl = true;
                return bl;
            }
            this.set(sOriginal, pOriginal);
            boolean bl = false;
            return bl;
        }
    }

    public boolean toPrevSibling() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc() || s.isAttr()) {
                    boolean bl = false;
                    return bl;
                }
                s = s.prevSplay();
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(p > 0);
                }
                if (s.isContainer()) {
                    if (s.isLeaf()) {
                        if (p <= s.getPosLeafEnd()) {
                            boolean bl = false;
                            return bl;
                        }
                        this.set(0);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            while (true) {
                if (s.isEnd()) {
                    s = s.getContainer();
                    break;
                }
                if (s.isLeaf()) break;
                if (s.isContainer()) {
                    boolean bl = false;
                    return bl;
                }
                s = s.prevSplay();
            }
            this.set(s, 0);
            boolean bl = true;
            return bl;
        }
    }

    private Splay getStart() {
        this.checkDisposed();
        Splay s = this.getSplay();
        if (!s.isContainer() || this.getPos() != 0) {
            this.push();
            s = this.toNextSibling() ? this.getSplay() : null;
            this.pop();
        }
        return s;
    }

    public boolean toFirstChild() {
        return this.toChild((QName)null);
    }

    public boolean toChild(String name) {
        return this.toChild(new QName(name));
    }

    public boolean toChild(String namespace, String name) {
        return this.toChild(new QName(namespace, name));
    }

    public boolean toChild(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay.Begin s = this.getRoot().findNthBegin(this.getStart(), name, null, 0);
            if (s == null) {
                boolean bl = false;
                return bl;
            }
            this.set(s, 0);
            boolean bl = true;
            return bl;
        }
    }

    public boolean toChild(int n) {
        return this.toChild(null, n);
    }

    public boolean toChild(QName name, int n) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay.Begin s = this.getRoot().findNthBegin(this.getStart(), name, null, n);
            if (s == null) {
                boolean bl = false;
                return bl;
            }
            this.set(s, 0);
            boolean bl = true;
            return bl;
        }
    }

    public boolean toLastChild() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!(sOriginal.isContainer() && pOriginal == 0 || this.toNextSibling())) {
                boolean bl = false;
                return bl;
            }
            if (!this.toEndToken().isNone() && this.toPrevSibling()) {
                boolean bl = true;
                return bl;
            }
            this.set(sOriginal, pOriginal);
            boolean bl = false;
            return bl;
        }
    }

    public boolean toFirstAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!sOriginal.isContainer() || pOriginal != 0) {
                boolean bl = false;
                return bl;
            }
            Splay s = sOriginal.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    boolean bl = true;
                    return bl;
                }
                s = s.nextSplay();
            }
            this.set(sOriginal, pOriginal);
            boolean bl = false;
            return bl;
        }
    }

    public boolean toLastAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!sOriginal.isContainer() || pOriginal != 0) {
                boolean bl = false;
                return bl;
            }
            Splay lastNormalAttr = null;
            Splay s = sOriginal.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    lastNormalAttr = s;
                }
                s = s.nextSplay();
            }
            if (lastNormalAttr != null) {
                this.set(lastNormalAttr, 0);
                boolean bl = true;
                return bl;
            }
            this.set(sOriginal, pOriginal);
            boolean bl = false;
            return bl;
        }
    }

    public boolean toNextAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (!s.isAttr()) {
                boolean bl = false;
                return bl;
            }
            s = s.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    boolean bl = true;
                    return bl;
                }
                s = s.nextSplay();
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean toPrevAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (!s.isAttr()) {
                boolean bl = false;
                return bl;
            }
            s = s.prevSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    boolean bl = true;
                    return bl;
                }
                s = s.prevSplay();
            }
            boolean bl = false;
            return bl;
        }
    }

    public String getAttributeText(QName attrName) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            if (this.getPos() > 0) {
                String string = null;
                return string;
            }
            Splay s = this.getSplay().getAttr(attrName);
            String string = s == null ? null : s.getText(this.getRoot());
            return string;
        }
    }

    public boolean setAttributeText(QName attrName, String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            Cursor.validateLocalName(attrName.getLocalPart());
            if (this.getPos() > 0) {
                boolean bl = false;
                return bl;
            }
            Splay s = this.getSplay();
            if (!s.isContainer()) {
                boolean bl = false;
                return bl;
            }
            if (value == null) {
                value = "";
            }
            if ((s = this.getSplay().getAttr(attrName)) == null) {
                XmlCursor c = this.newCursor();
                try {
                    do {
                        c.toNextToken();
                    } while (c.isAnyAttr());
                    c.insertAttributeWithValue(attrName, value);
                    Object var9_9 = null;
                    c.dispose();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    c.dispose();
                    throw throwable;
                }
            } else {
                s.setText(this.getRoot(), value, 0, value.length());
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeAttribute(QName attrName) {
        Object object = this.monitor();
        synchronized (object) {
            Splay s;
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            if (this.getPos() > 0) {
                boolean bl = false;
                return bl;
            }
            boolean removed = false;
            while ((s = this.getSplay().getAttr(attrName)) != null) {
                s.remove(this.getRoot(), true);
                removed = true;
            }
            boolean bl = removed;
            return bl;
        }
    }

    public int removeChars(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int postCch = this.getPostCch();
            if (postCch == 0 || cch == 0) {
                int n = 0;
                return n;
            }
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            int n = this.getSplay().removeChars(this.getRoot(), this.getPos(), cch);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int moveChars(int cch, XmlCursor dst) {
        int n;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (this.monitor() == dst.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveCharsImpl(cch, dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        n = this.moveCharsImpl(cch, dst);
                    }
                }
                Object var10_10 = null;
                if (!acquired) return n;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return n;
    }

    private int moveCharsImpl(int cch, XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        if (pDst == 0 && (sDst.isDoc() || sDst.isAttr())) {
            throw new IllegalArgumentException("Invalid destination");
        }
        return this.getSplay().moveChars(this.getRoot(), this.getPos(), cch, rDst, sDst, pDst, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int copyChars(int cch, XmlCursor dst) {
        int n;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyCharsImpl(cch, dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        n = this.copyCharsImpl(cch, dst);
                    }
                }
                Object var10_10 = null;
                if (!acquired) return n;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return n;
    }

    private int copyCharsImpl(int cch, XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        if (pDst == 0) {
            if (sDst.isDoc() || sDst.isAttr()) {
                throw new IllegalArgumentException("Invalid destination");
            }
            sDst = sDst.prevNonAttrSplay();
            pDst = sDst.getEndPos();
        }
        return this.getSplay().copyChars(this.getRoot(), this.getPos(), cch, rDst, sDst, pDst);
    }

    public String namespaceForPrefix(String prefix) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            String string = s.namespaceForPrefix(prefix, true);
            return string;
        }
    }

    public String prefixForNamespace(String ns) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (ns == null || ns.length() == 0) {
                throw new IllegalArgumentException("Must specify a namespace");
            }
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            String result = s.prefixForNamespace(this.getRoot(), ns, null, true);
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(result != null);
            }
            String string = result;
            return string;
        }
    }

    public void getAllNamespaces(Map addToThis) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            XmlCursor c = this.newCursor();
            do {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(c.isContainer());
                }
                QName cName = c.getName();
                while (!c.toNextToken().isNone() && c.isAnyAttr()) {
                    if (!c.isNamespace()) continue;
                    String prefix = c.getName().getLocalPart();
                    String uri = c.getName().getNamespaceURI();
                    if (prefix.length() == 0 && uri.length() > 0 && cName != null && cName.getNamespaceURI().length() > 0 || addToThis.containsKey(prefix)) continue;
                    addToThis.put(prefix, uri);
                }
                c.toParent();
            } while (c.toParent());
            c.dispose();
        }
    }

    public int comparePosition(XmlCursor xthat) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (xthat == null || !(xthat instanceof Cursor)) {
                throw new IllegalArgumentException("Invalid that cursor");
            }
            Cursor that = (Cursor)xthat;
            Root r = this.getRoot();
            if (r != that.getRoot()) {
                throw new IllegalArgumentException("Cursors not in same document");
            }
            Cursor.checkDisposed(that);
            int n = this.getSplay().compare(r, this.getPos(), that.getSplay(), that.getPos());
            return n;
        }
    }

    public boolean isLeftOf(XmlCursor that) {
        return this.comparePosition(that) < 0;
    }

    public boolean isAtSamePositionAs(XmlCursor that) {
        return this.comparePosition(that) == 0;
    }

    public boolean isRightOf(XmlCursor that) {
        return this.comparePosition(that) > 0;
    }

    public InputStream newInputStream(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Saver.InputStreamSaver inputStreamSaver = new Saver.InputStreamSaver(this.getRoot(), this.getSplay(), this.getPos(), options);
            return inputStreamSaver;
        }
    }

    public InputStream newInputStream() {
        return this.newInputStream(null);
    }

    public Reader newReader() {
        return this.newReader(null);
    }

    public Reader newReader(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Saver.TextReader textReader = new Saver.TextReader(this.getRoot(), this.getSplay(), this.getPos(), options);
            return textReader;
        }
    }

    public XMLInputStream newXMLInputStream(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Saver.XmlInputStreamImpl xmlInputStreamImpl = new Saver.XmlInputStreamImpl(this.getRoot(), this.getSplay(), this.getPos(), options);
            return xmlInputStreamImpl;
        }
    }

    public XMLInputStream newXMLInputStream() {
        return this.newXMLInputStream(null);
    }

    static final XmlOptions buildPrettyOptions() {
        XmlOptions options = new XmlOptions();
        options.put("SAVE_PRETTY_PRINT");
        options.put("SAVE_AGGRESSIVE_NAMESPACES");
        options.put("SAVE_USE_DEFAULT_NAMESPACE");
        return options;
    }

    public String toString() {
        return this.xmlText(_toStringOptions);
    }

    public String xmlText() {
        return this.xmlText(null);
    }

    public String xmlText(XmlOptions options) {
        Saver.TextSaver saver;
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            saver = new Saver.TextSaver(this.getRoot(), this.getSplay(), this.getPos(), options, null);
        }
        return saver.saveToString();
    }

    public XmlCursor.ChangeStamp getDocChangeStamp() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            ChangeStampImpl changeStampImpl = new ChangeStampImpl(this.getRoot());
            return changeStampImpl;
        }
    }

    public boolean removeXml() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(p < s.getEndPos());
            }
            if (p > 0) {
                if (s.isLeaf() && p == s.getPosLeafEnd()) {
                    boolean bl = false;
                    return bl;
                }
                int cchRemove = this.removeChars(this.getPostCch());
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(cchRemove > 0);
                }
                boolean bl = true;
                return bl;
            }
            if (s.isDoc()) {
                throw new IllegalStateException("Can't remove a whole document.");
            }
            if (s.isFinish()) {
                boolean bl = false;
                return bl;
            }
            s.remove(this.getRoot(), true);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveXml(XmlCursor dst) {
        boolean bl;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveXmlImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        bl = this.moveXmlImpl(dst);
                    }
                }
                Object var9_9 = null;
                if (!acquired) return bl;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return bl;
    }

    private boolean moveXmlImpl(XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Can't move to a foreign document");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        Root rSrc = this.getRoot();
        Splay sSrc = this.getSplay();
        int pSrc = this.getPos();
        if (sSrc.checkInsertionValidity(pSrc, sDst, pDst, true)) {
            return sSrc.moveChars(rSrc, pSrc, this.getPostCch(), rDst, sDst, pDst, false) > 0;
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pSrc == 0);
        }
        if (rSrc == rDst && sDst.between(rDst, pDst, sSrc)) {
            return false;
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(pSrc == 0);
        }
        sSrc.move(rSrc, cDst.getRoot(), cDst.getSplay(), cDst.getPos(), true);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyXml(XmlCursor dst) {
        boolean bl;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyXmlImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        bl = this.copyXmlImpl(dst);
                    }
                }
                Object var9_9 = null;
                if (!acquired) return bl;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return bl;
    }

    private boolean copyXmlImpl(XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Can't copy to a foreign document");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        Splay s = this.getSplay();
        int p = this.getPos();
        if (s.checkInsertionValidity(p, sDst, pDst, true)) {
            return this.copyCharsImpl(this.getPostCch(), dst) > 0;
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(p == 0);
        }
        Root r = this.getRoot();
        Root rDst = cDst.getRoot();
        Splay copy = s.copySplay();
        Object txt = r._text;
        int cp = r.getCp(s);
        int cch = copy.getCchLeft() + copy.getCch();
        if (s.isLeaf() && s.getCchAfter() > 0) {
            int cchValue = s.getCchValue();
            int cchAfter = s.getCchAfter();
            if (cchValue == 0) {
                cp += cchAfter;
            } else if (s.nextSplay().isAttr()) {
                char[] buf = new char[cch];
                r._text.fetch(buf, 0, cp, cchValue);
                r._text.fetch(buf, cchValue, cp + cchValue + cchAfter, cch - cchValue);
                txt = buf;
                cp = 0;
            }
        }
        sDst.insert(rDst, pDst, copy, txt, cp, cch, true);
        return true;
    }

    public boolean removeXmlContents() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (!this.isContainer()) {
                boolean bl = false;
                return bl;
            }
            XmlCursor.TokenType tt = this.toFirstContentToken();
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(!tt.isNone());
            }
            boolean removed = !this.isFinish();
            try {
                while (!this.isFinish()) {
                    boolean b = this.removeXml();
                    if (!XmlBeans.ASSERTS) continue;
                    XmlBeans.assertTrue(b);
                }
                Object var7_6 = null;
                this.toParent();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.toParent();
                throw throwable;
            }
            boolean bl = removed;
            return bl;
        }
    }

    private boolean contains(XmlCursor dst) {
        if (this.isInSameDocument(dst)) {
            dst.push();
            do {
                if (!dst.isAtSamePositionAs(this)) continue;
                dst.pop();
                return true;
            } while (dst.toParent());
            dst.pop();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveXmlContents(XmlCursor dst) {
        boolean bl;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveXmlContentsImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        bl = this.moveXmlContentsImpl(dst);
                    }
                }
                Object var9_9 = null;
                if (!acquired) return bl;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveXmlContentsImpl(XmlCursor dst) {
        this.checkDisposed();
        if (!this.isContainer()) {
            return false;
        }
        if (this.contains(dst)) {
            return false;
        }
        XmlCursor.TokenType tt = this.toFirstContentToken();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(!tt.isNone());
        }
        boolean moved = !this.isFinish();
        try {
            if (!this.moveXmlImpl(dst)) {
                boolean bl = false;
                Object var7_5 = null;
                this.toParent();
                return bl;
            }
            while (true) {
                if (this.isFinish()) {
                    break;
                }
                boolean b = this.moveXmlImpl(dst);
                if (!XmlBeans.ASSERTS) continue;
                XmlBeans.assertTrue(b);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.toParent();
            throw throwable;
        }
        Object var7_6 = null;
        this.toParent();
        return moved;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyXmlContents(XmlCursor dst) {
        boolean bl;
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyXmlContentsImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            try {
                GlobalLock.acquire();
                acquired = true;
                Object object = this.monitor();
                synchronized (object) {
                    Object object2 = dst.monitor();
                    synchronized (object2) {
                        GlobalLock.release();
                        acquired = false;
                        bl = this.copyXmlContentsImpl(dst);
                    }
                }
                Object var9_9 = null;
                if (!acquired) return bl;
            }
            catch (InterruptedException e) {
                throw new XmlRuntimeException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!acquired) throw throwable;
            GlobalLock.release();
            throw throwable;
        }
        GlobalLock.release();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyXmlContentsImpl(XmlCursor dst) {
        this.checkDisposed();
        if (!this.isContainer()) {
            return false;
        }
        if (this.contains(dst)) {
            XmlCursor cTmp = XmlObject.Factory.newInstance().newCursor();
            cTmp.toNextToken();
            if (!this.copyXmlContentsImpl(cTmp)) {
                cTmp.dispose();
                return false;
            }
            cTmp.toStartDoc();
            ((Cursor)cTmp).moveXmlContentsImpl(dst);
            cTmp.dispose();
            return true;
        }
        XmlCursor.TokenType tt = this.toFirstContentToken();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(!tt.isNone());
        }
        boolean copied = !this.isFinish();
        try {
            if (!this.copyXmlImpl(dst)) {
                boolean bl = false;
                Object var7_6 = null;
                this.toParent();
                return bl;
            }
            while (true) {
                if (this.isStart()) {
                    this.toEndToken();
                }
                this.toNextToken();
                if (!this.isFinish()) {
                    boolean b = this.copyXmlImpl(dst);
                    if (!XmlBeans.ASSERTS) continue;
                    XmlBeans.assertTrue(b);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.toParent();
            throw throwable;
        }
        Object var7_7 = null;
        this.toParent();
        return copied;
    }

    public boolean isInSameDocument(XmlCursor xthat) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (xthat == null || !(xthat instanceof Cursor)) {
                boolean bl = false;
                return bl;
            }
            Cursor that = (Cursor)xthat;
            Cursor.checkDisposed(that);
            boolean bl = this.getRoot() == that.getRoot();
            return bl;
        }
    }

    public void push() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._stack == null) {
                this._data._stack = new Selections();
            }
            this._data._stack.add(this.getRoot(), this.getSplay(), this.getPos());
            this.getRoot().registerForChange(this);
        }
    }

    public boolean pop() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._stack == null || this._data._stack.size() == 0) {
                boolean bl = false;
                return bl;
            }
            this._data._stack.setCursor(this, this._data._stack.size() - 1);
            this._data._stack.pop();
            boolean bl = true;
            return bl;
        }
    }

    public int getSelectionCount() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int n = this._data._selections == null ? 0 : this._data._selections.size();
            return n;
        }
    }

    public boolean toSelection(int i) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections != null && i >= 0 && this._data._selections.setCursor(this, i)) {
                this._data._currentSelection = i;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean hasNextSelection() {
        Object object = this.monitor();
        synchronized (object) {
            boolean bl;
            this.push();
            int currentSelection = this._data._currentSelection;
            try {
                bl = this.toNextSelection();
                Object var5_4 = null;
                this.pop();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.pop();
                this._data._currentSelection = currentSelection;
                throw throwable;
            }
            this._data._currentSelection = currentSelection;
            return bl;
        }
    }

    public boolean toNextSelection() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null || this._data._currentSelection < -1) {
                boolean bl = false;
                return bl;
            }
            int nextSelection = this._data._currentSelection + 1;
            if (!this._data._selections.setCursor(this, nextSelection)) {
                this._data._currentSelection = -2;
                boolean bl = false;
                return bl;
            }
            this._data._currentSelection = nextSelection;
            boolean bl = true;
            return bl;
        }
    }

    public void clearSelections() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this._data.clearSelections();
        }
    }

    public void addToSelection() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null) {
                this._data._selections = Path.newSelections();
            }
            this._data._selections.size();
            this._data._selections.add(this.getRoot(), this.getSplay(), this.getPos());
            this.getRoot().registerForChange(this);
        }
    }

    public void changeNotification() {
        if (!this.isDisposed()) {
            if (this._data._selections != null) {
                this._data._selections.size();
                this._data._selections.cursify(this.getRoot());
            }
            if (this._data._stack != null) {
                this._data._stack.cursify(this.getRoot());
            }
        }
    }

    public void selectPath(String path, XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null) {
                this._data._selections = Path.newSelections();
            } else {
                this._data._selections.dispose();
            }
            this._data._selections.init(Path.select(this.getRoot(), this.getSplay(), this.getPos(), path, options));
            this.push();
            if (this._data._selections.setCursor(this, 0)) {
                this.getRoot().registerForChange(this);
                this._data._currentSelection = -1;
            } else {
                this._data._currentSelection = -2;
            }
            this.pop();
        }
    }

    public void selectPath(String path) {
        this.selectPath(path, null);
    }

    public XmlCursor execQuery(String queryExpr, XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            XmlCursor xmlCursor = Path.query(this, queryExpr, options);
            return xmlCursor;
        }
    }

    public XmlCursor execQuery(String query) {
        return this.execQuery(query, null);
    }

    public Node newDomNode() {
        return this.newDomNode(null);
    }

    public Node newDomNode(XmlOptions options) {
        try {
            Saver.DomSaver saver;
            Object object = this.monitor();
            synchronized (object) {
                this.checkDisposed();
                saver = new Saver.DomSaver(this.getRoot(), this.getSplay(), this.getPos(), !this.isFragment(), options);
            }
            return saver.exportDom();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new XmlRuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFragment() {
        XmlCursor c;
        boolean seenElement;
        block17: {
            boolean bl;
            block18: {
                boolean bl2;
                block16: {
                    if (!this.isStartdoc()) {
                        return true;
                    }
                    seenElement = false;
                    c = this.newCursor();
                    int token = c.toNextToken().intValue();
                    try {
                        while (true) {
                            switch (token) {
                                case 3: {
                                    if (seenElement) {
                                        boolean bl3 = true;
                                        Object var8_5 = null;
                                        c.dispose();
                                        return bl3;
                                    }
                                    seenElement = true;
                                    token = c.toEndToken().intValue();
                                    break;
                                }
                                case 5: {
                                    if (!Splay.isWhiteSpace(c.getChars())) {
                                        bl2 = true;
                                        break block16;
                                    } else {
                                        token = c.toNextToken().intValue();
                                        break;
                                    }
                                }
                                case 0: 
                                case 2: {
                                    break block17;
                                }
                                case 6: 
                                case 7: {
                                    bl = true;
                                    break block18;
                                }
                                case 4: 
                                case 8: 
                                case 9: {
                                    token = c.toNextToken().intValue();
                                    break;
                                }
                                case 1: {
                                    if (XmlBeans.ASSERTS) {
                                        XmlBeans.assertTrue(false);
                                    }
                                    break block17;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        c.dispose();
                        throw throwable;
                    }
                }
                Object var8_6 = null;
                c.dispose();
                return bl2;
            }
            Object var8_7 = null;
            c.dispose();
            return bl;
        }
        Object var8_8 = null;
        c.dispose();
        if (seenElement) return false;
        return true;
    }

    public void save(ContentHandler ch, LexicalHandler lh) throws SAXException {
        this.save(ch, lh, null);
    }

    public void save(File file) throws IOException {
        this.save(file, null);
    }

    public void save(OutputStream os) throws IOException {
        this.save(os, null);
    }

    public void save(Writer w) throws IOException {
        this.save(w, null);
    }

    public void save(ContentHandler ch, LexicalHandler lh, XmlOptions options) throws SAXException {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            new Saver.SaxSaver(this.getRoot(), this.getSplay(), this.getPos(), options, ch, lh);
        }
    }

    public void save(File file, XmlOptions options) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.save(os, options);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
    }

    public void save(OutputStream os, XmlOptions options) throws IOException {
        InputStream is = this.newInputStream(options);
        try {
            int n;
            byte[] bytes = new byte[8192];
            while ((n = is.read(bytes)) >= 0) {
                os.write(bytes, 0, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    public void save(Writer w, XmlOptions options) throws IOException {
        Reader r = this.newReader(options);
        try {
            int n;
            char[] chars = new char[8192];
            while ((n = r.read(chars)) >= 0) {
                w.write(chars, 0, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            r.close();
            throw throwable;
        }
        r.close();
    }

    private boolean validate() {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._data._goober.getRoot().validate());
        }
        return true;
    }

    public void dump() {
        this._data._goober.getRoot().dump();
    }

    public void dump(boolean verbose) {
        this._data._goober.getRoot().dump(verbose);
    }

    static class Selections {
        private Splay[] _splays;
        private int[] _positions;
        private int _count;
        private ArrayList _cursors;
        private PathEngine _pathEngine;

        Selections() {
        }

        void init(PathEngine pathEngine) {
            this.dispose();
            this._pathEngine = pathEngine;
        }

        void add(Root r, Splay s) {
            this.add(r, s, 0);
        }

        void add(Root r, Splay s, int p) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(s.getRootSlow() == r);
            }
            if (this._cursors != null) {
                Splay.CursorGoober g = new Splay.CursorGoober(r);
                g.set(s, p);
                this._cursors.add(g);
                return;
            }
            if (this._splays == null) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(this._count == 0);
                }
                this._splays = new Splay[16];
                this._positions = new int[16];
            } else if (this._count == this._splays.length) {
                Splay[] newSplays = new Splay[this._count * 2];
                int[] newPositions = new int[this._count * 2];
                System.arraycopy(this._splays, 0, newSplays, 0, this._count);
                System.arraycopy(this._positions, 0, newPositions, 0, this._count);
                this._splays = newSplays;
                this._positions = newPositions;
            }
            this._splays[this._count] = s;
            this._positions[this._count] = p;
            ++this._count;
        }

        void pop() {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(this.size() > 0);
            }
            if (this._cursors != null) {
                int i = this._cursors.size() - 1;
                ((Splay.CursorGoober)this._cursors.get(i)).set(null, 0);
                this._cursors.remove(i);
            } else {
                --this._count;
            }
        }

        void cursify(Root r) {
            if (this._cursors != null || this._count <= 0) {
                return;
            }
            this._cursors = new ArrayList();
            int i = 0;
            while (i < this._count) {
                Splay.CursorGoober g = new Splay.CursorGoober(r);
                g.set(this._splays[i], this._positions[i]);
                this._cursors.add(g);
                ++i;
            }
            this._count = 0;
        }

        int size() {
            if (this._pathEngine != null) {
                while (this._pathEngine.next(this)) {
                }
                this._pathEngine = null;
            }
            return this.currentSize();
        }

        int currentSize() {
            return this._cursors != null ? this._cursors.size() : this._count;
        }

        boolean setCursor(Cursor c, int i) {
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(i >= 0);
            }
            while (this._pathEngine != null && this.currentSize() <= i) {
                if (this._pathEngine.next(this)) continue;
                this._pathEngine = null;
            }
            if (i >= this.currentSize()) {
                return false;
            }
            if (this._cursors != null) {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(i < this._cursors.size());
                }
                c.set((Splay.CursorGoober)this._cursors.get(i));
            } else {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(i < this._count);
                }
                c.set(this._splays[i], this._positions[i]);
            }
            return true;
        }

        void dispose() {
            if (this._cursors != null) {
                int i = 0;
                while (i < this._cursors.size()) {
                    ((Splay.CursorGoober)this._cursors.get(i)).set(null, 0);
                    ++i;
                }
                this._cursors.clear();
                this._cursors = null;
            }
            this._count = 0;
        }
    }

    static interface PathEngine {
        public boolean next(Selections var1);
    }

    static class ChangeStampImpl
    implements XmlCursor.ChangeStamp {
        private final Root _root;
        private final long _versionStamp;

        ChangeStampImpl(Root r) {
            this._root = r;
            this._versionStamp = this._root.getVersion();
        }

        public boolean hasChanged() {
            return this._versionStamp != this._root.getVersion();
        }
    }
}

