/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAttributeGroup;
import org.apache.xmlbeans.SchemaComponent;
import org.apache.xmlbeans.SchemaGlobalAttribute;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaModelGroup;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.IOUtil;
import org.apache.xmlbeans.impl.common.NetUtils;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.SequencedHashMap;
import org.apache.xmlbeans.impl.common.SequencedHashSet;
import org.apache.xmlbeans.impl.common.StringUtils;
import org.apache.xmlbeans.impl.config.ExtensionHolder;
import org.apache.xmlbeans.impl.config.SchemaConfig;
import org.apache.xmlbeans.impl.schema.SchemaAttributeGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaGlobalAttributeImpl;
import org.apache.xmlbeans.impl.schema.SchemaGlobalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaIdentityConstraintImpl;
import org.apache.xmlbeans.impl.schema.SchemaModelGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;
import org.apache.xmlbeans.impl.schema.XmlValueRef;
import org.apache.xmlbeans.impl.util.HexBin;
import org.apache.xmlbeans.impl.values.XmlStringImpl;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.xml.sax.EntityResolver;

public class StscState {
    private String _givenStsName;
    private Collection _errorListener;
    private SchemaTypeSystemImpl _target;
    private SchemaConfig _config;
    private Map _compatMap;
    private boolean _doingDownloads;
    private byte[] _digest = null;
    private boolean _noDigest = false;
    private SchemaTypeLoader _importingLoader;
    private Map _redefinedGlobalTypes = new SequencedHashMap();
    private Map _redefinedModelGroups = new SequencedHashMap();
    private Map _redefinedAttributeGroups = new SequencedHashMap();
    private Map _globalTypes = new SequencedHashMap();
    private Map _globalElements = new SequencedHashMap();
    private Map _globalAttributes = new SequencedHashMap();
    private Map _modelGroups = new SequencedHashMap();
    private Map _attributeGroups = new SequencedHashMap();
    private Map _documentTypes = new SequencedHashMap();
    private Map _attributeTypes = new SequencedHashMap();
    private Map _typesByClassname = new SequencedHashMap();
    private Map _misspelledNames = new HashMap();
    private Set _processingGroups = new SequencedHashSet();
    private Map _idConstraints = new SequencedHashMap();
    private Set _namespaces = new HashSet();
    private boolean _noUpa;
    private boolean _noPvr;
    private Set _mdefNamespaces = StscState.buildDefaultMdefNamespaces();
    private EntityResolver _entityResolver;
    public static final Object CHAMELEON_INCLUDE_URI = new Object();
    private static ThreadLocal stscStack = new ThreadLocal(){

        protected Object initialValue() {
            return new StscStack();
        }
    };
    private static final XmlValueRef XMLSTR_PRESERVE = StscState.buildString("preserve");
    private static final XmlValueRef XMLSTR_REPLACE = StscState.buildString("preserve");
    private static final XmlValueRef XMLSTR_COLLAPSE = StscState.buildString("preserve");
    static final SchemaType[] EMPTY_ST_ARRAY = new SchemaType[0];
    static final SchemaType.Ref[] EMPTY_STREF_ARRAY = new SchemaType.Ref[0];
    private static final XmlValueRef[] FACETS_NONE = new XmlValueRef[]{null, null, null, null, null, null, null, null, null, null, null, null};
    private static final boolean[] FIXED_FACETS_NONE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
    private static final XmlValueRef[] FACETS_WS_COLLAPSE = new XmlValueRef[]{null, null, null, null, null, null, null, null, null, StscState.build_wsstring(3), null, null};
    private static final boolean[] FIXED_FACETS_WS = new boolean[]{false, false, false, false, false, false, false, false, false, true, false, false};
    static final XmlValueRef[] FACETS_UNION = FACETS_NONE;
    static final boolean[] FIXED_FACETS_UNION = FIXED_FACETS_NONE;
    static final XmlValueRef[] FACETS_LIST = FACETS_WS_COLLAPSE;
    static final boolean[] FIXED_FACETS_LIST = FIXED_FACETS_WS;
    private static final String PROJECT_URL_PREFIX = "project://local";
    Map _sourceForUri = new HashMap();
    String _baseURI = "project://local/";
    SchemaTypeLoader _s4sloader = XmlBeans.typeLoaderForClassLoader((class$org$w3$x2001$xmlSchema$SchemaDocument == null ? (class$org$w3$x2001$xmlSchema$SchemaDocument = StscState.class$("org.w3.x2001.xmlSchema.SchemaDocument")) : class$org$w3$x2001$xmlSchema$SchemaDocument).getClassLoader());
    static /* synthetic */ Class class$org$w3$x2001$xmlSchema$SchemaDocument;

    private static Set buildDefaultMdefNamespaces() {
        return new HashSet<String>(Arrays.asList("http://www.openuri.org/2002/04/soap/conversation/"));
    }

    private StscState() {
    }

    public void setImportingTypeLoader(SchemaTypeLoader loader) {
        this._importingLoader = loader;
    }

    public void setErrorListener(Collection errorListener) {
        this._errorListener = errorListener;
    }

    public void error(String message, int code, XmlObject loc) {
        StscState.addError(this._errorListener, message, code, loc);
    }

    public void warning(String message, int code, XmlObject loc) {
        if (code == 44 && loc.documentProperties().getSourceName() != null && loc.documentProperties().getSourceName().indexOf("XMLSchema.xsd") > 0) {
            return;
        }
        StscState.addWarning(this._errorListener, message, code, loc);
    }

    public void info(String message) {
        StscState.addInfo(this._errorListener, message);
    }

    public static void addError(Collection errorListener, String message, int code, XmlObject location) {
        XmlError err = XmlError.forObject(message, 0, location);
        errorListener.add(err);
    }

    public static void addError(Collection errorListener, String message, int code, File location) {
        XmlError err = XmlError.forLocation(message, 0, IOUtil.fileToURL(location).toString(), 0, 0, 0);
        errorListener.add(err);
    }

    public static void addWarning(Collection errorListener, String message, int code, XmlObject location) {
        XmlError err = XmlError.forObject(message, 1, location);
        errorListener.add(err);
    }

    public static void addInfo(Collection errorListener, String message) {
        XmlError err = XmlError.forMessage(message, 2);
        errorListener.add(err);
    }

    public void setGivenTypeSystemName(String name) {
        this._givenStsName = name;
    }

    public void setTargetSchemaTypeSystem(SchemaTypeSystemImpl target) {
        this._target = target;
    }

    public void addSchemaDigest(byte[] digest) {
        int len;
        if (this._noDigest) {
            return;
        }
        if (digest == null) {
            this._noDigest = true;
            this._digest = null;
            return;
        }
        if (this._digest == null) {
            this._digest = new byte[16];
        }
        if (digest.length < (len = this._digest.length)) {
            len = digest.length;
        }
        int i = 0;
        while (i < len) {
            int n = i;
            this._digest[n] = (byte)(this._digest[n] ^ digest[i]);
            ++i;
        }
    }

    public SchemaTypeSystemImpl sts() {
        if (this._target != null) {
            return this._target;
        }
        String name = this._givenStsName;
        if (name == null && this._digest != null) {
            name = "s" + new String(HexBin.encode(this._digest));
        }
        this._target = new SchemaTypeSystemImpl(name);
        return this._target;
    }

    public boolean shouldDownloadURI(String uriString) {
        if (this._doingDownloads) {
            return true;
        }
        if (uriString == null) {
            return false;
        }
        try {
            URL url = new URL(uriString);
            return url.getProtocol().equalsIgnoreCase("file");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setOptions(XmlOptions options) {
        if (options == null) {
            return;
        }
        this._compatMap = (Map)options.get("COMPILE_SUBSTITUTE_NAMES");
        boolean bl = options.hasOption("COMPILE_NO_UPA_RULE") ? true : (this._noUpa = !"true".equals(System.getProperty("xmlbean.uniqueparticleattribution", "true")));
        this._noPvr = options.hasOption("COMPILE_NO_PVR_RULE") ? true : !"true".equals(System.getProperty("xmlbean.particlerestriction", "true"));
        this._doingDownloads = options.hasOption("COMPILE_DOWNLOAD_URLS") ? true : "true".equals(System.getProperty("xmlbean.downloadurls", "false"));
        this._entityResolver = (EntityResolver)options.get("ENTITY_RESOLVER");
        if (this._entityResolver != null) {
            this._doingDownloads = true;
        }
        if (options.hasOption("COMPILE_MDEF_NAMESPACES")) {
            this._mdefNamespaces.addAll((Collection)options.get("COMPILE_MDEF_NAMESPACES"));
            String local = "##local";
            if (this._mdefNamespaces.contains(local)) {
                this._mdefNamespaces.remove(local);
                this._mdefNamespaces.add("");
            }
        }
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public boolean noUpa() {
        return this._noUpa;
    }

    public boolean noPvr() {
        return this._noPvr;
    }

    private QName compatName(QName name, String chameleonNamespace) {
        if (name.getNamespaceURI().length() == 0 && chameleonNamespace != null && chameleonNamespace.length() > 0) {
            name = new QName(chameleonNamespace, name.getLocalPart());
        }
        if (this._compatMap == null) {
            return name;
        }
        QName subst = (QName)this._compatMap.get(name);
        if (subst == null) {
            return name;
        }
        return subst;
    }

    public void setSchemaConfig(SchemaConfig config) throws IllegalArgumentException {
        this._config = config;
    }

    public String getPackageOverride(String namespace) {
        return this._config.lookupPackageForNamespace(namespace);
    }

    public String getJavaPrefix(String namespace) {
        return this._config.lookupPrefixForNamespace(namespace);
    }

    public String getJavaSuffix(String namespace) {
        return this._config.lookupSuffixForNamespace(namespace);
    }

    public String getJavaname(QName qname) {
        return this._config.lookupJavanameForQName(qname);
    }

    public ExtensionHolder getExtensionHolder(String javaName) {
        return this._config.extensionHolderFor(javaName);
    }

    public ExtensionHolder getExtensionHolder() {
        return this._config.getExtensionHolder();
    }

    private static String crunchName(QName name) {
        return name.getLocalPart().toLowerCase();
    }

    void addSpelling(QName name, SchemaComponent comp) {
        this._misspelledNames.put(StscState.crunchName(name), comp);
    }

    SchemaComponent findSpelling(QName name) {
        return (SchemaComponent)this._misspelledNames.get(StscState.crunchName(name));
    }

    void addNamespace(String targetNamespace) {
        this._namespaces.add(targetNamespace);
    }

    String[] getNamespaces() {
        return this._namespaces.toArray(new String[this._namespaces.size()]);
    }

    boolean linkerDefinesNamespace(String namespace) {
        return this._importingLoader.isNamespaceDefined(namespace);
    }

    SchemaTypeImpl findGlobalType(QName name, String chameleonNamespace) {
        SchemaTypeImpl result = (SchemaTypeImpl)this._globalTypes.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaTypeImpl)this._importingLoader.findType(name);
        }
        return result;
    }

    SchemaTypeImpl findRedefinedGlobalType(QName name, String chameleonNamespace, QName redefinedName) {
        if ((name = this.compatName(name, chameleonNamespace)).equals(redefinedName)) {
            return (SchemaTypeImpl)this._redefinedGlobalTypes.get(name);
        }
        SchemaTypeImpl result = (SchemaTypeImpl)this._globalTypes.get(name);
        if (result == null) {
            result = (SchemaTypeImpl)this._importingLoader.findType(name);
        }
        return result;
    }

    void addGlobalType(SchemaTypeImpl type, boolean redefined) {
        if (type != null) {
            QName name = type.getName();
            if (redefined) {
                if (this._redefinedGlobalTypes.containsKey(name)) {
                    if (!this.ignoreMdef(name)) {
                        this.error("Duplicate global type: " + QNameHelper.pretty(name), 49, null);
                    }
                } else {
                    this._redefinedGlobalTypes.put(name, type);
                }
            } else if (this._globalTypes.containsKey(name)) {
                if (!this.ignoreMdef(name)) {
                    this.error("Duplicate global type: " + QNameHelper.pretty(name), 49, null);
                }
            } else {
                this._globalTypes.put(name, type);
                this.addSpelling(name, type);
            }
        }
    }

    private boolean ignoreMdef(QName name) {
        return this._mdefNamespaces.contains(name.getNamespaceURI());
    }

    SchemaType[] globalTypes() {
        return this._globalTypes.values().toArray(new SchemaType[this._globalTypes.size()]);
    }

    SchemaType[] redefinedGlobalTypes() {
        return this._redefinedGlobalTypes.values().toArray(new SchemaType[this._redefinedGlobalTypes.size()]);
    }

    SchemaTypeImpl findDocumentType(QName name, String chameleonNamespace) {
        SchemaTypeImpl result = (SchemaTypeImpl)this._documentTypes.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaTypeImpl)this._importingLoader.findDocumentType(name);
        }
        return result;
    }

    void addDocumentType(SchemaTypeImpl type, QName name) {
        if (this._documentTypes.containsKey(name)) {
            if (!this.ignoreMdef(name)) {
                this.error("Duplicate global element: " + QNameHelper.pretty(name), 47, null);
            }
        } else {
            this._documentTypes.put(name, type);
        }
    }

    SchemaType[] documentTypes() {
        return this._documentTypes.values().toArray(new SchemaType[this._documentTypes.size()]);
    }

    SchemaTypeImpl findAttributeType(QName name, String chameleonNamespace) {
        SchemaTypeImpl result = (SchemaTypeImpl)this._attributeTypes.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaTypeImpl)this._importingLoader.findAttributeType(name);
        }
        return result;
    }

    void addAttributeType(SchemaTypeImpl type, QName name) {
        if (this._attributeTypes.containsKey(name)) {
            if (!this.ignoreMdef(name)) {
                this.error("Duplicate global attribute: " + QNameHelper.pretty(name), 48, null);
            }
        } else {
            this._attributeTypes.put(name, type);
        }
    }

    SchemaType[] attributeTypes() {
        return this._attributeTypes.values().toArray(new SchemaType[this._attributeTypes.size()]);
    }

    SchemaGlobalAttributeImpl findGlobalAttribute(QName name, String chameleonNamespace) {
        SchemaGlobalAttributeImpl result = (SchemaGlobalAttributeImpl)this._globalAttributes.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaGlobalAttributeImpl)this._importingLoader.findAttribute(name);
        }
        return result;
    }

    void addGlobalAttribute(SchemaGlobalAttributeImpl attribute) {
        if (attribute != null) {
            QName name = attribute.getName();
            this._globalAttributes.put(name, attribute);
            this.addSpelling(name, attribute);
        }
    }

    SchemaGlobalAttribute[] globalAttributes() {
        return this._globalAttributes.values().toArray(new SchemaGlobalAttribute[this._globalAttributes.size()]);
    }

    SchemaGlobalElementImpl findGlobalElement(QName name, String chameleonNamespace) {
        SchemaGlobalElementImpl result = (SchemaGlobalElementImpl)this._globalElements.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaGlobalElementImpl)this._importingLoader.findElement(name);
        }
        return result;
    }

    void addGlobalElement(SchemaGlobalElementImpl element) {
        if (element != null) {
            QName name = element.getName();
            this._globalElements.put(name, element);
            this.addSpelling(name, element);
        }
    }

    SchemaGlobalElement[] globalElements() {
        return this._globalElements.values().toArray(new SchemaGlobalElement[this._globalElements.size()]);
    }

    SchemaAttributeGroupImpl findAttributeGroup(QName name, String chameleonNamespace) {
        SchemaAttributeGroupImpl result = (SchemaAttributeGroupImpl)this._attributeGroups.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaAttributeGroupImpl)this._importingLoader.findAttributeGroup(name);
        }
        return result;
    }

    SchemaAttributeGroupImpl findRedefinedAttributeGroup(QName name, String chameleonNamespace, QName redefinitionFor) {
        if ((name = this.compatName(name, chameleonNamespace)).equals(redefinitionFor)) {
            return (SchemaAttributeGroupImpl)this._redefinedAttributeGroups.get(name);
        }
        SchemaAttributeGroupImpl result = (SchemaAttributeGroupImpl)this._attributeGroups.get(name);
        if (result == null) {
            result = (SchemaAttributeGroupImpl)this._importingLoader.findAttributeGroup(name);
        }
        return result;
    }

    void addAttributeGroup(SchemaAttributeGroupImpl attributeGroup, boolean redefined) {
        if (attributeGroup != null) {
            QName name = attributeGroup.getName();
            if (redefined) {
                if (this._redefinedAttributeGroups.containsKey(name)) {
                    if (!this.ignoreMdef(name)) {
                        this.error("Duplicate attribute group: " + QNameHelper.pretty(name), 49, null);
                    }
                } else {
                    this._redefinedAttributeGroups.put(name, attributeGroup);
                }
            } else if (this._attributeGroups.containsKey(name)) {
                if (!this.ignoreMdef(name)) {
                    this.error("Duplicate attribute group: " + QNameHelper.pretty(name), 49, null);
                }
            } else {
                this._attributeGroups.put(attributeGroup.getName(), attributeGroup);
                this.addSpelling(attributeGroup.getName(), attributeGroup);
            }
        }
    }

    SchemaAttributeGroup[] attributeGroups() {
        return this._attributeGroups.values().toArray(new SchemaAttributeGroup[this._attributeGroups.size()]);
    }

    SchemaAttributeGroup[] redefinedAttributeGroups() {
        return this._redefinedAttributeGroups.values().toArray(new SchemaAttributeGroup[this._redefinedAttributeGroups.size()]);
    }

    SchemaModelGroupImpl findModelGroup(QName name, String chameleonNamespace) {
        SchemaModelGroupImpl result = (SchemaModelGroupImpl)this._modelGroups.get(name = this.compatName(name, chameleonNamespace));
        if (result == null) {
            result = (SchemaModelGroupImpl)this._importingLoader.findModelGroup(name);
        }
        return result;
    }

    SchemaModelGroupImpl findRedefinedModelGroup(QName name, String chameleonNamespace, QName redefinitionFor) {
        if ((name = this.compatName(name, chameleonNamespace)).equals(redefinitionFor)) {
            return (SchemaModelGroupImpl)this._redefinedModelGroups.get(name);
        }
        SchemaModelGroupImpl result = (SchemaModelGroupImpl)this._modelGroups.get(name);
        if (result == null) {
            result = (SchemaModelGroupImpl)this._importingLoader.findModelGroup(name);
        }
        return result;
    }

    void addModelGroup(SchemaModelGroupImpl modelGroup, boolean redefined) {
        if (modelGroup != null) {
            QName name = modelGroup.getName();
            if (redefined) {
                if (this._redefinedModelGroups.containsKey(name)) {
                    if (!this.ignoreMdef(name)) {
                        this.error("Duplicate model group: " + QNameHelper.pretty(name), 49, null);
                    }
                } else {
                    this._redefinedModelGroups.put(name, modelGroup);
                }
            } else if (this._modelGroups.containsKey(name)) {
                if (!this.ignoreMdef(name)) {
                    this.error("Duplicate model group: " + QNameHelper.pretty(name), 49, null);
                }
            } else {
                this._modelGroups.put(modelGroup.getName(), modelGroup);
                this.addSpelling(modelGroup.getName(), modelGroup);
            }
        }
    }

    SchemaModelGroup[] modelGroups() {
        return this._modelGroups.values().toArray(new SchemaModelGroup[this._modelGroups.size()]);
    }

    SchemaModelGroup[] redefinedModelGroups() {
        return this._redefinedModelGroups.values().toArray(new SchemaModelGroup[this._redefinedModelGroups.size()]);
    }

    SchemaIdentityConstraintImpl findIdConstraint(QName name, String chameleonNamespace) {
        name = this.compatName(name, chameleonNamespace);
        return (SchemaIdentityConstraintImpl)this._idConstraints.get(name);
    }

    void addIdConstraint(SchemaIdentityConstraintImpl idc) {
        if (idc != null) {
            this._idConstraints.put(idc.getName(), idc);
            this.addSpelling(idc.getName(), idc);
        }
    }

    SchemaIdentityConstraintImpl[] idConstraints() {
        return this._idConstraints.values().toArray(new SchemaIdentityConstraintImpl[this._idConstraints.size()]);
    }

    boolean isProcessing(Object obj) {
        return this._processingGroups.contains(obj);
    }

    void startProcessing(Object obj) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(!this._processingGroups.contains(obj));
        }
        this._processingGroups.add(obj);
    }

    void finishProcessing(Object obj) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(this._processingGroups.contains(obj));
        }
        this._processingGroups.remove(obj);
    }

    Object[] getCurrentProcessing() {
        return this._processingGroups.toArray();
    }

    Map typesByClassname() {
        return Collections.unmodifiableMap(this._typesByClassname);
    }

    void addClassname(String classname, SchemaType type) {
        this._typesByClassname.put(classname, type);
    }

    public static StscState start() {
        return ((StscStack)stscStack.get()).push();
    }

    public static StscState get() {
        return ((StscStack)StscState.stscStack.get()).current;
    }

    public static void end() {
        ((StscStack)stscStack.get()).pop();
    }

    static XmlValueRef build_wsstring(int wsr) {
        switch (wsr) {
            case 1: {
                return XMLSTR_PRESERVE;
            }
            case 2: {
                return XMLSTR_REPLACE;
            }
            case 3: {
                return XMLSTR_COLLAPSE;
            }
        }
        return null;
    }

    static XmlValueRef buildString(String str) {
        if (str == null) {
            return null;
        }
        try {
            XmlStringImpl i = new XmlStringImpl();
            i.set(str);
            i.setImmutable();
            return new XmlValueRef(i);
        }
        catch (XmlValueOutOfRangeException e) {
            return null;
        }
    }

    public void notFoundError(QName itemName, int code, XmlObject loc) {
        QName name;
        String basicMessage;
        switch (code) {
            case 6: {
                basicMessage = "Type " + QNameHelper.pretty(itemName) + " not found.";
                break;
            }
            case 29: {
                basicMessage = "Element " + QNameHelper.pretty(itemName) + " not found.";
                break;
            }
            case 36: {
                basicMessage = "Attribute " + QNameHelper.pretty(itemName) + " not found.";
                break;
            }
            case 34: {
                basicMessage = "Model group " + QNameHelper.pretty(itemName) + " not found.";
                break;
            }
            case 40: {
                basicMessage = "Attribute group " + QNameHelper.pretty(itemName) + " not found.";
                break;
            }
            case 55: {
                basicMessage = "Identity constraint '" + QNameHelper.pretty(itemName) + "' not found.";
                break;
            }
            default: {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(false);
                }
                basicMessage = "Definition " + QNameHelper.pretty(itemName) + " not found.";
            }
        }
        String helpfulMessage = "";
        SchemaComponent foundComponent = this.findSpelling(itemName);
        if (foundComponent != null && (name = foundComponent.getName()) != null) {
            String sourceName = null;
            switch (foundComponent.getComponentType()) {
                case 0: {
                    sourceName = ((SchemaType)foundComponent).getSourceName();
                    break;
                }
                case 1: {
                    sourceName = ((SchemaGlobalElement)foundComponent).getSourceName();
                    break;
                }
                case 3: {
                    sourceName = ((SchemaGlobalAttribute)foundComponent).getSourceName();
                }
            }
            String source = "";
            if (sourceName != null) {
                source = " (in " + sourceName.substring(sourceName.lastIndexOf(47) + 1) + ")";
            }
            if (name.equals(itemName)) {
                switch (foundComponent.getComponentType()) {
                    case 0: {
                        helpfulMessage = "  Do you mean to refer to the type with that name" + source + "?";
                        break;
                    }
                    case 1: {
                        helpfulMessage = "  Do you mean to refer to the element with that name" + source + "?";
                        break;
                    }
                    case 3: {
                        helpfulMessage = "  Do you mean to refer to the attribute with that name" + source + "?";
                        break;
                    }
                    case 4: {
                        helpfulMessage = "  Do you mean to refer to the attribute group with that name" + source + "?";
                        break;
                    }
                    case 6: {
                        helpfulMessage = "  Do you mean to refer to the model group with that name" + source + "?";
                    }
                }
            } else {
                switch (foundComponent.getComponentType()) {
                    case 0: {
                        helpfulMessage = "  Do you mean to refer to the type named " + QNameHelper.pretty(name) + source + "?";
                        break;
                    }
                    case 1: {
                        helpfulMessage = "  Do you mean to refer to the element named " + QNameHelper.pretty(name) + source + "?";
                        break;
                    }
                    case 3: {
                        helpfulMessage = "  Do you mean to refer to the attribute named " + QNameHelper.pretty(name) + source + "?";
                        break;
                    }
                    case 4: {
                        helpfulMessage = "  Do you mean to refer to the attribute group named " + QNameHelper.pretty(name) + source + "?";
                        break;
                    }
                    case 6: {
                        helpfulMessage = "  Do you mean to refer to the model group named " + QNameHelper.pretty(name) + source + "?";
                    }
                }
            }
        }
        this.error(basicMessage + helpfulMessage, code, loc);
    }

    public String sourceNameForUri(String uri) {
        return (String)this._sourceForUri.get(uri);
    }

    public Map sourceCopyMap() {
        return Collections.unmodifiableMap(this._sourceForUri);
    }

    public void setBaseUri(String uri) {
        this._baseURI = uri;
    }

    public String relativize(String uri) {
        return this.relativize(uri, false);
    }

    public String computeSavedFilename(String uri) {
        return this.relativize(uri, true);
    }

    private String relativize(String uri, boolean forSavedFilename) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("/")) {
            uri = PROJECT_URL_PREFIX + uri.replace('\\', '/');
        } else {
            int colon = uri.indexOf(58);
            if (colon <= 1 || !StringUtils.matches(uri.substring(0, colon), "^\\w+$")) {
                uri = "project://local/" + uri.replace('\\', '/');
            }
        }
        if (this._baseURI != null) {
            String relative = NetUtils.relativize(this._baseURI, uri);
            if (relative.charAt(0) != '/') {
                return relative;
            }
            uri = relative;
        }
        if (!forSavedFilename) {
            return uri;
        }
        int lastslash = uri.lastIndexOf(47);
        String dir = QNameHelper.hexsafe(lastslash == -1 ? "" : uri.substring(0, lastslash));
        return dir + "/" + uri.substring(lastslash + 1);
    }

    public void addSourceUri(String uri, String nameToUse) {
        if (uri == null) {
            return;
        }
        if (nameToUse == null) {
            nameToUse = this.computeSavedFilename(uri);
        }
        this._sourceForUri.put(uri, nameToUse);
    }

    public Collection getErrorListener() {
        return this._errorListener;
    }

    public SchemaTypeLoader getS4SLoader() {
        return this._s4sloader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class StscStack {
        StscState current;
        ArrayList stack = new ArrayList();

        private StscStack() {
        }

        final StscState push() {
            this.stack.add(this.current);
            this.current = new StscState();
            return this.current;
        }

        final void pop() {
            this.current = (StscState)this.stack.get(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
        }
    }
}

