/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAttributeGroup;
import org.apache.xmlbeans.SchemaField;
import org.apache.xmlbeans.SchemaGlobalAttribute;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaIdentityConstraint;
import org.apache.xmlbeans.SchemaModelGroup;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlFactoryHook;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlSaxHandler;
import org.apache.xmlbeans.impl.common.IOUtil;
import org.apache.xmlbeans.impl.common.NetUtils;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.validator.ValidatingXMLInputStream;
import org.apache.xmlbeans.impl.values.XmlStore;
import org.apache.xmlbeans.xml.stream.XMLInputStream;
import org.apache.xmlbeans.xml.stream.XMLStreamException;
import org.w3c.dom.Node;

public abstract class SchemaTypeLoaderBase
implements SchemaTypeLoader {
    private static final String USER_AGENT = "XMLBeans/" + XmlBeans.getVersion() + " (" + XmlBeans.getTitle() + ")";
    private static final Method _rootBuilder = SchemaTypeLoaderBase.getMethod("org.apache.xmlbeans.impl.store.Root", "newStore", new Class[]{class$org$apache$xmlbeans$SchemaTypeLoader == null ? (class$org$apache$xmlbeans$SchemaTypeLoader = SchemaTypeLoaderBase.class$("org.apache.xmlbeans.SchemaTypeLoader")) : class$org$apache$xmlbeans$SchemaTypeLoader, class$org$apache$xmlbeans$SchemaType == null ? (class$org$apache$xmlbeans$SchemaType = SchemaTypeLoaderBase.class$("org.apache.xmlbeans.SchemaType")) : class$org$apache$xmlbeans$SchemaType, class$org$apache$xmlbeans$XmlOptions == null ? (class$org$apache$xmlbeans$XmlOptions = SchemaTypeLoaderBase.class$("org.apache.xmlbeans.XmlOptions")) : class$org$apache$xmlbeans$XmlOptions});
    private static final Method _pathCompiler = SchemaTypeLoaderBase.getMethod("org.apache.xmlbeans.impl.store.Path", "getCompiledPath", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SchemaTypeLoaderBase.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xmlbeans$XmlOptions == null ? (class$org$apache$xmlbeans$XmlOptions = SchemaTypeLoaderBase.class$("org.apache.xmlbeans.XmlOptions")) : class$org$apache$xmlbeans$XmlOptions});
    private static final Method _queryCompiler = SchemaTypeLoaderBase.getMethod("org.apache.xmlbeans.impl.store.Path", "getCompiledQuery", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SchemaTypeLoaderBase.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xmlbeans$XmlOptions == null ? (class$org$apache$xmlbeans$XmlOptions = SchemaTypeLoaderBase.class$("org.apache.xmlbeans.XmlOptions")) : class$org$apache$xmlbeans$XmlOptions});
    static /* synthetic */ Class class$org$apache$xmlbeans$SchemaTypeLoader;
    static /* synthetic */ Class class$org$apache$xmlbeans$SchemaType;
    static /* synthetic */ Class class$org$apache$xmlbeans$XmlOptions;
    static /* synthetic */ Class class$java$lang$String;

    private static Method getMethod(String className, String methodName, Class[] args) {
        try {
            return Class.forName(className).getDeclaredMethod(methodName, args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find " + className + "." + methodName + ".  verify that xmlstore " + "(from xbean.jar) is on classpath");
        }
    }

    private static Object invokeMethod(Method method, Object[] args) {
        try {
            return method.invoke((Object)method, args);
        }
        catch (InvocationTargetException e) {
            XmlRuntimeException ise = new XmlRuntimeException(e.getTargetException().getMessage());
            ise.initCause(e);
            throw ise;
        }
        catch (Exception e) {
            XmlRuntimeException ise = new XmlRuntimeException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
    }

    private XmlStore createNewStore(SchemaType type, XmlOptions options) {
        return (XmlStore)SchemaTypeLoaderBase.invokeMethod(_rootBuilder, new Object[]{this, type, options});
    }

    private static String doCompilePath(String pathExpr, XmlOptions options) {
        return (String)SchemaTypeLoaderBase.invokeMethod(_pathCompiler, new Object[]{pathExpr, options});
    }

    private static String doCompileQuery(String queryExpr, XmlOptions options) {
        return (String)SchemaTypeLoaderBase.invokeMethod(_queryCompiler, new Object[]{queryExpr, options});
    }

    public SchemaType findType(QName name) {
        SchemaType.Ref ref = this.findTypeRef(name);
        if (ref == null) {
            return null;
        }
        SchemaType result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaType findDocumentType(QName name) {
        SchemaType.Ref ref = this.findDocumentTypeRef(name);
        if (ref == null) {
            return null;
        }
        SchemaType result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaType findAttributeType(QName name) {
        SchemaType.Ref ref = this.findAttributeTypeRef(name);
        if (ref == null) {
            return null;
        }
        SchemaType result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaModelGroup findModelGroup(QName name) {
        SchemaModelGroup.Ref ref = this.findModelGroupRef(name);
        if (ref == null) {
            return null;
        }
        SchemaModelGroup result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaAttributeGroup findAttributeGroup(QName name) {
        SchemaAttributeGroup.Ref ref = this.findAttributeGroupRef(name);
        if (ref == null) {
            return null;
        }
        SchemaAttributeGroup result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaGlobalElement findElement(QName name) {
        SchemaGlobalElement.Ref ref = this.findElementRef(name);
        if (ref == null) {
            return null;
        }
        SchemaGlobalElement result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public SchemaGlobalAttribute findAttribute(QName name) {
        SchemaGlobalAttribute.Ref ref = this.findAttributeRef(name);
        if (ref == null) {
            return null;
        }
        SchemaGlobalAttribute result = ref.get();
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(result != null);
        }
        return result;
    }

    public XmlObject newInstance(SchemaType type, XmlOptions options) {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.newInstance(this, type, options);
        }
        return this.createNewStore(type, options).getObject();
    }

    public XmlObject parse(String xmlText, SchemaType type, XmlOptions options) throws XmlException {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.parse((SchemaTypeLoader)this, xmlText, type, options);
        }
        return this.createNewStore(null, options).loadXml(xmlText, type, options);
    }

    public XmlObject parse(XMLInputStream xis, SchemaType type, XmlOptions options) throws XmlException, XMLStreamException {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.parse((SchemaTypeLoader)this, xis, type, options);
        }
        return this.createNewStore(null, options).loadXml(xis, type, options);
    }

    public XmlObject parse(File file, SchemaType type, XmlOptions options) throws XmlException, IOException {
        XmlObject xmlObject;
        if (options == null) {
            options = new XmlOptions();
            options.put((Object)"DOCUMENT_SOURCE_NAME", NetUtils.normalize(IOUtil.fileToURL(file).toString()));
        } else if (!options.hasOption("DOCUMENT_SOURCE_NAME")) {
            options = new XmlOptions(options);
            options.put((Object)"DOCUMENT_SOURCE_NAME", NetUtils.normalize(IOUtil.fileToURL(file).toString()));
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            xmlObject = this.parse(fis, type, options);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)fis).close();
            throw throwable;
        }
        ((InputStream)fis).close();
        return xmlObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlObject parse(URL url, SchemaType type, XmlOptions options) throws XmlException, IOException {
        XmlObject xmlObject;
        if (options == null) {
            options = new XmlOptions();
            options.put((Object)"DOCUMENT_SOURCE_NAME", url.toString());
        } else if (!options.hasOption("DOCUMENT_SOURCE_NAME")) {
            options = new XmlOptions(options);
            options.put((Object)"DOCUMENT_SOURCE_NAME", url.toString());
        }
        URLConnection conn = null;
        InputStream stream = null;
        try {
            boolean redirected = false;
            int count = 0;
            do {
                conn = url.openConnection();
                conn.setRequestProperty("User-Agent", USER_AGENT);
                conn.setRequestProperty("Accept", "application/xml, text/xml, */*");
                if (!(conn instanceof HttpURLConnection)) continue;
                HttpURLConnection httpcon = (HttpURLConnection)conn;
                int code = httpcon.getResponseCode();
                boolean bl = redirected = code == 301 || code == 302;
                if (redirected && count > 5) {
                    redirected = false;
                }
                if (!redirected) continue;
                String newLocation = httpcon.getHeaderField("Location");
                if (newLocation == null) {
                    redirected = false;
                    continue;
                }
                url = new URL(newLocation);
                ++count;
            } while (redirected);
            stream = conn.getInputStream();
            xmlObject = this.parse(stream, type, options);
            Object var12_11 = null;
            if (stream == null) return xmlObject;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
        return xmlObject;
    }

    public XmlObject parse(InputStream jiois, SchemaType type, XmlOptions options) throws XmlException, IOException {
        DigestInputStream digestStream;
        XmlFactoryHook hook;
        block5: {
            hook = XmlFactoryHook.ThreadContext.getHook();
            digestStream = null;
            if (options != null && options.hasOption("LOAD_MESSAGE_DIGEST")) {
                MessageDigest sha;
                try {
                    sha = MessageDigest.getInstance("SHA");
                }
                catch (NoSuchAlgorithmException e) {
                    break block5;
                }
                digestStream = new DigestInputStream(jiois, sha);
                jiois = digestStream;
            }
        }
        if (hook != null) {
            return hook.parse((SchemaTypeLoader)this, jiois, type, options);
        }
        XmlObject result = this.createNewStore(null, options).loadXml(jiois, type, options);
        if (digestStream != null) {
            result.documentProperties().setMessageDigest(digestStream.getMessageDigest().digest());
        }
        return result;
    }

    public XmlObject parse(Reader jior, SchemaType type, XmlOptions options) throws XmlException, IOException {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.parse((SchemaTypeLoader)this, jior, type, options);
        }
        return this.createNewStore(null, options).loadXml(jior, type, options);
    }

    public XmlObject parse(Node node, SchemaType type, XmlOptions options) throws XmlException {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.parse((SchemaTypeLoader)this, node, type, options);
        }
        return this.createNewStore(null, options).loadXml(node, type, options);
    }

    public XmlSaxHandler newXmlSaxHandler(SchemaType type, XmlOptions options) {
        XmlFactoryHook hook = XmlFactoryHook.ThreadContext.getHook();
        if (hook != null) {
            return hook.newXmlSaxHandler(this, type, options);
        }
        return this.createNewStore(null, options).newSaxHandler(type, options);
    }

    public XMLInputStream newValidatingXMLInputStream(XMLInputStream xis, SchemaType type, XmlOptions options) throws XmlException, XMLStreamException {
        return new ValidatingXMLInputStream(xis, this, type, options);
    }

    public String compilePath(String pathExpr) {
        return this.compilePath(pathExpr, null);
    }

    public String compilePath(String pathExpr, XmlOptions options) {
        return SchemaTypeLoaderBase.doCompilePath(pathExpr, options);
    }

    public String compileQuery(String queryExpr) {
        return this.compileQuery(queryExpr, null);
    }

    public String compileQuery(String queryExpr, XmlOptions options) {
        return SchemaTypeLoaderBase.doCompileQuery(queryExpr, options);
    }

    public SchemaType typeForSignature(String signature) {
        String uri;
        int end = signature.indexOf(64);
        if (end < 0) {
            uri = "";
            end = signature.length();
        } else {
            uri = signature.substring(end + 1);
        }
        ArrayList<String> parts = new ArrayList<String>();
        int index = 0;
        while (index < end) {
            int next;
            int nextc = signature.indexOf(58, index);
            int nextd = signature.indexOf(124, index);
            int n = nextc < 0 ? nextd : (nextd < 0 ? nextc : (next = nextc < nextd ? nextc : nextd));
            if (next < 0 || next > end) {
                next = end;
            }
            String part = signature.substring(index, next);
            parts.add(part);
            index = next + 1;
        }
        SchemaType curType = null;
        int i = parts.size() - 1;
        while (i >= 0) {
            String part = (String)parts.get(i);
            if (part.length() < 1) {
                throw new IllegalArgumentException();
            }
            int offset = part.length() >= 2 && part.charAt(1) == '=' ? 2 : 1;
            block1 : switch (part.charAt(0)) {
                case 'T': {
                    if (curType != null) {
                        throw new IllegalArgumentException();
                    }
                    curType = this.findType(QNameHelper.forLNS(part.substring(offset), uri));
                    if (curType != null) break;
                    return null;
                }
                case 'D': {
                    if (curType != null) {
                        throw new IllegalArgumentException();
                    }
                    curType = this.findDocumentType(QNameHelper.forLNS(part.substring(offset), uri));
                    if (curType != null) break;
                    return null;
                }
                case 'C': 
                case 'R': {
                    if (curType != null) {
                        throw new IllegalArgumentException();
                    }
                    curType = this.findAttributeType(QNameHelper.forLNS(part.substring(offset), uri));
                    if (curType != null) break;
                    return null;
                }
                case 'E': 
                case 'U': {
                    SchemaField field;
                    int j;
                    String localName;
                    if (curType != null) {
                        if (curType.getContentType() < 3) {
                            return null;
                        }
                        SchemaType[] subTypes = curType.getAnonymousTypes();
                        localName = part.substring(offset);
                        j = 0;
                        while (j < subTypes.length) {
                            field = subTypes[j].getContainerField();
                            if (field != null && !field.isAttribute() && field.getName().getLocalPart().equals(localName)) {
                                curType = subTypes[j];
                                break block1;
                            }
                            ++j;
                        }
                        return null;
                    }
                    SchemaGlobalElement elt = this.findElement(QNameHelper.forLNS(part.substring(offset), uri));
                    if (elt == null) {
                        return null;
                    }
                    curType = elt.getType();
                    break;
                }
                case 'A': 
                case 'Q': {
                    SchemaField field;
                    int j;
                    String localName;
                    if (curType != null) {
                        if (curType.isSimpleType()) {
                            return null;
                        }
                        SchemaType[] subTypes = curType.getAnonymousTypes();
                        localName = part.substring(offset);
                        j = 0;
                        while (j < subTypes.length) {
                            field = subTypes[j].getContainerField();
                            if (field != null && field.isAttribute() && field.getName().getLocalPart().equals(localName)) {
                                curType = subTypes[j];
                                break block1;
                            }
                            ++j;
                        }
                        return null;
                    }
                    SchemaGlobalAttribute attr = this.findAttribute(QNameHelper.forLNS(part.substring(offset), uri));
                    if (attr == null) {
                        return null;
                    }
                    curType = attr.getType();
                    break;
                }
                case 'B': {
                    if (curType == null) {
                        throw new IllegalArgumentException();
                    }
                    if (curType.getSimpleVariety() != 1) {
                        return null;
                    }
                    SchemaType[] subTypes = curType.getAnonymousTypes();
                    if (subTypes.length != 1) {
                        return null;
                    }
                    curType = subTypes[0];
                    break;
                }
                case 'I': {
                    if (curType == null) {
                        throw new IllegalArgumentException();
                    }
                    if (curType.getSimpleVariety() != 3) {
                        return null;
                    }
                    SchemaType[] subTypes = curType.getAnonymousTypes();
                    if (subTypes.length != 1) {
                        return null;
                    }
                    curType = subTypes[0];
                    break;
                }
                case 'M': {
                    int index2;
                    if (curType == null) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        index2 = Integer.parseInt(part.substring(offset));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException();
                    }
                    if (curType.getSimpleVariety() != 2) {
                        return null;
                    }
                    SchemaType[] subTypes = curType.getAnonymousTypes();
                    if (subTypes.length <= index2) {
                        return null;
                    }
                    curType = subTypes[index2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            --i;
        }
        return curType;
    }

    public abstract InputStream getSourceAsStream(String var1);

    public abstract SchemaType typeForClassname(String var1);

    public abstract SchemaIdentityConstraint.Ref findIdentityConstraintRef(QName var1);

    public abstract SchemaAttributeGroup.Ref findAttributeGroupRef(QName var1);

    public abstract SchemaModelGroup.Ref findModelGroupRef(QName var1);

    public abstract SchemaGlobalAttribute.Ref findAttributeRef(QName var1);

    public abstract SchemaGlobalElement.Ref findElementRef(QName var1);

    public abstract SchemaType.Ref findAttributeTypeRef(QName var1);

    public abstract SchemaType.Ref findDocumentTypeRef(QName var1);

    public abstract SchemaType.Ref findTypeRef(QName var1);

    public abstract boolean isNamespaceDefined(String var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

