/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaStringEnumEntry;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.NameUtil;
import org.apache.xmlbeans.impl.config.ExtensionHolder;
import org.apache.xmlbeans.impl.config.InterfaceExtension;
import org.apache.xmlbeans.impl.config.PrePostExtension;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;

public final class SchemaTypeCodePrinter {
    Writer _writer;
    int _indent;
    static final String LINE_SEPARATOR = System.getProperty("line.separator") == null ? "\n" : System.getProperty("line.separator");
    static final String MAX_SPACES = "                                        ";
    static final int INDENT_INCREMENT = 4;
    public static final String INDEX_CLASSNAME = "TypeSystemHolder";
    private static final int NOTHING = 1;
    private static final int ADD_NEW_VALUE = 3;
    private static final int THROW_EXCEPTION = 4;

    public SchemaTypeCodePrinter(Writer writer) {
        this._writer = writer;
        this._indent = 0;
    }

    void indent() {
        this._indent += 4;
    }

    void outdent() {
        this._indent -= 4;
    }

    String encodeString(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch == '\\') {
                sb.append('\\');
                sb.append('\\');
            } else if (ch == '\r') {
                sb.append('\\');
                sb.append('r');
            } else if (ch == '\n') {
                sb.append('\\');
                sb.append('n');
            } else if (ch == '\t') {
                sb.append('\\');
                sb.append('t');
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    void emit(String s) throws IOException {
        int indent = this._indent;
        if (indent > MAX_SPACES.length() / 2) {
            indent = MAX_SPACES.length() / 4 + indent / 2;
        }
        if (indent > MAX_SPACES.length()) {
            indent = MAX_SPACES.length();
        }
        this._writer.write(MAX_SPACES.substring(0, indent));
        this._writer.write(s);
        this._writer.write(LINE_SEPARATOR);
    }

    public static void printTypeImpl(Writer writer, SchemaType sType) throws IOException {
        new SchemaTypeCodePrinter(writer).printTypeImpl(sType, sType.getTypeSystem());
    }

    public static void printType(Writer writer, SchemaType sType) throws IOException {
        new SchemaTypeCodePrinter(writer).printType(sType, sType.getTypeSystem());
    }

    public static void printLoader(Writer writer, SchemaTypeSystem system) throws IOException {
        new SchemaTypeCodePrinter(writer).printIndexType(system);
    }

    void printType(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.printTopComment(sType);
        this.printPackage(sType, true);
        this.emit("");
        this.printInnerType(sType, system);
        this._writer.flush();
    }

    void printTypeImpl(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.printTopComment(sType);
        this.printPackage(sType, false);
        this.printInnerTypeImpl(sType, system, false);
    }

    String findJavaType(SchemaType sType) {
        while (sType.getFullJavaName() == null) {
            sType = sType.getBaseType();
        }
        return sType.getFullJavaName();
    }

    static String prettyQName(QName qname) {
        String result = qname.getLocalPart();
        if (qname.getNamespaceURI() != null) {
            result = result + "(@" + qname.getNamespaceURI() + ")";
        }
        return result;
    }

    void printInnerTypeJavaDoc(SchemaType sType) throws IOException {
        QName name = sType.getName();
        if (name == null) {
            if (sType.isDocumentType()) {
                name = sType.getDocumentElementName();
            } else if (sType.isAttributeType()) {
                name = sType.getAttributeTypeAttributeName();
            } else if (sType.getContainerField() != null) {
                name = sType.getContainerField().getName();
            }
        }
        this.emit("/**");
        if (sType.isDocumentType()) {
            this.emit(" * A document containing one " + SchemaTypeCodePrinter.prettyQName(name) + " element.");
        } else if (sType.isAttributeType()) {
            this.emit(" * A document containing one " + SchemaTypeCodePrinter.prettyQName(name) + " attribute.");
        } else if (name != null) {
            this.emit(" * An XML " + SchemaTypeCodePrinter.prettyQName(name) + ".");
        } else {
            this.emit(" * An anonymous inner XML type.");
        }
        this.emit(" *");
        switch (sType.getSimpleVariety()) {
            case 0: {
                this.emit(" * This is a complex type.");
                break;
            }
            case 1: {
                this.emit(" * This is an atomic type that is a restriction of " + sType.getBaseType().getFullJavaName() + ".");
                break;
            }
            case 3: {
                this.emit(" * This is a list type whose items are " + sType.getListItemType().getFullJavaName() + ".");
                break;
            }
            case 2: {
                this.emit(" * This is a union type. Instances are of one of the following types:");
                SchemaType[] members = sType.getUnionConstituentTypes();
                int i = 0;
                while (i < members.length) {
                    this.emit(" *     " + members[i].getFullJavaName());
                    ++i;
                }
                break;
            }
        }
        this.emit(" */");
    }

    public static String indexClassForSystem(SchemaTypeSystem system) {
        String name = system.getName();
        return name + "." + INDEX_CLASSNAME;
    }

    static String shortIndexClassForSystem(SchemaTypeSystem system) {
        return INDEX_CLASSNAME;
    }

    void printStaticTypeDeclaration(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.emit("public static final org.apache.xmlbeans.SchemaType type = (org.apache.xmlbeans.SchemaType)" + SchemaTypeCodePrinter.indexClassForSystem(system) + ".typeSystem.resolveHandle(\"" + ((SchemaTypeSystemImpl)system).handleForType(sType) + "\");");
    }

    void printIndexType(SchemaTypeSystem system) throws IOException {
        String shortName = SchemaTypeCodePrinter.shortIndexClassForSystem(system);
        this.emit("package " + system.getName() + ";");
        this.emit("");
        this.emit("public final class " + shortName);
        this.emit("{");
        this.indent();
        this.emit("private " + shortName + "() { }");
        this.emit("public static final org.apache.xmlbeans.SchemaTypeSystem typeSystem = loadTypeSystem();");
        this.emit("static { typeSystem.resolve(); }");
        this.emit("private static final org.apache.xmlbeans.SchemaTypeSystem loadTypeSystem()");
        this.emit("{");
        this.indent();
        this.emit("try { return (org.apache.xmlbeans.SchemaTypeSystem)Class.forName(\"org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl\", true, " + shortName + ".class.getClassLoader()).getConstructor(new Class[] { Class.class }).newInstance(new java.lang.Object[] { " + shortName + ".class }); }");
        this.emit("catch (ClassNotFoundException e) { throw new org.apache.xmlbeans.XmlRuntimeException(\"Cannot load org.apache.xmlbeans.impl.SchemaTypeSystemImpl: make sure xbean.jar is on the classpath.\", e); }");
        this.emit("catch (Exception e) { throw new org.apache.xmlbeans.XmlRuntimeException(\"Could not instantiate SchemaTypeSystemImpl (\" + e.toString() + \"): is the version of xbean.jar correct?\", e); }");
        this.outdent();
        this.emit("}");
        this.outdent();
        this.emit("}");
    }

    void printInnerType(SchemaType sType, SchemaTypeSystem system) throws IOException {
        this.emit("");
        this.printInnerTypeJavaDoc(sType);
        this.startInterface(sType);
        this.printStaticTypeDeclaration(sType, system);
        if (sType.isSimpleType()) {
            if (sType.hasStringEnumValues()) {
                this.printStringEnumeration(sType);
            }
        } else {
            SchemaProperty[] props = sType.getDerivedProperties();
            int i = 0;
            while (i < props.length) {
                SchemaProperty prop = props[i];
                this.printPropertyGetters(prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), this.javaTypeForProperty(prop), this.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton());
                if (!prop.isReadOnly()) {
                    this.printPropertySetters(prop.getName(), prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), this.javaTypeForProperty(prop), this.xmlTypeForProperty(prop), prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton());
                }
                ++i;
            }
        }
        this.printNestedInnerTypes(sType, system);
        this.printFactory(sType);
        this.endBlock();
    }

    void printFactory(SchemaType sType) throws IOException {
        boolean fullFactory = true;
        if (sType.isAnonymousType() && !sType.isDocumentType() && !sType.isAttributeType()) {
            fullFactory = false;
        }
        String fullName = sType.getFullJavaName().replace('$', '.');
        this.emit("");
        this.emit("/**");
        this.emit(" * A factory class with static methods for creating instances");
        this.emit(" * of this type.");
        this.emit(" */");
        this.emit("");
        this.emit("public static final class Factory");
        this.emit("{");
        this.indent();
        if (sType.isSimpleType()) {
            this.emit("public static " + fullName + " newValue(java.lang.Object obj) {");
            this.emit("  return (" + fullName + ") type.newValue( obj ); }");
            this.emit("");
        }
        this.emit("public static " + fullName + " newInstance() {");
        this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().newInstance( type, null ); }");
        this.emit("");
        this.emit("public static " + fullName + " newInstance(org.apache.xmlbeans.XmlOptions options) {");
        this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().newInstance( type, options ); }");
        this.emit("");
        if (fullFactory) {
            this.emit("public static " + fullName + " parse(java.lang.String s) throws org.apache.xmlbeans.XmlException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( s, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.lang.String s, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( s, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.File f) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( f, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.File f, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( f, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.net.URL u) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( u, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.net.URL u, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( u, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.InputStream is) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( is, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.InputStream is, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( is, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.Reader r) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( r, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(java.io.Reader r, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, java.io.IOException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( r, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.w3c.dom.Node node) throws org.apache.xmlbeans.XmlException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( node, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.w3c.dom.Node node, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( node, type, options ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.apache.xmlbeans.xml.stream.XMLInputStream xis) throws org.apache.xmlbeans.XmlException, org.apache.xmlbeans.xml.stream.XMLStreamException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( xis, type, null ); }");
            this.emit("");
            this.emit("public static " + fullName + " parse(org.apache.xmlbeans.xml.stream.XMLInputStream xis, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, org.apache.xmlbeans.xml.stream.XMLStreamException {");
            this.emit("  return (" + fullName + ") org.apache.xmlbeans.XmlBeans.getContextTypeLoader().parse( xis, type, options ); }");
            this.emit("");
            this.emit("public static org.apache.xmlbeans.xml.stream.XMLInputStream newValidatingXMLInputStream(org.apache.xmlbeans.xml.stream.XMLInputStream xis) throws org.apache.xmlbeans.XmlException, org.apache.xmlbeans.xml.stream.XMLStreamException {");
            this.emit("  return org.apache.xmlbeans.XmlBeans.getContextTypeLoader().newValidatingXMLInputStream( xis, type, null ); }");
            this.emit("");
            this.emit("public static org.apache.xmlbeans.xml.stream.XMLInputStream newValidatingXMLInputStream(org.apache.xmlbeans.xml.stream.XMLInputStream xis, org.apache.xmlbeans.XmlOptions options) throws org.apache.xmlbeans.XmlException, org.apache.xmlbeans.xml.stream.XMLStreamException {");
            this.emit("  return org.apache.xmlbeans.XmlBeans.getContextTypeLoader().newValidatingXMLInputStream( xis, type, options ); }");
            this.emit("");
        }
        this.emit("private Factory() { } // No instance of this class allowed");
        this.outdent();
        this.emit("}");
    }

    void printNestedInnerTypes(SchemaType sType, SchemaTypeSystem system) throws IOException {
        SchemaType[] anonTypes = sType.getAnonymousTypes();
        int i = 0;
        while (i < anonTypes.length) {
            if (anonTypes[i].isSkippedAnonymousType()) {
                this.printNestedInnerTypes(anonTypes[i], system);
            } else {
                this.printInnerType(anonTypes[i], system);
            }
            ++i;
        }
    }

    void printTopComment(SchemaType sType) throws IOException {
        this.emit("/*");
        if (sType.getName() != null) {
            this.emit(" * XML Type:  " + sType.getName().getLocalPart());
            this.emit(" * Namespace: " + sType.getName().getNamespaceURI());
        } else {
            QName thename = null;
            if (sType.isDocumentType()) {
                thename = sType.getDocumentElementName();
                this.emit(" * An XML document type.");
            } else if (sType.isAttributeType()) {
                thename = sType.getAttributeTypeAttributeName();
                this.emit(" * An XML attribute type.");
            } else if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(false);
            }
            if (XmlBeans.ASSERTS) {
                XmlBeans.assertTrue(thename != null);
            }
            this.emit(" * Localname: " + thename.getLocalPart());
            this.emit(" * Namespace: " + thename.getNamespaceURI());
        }
        this.emit(" * Java type: " + sType.getFullJavaName());
        this.emit(" *");
        this.emit(" * Automatically generated - do not modify.");
        this.emit(" */");
    }

    void printPackage(SchemaType sType, boolean intf) throws IOException {
        String fqjn = intf ? sType.getFullJavaName() : sType.getFullJavaImplName();
        int lastdot = fqjn.lastIndexOf(46);
        if (lastdot < 0) {
            return;
        }
        String pkg = fqjn.substring(0, lastdot);
        this.emit("package " + pkg + ";");
    }

    void startInterface(SchemaType sType) throws IOException {
        String shortName = sType.getShortJavaName();
        String baseInterface = this.findJavaType(sType.getBaseType());
        this.emit("public interface " + shortName + " extends " + baseInterface + SchemaTypeCodePrinter.getExtensionInterfaces(sType));
        this.emit("{");
        this.indent();
        this.emitSpecializedAccessors(sType);
    }

    private static String getExtensionInterfaces(SchemaType sType) {
        SchemaTypeImpl sImpl = SchemaTypeCodePrinter.getImpl(sType);
        if (sImpl == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        ExtensionHolder extHolder = sImpl.getExtensionHolder();
        if (extHolder != null) {
            List exts = extHolder.getInterfaceExtensionsFor(sType.getFullJavaName());
            Iterator i = exts.iterator();
            while (i.hasNext()) {
                InterfaceExtension ext = (InterfaceExtension)i.next();
                sb.append(", " + ext.getInterfaceNameForJavaSource());
            }
        }
        return sb.toString();
    }

    private static SchemaTypeImpl getImpl(SchemaType sType) {
        if (sType instanceof SchemaTypeImpl) {
            return (SchemaTypeImpl)sType;
        }
        return null;
    }

    private void emitSpecializedAccessors(SchemaType sType) throws IOException {
        int parentBits;
        int bits;
        if (sType.getSimpleVariety() == 1 && sType.getPrimitiveType().getBuiltinTypeCode() == 11 && ((bits = sType.getDecimalSize()) != (parentBits = sType.getBaseType().getDecimalSize()) || sType.getBaseType().getFullJavaName() == null)) {
            if (bits == 1000000) {
                this.emit("java.math.BigInteger getBigIntegerValue();");
                this.emit("void setBigIntegerValue(java.math.BigInteger bi);");
                this.emit("/** @deprecated */");
                this.emit("java.math.BigInteger bigIntegerValue();");
                this.emit("/** @deprecated */");
                this.emit("void set(java.math.BigInteger bi);");
            } else if (bits == 64) {
                this.emit("long getLongValue();");
                this.emit("void setLongValue(long l);");
                this.emit("/** @deprecated */");
                this.emit("long longValue();");
                this.emit("/** @deprecated */");
                this.emit("void set(long l);");
            } else if (bits == 32) {
                this.emit("int getIntValue();");
                this.emit("void setIntValue(int i);");
                this.emit("/** @deprecated */");
                this.emit("int intValue();");
                this.emit("/** @deprecated */");
                this.emit("void set(int i);");
            } else if (bits == 16) {
                this.emit("short getShortValue();");
                this.emit("void setShortValue(short s);");
                this.emit("/** @deprecated */");
                this.emit("short shortValue();");
                this.emit("/** @deprecated */");
                this.emit("void set(short s);");
            } else if (bits == 8) {
                this.emit("byte getByteValue();");
                this.emit("void setByteValue(byte b);");
                this.emit("/** @deprecated */");
                this.emit("byte byteValue();");
                this.emit("/** @deprecated */");
                this.emit("void set(byte b);");
            }
        }
        if (sType.getSimpleVariety() == 2) {
            this.emit("java.lang.Object getObjectValue();");
            this.emit("void setObjectValue(java.lang.Object val);");
            this.emit("/** @deprecated */");
            this.emit("java.lang.Object objectValue();");
            this.emit("/** @deprecated */");
            this.emit("void objectSet(java.lang.Object val);");
            this.emit("org.apache.xmlbeans.SchemaType instanceType();");
            SchemaType ctype = sType.getUnionCommonBaseType();
            if (ctype == null || ctype.getSimpleVariety() != 2) {
                // empty if block
            }
            this.emitSpecializedAccessors(ctype);
        }
        if (sType.getSimpleVariety() == 3) {
            this.emit("java.util.List getListValue();");
            this.emit("java.util.List xgetListValue();");
            this.emit("void setListValue(java.util.List list);");
            this.emit("/** @deprecated */");
            this.emit("java.util.List listValue();");
            this.emit("/** @deprecated */");
            this.emit("java.util.List xlistValue();");
            this.emit("/** @deprecated */");
            this.emit("void set(java.util.List list);");
        }
    }

    void startBlock() throws IOException {
        this.emit("{");
        this.indent();
    }

    void endBlock() throws IOException {
        this.outdent();
        this.emit("}");
    }

    void printJavaDoc(String sentence) throws IOException {
        this.emit("");
        this.emit("/**");
        this.emit(" * " + sentence);
        this.emit(" */");
    }

    void printShortJavaDoc(String sentence) throws IOException {
        this.emit("/** " + sentence + " */");
    }

    static SchemaType findBaseEnumType(SchemaType sType) {
        while (sType.getBaseType().hasStringEnumValues()) {
            sType = sType.getBaseType();
        }
        return sType;
    }

    public static String javaStringEscape(String str) {
        block11: {
            int i = 0;
            while (i < str.length()) {
                switch (str.charAt(i)) {
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\\': {
                        break block11;
                    }
                    default: {
                        ++i;
                    }
                }
            }
            return str;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                default: {
                    sb.append(ch);
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    void printStringEnumeration(SchemaType sType) throws IOException {
        String constName;
        SchemaType baseEnumType = SchemaTypeCodePrinter.findBaseEnumType(sType);
        String baseEnumClass = baseEnumType.getFullJavaName();
        if (baseEnumType == sType) {
            this.emit("");
            this.emit("org.apache.xmlbeans.StringEnumAbstractBase enumValue();");
            this.emit("void set(org.apache.xmlbeans.StringEnumAbstractBase e);");
        }
        this.emit("");
        SchemaStringEnumEntry[] entries = sType.getStringEnumEntries();
        int i = 0;
        while (i < entries.length) {
            String enumValue = entries[i].getString();
            constName = entries[i].getEnumName();
            if (baseEnumType != sType) {
                this.emit("static final " + baseEnumClass + ".Enum " + constName + " = " + baseEnumClass + "." + constName + ";");
            } else {
                this.emit("static final Enum " + constName + " = Enum.forString(\"" + SchemaTypeCodePrinter.javaStringEscape(enumValue) + "\");");
            }
            ++i;
        }
        this.emit("");
        int i2 = 0;
        while (i2 < entries.length) {
            constName = "INT_" + entries[i2].getEnumName();
            if (baseEnumType != sType) {
                this.emit("static final int " + constName + " = " + baseEnumClass + "." + constName + ";");
            } else {
                this.emit("static final int " + constName + " = Enum." + constName + ";");
            }
            ++i2;
        }
        if (baseEnumType == sType) {
            this.emit("");
            this.emit("/**");
            this.emit(" * Enumeration value class for " + baseEnumClass + ".");
            this.emit(" * These enum values can be used as follows:");
            this.emit(" * <pre>");
            this.emit(" * enum.toString(); // returns the string value of the enum");
            this.emit(" * enum.intValue(); // returns an int value, useful for switches");
            if (entries.length > 0) {
                this.emit(" * // e.g., case Enum.INT_" + entries[0].getEnumName());
            }
            this.emit(" * Enum.forString(s); // returns the enum value for a string");
            this.emit(" * Enum.forInt(i); // returns the enum value for an int");
            this.emit(" * </pre>");
            this.emit(" * Enumeration objects are immutable singleton objects that");
            this.emit(" * can be compared using == object equality. They have no");
            this.emit(" * public constructor. See the constants defined within this");
            this.emit(" * class for all the valid values.");
            this.emit(" */");
            this.emit("static final class Enum extends org.apache.xmlbeans.StringEnumAbstractBase");
            this.emit("{");
            this.indent();
            this.emit("/**");
            this.emit(" * Returns the enum value for a string, or null if none.");
            this.emit(" */");
            this.emit("public static Enum forString(java.lang.String s)");
            this.emit("    { return (Enum)table.forString(s); }");
            this.emit("/**");
            this.emit(" * Returns the enum value corresponding to an int, or null if none.");
            this.emit(" */");
            this.emit("public static Enum forInt(int i)");
            this.emit("    { return (Enum)table.forInt(i); }");
            this.emit("");
            this.emit("private Enum(java.lang.String s, int i)");
            this.emit("    { super(s, i); }");
            this.emit("");
            int i3 = 0;
            while (i3 < entries.length) {
                String constName2 = "INT_" + entries[i3].getEnumName();
                int intValue = entries[i3].getIntValue();
                this.emit("static final int " + constName2 + " = " + intValue + ";");
                ++i3;
            }
            this.emit("");
            this.emit("public static final org.apache.xmlbeans.StringEnumAbstractBase.Table table =");
            this.emit("    new org.apache.xmlbeans.StringEnumAbstractBase.Table");
            this.emit("(");
            this.indent();
            this.emit("new Enum[]");
            this.emit("{");
            this.indent();
            int i4 = 0;
            while (i4 < entries.length) {
                String enumValue = entries[i4].getString();
                String constName3 = "INT_" + entries[i4].getEnumName();
                this.emit("new Enum(\"" + SchemaTypeCodePrinter.javaStringEscape(enumValue) + "\", " + constName3 + "),");
                ++i4;
            }
            this.outdent();
            this.emit("}");
            this.outdent();
            this.emit(");");
            this.emit("private static final long serialVersionUID = 1L;");
            this.emit("private java.lang.Object readResolve() { return forInt(intValue()); } ");
            this.outdent();
            this.emit("}");
        }
    }

    String xmlTypeForProperty(SchemaProperty sProp) {
        SchemaType sType = sProp.javaBasedOnType();
        return this.findJavaType(sType).replace('$', '.');
    }

    static boolean xmlTypeForPropertyIsUnion(SchemaProperty sProp) {
        SchemaType sType = sProp.javaBasedOnType();
        return sType.isSimpleType() && sType.getSimpleVariety() == 2;
    }

    String javaTypeForProperty(SchemaProperty sProp) {
        if (sProp.getJavaTypeCode() == 0) {
            SchemaType sType = sProp.javaBasedOnType();
            return this.findJavaType(sType).replace('$', '.');
        }
        switch (sProp.getJavaTypeCode()) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "byte";
            }
            case 5: {
                return "short";
            }
            case 6: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "java.math.BigDecimal";
            }
            case 9: {
                return "java.math.BigInteger";
            }
            case 10: {
                return "java.lang.String";
            }
            case 11: {
                return "byte[]";
            }
            case 12: {
                return "org.apache.xmlbeans.GDate";
            }
            case 13: {
                return "org.apache.xmlbeans.GDuration";
            }
            case 14: {
                return "java.util.Date";
            }
            case 15: {
                return "javax.xml.namespace.QName";
            }
            case 16: {
                return "java.util.List";
            }
            case 17: {
                return "java.util.Calendar";
            }
            case 18: {
                SchemaType sType = sProp.javaBasedOnType().getBaseEnumType();
                return this.findJavaType(sType).replace('$', '.') + ".Enum";
            }
            case 19: {
                return "java.lang.Object";
            }
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(false);
        }
        throw new IllegalStateException();
    }

    void printPropertyGetters(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton) throws IOException {
        boolean xmltype;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        boolean bl = xmltype = javaType == 0;
        if (singleton) {
            this.printJavaDoc((several ? "Gets first " : "Gets the ") + propdesc);
            this.emit(type + " get" + propertyName + "();");
            if (!xmltype) {
                this.printJavaDoc((several ? "Gets (as xml) first " : "Gets (as xml) the ") + propdesc);
                this.emit(xtype + " xget" + propertyName + "();");
            }
            if (nillable) {
                this.printJavaDoc((several ? "Tests for nil first " : "Tests for nil ") + propdesc);
                this.emit("boolean isNil" + propertyName + "();");
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "True if has at least one " : "True if has ") + propdesc);
            this.emit("boolean isSet" + propertyName + "();");
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Gets array of all " + propdesc + "s");
            this.emit(type + "[] get" + arrayName + "();");
            this.printJavaDoc("Gets ith " + propdesc);
            this.emit(type + " get" + arrayName + "(int i);");
            if (!xmltype) {
                this.printJavaDoc("Gets (as xml) array of all " + propdesc + "s");
                this.emit(xtype + "[] xget" + arrayName + "();");
                this.printJavaDoc("Gets (as xml) ith " + propdesc);
                this.emit(xtype + " xget" + arrayName + "(int i);");
            }
            if (nillable) {
                this.printJavaDoc("Tests for nil ith " + propdesc);
                this.emit("boolean isNil" + arrayName + "(int i);");
            }
            this.printJavaDoc("Returns number of " + propdesc);
            this.emit("int sizeOf" + arrayName + "();");
        }
    }

    void printPropertySetters(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton) throws IOException {
        String safeVarName = NameUtil.nonJavaKeyword(NameUtil.lowerCamelCase(propertyName));
        if (safeVarName.equals("i")) {
            safeVarName = "iValue";
        }
        boolean xmltype = javaType == 0;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        if (singleton) {
            this.printJavaDoc((several ? "Sets first " : "Sets the ") + propdesc);
            this.emit("void set" + propertyName + "(" + type + " " + safeVarName + ");");
            if (!xmltype) {
                this.printJavaDoc((several ? "Sets (as xml) first " : "Sets (as xml) the ") + propdesc);
                this.emit("void xset" + propertyName + "(" + xtype + " " + safeVarName + ");");
            }
            if (xmltype && !several) {
                this.printJavaDoc("Appends and returns a new empty " + propdesc);
                this.emit(xtype + " addNew" + propertyName + "();");
            }
            if (nillable) {
                this.printJavaDoc((several ? "Nils the first " : "Nils the ") + propdesc);
                this.emit("void setNil" + propertyName + "();");
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "Removes first " : "Unsets the ") + propdesc);
            this.emit("void unset" + propertyName + "();");
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Sets array of all " + propdesc);
            this.emit("void set" + arrayName + "(" + type + "[] " + safeVarName + "Array);");
            this.printJavaDoc("Sets ith " + propdesc);
            this.emit("void set" + arrayName + "(int i, " + type + " " + safeVarName + ");");
            if (!xmltype) {
                this.printJavaDoc("Sets (as xml) array of all " + propdesc);
                this.emit("void xset" + arrayName + "(" + xtype + "[]" + safeVarName + "Array);");
                this.printJavaDoc("Sets (as xml) ith " + propdesc);
                this.emit("void xset" + arrayName + "(int i, " + xtype + " " + safeVarName + ");");
            }
            if (nillable) {
                this.printJavaDoc("Nils the ith " + propdesc);
                this.emit("void setNil" + arrayName + "(int i);");
            }
            if (!xmltype) {
                this.printJavaDoc("Inserts the value as the ith " + propdesc);
                this.emit("void insert" + propertyName + "(int i, " + type + " " + safeVarName + ");");
                this.printJavaDoc("Appends the value as the last " + propdesc);
                this.emit("void add" + propertyName + "(" + type + " " + safeVarName + ");");
            }
            if (xmltype) {
                this.printJavaDoc("Inserts and returns a new empty value (as xml) as the ith " + propdesc);
                this.emit(xtype + " insertNew" + propertyName + "(int i);");
                this.printJavaDoc("Appends and returns a new empty value (as xml) as the last " + propdesc);
                this.emit(xtype + " addNew" + propertyName + "();");
            }
            this.printJavaDoc("Removes the ith " + propdesc);
            this.emit("void remove" + propertyName + "(int i);");
        }
    }

    String getAtomicRestrictionType(SchemaType sType) {
        SchemaType pType = sType.getPrimitiveType();
        switch (pType.getBuiltinTypeCode()) {
            case 2: {
                return "org.apache.xmlbeans.impl.values.XmlAnySimpleTypeImpl";
            }
            case 3: {
                return "org.apache.xmlbeans.impl.values.JavaBooleanHolderEx";
            }
            case 4: {
                return "org.apache.xmlbeans.impl.values.JavaBase64HolderEx";
            }
            case 5: {
                return "org.apache.xmlbeans.impl.values.JavaHexBinaryHolderEx";
            }
            case 6: {
                return "org.apache.xmlbeans.impl.values.JavaUriHolderEx";
            }
            case 7: {
                return "org.apache.xmlbeans.impl.values.JavaQNameHolderEx";
            }
            case 8: {
                return "org.apache.xmlbeans.impl.values.JavaNotationHolderEx";
            }
            case 9: {
                return "org.apache.xmlbeans.impl.values.JavaFloatHolderEx";
            }
            case 10: {
                return "org.apache.xmlbeans.impl.values.JavaDoubleHolderEx";
            }
            case 11: {
                switch (sType.getDecimalSize()) {
                    default: {
                        if (XmlBeans.ASSERTS) {
                            XmlBeans.assertTrue(false);
                        }
                    }
                    case 1000001: {
                        return "org.apache.xmlbeans.impl.values.JavaDecimalHolderEx";
                    }
                    case 1000000: {
                        return "org.apache.xmlbeans.impl.values.JavaIntegerHolderEx";
                    }
                    case 64: {
                        return "org.apache.xmlbeans.impl.values.JavaLongHolderEx";
                    }
                    case 8: 
                    case 16: 
                    case 32: 
                }
                return "org.apache.xmlbeans.impl.values.JavaIntHolderEx";
            }
            case 12: {
                if (sType.hasStringEnumValues()) {
                    return "org.apache.xmlbeans.impl.values.JavaStringEnumerationHolderEx";
                }
                return "org.apache.xmlbeans.impl.values.JavaStringHolderEx";
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return "org.apache.xmlbeans.impl.values.JavaGDateHolderEx";
            }
            case 13: {
                return "org.apache.xmlbeans.impl.values.JavaGDurationHolderEx";
            }
        }
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(false, "unrecognized primitive type");
        }
        return null;
    }

    static SchemaType findBaseType(SchemaType sType) {
        while (sType.getFullJavaName() == null) {
            sType = sType.getBaseType();
        }
        return sType;
    }

    String getBaseClass(SchemaType sType) {
        SchemaType baseType = SchemaTypeCodePrinter.findBaseType(sType.getBaseType());
        switch (sType.getSimpleVariety()) {
            case 0: {
                if (!XmlObject.type.equals(baseType)) {
                    return baseType.getFullJavaImplName();
                }
                return "org.apache.xmlbeans.impl.values.XmlComplexContentImpl";
            }
            case 1: {
                if (XmlBeans.ASSERTS) {
                    XmlBeans.assertTrue(!sType.isBuiltinType());
                }
                return this.getAtomicRestrictionType(sType);
            }
            case 3: {
                return "org.apache.xmlbeans.impl.values.XmlListImpl";
            }
            case 2: {
                return "org.apache.xmlbeans.impl.values.XmlUnionImpl";
            }
        }
        throw new IllegalStateException();
    }

    void printConstructor(SchemaType sType, String shortName) throws IOException {
        this.emit("");
        this.emit("public " + shortName + "(org.apache.xmlbeans.SchemaType sType)");
        this.startBlock();
        this.emit("super(sType" + (sType.getSimpleVariety() == 0 ? "" : ", " + !sType.isSimpleType()) + ");");
        this.endBlock();
        if (sType.getSimpleVariety() != 0) {
            this.emit("");
            this.emit("protected " + shortName + "(org.apache.xmlbeans.SchemaType sType, boolean b)");
            this.startBlock();
            this.emit("super(sType, b);");
            this.endBlock();
        }
    }

    void startClass(SchemaType sType, boolean isInner) throws IOException {
        String shortName = sType.getShortJavaImplName();
        String baseClass = this.getBaseClass(sType);
        StringBuffer interfaces = new StringBuffer();
        interfaces.append(sType.getFullJavaName().replace('$', '.'));
        if (sType.getSimpleVariety() == 2) {
            SchemaType[] memberTypes = sType.getUnionMemberTypes();
            int i = 0;
            while (i < memberTypes.length) {
                interfaces.append(", " + memberTypes[i].getFullJavaName().replace('$', '.'));
                ++i;
            }
        }
        this.emit("public " + (isInner ? "static " : "") + "class " + shortName + " extends " + baseClass + " implements " + interfaces.toString());
        this.startBlock();
    }

    void makeAttributeDefaultValue(String jtargetType, SchemaProperty prop, String identifier) throws IOException {
        String fullName = jtargetType;
        if (fullName == null) {
            fullName = prop.javaBasedOnType().getFullJavaName().replace('$', '.');
        }
        this.emit("target = (" + fullName + ")get_default_attribute_value(" + identifier + ");");
    }

    void makeMissingValue(int javaType) throws IOException {
        switch (javaType) {
            case 1: {
                this.emit("return false;");
                break;
            }
            case 2: {
                this.emit("return 0.0f;");
                break;
            }
            case 3: {
                this.emit("return 0.0;");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.emit("return 0;");
                break;
            }
            case 7: {
                this.emit("return 0L;");
                break;
            }
            default: {
                this.emit("return null;");
            }
        }
    }

    void printJGetArrayValue(int javaType, String type) throws IOException {
        switch (javaType) {
            case 0: {
                this.emit(type + "[] result = new " + type + "[targetList.size()];");
                this.emit("targetList.toArray(result);");
                break;
            }
            case 18: {
                this.emit(type + "[] result = new " + type + "[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = (" + type + ")((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getEnumValue();");
                break;
            }
            case 1: {
                this.emit("boolean[] result = new boolean[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getBooleanValue();");
                break;
            }
            case 2: {
                this.emit("float[] result = new float[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getFloatValue();");
                break;
            }
            case 3: {
                this.emit("double[] result = new double[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getDoubleValue();");
                break;
            }
            case 4: {
                this.emit("byte[] result = new byte[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getByteValue();");
                break;
            }
            case 5: {
                this.emit("short[] result = new short[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getShortValue();");
                break;
            }
            case 6: {
                this.emit("int[] result = new int[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getIntValue();");
                break;
            }
            case 7: {
                this.emit("long[] result = new long[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getLongValue();");
                break;
            }
            case 8: {
                this.emit("java.math.BigDecimal[] result = new java.math.BigDecimal[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getBigDecimalValue();");
                break;
            }
            case 9: {
                this.emit("java.math.BigInteger[] result = new java.math.BigInteger[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getBigIntegerValue();");
                break;
            }
            case 10: {
                this.emit("java.lang.String[] result = new java.lang.String[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getStringValue();");
                break;
            }
            case 11: {
                this.emit("byte[][] result = new byte[targetList.size()][];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getByteArrayValue();");
                break;
            }
            case 17: {
                this.emit("java.util.Calendar[] result = new java.util.Calendar[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getCalendarValue();");
                break;
            }
            case 14: {
                this.emit("java.util.Date[] result = new java.util.Date[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getDateValue();");
                break;
            }
            case 12: {
                this.emit("org.apache.xmlbeans.GDate[] result = new org.apache.xmlbeans.GDate[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getGDateValue();");
                break;
            }
            case 13: {
                this.emit("org.apache.xmlbeans.GDuration[] result = new org.apache.xmlbeans.GDuration[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getGDurationValue();");
                break;
            }
            case 15: {
                this.emit("javax.xml.namespace.QName[] result = new javax.xml.namespace.QName[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getQNameValue();");
                break;
            }
            case 16: {
                this.emit("java.util.List[] result = new java.util.List[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getListValue();");
                break;
            }
            case 19: {
                this.emit("java.lang.Object[] result = new java.lang.Object[targetList.size()];");
                this.emit("for (int i = 0, len = targetList.size() ; i < len ; i++)");
                this.emit("    result[i] = ((org.apache.xmlbeans.SimpleValue)targetList.get(i)).getObjectValue();");
            }
        }
        this.emit("return result;");
    }

    void printJGetValue(int javaType, String type) throws IOException {
        switch (javaType) {
            case 0: {
                this.emit("return target;");
                break;
            }
            case 1: {
                this.emit("return target.getBooleanValue();");
                break;
            }
            case 2: {
                this.emit("return target.getFloatValue();");
                break;
            }
            case 3: {
                this.emit("return target.getDoubleValue();");
                break;
            }
            case 4: {
                this.emit("return target.getByteValue();");
                break;
            }
            case 5: {
                this.emit("return target.getShortValue();");
                break;
            }
            case 6: {
                this.emit("return target.getIntValue();");
                break;
            }
            case 7: {
                this.emit("return target.getLongValue();");
                break;
            }
            case 8: {
                this.emit("return target.getBigDecimalValue();");
                break;
            }
            case 9: {
                this.emit("return target.getBigIntegerValue();");
                break;
            }
            case 10: {
                this.emit("return target.getStringValue();");
                break;
            }
            case 11: {
                this.emit("return target.getByteArrayValue();");
                break;
            }
            case 12: {
                this.emit("return target.getGDateValue();");
                break;
            }
            case 13: {
                this.emit("return target.getGDurationValue();");
                break;
            }
            case 17: {
                this.emit("return target.getCalendarValue();");
                break;
            }
            case 14: {
                this.emit("return target.getDateValue();");
                break;
            }
            case 15: {
                this.emit("return target.getQNameValue();");
                break;
            }
            case 16: {
                this.emit("return target.getListValue();");
                break;
            }
            case 18: {
                this.emit("return (" + type + ")target.getEnumValue();");
                break;
            }
            case 19: {
                this.emit("return target.getObjectValue();");
            }
        }
    }

    String jsetMethod(int javaType) throws IOException {
        switch (javaType) {
            case 0: {
                return "target.set";
            }
            case 1: {
                return "target.setBooleanValue";
            }
            case 2: {
                return "target.setFloatValue";
            }
            case 3: {
                return "target.setDoubleValue";
            }
            case 4: {
                return "target.setByteValue";
            }
            case 5: {
                return "target.setShortValue";
            }
            case 6: {
                return "target.setIntValue";
            }
            case 7: {
                return "target.setLongValue";
            }
            case 8: {
                return "target.setBigDecimalValue";
            }
            case 9: {
                return "target.setBigIntegerValue";
            }
            case 10: {
                return "target.setStringValue";
            }
            case 11: {
                return "target.setByteArrayValue";
            }
            case 12: {
                return "target.setGDateValue";
            }
            case 13: {
                return "target.setGDurationValue";
            }
            case 17: {
                return "target.setCalendarValue";
            }
            case 14: {
                return "target.setDateValue";
            }
            case 15: {
                return "target.setQNameValue";
            }
            case 16: {
                return "target.setListValue";
            }
            case 18: {
                return "target.setEnumValue";
            }
            case 19: {
                return "target.setObjectValue";
            }
        }
        throw new IllegalStateException();
    }

    String getIdentifier(Map qNameMap, QName qName) {
        return ((String[])qNameMap.get(qName))[0];
    }

    String getSetIdentifier(Map qNameMap, QName qName) {
        String[] identifiers = (String[])qNameMap.get(qName);
        return identifiers[1] == null ? identifiers[0] : identifiers[1];
    }

    Map printStaticFields(SchemaProperty[] properties) throws IOException {
        HashMap<QName, String[]> results = new HashMap<QName, String[]>();
        this.emit("");
        int i = 0;
        while (i < properties.length) {
            QName[] qnames;
            String[] identifiers = new String[2];
            SchemaProperty prop = properties[i];
            QName name = prop.getName();
            results.put(name, identifiers);
            String javaName = prop.getJavaPropertyName();
            identifiers[0] = (javaName + "$" + i * 2).toUpperCase();
            String uriString = "\"" + name.getNamespaceURI() + "\"";
            this.emit("private static final javax.xml.namespace.QName " + identifiers[0] + " = ");
            this.indent();
            this.emit("new javax.xml.namespace.QName(" + uriString + ", \"" + name.getLocalPart() + "\");");
            this.outdent();
            if (properties[i].acceptedNames() != null && (qnames = properties[i].acceptedNames()).length > 1) {
                identifiers[1] = (javaName + "$" + (i * 2 + 1)).toUpperCase();
                this.emit("private static final org.apache.xmlbeans.QNameSet " + identifiers[1] + " = org.apache.xmlbeans.QNameSet.forArray( new javax.xml.namespace.QName[] { ");
                this.indent();
                int j = 0;
                while (j < qnames.length) {
                    this.emit("new javax.xml.namespace.QName(\"" + qnames[j].getNamespaceURI() + "\", \"" + qnames[j].getLocalPart() + "\"),");
                    ++j;
                }
                this.outdent();
                this.emit("});");
            }
            ++i;
        }
        this.emit("");
        return results;
    }

    void emitImplementationPreamble() throws IOException {
        this.emit("synchronized (monitor())");
        this.emit("{");
        this.indent();
        this.emit("check_orphaned();");
    }

    void emitImplementationPostamble() throws IOException {
        this.outdent();
        this.emit("}");
    }

    void emitDeclareTarget(boolean declareTarget, String xtype) throws IOException {
        if (declareTarget) {
            this.emit(xtype + " target = null;");
        }
    }

    void emitAddTarget(String identifier, boolean isAttr, boolean declareTarget, String xtype) throws IOException {
        if (isAttr) {
            this.emit("target = (" + xtype + ")get_store().add_attribute_user(" + identifier + ");");
        } else {
            this.emit("target = (" + xtype + ")get_store().add_element_user(" + identifier + ");");
        }
    }

    void emitPre(SchemaType sType, int opType, String identifier, boolean isAttr) throws IOException {
        this.emitPre(sType, opType, identifier, isAttr, "-1");
    }

    void emitPre(SchemaType sType, int opType, String identifier, boolean isAttr, String index) throws IOException {
        SchemaTypeImpl sImpl = SchemaTypeCodePrinter.getImpl(sType);
        if (sImpl == null) {
            return;
        }
        ExtensionHolder extHolder = sImpl.getExtensionHolder();
        if (extHolder == null) {
            return;
        }
        PrePostExtension ext = extHolder.getPrePostExtensionsFor(sType.getFullJavaName());
        if (ext != null && ext.hasPreCall()) {
            this.emit("if ( " + ext.getPreCall(opType, identifier, isAttr, index) + " )");
            this.startBlock();
        }
    }

    void emitPost(SchemaType sType, int opType, String identifier, boolean isAttr) throws IOException {
        this.emitPost(sType, opType, identifier, isAttr, "-1");
    }

    void emitPost(SchemaType sType, int opType, String identifier, boolean isAttr, String index) throws IOException {
        SchemaTypeImpl sImpl = SchemaTypeCodePrinter.getImpl(sType);
        if (sImpl == null) {
            return;
        }
        ExtensionHolder extHolder = sImpl.getExtensionHolder();
        if (extHolder == null) {
            return;
        }
        PrePostExtension ext = extHolder.getPrePostExtensionsFor(sType.getFullJavaName());
        if (ext != null) {
            if (ext.hasPreCall()) {
                this.endBlock();
            }
            if (ext.hasPostCall()) {
                this.emit(ext.getPostCall(opType, identifier, isAttr, index));
            }
        }
    }

    void emitGetTarget(String setIdentifier, String identifier, boolean isAttr, String index, int nullBehaviour, String xtype) throws IOException {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(setIdentifier != null && identifier != null);
        }
        this.emit(xtype + " target = null;");
        if (isAttr) {
            this.emit("target = (" + xtype + ")get_store().find_attribute_user(" + identifier + ");");
        } else {
            this.emit("target = (" + xtype + ")get_store().find_element_user(" + setIdentifier + ", " + index + ");");
        }
        if (nullBehaviour == 1) {
            return;
        }
        this.emit("if (target == null)");
        this.startBlock();
        switch (nullBehaviour) {
            case 3: {
                this.emitAddTarget(identifier, isAttr, false, xtype);
                break;
            }
            case 4: {
                this.emit("throw new IndexOutOfBoundsException();");
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (!XmlBeans.ASSERTS) break;
                XmlBeans.assertTrue(false, "Bad behaviour type: " + nullBehaviour);
            }
        }
        this.endBlock();
    }

    void printGetterImpls(SchemaProperty prop, QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton, boolean isunion, String identifier, String setIdentifier) throws IOException {
        String jtargetType;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        boolean xmltype = javaType == 0;
        String string = jtargetType = isunion || !xmltype ? "org.apache.xmlbeans.SimpleValue" : xtype;
        if (singleton) {
            this.printJavaDoc((several ? "Gets first " : "Gets the ") + propdesc);
            this.emit("public " + type + " get" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 1, jtargetType);
            if (isAttr && (prop.hasDefault() == 2 || prop.hasFixed() == 2)) {
                this.emit("if (target == null)");
                this.startBlock();
                this.makeAttributeDefaultValue(jtargetType, prop, identifier);
                this.endBlock();
            }
            this.emit("if (target == null)");
            this.startBlock();
            this.makeMissingValue(javaType);
            this.endBlock();
            this.printJGetValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc((several ? "Gets (as xml) first " : "Gets (as xml) the ") + propdesc);
                this.emit("public " + xtype + " xget" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 1, xtype);
                if (isAttr && (prop.hasDefault() == 2 || prop.hasFixed() == 2)) {
                    this.emit("if (target == null)");
                    this.startBlock();
                    this.makeAttributeDefaultValue(xtype, prop, identifier);
                    this.endBlock();
                }
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc((several ? "Tests for nil first " : "Tests for nil ") + propdesc);
                this.emit("public boolean isNil" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 1, xtype);
                this.emit("if (target == null) return false;");
                this.emit("return target.isNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "True if has at least one " : "True if has ") + propdesc);
            this.emit("public boolean isSet" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            if (isAttr) {
                this.emit("return get_store().find_attribute_user(" + identifier + ") != null;");
            } else {
                this.emit("return get_store().count_elements(" + setIdentifier + ") != 0;");
            }
            this.emitImplementationPostamble();
            this.endBlock();
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Gets array of all " + propdesc + "s");
            this.emit("public " + type + "[] get" + arrayName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emit("java.util.List targetList = new java.util.ArrayList();");
            this.emit("get_store().find_all_element_users(" + setIdentifier + ", targetList);");
            this.printJGetArrayValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            this.printJavaDoc("Gets ith " + propdesc);
            this.emit("public " + type + " get" + arrayName + "(int i)");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, jtargetType);
            this.printJGetValue(javaType, type);
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc("Gets (as xml) array of all " + propdesc + "s");
                this.emit("public " + xtype + "[] xget" + arrayName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emit("java.util.List targetList = new java.util.ArrayList();");
                this.emit("get_store().find_all_element_users(" + setIdentifier + ", targetList);");
                this.emit(xtype + "[] result = new " + xtype + "[targetList.size()];");
                this.emit("targetList.toArray(result);");
                this.emit("return result;");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Gets (as xml) ith " + propdesc);
                this.emit("public " + xtype + " xget" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, xtype);
                this.emit("return (" + xtype + ")target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc("Tests for nil ith " + propdesc);
                this.emit("public boolean isNil" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, xtype);
                this.emit("return target.isNil();");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            this.printJavaDoc("Returns number of " + propdesc);
            this.emit("public int sizeOf" + arrayName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emit("return get_store().count_elements(" + setIdentifier + ");");
            this.emitImplementationPostamble();
            this.endBlock();
        }
    }

    void printSetterImpls(QName qName, boolean isAttr, String propertyName, int javaType, String type, String xtype, boolean nillable, boolean optional, boolean several, boolean singleton, boolean isunion, String identifier, String setIdentifier, SchemaType sType) throws IOException {
        String safeVarName = NameUtil.nonJavaKeyword(NameUtil.lowerCamelCase(propertyName));
        if (safeVarName.equals("i")) {
            safeVarName = "iValue";
        } else if (safeVarName.equals("target")) {
            safeVarName = "targetValue";
        }
        boolean xmltype = javaType == 0;
        boolean isobj = javaType == 19;
        boolean isSubstGroup = identifier != setIdentifier;
        String jSet = this.jsetMethod(javaType);
        String jtargetType = isunion || !xmltype ? "org.apache.xmlbeans.SimpleValue" : xtype;
        String propdesc = "\"" + qName.getLocalPart() + "\"" + (isAttr ? " attribute" : " element");
        if (singleton) {
            this.printJavaDoc((several ? "Sets first " : "Sets the ") + propdesc);
            this.emit("public void set" + propertyName + "(" + type + " " + safeVarName + ")");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
            this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 3, jtargetType);
            this.emit(jSet + "(" + safeVarName + ");");
            this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc((several ? "Sets (as xml) first " : "Sets (as xml) the ") + propdesc);
                this.emit("public void xset" + propertyName + "(" + xtype + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
                this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 3, xtype);
                this.emit("target.set(" + safeVarName + ");");
                this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (xmltype && !several) {
                this.printJavaDoc("Appends and returns a new empty " + propdesc);
                this.emit("public " + xtype + " addNew" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitDeclareTarget(true, xtype);
                this.emitPre(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emitAddTarget(identifier, isAttr, true, xtype);
                this.emitPost(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc((several ? "Nils the first " : "Nils the ") + propdesc);
                this.emit("public void setNil" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
                this.emitGetTarget(setIdentifier, identifier, isAttr, "0", 3, xtype);
                this.emit("target.setNil();");
                this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, several ? "0" : "-1");
                this.emitImplementationPostamble();
                this.endBlock();
            }
        }
        if (optional) {
            this.printJavaDoc((several ? "Removes first " : "Unsets the ") + propdesc);
            this.emit("public void unset" + propertyName + "()");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitPre(sType, PrePostExtension.OPERATION_REMOVE, identifier, isAttr, several ? "0" : "-1");
            if (isAttr) {
                this.emit("get_store().remove_attribute(" + identifier + ");");
            } else {
                this.emit("get_store().remove_element(" + setIdentifier + ", 0);");
            }
            this.emitPost(sType, PrePostExtension.OPERATION_REMOVE, identifier, isAttr, several ? "0" : "-1");
            this.emitImplementationPostamble();
            this.endBlock();
        }
        if (several) {
            String arrayName = propertyName + "Array";
            this.printJavaDoc("Sets array of all " + propdesc);
            this.emit("public void set" + arrayName + "(" + type + "[] " + safeVarName + "Array)");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr);
            if (isobj) {
                if (!isSubstGroup) {
                    this.emit("unionArraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
                } else {
                    this.emit("unionArraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ", " + setIdentifier + ");");
                }
            } else if (!isSubstGroup) {
                this.emit("arraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
            } else {
                this.emit("arraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ", " + setIdentifier + ");");
            }
            this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr);
            this.emitImplementationPostamble();
            this.endBlock();
            this.printJavaDoc("Sets ith " + propdesc);
            this.emit("public void set" + arrayName + "(int i, " + type + " " + safeVarName + ")");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
            this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, jtargetType);
            this.emit(jSet + "(" + safeVarName + ");");
            this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
            this.emitImplementationPostamble();
            this.endBlock();
            if (!xmltype) {
                this.printJavaDoc("Sets (as xml) array of all " + propdesc);
                this.emit("public void xset" + arrayName + "(" + xtype + "[]" + safeVarName + "Array)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr);
                this.emit("arraySetterHelper(" + safeVarName + "Array" + ", " + identifier + ");");
                this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr);
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Sets (as xml) ith " + propdesc);
                this.emit("public void xset" + arrayName + "(int i, " + xtype + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
                this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, xtype);
                this.emit("target.set(" + safeVarName + ");");
                this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (nillable) {
                this.printJavaDoc("Nils the ith " + propdesc);
                this.emit("public void setNil" + arrayName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
                this.emitGetTarget(setIdentifier, identifier, isAttr, "i", 4, xtype);
                this.emit("target.setNil();");
                this.emitPost(sType, PrePostExtension.OPERATION_SET, identifier, isAttr, "i");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (!xmltype) {
                this.printJavaDoc("Inserts the value as the ith " + propdesc);
                this.emit("public void insert" + propertyName + "(int i, " + type + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitPre(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr, "i");
                this.emit(jtargetType + " target = ");
                this.indent();
                if (!isSubstGroup) {
                    this.emit("(" + jtargetType + ")get_store().insert_element_user(" + identifier + ", i);");
                } else {
                    this.emit("(" + jtargetType + ")get_store().insert_element_user(" + setIdentifier + ", " + identifier + ", i);");
                }
                this.outdent();
                this.emit(jSet + "(" + safeVarName + ");");
                this.emitPost(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr, "i");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Appends the value as the last " + propdesc);
                this.emit("public void add" + propertyName + "(" + type + " " + safeVarName + ")");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitDeclareTarget(true, jtargetType);
                this.emitPre(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emitAddTarget(identifier, isAttr, true, jtargetType);
                this.emit(jSet + "(" + safeVarName + ");");
                this.emitPost(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emitImplementationPostamble();
                this.endBlock();
            }
            if (xmltype) {
                this.printJavaDoc("Inserts and returns a new empty value (as xml) as the ith " + propdesc);
                this.emit("public " + xtype + " insertNew" + propertyName + "(int i)");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitDeclareTarget(true, xtype);
                this.emitPre(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr, "i");
                this.emit("target = (" + xtype + ")get_store().insert_element_user(" + identifier + ", i);");
                this.emitPost(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr, "i");
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
                this.printJavaDoc("Appends and returns a new empty value (as xml) as the last " + propdesc);
                this.emit("public " + xtype + " addNew" + propertyName + "()");
                this.startBlock();
                this.emitImplementationPreamble();
                this.emitDeclareTarget(true, xtype);
                this.emitPre(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emitAddTarget(identifier, isAttr, true, xtype);
                this.emitPost(sType, PrePostExtension.OPERATION_INSERT, identifier, isAttr);
                this.emit("return target;");
                this.emitImplementationPostamble();
                this.endBlock();
            }
            this.printJavaDoc("Removes the ith " + propdesc);
            this.emit("public void remove" + propertyName + "(int i)");
            this.startBlock();
            this.emitImplementationPreamble();
            this.emitPre(sType, PrePostExtension.OPERATION_REMOVE, identifier, isAttr, "i");
            this.emit("get_store().remove_element(" + setIdentifier + ", i);");
            this.emitPost(sType, PrePostExtension.OPERATION_REMOVE, identifier, isAttr, "i");
            this.emitImplementationPostamble();
            this.endBlock();
        }
    }

    static void getTypeName(Class c, StringBuffer sb) {
        int arrayCount = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++arrayCount;
        }
        sb.append(c.getName());
        int i = 0;
        while (i < arrayCount) {
            sb.append("[]");
            ++i;
        }
    }

    void printInnerTypeImpl(SchemaType sType, SchemaTypeSystem system, boolean isInner) throws IOException {
        String shortName = sType.getShortJavaImplName();
        this.printInnerTypeJavaDoc(sType);
        this.startClass(sType, isInner);
        this.printConstructor(sType, shortName);
        this.printExtensionImplMethods(sType);
        if (!sType.isSimpleType()) {
            SchemaProperty[] properties = sType.getContentType() == 2 ? sType.getProperties() : sType.getDerivedProperties();
            Map qNameMap = this.printStaticFields(properties);
            int i = 0;
            while (i < properties.length) {
                SchemaProperty prop = properties[i];
                QName name = prop.getName();
                String xmlType = this.xmlTypeForProperty(prop);
                this.printGetterImpls(prop, name, prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), this.javaTypeForProperty(prop), xmlType, prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton(), SchemaTypeCodePrinter.xmlTypeForPropertyIsUnion(prop), this.getIdentifier(qNameMap, name), this.getSetIdentifier(qNameMap, name));
                if (!prop.isReadOnly()) {
                    this.printSetterImpls(name, prop.isAttribute(), prop.getJavaPropertyName(), prop.getJavaTypeCode(), this.javaTypeForProperty(prop), xmlType, prop.hasNillable() != 0, prop.extendsJavaOption(), prop.extendsJavaArray(), prop.extendsJavaSingleton(), SchemaTypeCodePrinter.xmlTypeForPropertyIsUnion(prop), this.getIdentifier(qNameMap, name), this.getSetIdentifier(qNameMap, name), sType);
                }
                ++i;
            }
        }
        this.printNestedTypeImpls(sType, system);
        this.endBlock();
    }

    private void printExtensionImplMethods(SchemaType sType) throws IOException {
        SchemaTypeImpl sImpl = SchemaTypeCodePrinter.getImpl(sType);
        if (sImpl == null) {
            return;
        }
        ExtensionHolder extHolder = sImpl.getExtensionHolder();
        if (extHolder == null) {
            return;
        }
        List exts = extHolder.getInterfaceExtensionsFor(sType.getFullJavaName());
        Iterator i = exts.iterator();
        while (i.hasNext()) {
            InterfaceExtension ext = (InterfaceExtension)i.next();
            int j = 0;
            while (j < ext.getInterfaceMethodCount()) {
                this.printJavaDoc("Implementation method for interface " + ext.getInterfaceNameForJavaSource());
                this.emit(ext.getInterfaceMethodDecl(j));
                this.startBlock();
                this.emit(ext.getInterfaceMethodImpl(j));
                this.endBlock();
                ++j;
            }
        }
    }

    void printNestedTypeImpls(SchemaType sType, SchemaTypeSystem system) throws IOException {
        SchemaType[] anonTypes = sType.getAnonymousTypes();
        int i = 0;
        while (i < anonTypes.length) {
            if (anonTypes[i].isSkippedAnonymousType()) {
                this.printNestedTypeImpls(anonTypes[i], system);
            } else {
                this.printInnerTypeImpl(anonTypes[i], system, true);
            }
            ++i;
        }
    }
}

