/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.impl.schema.XmlValueRef;
import org.apache.xmlbeans.impl.values.NamespaceContext;

public class SchemaParticleImpl
implements SchemaParticle {
    private int _particleType;
    private BigInteger _minOccurs;
    private BigInteger _maxOccurs;
    private SchemaParticle[] _particleChildren;
    private boolean _isImmutable;
    private QNameSet _startSet;
    private QNameSet _excludeNextSet;
    private boolean _isSkippable;
    private boolean _isDeterministic;
    private int _intMinOccurs;
    private int _intMaxOccurs;
    private QNameSet _wildcardSet;
    private int _wildcardProcess;
    private String _defaultText;
    private boolean _isDefault;
    private boolean _isFixed;
    private QName _qName;
    private boolean _isNillable;
    private SchemaType.Ref _typeref;
    protected XmlObject _parseObject;
    private XmlValueRef _defaultValue;
    private static final BigInteger _maxint = BigInteger.valueOf(Integer.MAX_VALUE);

    protected void mutate() {
        if (this._isImmutable) {
            throw new IllegalStateException();
        }
    }

    public void setImmutable() {
        this.mutate();
        this._isImmutable = true;
    }

    public boolean hasTransitionRules() {
        return this._startSet != null;
    }

    public boolean hasTransitionNotes() {
        return this._excludeNextSet != null;
    }

    public void setTransitionRules(QNameSet start, boolean isSkippable) {
        this._startSet = start;
        this._isSkippable = isSkippable;
    }

    public void setTransitionNotes(QNameSet excludeNext, boolean isDeterministic) {
        this._excludeNextSet = excludeNext;
        this._isDeterministic = isDeterministic;
    }

    public boolean canStartWithElement(QName name) {
        return name != null && this._startSet.contains(name);
    }

    public QNameSet acceptedStartNames() {
        return this._startSet;
    }

    public QNameSet getExcludeNextSet() {
        return this._excludeNextSet;
    }

    public boolean isSkippable() {
        return this._isSkippable;
    }

    public boolean isDeterministic() {
        return this._isDeterministic;
    }

    public int getParticleType() {
        return this._particleType;
    }

    public void setParticleType(int pType) {
        this.mutate();
        this._particleType = pType;
    }

    public boolean isSingleton() {
        return this._maxOccurs != null && this._maxOccurs.compareTo(BigInteger.ONE) == 0 && this._minOccurs.compareTo(BigInteger.ONE) == 0;
    }

    public BigInteger getMinOccurs() {
        return this._minOccurs;
    }

    public void setMinOccurs(BigInteger min) {
        this.mutate();
        this._minOccurs = min;
        this._intMinOccurs = SchemaParticleImpl.pegBigInteger(min);
    }

    public int getIntMinOccurs() {
        return this._intMinOccurs;
    }

    public BigInteger getMaxOccurs() {
        return this._maxOccurs;
    }

    public int getIntMaxOccurs() {
        return this._intMaxOccurs;
    }

    public void setMaxOccurs(BigInteger max) {
        this.mutate();
        this._maxOccurs = max;
        this._intMaxOccurs = SchemaParticleImpl.pegBigInteger(max);
    }

    public SchemaParticle[] getParticleChildren() {
        SchemaParticle[] result = new SchemaParticle[this._particleChildren.length];
        System.arraycopy(this._particleChildren, 0, result, 0, this._particleChildren.length);
        return result;
    }

    public void setParticleChildren(SchemaParticle[] children) {
        this.mutate();
        this._particleChildren = children;
    }

    public SchemaParticle getParticleChild(int i) {
        return this._particleChildren[i];
    }

    public int countOfParticleChild() {
        return this._particleChildren == null ? 0 : this._particleChildren.length;
    }

    public void setWildcardSet(QNameSet set) {
        this.mutate();
        this._wildcardSet = set;
    }

    public QNameSet getWildcardSet() {
        return this._wildcardSet;
    }

    public void setWildcardProcess(int process) {
        this.mutate();
        this._wildcardProcess = process;
    }

    public int getWildcardProcess() {
        return this._wildcardProcess;
    }

    private static final int pegBigInteger(BigInteger bi) {
        if (bi == null) {
            return Integer.MAX_VALUE;
        }
        if (bi.signum() <= 0) {
            return 0;
        }
        if (bi.compareTo(_maxint) >= 0) {
            return Integer.MAX_VALUE;
        }
        return bi.intValue();
    }

    public QName getName() {
        return this._qName;
    }

    public void setNameAndTypeRef(QName formname, SchemaType.Ref typeref) {
        this.mutate();
        this._qName = formname;
        this._typeref = typeref;
    }

    public boolean isTypeResolved() {
        return this._typeref != null;
    }

    public void resolveTypeRef(SchemaType.Ref typeref) {
        if (this._typeref != null) {
            throw new IllegalStateException();
        }
        this._typeref = typeref;
    }

    public boolean isAttribute() {
        return false;
    }

    public SchemaType getType() {
        if (this._typeref == null) {
            return null;
        }
        return this._typeref.get();
    }

    public String getDefaultText() {
        return this._defaultText;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public boolean isFixed() {
        return this._isFixed;
    }

    public void setDefault(String deftext, boolean isFixed, XmlObject parseObject) {
        this.mutate();
        this._defaultText = deftext;
        this._isDefault = deftext != null;
        this._isFixed = isFixed;
        this._parseObject = parseObject;
    }

    public boolean isNillable() {
        return this._isNillable;
    }

    public void setNillable(boolean nillable) {
        this.mutate();
        this._isNillable = nillable;
    }

    public XmlAnySimpleType getDefaultValue() {
        if (this._defaultValue != null) {
            return this._defaultValue.get();
        }
        if (this._defaultText != null && XmlAnySimpleType.type.isAssignableFrom(this.getType())) {
            if (this._parseObject != null && XmlQName.type.isAssignableFrom(this.getType())) {
                XmlAnySimpleType xmlAnySimpleType;
                try {
                    NamespaceContext.push(new NamespaceContext(this._parseObject));
                    xmlAnySimpleType = this.getType().newValue(this._defaultText);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    NamespaceContext.pop();
                    throw throwable;
                }
                NamespaceContext.pop();
                return xmlAnySimpleType;
            }
            return this.getType().newValue(this._defaultText);
        }
        return null;
    }

    public void setDefaultValue(XmlValueRef defaultRef) {
        this.mutate();
        this._defaultValue = defaultRef;
    }
}

