/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.util.ArrayList;
import org.apache.xmlbeans.impl.regex.Match;
import org.apache.xmlbeans.impl.regex.RegularExpression;

public class StringUtils {
    public static int count(String str, char c) {
        int index = 0;
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                ++index;
            }
            ++i;
        }
        return index;
    }

    public static int matchStrings(String a, String b) {
        char[] cb;
        char[] ca = a.toCharArray();
        int len = ca.length < (cb = b.toCharArray()).length ? ca.length : cb.length;
        int i = 0;
        while (i < len) {
            if (ca[i] != cb[i]) break;
            ++i;
        }
        return i;
    }

    public static boolean matches(String source, String pattern) {
        RegularExpression re = new RegularExpression(pattern);
        return re.matches(source);
    }

    public static String[] split(String source, char delim) {
        ArrayList<String> result = new ArrayList<String>(3);
        int pos = 0;
        int start = 0;
        int len = source.length();
        while (true) {
            if (pos < len && delim == source.charAt(pos)) {
                ++pos;
                continue;
            }
            if (pos >= len) break;
            start = pos;
            while (pos < len && delim != source.charAt(pos)) {
                ++pos;
            }
            result.add(source.substring(start, pos));
        }
        if (result.size() == 0) {
            result.add(source);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] split(String source, String delimPattern) {
        ArrayList<String> result = new ArrayList<String>(3);
        RegularExpression re = new RegularExpression(delimPattern);
        Match matcher = new Match();
        if (re.matches(source, matcher)) {
            int groups = matcher.getNumberOfGroups();
            int start = 0;
            int i = 0;
            while (i < groups) {
                result.add(source.substring(start, matcher.getBeginning(i)));
                start = matcher.getEnd(i);
                ++i;
            }
            result.add(source.substring(start));
        } else {
            result.add(source);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void replaceAll(Match matcher, StringBuffer target, String replace) {
        int groups = matcher.getNumberOfGroups();
        if (groups == 0) {
            return;
        }
        int i = 0;
        while (i < groups) {
            target.replace(matcher.getBeginning(i), matcher.getEnd(i), replace);
            ++i;
        }
    }

    public static String replaceAll(String source, String pattern, String replace) {
        RegularExpression re = new RegularExpression(pattern);
        Match matcher = new Match();
        if (re.matches(source, matcher)) {
            StringBuffer sb = new StringBuffer(source);
            StringUtils.replaceAll(matcher, sb, replace);
            return new String(sb);
        }
        return source;
    }
}

