/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.xmlbeans.impl.common.SniffedXmlInputStream;

public class SniffedXmlReader
extends BufferedReader {
    public static int MAX_SNIFFED_CHARS = 192;
    private String _encoding = this.sniffForXmlDecl();

    public SniffedXmlReader(Reader reader) throws IOException {
        super(reader);
    }

    private int readAsMuchAsPossible(char[] buf, int startAt, int len) throws IOException {
        int total = 0;
        while (total < len) {
            int count = this.read(buf, startAt + total, len - total);
            if (count < 0) break;
            total += count;
        }
        return total;
    }

    private String sniffForXmlDecl() throws IOException {
        String string;
        this.mark(MAX_SNIFFED_CHARS);
        try {
            char[] buf = new char[MAX_SNIFFED_CHARS];
            int limit = this.readAsMuchAsPossible(buf, 0, MAX_SNIFFED_CHARS);
            string = SniffedXmlInputStream.extractXmlDeclEncoding(buf, 0, limit);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.reset();
            throw throwable;
        }
        this.reset();
        return string;
    }

    public String getXmlEncoding() {
        return this._encoding;
    }
}

