/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.xmlbeans.XmlBeans;

public class SniffedXmlInputStream
extends BufferedInputStream {
    public static int MAX_SNIFFED_BYTES = 192;
    private String _encoding = this.sniffFourBytes();
    private static char[] WHITESPACE = new char[]{' ', '\r', '\t', '\n'};
    private static char[] NOTNAME = new char[]{'=', ' ', '\r', '\t', '\n', '?', '>', '<', '\'', '\"'};

    public SniffedXmlInputStream(InputStream stream) throws IOException {
        super(stream);
        String encoding;
        if (this._encoding != null && this._encoding.equals("IBM037") && (encoding = this.sniffForXmlDecl(this._encoding)) != null) {
            this._encoding = encoding;
        }
        if (this._encoding == null) {
            this._encoding = this.sniffForXmlDecl("UTF-8");
        }
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
    }

    private int readAsMuchAsPossible(byte[] buf, int startAt, int len) throws IOException {
        int total = 0;
        while (total < len) {
            int count = this.read(buf, startAt + total, len - total);
            if (count < 0) break;
            total += count;
        }
        return total;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sniffFourBytes() throws IOException {
        String string;
        block26: {
            String string2;
            block25: {
                String string3;
                block24: {
                    String string4;
                    block23: {
                        String string5;
                        block22: {
                            String string6;
                            block21: {
                                String string7;
                                block20: {
                                    String string8;
                                    block19: {
                                        String string9;
                                        block18: {
                                            String string10;
                                            block17: {
                                                String string11;
                                                block16: {
                                                    String string12;
                                                    block15: {
                                                        String string13;
                                                        block14: {
                                                            this.mark(4);
                                                            boolean skip = false;
                                                            try {
                                                                byte[] buf = new byte[4];
                                                                if (this.readAsMuchAsPossible(buf, 0, 4) < 4) {
                                                                    string13 = null;
                                                                    Object var19_4 = null;
                                                                    break block14;
                                                                }
                                                                long result = 0xFF000000 & buf[0] << 24 | 0xFF0000 & buf[1] << 16 | 0xFF00 & buf[2] << 8 | 0xFF & buf[3];
                                                                if (result == 65279L) {
                                                                    string12 = "UCS-4";
                                                                    break block15;
                                                                }
                                                                if (result == -131072L) {
                                                                    string11 = "UCS-4";
                                                                    break block16;
                                                                }
                                                                if (result == 60L) {
                                                                    string10 = "UCS-4BE";
                                                                    break block17;
                                                                }
                                                                if (result == 0x3C000000L) {
                                                                    string9 = "UCS-4LE";
                                                                    break block18;
                                                                }
                                                                if (result == 3932223L) {
                                                                    string8 = "UTF-16BE";
                                                                    break block19;
                                                                }
                                                                if (result == 1006649088L) {
                                                                    string7 = "UTF-16LE";
                                                                    break block20;
                                                                }
                                                                if (result == 1010792557L) {
                                                                    string6 = null;
                                                                    break block21;
                                                                }
                                                                if (result == 1282385812L) {
                                                                    string5 = "IBM037";
                                                                    break block22;
                                                                }
                                                                if ((result & 0xFFFFFFFFFFFF0000L) == -16842752L) {
                                                                    string4 = "UTF-16";
                                                                    break block23;
                                                                }
                                                                if ((result & 0xFFFFFFFFFFFF0000L) == -131072L) {
                                                                    string3 = "UTF-16";
                                                                    break block24;
                                                                }
                                                                if ((result & 0xFFFFFFFFFFFFFF00L) == -272908544L) {
                                                                    string2 = "UTF-8";
                                                                    break block25;
                                                                }
                                                                string = null;
                                                                break block26;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var19_17 = null;
                                                                this.reset();
                                                                throw throwable;
                                                            }
                                                        }
                                                        this.reset();
                                                        return string13;
                                                    }
                                                    Object var19_5 = null;
                                                    this.reset();
                                                    return string12;
                                                }
                                                Object var19_6 = null;
                                                this.reset();
                                                return string11;
                                            }
                                            Object var19_7 = null;
                                            this.reset();
                                            return string10;
                                        }
                                        Object var19_8 = null;
                                        this.reset();
                                        return string9;
                                    }
                                    Object var19_9 = null;
                                    this.reset();
                                    return string8;
                                }
                                Object var19_10 = null;
                                this.reset();
                                return string7;
                            }
                            Object var19_11 = null;
                            this.reset();
                            return string6;
                        }
                        Object var19_12 = null;
                        this.reset();
                        return string5;
                    }
                    Object var19_13 = null;
                    this.reset();
                    return string4;
                }
                Object var19_14 = null;
                this.reset();
                return string3;
            }
            Object var19_15 = null;
            this.reset();
            return string2;
        }
        Object var19_16 = null;
        this.reset();
        return string;
    }

    private String sniffForXmlDecl(String encoding) throws IOException {
        String string;
        this.mark(MAX_SNIFFED_BYTES);
        try {
            byte[] bytebuf = new byte[MAX_SNIFFED_BYTES];
            int bytelimit = this.readAsMuchAsPossible(bytebuf, 0, MAX_SNIFFED_BYTES);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytebuf, 0, bytelimit), encoding);
            char[] buf = new char[bytelimit];
            int limit = 0;
            while (limit < bytelimit) {
                int count = ((Reader)reader).read(buf, limit, bytelimit - limit);
                if (count < 0) break;
                limit += count;
            }
            string = SniffedXmlInputStream.extractXmlDeclEncoding(buf, 0, limit);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.reset();
            throw throwable;
        }
        this.reset();
        return string;
    }

    public String getXmlEncoding() {
        return this._encoding;
    }

    static String extractXmlDeclEncoding(char[] buf, int offset, int size) {
        int limit = offset + size;
        int xmlpi = SniffedXmlInputStream.firstIndexOf("<?xml", buf, offset, limit);
        if (xmlpi >= 0) {
            int i = xmlpi + 5;
            ScannedAttribute attr = new ScannedAttribute();
            while (i < limit) {
                if ((i = SniffedXmlInputStream.scanAttribute(buf, i, limit, attr)) < 0) {
                    return null;
                }
                if (!attr.name.equals("encoding")) continue;
                return attr.value;
            }
        }
        return null;
    }

    private static int firstIndexOf(String s, char[] buf, int startAt, int limit) {
        if (XmlBeans.ASSERTS) {
            XmlBeans.assertTrue(s.length() > 0);
        }
        char[] lookFor = s.toCharArray();
        char firstchar = lookFor[0];
        limit -= lookFor.length;
        while (startAt < limit) {
            block5: {
                if (buf[startAt] == firstchar) {
                    int i = 1;
                    while (i < lookFor.length) {
                        if (buf[startAt + i] == lookFor[i]) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return startAt;
                }
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextNonmatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            block3: {
                char thischar = buf[startAt];
                int i = 0;
                while (i < lookFor.length) {
                    if (thischar != lookFor[i]) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            char thischar = buf[startAt];
            int i = 0;
            while (i < lookFor.length) {
                if (thischar == lookFor[i]) {
                    return startAt;
                }
                ++i;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            if (buf[startAt] == lookFor) {
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int scanAttribute(char[] buf, int startAt, int limit, ScannedAttribute attr) {
        int nameStart = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, startAt, limit);
        if (nameStart < 0) {
            return -1;
        }
        int nameEnd = SniffedXmlInputStream.nextMatchingByte(NOTNAME, buf, nameStart, limit);
        if (nameEnd < 0) {
            return -1;
        }
        int equals = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, nameEnd, limit);
        if (equals < 0) {
            return -1;
        }
        if (buf[equals] != '=') {
            return -1;
        }
        int valQuote = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, equals + 1, limit);
        if (buf[valQuote] != '\'' && buf[valQuote] != '\"') {
            return -1;
        }
        int valEndquote = SniffedXmlInputStream.nextMatchingByte(buf[valQuote], buf, valQuote + 1, limit);
        if (valEndquote < 0) {
            return -1;
        }
        attr.name = new String(buf, nameStart, nameEnd - nameStart);
        attr.value = new String(buf, valQuote + 1, valEndquote - valQuote - 1);
        return valEndquote + 1;
    }

    private static class ScannedAttribute {
        public String name;
        public String value;

        private ScannedAttribute() {
        }
    }
}

