/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;

public class XmlRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Throwable _cause = null;
    private String _detailMessage = null;
    private List _errors;

    public XmlRuntimeException() {
    }

    public XmlRuntimeException(String m) {
        super(m);
    }

    public XmlRuntimeException(String m, Throwable t) {
        super(m);
        this._cause = t;
    }

    public XmlRuntimeException(Throwable t) {
        this._cause = t;
    }

    public XmlRuntimeException(String m, Throwable t, Collection errors) {
        this(m, t);
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList(errors));
        }
    }

    public XmlRuntimeException(XmlError error) {
        this(error.toString(), null, error);
    }

    public XmlRuntimeException(String m, Throwable t, XmlError error) {
        this(m, t, Collections.singletonList(error));
    }

    public XmlRuntimeException(XmlException xmlException) {
        this(xmlException.getMessage(), xmlException.getCause());
        Collection errors = xmlException.getErrors();
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList(errors));
        }
    }

    public XmlError getError() {
        if (this._errors == null || this._errors.size() == 0) {
            return null;
        }
        return (XmlError)this._errors.get(0);
    }

    public Collection getErrors() {
        return this._errors;
    }

    public Throwable getCause() {
        return this._cause;
    }

    public Throwable initCause(Throwable t) {
        if (this._cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (this._cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this._cause = t;
        return this;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    public String getMessage() {
        if (this._detailMessage == null) {
            this._detailMessage = this._cause != null ? this._cause.toString() : super.getMessage();
        }
        return this._detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                s.println("Caused by: ");
                ourCause.printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintWriter p) {
        PrintWriter printWriter = p;
        synchronized (printWriter) {
            super.printStackTrace(p);
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                p.println("Caused by: ");
                ourCause.printStackTrace(p);
            }
        }
    }
}

