/**
Copyright (C) 2025 Digital Venture Consultants (info@dvc.ventures)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package ventures.dvc.karbon.provider

import org.springframework.web.reactive.function.client.WebClient
import ventures.dvc.karbon.provider.webclient.WebClientForecastOperation
import ventures.dvc.karbon.provider.webclient.WebClientValidateKeyOperation
import ventures.dvc.karbon.serialization.KarbonForecastDeserializer

public interface WebClientForecastProvider : KarbonForecastProvider, ValidateKeyProvider


public fun WebClientForecastProvider(
    serializer: KarbonForecastDeserializer,
    clientFactory: () -> WebClient = { WebClient.create() },
    configuration: WebClientForecastProviderConfiguration = WebClientForecastProviderConfiguration(),
): WebClientForecastProvider = DefaultWebClientForecastProvider(
    serializer = serializer,
    client = clientFactory(),
    configuration = configuration,
)


private class DefaultWebClientForecastProvider(
    serializer: KarbonForecastDeserializer,
    client: WebClient,
    configuration: WebClientForecastProviderConfiguration
) : WebClientForecastProvider,
    KarbonForecastProvider by WebClientForecastOperation(configuration, serializer, client),
    ValidateKeyProvider by WebClientValidateKeyOperation(configuration, client)