/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.jndi;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.omg.CosNaming.NameComponent;

public class Parser
implements NameParser {
    public Name parse(String name) {
        try {
            CompositeName cname = new CompositeName(name);
            return cname;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public NameComponent[] translateToCosName(Name name) {
        NameComponent[] corba_name = this.getNameComponentParts(name.toString());
        return corba_name;
    }

    public Name translateToName(NameComponent[] name) {
        CompositeName n = new CompositeName();
        String str = null;
        try {
            for (int i = 0; i < name.length; ++i) {
                str = new String(this.adaptName(name[i].id));
                if (!name[i].kind.equals("")) {
                    str = str + "." + this.adaptName(name[i].kind);
                }
                n.add(str);
            }
        }
        catch (InvalidNameException ex) {
            return null;
        }
        return n;
    }

    private NameComponent[] getNameComponentParts(String sn) {
        NameComponent cp = null;
        Vector<NameComponent> list = new Vector<NameComponent>();
        StringTokenizer token = new StringTokenizer(sn, "/");
        while (token.hasMoreElements()) {
            String part = (String)token.nextElement();
            cp = new NameComponent();
            StringTokenizer sub_token = new StringTokenizer(part, ".");
            cp.id = (String)sub_token.nextElement();
            cp.kind = sub_token.hasMoreElements() ? (String)sub_token.nextElement() : "";
            list.addElement(cp);
        }
        NameComponent[] name = new NameComponent[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            name[i] = (NameComponent)list.elementAt(i);
        }
        return name;
    }

    private String adaptName(String n) {
        String str = "";
        for (int i = 0; i < n.length(); ++i) {
            str = n.charAt(i) == '/' ? str + "\\/" : (n.charAt(i) == '.' ? str + "\\." : str + n.charAt(i));
        }
        return str;
    }

    private String removeExtra(String n) {
        String str = "";
        for (int i = 0; i < n.length(); ++i) {
            if (n.charAt(i) == '\\') continue;
            str = str + n.charAt(i);
        }
        return str;
    }
}

