/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.jndi;

import java.rmi.Remote;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.openorb.ns.jndi.Parser;

public class Context
implements javax.naming.Context {
    private Hashtable m_env;
    private CompositeName m_name;
    private NamingContext m_naming;
    private static Parser s_parser = new Parser();

    public Context(NamingContext naming, CompositeName name, Hashtable env) {
        this.m_naming = naming;
        this.m_name = name;
        this.m_env = env;
    }

    public NamingContext getCosContext() {
        return this.m_naming;
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        return this.m_env.put(propName, propVal);
    }

    public Hashtable getEnvironment() {
        return this.m_env;
    }

    public java.lang.Object removeFromEnvironment(String propName) {
        return this.m_env.remove(propName);
    }

    public String getNameInNamespace() throws NamingException {
        return this.m_name.toString();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return s_parser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return s_parser;
    }

    public String composeName(String name, String prefix) throws NamingException {
        CompositeName cname = new CompositeName(name);
        CompositeName cprefix = new CompositeName(prefix);
        return this.composeName(cname, cprefix).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name ret = (Name)prefix.clone();
        ret.addAll(name);
        return ret;
    }

    public void close() {
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        CompositeName cname = new CompositeName(name);
        this.bind(cname, obj);
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        Object corba_obj = this.getCORBAObject(obj);
        NameComponent[] corbam_name = s_parser.translateToCosName(name);
        try {
            if (corba_obj._is_a(NamingContextHelper.id())) {
                this.m_naming.bind_context(corbam_name, NamingContextHelper.narrow((Object)corba_obj));
            } else {
                this.m_naming.bind(corbam_name, corba_obj);
            }
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        CompositeName cname = new CompositeName(name);
        this.rebind(cname, obj);
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        Object corba_obj = this.getCORBAObject(obj);
        NameComponent[] corbam_name = s_parser.translateToCosName(name);
        try {
            if (corba_obj._is_a(NamingContextHelper.id())) {
                this.m_naming.rebind_context(corbam_name, NamingContextHelper.narrow((Object)corba_obj));
            } else {
                this.m_naming.rebind(corbam_name, corba_obj);
            }
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public javax.naming.Context createSubcontext(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        return this.createSubcontext(cname);
    }

    public javax.naming.Context createSubcontext(Name name) throws NamingException {
        NameComponent[] corbam_name = s_parser.translateToCosName(name);
        NamingContext new_ctx = null;
        try {
            new_ctx = this.m_naming.bind_new_context(corbam_name);
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
        CompositeName child = (CompositeName)this.m_name.clone();
        child.addAll(name);
        return new Context(new_ctx, child, this.m_env);
    }

    public void destroySubcontext(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        this.destroySubcontext(cname);
    }

    public void destroySubcontext(Name name) throws NamingException {
        NameComponent[] corbam_name = s_parser.translateToCosName(name);
        try {
            Object obj = this.m_naming.resolve(corbam_name);
            NamingContext ctx = NamingContextHelper.narrow((Object)obj);
            ctx.destroy();
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public void unbind(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        this.unbind(cname);
    }

    public void unbind(Name name) throws NamingException {
        NameComponent[] corbam_name = s_parser.translateToCosName(name);
        try {
            this.m_naming.unbind(corbam_name);
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public java.lang.Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return this.m_naming;
        }
        CompositeName cname = new CompositeName(name);
        return this.lookup(cname);
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        if (name.toString().equals("")) {
            return this.m_naming;
        }
        NameComponent[] corbaname = s_parser.translateToCosName(name);
        try {
            Object obj = this.m_naming.resolve(corbaname);
            try {
                NamingContext nc = NamingContextHelper.narrow((Object)obj);
                CompositeName child = (CompositeName)this.m_name.clone();
                child.addAll(name);
                return new Context(nc, child, this.m_env);
            }
            catch (BAD_PARAM ex) {
                return obj;
            }
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        return this.lookupLink(cname);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        java.lang.Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        CompositeName coname = new CompositeName(oldName);
        CompositeName cnname = new CompositeName(newName);
        this.rename(coname, cnname);
    }

    public NamingEnumeration list(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        return this.list(cname);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        CompositeName cname = new CompositeName(name);
        return this.listBindings(cname);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        CompositeName child = (CompositeName)this.m_name.clone();
        child.addAll(name);
        try {
            NameComponent[] corbam_name = s_parser.translateToCosName(name);
            Object obj = this.m_naming.resolve(corbam_name);
            try {
                NamingContextHelper.narrow((Object)obj);
                return new Enum();
            }
            catch (BAD_PARAM ex) {
                throw new NotContextException("This operation can only be applied on a NamingContext!");
            }
        }
        catch (Exception ex) {
            throw this.mapException(ex);
        }
    }

    private Object getCORBAObject(java.lang.Object obj) throws NamingException {
        if (obj instanceof Object) {
            return (Object)obj;
        }
        if (obj instanceof Remote) {
            Tie trader_tie = Util.getTie((Remote)((Remote)obj));
            return trader_tie.thisObject();
        }
        throw new NamingException("Target is not a reference object");
    }

    private NamingException mapException(Exception ex) {
        NamingException result = null;
        result = ex instanceof CannotProceed ? new CannotProceedException() : (ex instanceof InvalidName ? new InvalidNameException() : (ex instanceof AlreadyBound ? new NameAlreadyBoundException() : (ex instanceof NotFound ? new NameNotFoundException() : (ex instanceof NotEmpty ? new NamingException() : new NamingException()))));
        result.setRootCause(ex);
        return result;
    }

    private class Enum
    implements NamingEnumeration {
        private BindingIteratorHolder m_binding_iter = new BindingIteratorHolder();
        private BindingListHolder m_binding_list = new BindingListHolder();
        private int m_index = 0;

        Enum() {
            Context.this.m_naming.list(100, this.m_binding_list, this.m_binding_iter);
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_index < this.m_binding_list.value.length || this.loadBindings();
        }

        public java.lang.Object next() {
            return this.nextElement();
        }

        public java.lang.Object nextElement() {
            while (true) {
                try {
                    Object obj;
                    if (this.m_index >= this.m_binding_list.value.length && !this.loadBindings()) {
                        throw new NoSuchElementException();
                    }
                    org.omg.CosNaming.Binding b = this.m_binding_list.value[this.m_index++];
                    java.lang.Object bound = obj = Context.this.m_naming.resolve(b.binding_name);
                    Name name = s_parser.translateToName(b.binding_name);
                    if (b.binding_type == BindingType.ncontext) {
                        CompositeName child = (CompositeName)Context.this.m_name.clone();
                        child.addAll(name);
                        bound = new Context(NamingContextHelper.narrow((Object)obj), child, Context.this.m_env);
                    }
                    return new Binding(name.toString(), bound);
                }
                catch (NamingException ex) {
                    continue;
                }
                catch (UserException userException) {
                    continue;
                }
                break;
            }
        }

        public void close() {
            if (this.m_binding_iter.value != null) {
                this.m_binding_iter.value.destroy();
            }
        }

        private boolean loadBindings() {
            if (this.m_binding_iter.value == null) {
                return false;
            }
            this.m_index = 0;
            if (!this.m_binding_iter.value.next_n(100, this.m_binding_list)) {
                try {
                    this.m_binding_iter.value.destroy();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                this.m_binding_iter.value = null;
                return false;
            }
            return true;
        }
    }
}

