/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.portlet;

import javax.portlet.PortletURL;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.portlet.PortletMessages;
import org.apache.tapestry.util.QueryParameterMap;

public class PortletLink
implements ILink {
    private final IRequestCycle _cycle;
    private final PortletURL _portletURL;
    private final boolean _stateful;
    private final QueryParameterMap _parameters;

    public PortletLink(IRequestCycle cycle, PortletURL portletURL, QueryParameterMap parameters, boolean stateful) {
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)portletURL, (String)"portletURL");
        Defense.notNull((Object)parameters, (String)"parameters");
        this._cycle = cycle;
        this._portletURL = portletURL;
        this._parameters = parameters;
        this._stateful = stateful;
    }

    public String getURL() {
        return this.getURL(null, true);
    }

    public String getURL(String anchor, boolean includeParameters) {
        if (includeParameters) {
            this.loadParameters();
        }
        String url = this._portletURL.toString();
        url = this.unencode(url);
        if (this._stateful) {
            url = this._cycle.encodeURL(url);
        }
        if (anchor != null) {
            url = url + "#" + anchor;
        }
        return url;
    }

    private String unencode(String url) {
        int ampx;
        StringBuffer buffer = new StringBuffer(url.length());
        String text = url;
        while ((ampx = text.indexOf("&amp;")) >= 0) {
            buffer.append(text.substring(0, ampx + 1));
            text = text.substring(ampx + 5);
        }
        buffer.append(text);
        return buffer.toString();
    }

    private void loadParameters() {
        String[] names = this._parameters.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String[] values = this._parameters.getParameterValues(name);
            if (values == null) continue;
            this._portletURL.setParameter(name, values);
        }
    }

    public String getAbsoluteURL() {
        throw new UnsupportedOperationException(PortletMessages.unsupportedMethod("getAbsoluteURL"));
    }

    public String getAbsoluteURL(String scheme, String server, int port, String anchor, boolean includeParameters) {
        throw new UnsupportedOperationException(PortletMessages.unsupportedMethod("getAbsoluteURL"));
    }

    public String[] getParameterNames() {
        return this._parameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this._parameters.getParameterValues(name);
    }
}

