/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.portlet.PortletRenderer;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.util.PageRenderSupportImpl;
import org.apache.tapestry.web.WebResponse;

public class PortletRendererImpl
implements PortletRenderer {
    private WebResponse _response;
    private MarkupWriterSource _markupWriterSource;
    private IEngineService _assetService;
    private String _applicationId;

    public void renderPage(IRequestCycle cycle, String pageName) throws IOException {
        cycle.activate(pageName);
        IPage page = cycle.getPage();
        ContentType contentType = page.getResponseContentType();
        PrintWriter printWriter = this._response.getPrintWriter(contentType);
        IMarkupWriter writer = this._markupWriterSource.newMarkupWriter(printWriter, contentType);
        String namespace = this._response.getNamespace();
        PageRenderSupportImpl support = new PageRenderSupportImpl(this._assetService, namespace, null);
        TapestryUtils.storePageRenderSupport((IRequestCycle)cycle, (PageRenderSupport)support);
        NestedMarkupWriter nested = writer.getNestedWriter();
        cycle.renderPage((IMarkupWriter)nested);
        String id = "Tapestry Portlet " + this._applicationId + " " + namespace;
        writer.comment("BEGIN " + id);
        writer.comment("Page: " + page.getPageName());
        writer.comment("Generated: " + new Date());
        writer.comment("Framework version: " + Tapestry.VERSION);
        support.writeBodyScript(writer, cycle);
        nested.close();
        support.writeInitializationScript(writer);
        writer.comment("END " + id);
        writer.close();
    }

    public void setMarkupWriterSource(MarkupWriterSource markupWriterSource) {
        this._markupWriterSource = markupWriterSource;
    }

    public void setResponse(WebResponse response) {
        this._response = response;
    }

    public void setAssetService(IEngineService assetService) {
        this._assetService = assetService;
    }

    public void setApplicationId(String applicationId) {
        this._applicationId = applicationId;
    }
}

