/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.portlet;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.ActionResponse;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.describe.RenderStrategy;
import org.apache.tapestry.error.ErrorMessages;
import org.apache.tapestry.error.ExceptionPresenter;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.markup.AsciiMarkupFilter;
import org.apache.tapestry.markup.MarkupFilter;
import org.apache.tapestry.markup.MarkupWriterImpl;
import org.apache.tapestry.portlet.PortletMessages;
import org.apache.tapestry.portlet.PortletRequestGlobals;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.util.exception.ExceptionAnalyzer;
import org.apache.tapestry.util.exception.ExceptionDescription;
import org.apache.tapestry.util.exception.ExceptionProperty;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;

public class PortletExceptionPresenter
implements ExceptionPresenter {
    private PortletRequestGlobals _globals;
    private RenderStrategy _renderStrategy;
    private WebRequest _request;
    private RequestExceptionReporter _requestExceptionReporter;
    private WebResponse _response;

    public void presentException(IRequestCycle cycle, Throwable cause) {
        try {
            if (this._globals.isRenderRequest()) {
                this.reportRenderRequestException(cycle, cause);
            } else {
                this.reportActionRequestException(cycle, cause);
            }
        }
        catch (Exception ex) {
            this._requestExceptionReporter.reportRequestException(PortletMessages.errorReportingException(ex), (Throwable)ex);
            throw new ApplicationRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        this._requestExceptionReporter.reportRequestException(ErrorMessages.unableToProcessClientRequest((Throwable)cause), cause);
    }

    private void reportActionRequestException(IRequestCycle cycle, Throwable cause) {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        MarkupWriterImpl writer = new MarkupWriterImpl("text/html", pw, (MarkupFilter)new AsciiMarkupFilter());
        this.writeException((IMarkupWriter)writer, cycle, cause);
        writer.close();
        String markup = caw.toString();
        this._request.getSession(true).setAttribute("org.apache.tapestry.portlet.PortletExceptionMarkup", (Object)markup);
        ActionResponse response = this._globals.getActionResponse();
        response.setRenderParameter("service", "exception");
    }

    private void reportRenderRequestException(IRequestCycle cycle, Throwable cause) throws IOException {
        PrintWriter pw = this._response.getPrintWriter(new ContentType("text/html"));
        MarkupWriterImpl writer = new MarkupWriterImpl("text/html", pw, (MarkupFilter)new AsciiMarkupFilter());
        this.writeException((IMarkupWriter)writer, cycle, cause);
    }

    public void setGlobals(PortletRequestGlobals globals) {
        this._globals = globals;
    }

    public void setRenderStrategy(RenderStrategy renderStrategy) {
        this._renderStrategy = renderStrategy;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setRequestExceptionReporter(RequestExceptionReporter requestExceptionReporter) {
        this._requestExceptionReporter = requestExceptionReporter;
    }

    public void setResponse(WebResponse response) {
        this._response = response;
    }

    private void writeException(IMarkupWriter writer, IRequestCycle cycle, ExceptionDescription exception, boolean showStackTrace) {
        writer.begin("div");
        writer.attribute("class", "portlet-section-header");
        writer.print(exception.getExceptionClassName());
        writer.end();
        writer.println();
        writer.begin("div");
        writer.attribute("class", "portlet-msg-error");
        writer.print(exception.getMessage());
        writer.end();
        writer.println();
        ExceptionProperty[] properties = exception.getProperties();
        if (properties.length > 0) {
            writer.begin("table");
            writer.attribute("class", "portlet-section-subheader");
            for (int i = 0; i < properties.length; ++i) {
                writer.begin("tr");
                writer.attribute("class", i % 2 == 0 ? "portlet-section-body" : "portlet-section-alternate");
                writer.begin("th");
                writer.print(properties[i].getName());
                writer.end();
                writer.println();
                writer.begin("td");
                this._renderStrategy.renderObject(properties[i].getValue(), writer, cycle);
                writer.end("tr");
                writer.println();
            }
            writer.end();
            writer.println();
        }
        if (!showStackTrace) {
            return;
        }
        writer.begin("ul");
        String[] trace = exception.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            writer.begin("li");
            writer.print(trace[i]);
            writer.end();
            writer.println();
        }
        writer.end();
        writer.println();
    }

    private void writeException(IMarkupWriter writer, IRequestCycle cycle, Throwable cause) {
        ExceptionDescription[] exceptions = new ExceptionAnalyzer().analyze(cause);
        for (int i = 0; i < exceptions.length; ++i) {
            this.writeException(writer, cycle, exceptions[i], i + 1 == exceptions.length);
        }
    }
}

