/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.ClassAnnotationEnhancementWorker;
import org.apache.tapestry.annotations.Meta;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationWorker
implements ClassAnnotationEnhancementWorker {
    @Override
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Class baseClass, Location location) {
        List<Meta> metas = this.assembleMetas(baseClass);
        for (Meta meta : metas) {
            this.applyPropertiesFromMeta(meta, spec, location);
        }
    }

    private List<Meta> assembleMetas(Class baseClass) {
        Meta meta;
        Class searchClass = baseClass;
        ArrayList<Meta> result = new ArrayList<Meta>();
        Object lastMeta = null;
        while ((meta = searchClass.getAnnotation(Meta.class)) != null) {
            if (meta != lastMeta) {
                result.add(meta);
            }
            searchClass = searchClass.getSuperclass();
        }
        Collections.reverse(result);
        return result;
    }

    private void applyPropertiesFromMeta(Meta meta, IComponentSpecification spec, Location location) {
        String[] pairs;
        for (String pair : pairs = meta.value()) {
            int equalx = pair.indexOf(61);
            if (equalx < 0) {
                throw new ApplicationRuntimeException(AnnotationMessages.missingEqualsInMeta(pair), location, null);
            }
            String key = pair.substring(0, equalx);
            String value = pair.substring(equalx + 1);
            spec.setProperty(key, value);
        }
    }
}

