/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.beans.Introspector;
import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.annotations.AnnotationMessages;

public class AnnotationUtils {
    public static String getPropertyName(Method method) {
        String name = method.getName();
        if (name.startsWith("is")) {
            AnnotationUtils.checkGetter(method);
            return Introspector.decapitalize(name.substring(2));
        }
        if (name.startsWith("get")) {
            AnnotationUtils.checkGetter(method);
            return Introspector.decapitalize(name.substring(3));
        }
        if (name.startsWith("set")) {
            AnnotationUtils.checkSetter(method);
            return Introspector.decapitalize(name.substring(3));
        }
        throw new ApplicationRuntimeException(AnnotationMessages.notAccessor(method));
    }

    private static void checkGetter(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new ApplicationRuntimeException(AnnotationMessages.noParametersExpected(method));
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new ApplicationRuntimeException(AnnotationMessages.voidAccessor(method));
        }
    }

    private static void checkSetter(Method method) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new ApplicationRuntimeException(AnnotationMessages.nonVoidMutator(method));
        }
        if (method.getParameterTypes().length != 1) {
            throw new ApplicationRuntimeException(AnnotationMessages.wrongParameterCount(method));
        }
    }
}

