/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.form.IFormComponent;
import net.sf.tapestry.util.pool.IPoolable;
import net.sf.tapestry.valid.FieldTracking;
import net.sf.tapestry.valid.IFieldTracking;
import net.sf.tapestry.valid.IValidationDelegate;
import net.sf.tapestry.valid.RenderString;
import net.sf.tapestry.valid.ValidationConstraint;
import net.sf.tapestry.valid.ValidatorException;

public class ValidationDelegate
implements IValidationDelegate,
IPoolable {
    private IFormComponent _currentComponent;
    private List _trackings;
    private Map _trackingMap;

    public void clear() {
        this._currentComponent = null;
        this._trackings = null;
        this._trackingMap = null;
    }

    public void resetForPool() {
        this._currentComponent = null;
        if (this._trackings != null) {
            this._trackings.clear();
        }
        if (this._trackingMap != null) {
            this._trackingMap.clear();
        }
    }

    public void writeLabelPrefix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this.isInError(component)) {
            writer.begin("font");
            writer.attribute("color", "red");
        }
    }

    public void writeLabelSuffix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this.isInError(component)) {
            writer.end();
        }
    }

    protected IFieldTracking getComponentTracking() {
        if (this._trackingMap == null) {
            return null;
        }
        String formName = this._currentComponent.getForm().getName();
        Map formMap = (Map)this._trackingMap.get(formName);
        if (formMap == null) {
            return null;
        }
        return (IFieldTracking)formMap.get(this._currentComponent.getName());
    }

    public void setFormComponent(IFormComponent component) {
        this._currentComponent = component;
    }

    public boolean isInError() {
        return this.getComponentTracking() != null;
    }

    public String getInvalidInput() {
        return this.getComponentTracking().getInvalidInput();
    }

    public List getFieldTracking() {
        if (this._trackings == null) {
            return null;
        }
        return Collections.unmodifiableList(this._trackings);
    }

    public void reset() {
        IFieldTracking tracking = this.getComponentTracking();
        if (tracking != null) {
            this._trackings.remove(tracking);
            String formName = tracking.getFormComponent().getForm().getName();
            Map formMap = (Map)this._trackingMap.get(formName);
            if (formMap != null) {
                formMap.remove(tracking.getFieldName());
            }
        }
    }

    public void record(ValidatorException ex) {
        this.record(ex.getMessage(), ex.getConstraint(), ex.getInvalidInput());
    }

    public void record(String message, ValidationConstraint constraint, String invalidInput) {
        this.record(new RenderString(message), constraint, invalidInput);
    }

    public void record(IRender errorRenderer, ValidationConstraint constraint, String invalidInput) {
        IFieldTracking tracking = null;
        if (this._trackings == null) {
            this._trackings = new ArrayList();
        }
        if (this._trackingMap == null) {
            this._trackingMap = new HashMap();
        }
        if (this._currentComponent == null) {
            tracking = new FieldTracking();
            this._trackings.add(tracking);
        } else {
            tracking = this.getComponentTracking();
            if (tracking == null) {
                String formName = this._currentComponent.getForm().getName();
                HashMap<String, IFieldTracking> formMap = (HashMap<String, IFieldTracking>)this._trackingMap.get(formName);
                if (formMap == null) {
                    formMap = new HashMap<String, IFieldTracking>();
                    this._trackingMap.put(formName, formMap);
                }
                String fieldName = this._currentComponent.getName();
                tracking = new FieldTracking(fieldName, this._currentComponent);
                this._trackings.add(tracking);
                formMap.put(fieldName, tracking);
            }
        }
        tracking.setInvalidInput(invalidInput);
        tracking.setRenderer(errorRenderer);
        tracking.setConstraint(constraint);
    }

    public void writePrefix(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
    }

    public void writeAttributes(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
    }

    public void writeSuffix(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this.isInError()) {
            writer.printRaw("&nbsp;");
            writer.begin("font");
            writer.attribute("color", "red");
            writer.print("**");
            writer.end();
        }
    }

    public boolean getHasErrors() {
        return this._trackings != null && this._trackings.size() > 0;
    }

    public IRender getFirstError() {
        if (this._trackings == null) {
            return null;
        }
        if (this._trackings.size() == 0) {
            return null;
        }
        IFieldTracking tracking = (IFieldTracking)this._trackings.get(0);
        return tracking.getRenderer();
    }

    protected boolean isInError(IFormComponent component) {
        if (this._trackingMap == null) {
            return false;
        }
        String formName = component.getForm().getName();
        Map formMap = (Map)this._trackingMap.get(formName);
        if (formMap == null) {
            return false;
        }
        return formMap.containsKey(component.getName());
    }

    public List getAssociatedTrackings() {
        int count;
        int n = count = this._trackings == null ? 0 : this._trackings.size();
        if (count == 0) {
            return null;
        }
        ArrayList<IFieldTracking> result = new ArrayList<IFieldTracking>(count);
        int i = 0;
        while (i < count) {
            IFieldTracking tracking = (IFieldTracking)this._trackings.get(i);
            if (tracking.getFieldName() != null) {
                result.add(tracking);
            }
            ++i;
        }
        return result;
    }

    public List getUnassociatedTrackings() {
        int count;
        int n = count = this._trackings == null ? 0 : this._trackings.size();
        if (count == 0) {
            return null;
        }
        ArrayList<IFieldTracking> result = new ArrayList<IFieldTracking>(count);
        int i = 0;
        while (i < count) {
            IFieldTracking tracking = (IFieldTracking)this._trackings.get(i);
            if (tracking.getFieldName() == null) {
                result.add(tracking);
            }
            ++i;
        }
        return result;
    }
}

