/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.AbstractTextField;
import net.sf.tapestry.form.Form;
import net.sf.tapestry.form.IFormComponent;
import net.sf.tapestry.html.Body;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.IValidationDelegate;
import net.sf.tapestry.valid.IValidator;
import net.sf.tapestry.valid.ValidatorException;

public class ValidField
extends AbstractTextField
implements IField,
IFormComponent {
    private static final Map TYPES = new HashMap();
    private IBinding _valueBinding;
    private IBinding _displayNameBinding;
    private String _displayNameValue;
    private IValidator _validator;
    private String _typeName;
    private Class _valueType;
    private static final String SELECTED_ATTRIBUTE_NAME = "net.sf.tapestry.component.html.valid.SelectedFieldSet";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public IBinding getValueBinding() {
        return this._valueBinding;
    }

    public void setValueBinding(IBinding value) {
        this._valueBinding = value;
    }

    public IBinding getDisplayNameBinding() {
        return this._displayNameBinding;
    }

    public void setDisplayNameBinding(IBinding value) {
        this._displayNameBinding = value;
        if (value.isInvariant()) {
            this._displayNameValue = value.getString();
        }
    }

    public String getDisplayName() {
        if (this._displayNameValue != null) {
            return this._displayNameValue;
        }
        return this._displayNameBinding.getString();
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IValidationDelegate delegate = this.getForm().getDelegate();
        if (delegate == null) {
            throw new RequestCycleException(Tapestry.getString("ValidField.no-delegate", this.getExtendedId(), this.getForm().getExtendedId()), this);
        }
        Object displayName = null;
        boolean rendering = !cycle.isRewinding();
        delegate.setFormComponent(this);
        if (rendering) {
            delegate.writePrefix(writer, cycle);
        }
        super.renderComponent(writer, cycle);
        if (rendering) {
            delegate.writeSuffix(writer, cycle);
        }
        if (rendering && delegate.isInError()) {
            this.addSelect(cycle);
        }
    }

    protected void beforeCloseTag(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        this.getValidator().renderValidatorContribution(this, writer, cycle);
        this.getForm().getDelegate().writeAttributes(writer, cycle);
    }

    private void addSelect(IRequestCycle cycle) {
        if (cycle.getAttribute(SELECTED_ATTRIBUTE_NAME) != null) {
            return;
        }
        Body body = Body.get(cycle);
        if (body == null) {
            return;
        }
        IForm form = Form.get(cycle);
        String formName = form.getName();
        String textFieldName = this.getName();
        String fullName = "document." + formName + "." + textFieldName;
        body.addOtherInitialization(fullName + ".focus();");
        body.addOtherInitialization(fullName + ".select();");
        cycle.setAttribute(SELECTED_ATTRIBUTE_NAME, Boolean.TRUE);
    }

    protected String readValue() throws RequestCycleException {
        IValidationDelegate delegate = this.getForm().getDelegate();
        if (delegate.isInError()) {
            return delegate.getInvalidInput();
        }
        Object value = this._valueBinding.getObject();
        String result = this.getValidator().toString(this, value);
        if (Tapestry.isNull(result) && this.getValidator().isRequired()) {
            this.addSelect(this.getPage().getRequestCycle());
        }
        return result;
    }

    protected void updateValue(String value) throws RequestCycleException {
        Object objectValue = null;
        IValidationDelegate delegate = this.getForm().getDelegate();
        try {
            objectValue = this.getValidator().toObject(this, value);
        }
        catch (ValidatorException ex) {
            delegate.record(ex);
            return;
        }
        this._valueBinding.setObject(objectValue);
        delegate.reset();
    }

    public IValidator getValidator() {
        return this._validator;
    }

    public void setValidator(IValidator validator) {
        this._validator = validator;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public Class getValueType() {
        if (this._valueType == null) {
            this._valueType = this.resolveType();
        }
        return this._valueType;
    }

    private Class resolveType() {
        if (this._typeName == null) {
            throw new NullPointerException(Tapestry.getString("ValidField.no-type", this));
        }
        Map map = TYPES;
        synchronized (map) {
            Class result = (Class)TYPES.get(this._typeName);
            if (result != null) {
                Class clazz = result;
                return clazz;
            }
        }
        return this.getPage().getEngine().getResourceResolver().findClass(this._typeName);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._valueType = null;
        super.cleanupAfterRender(cycle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TYPES.put("boolean", Boolean.TYPE);
        TYPES.put("Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValidField.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("java.lang.Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValidField.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("char", Character.TYPE);
        TYPES.put("Character", class$java$lang$Character == null ? (class$java$lang$Character = ValidField.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = ValidField.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("short", Short.TYPE);
        TYPES.put("Short", class$java$lang$Short == null ? (class$java$lang$Short = ValidField.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = ValidField.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("int", Integer.TYPE);
        TYPES.put("Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = ValidField.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = ValidField.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("long", Long.TYPE);
        TYPES.put("Long", class$java$lang$Long == null ? (class$java$lang$Long = ValidField.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = ValidField.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("float", Float.TYPE);
        TYPES.put("Float", class$java$lang$Float == null ? (class$java$lang$Float = ValidField.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = ValidField.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("byte", Byte.TYPE);
        TYPES.put("Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ValidField.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ValidField.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("double", Double.TYPE);
        TYPES.put("Double", class$java$lang$Double == null ? (class$java$lang$Double = ValidField.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = ValidField.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.math.BigInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = ValidField.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        TYPES.put("java.math.BigDecimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ValidField.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }
}

