/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.util.HashMap;
import java.util.Locale;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.valid.BaseValidator;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.ValidationConstraint;
import net.sf.tapestry.valid.ValidatorException;

public class StringValidator
extends BaseValidator {
    public static final StringValidator REQUIRED = new StaticStringValidator(true);
    public static final StringValidator OPTIONAL = new StaticStringValidator(false);
    private int _minimumLength;
    private String _scriptPath = "/net/sf/tapestry/valid/StringValidator.script";

    public StringValidator() {
    }

    private StringValidator(boolean required) {
        super(required);
    }

    public String toString(IField field, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object toObject(IField field, String input) throws ValidatorException {
        if (this.checkRequired(field, input)) {
            return null;
        }
        if (this._minimumLength > 0 && input.length() < this._minimumLength) {
            String errorMessage = this.getString("field-too-short", field.getPage().getLocale(), Integer.toString(this._minimumLength), field.getDisplayName());
            throw new ValidatorException(errorMessage, ValidationConstraint.MINIMUM_WIDTH, input);
        }
        return input;
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this._minimumLength = minimumLength;
    }

    public void renderValidatorContribution(IField field, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!this.isRequired() && this._minimumLength <= 0) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        Locale locale = field.getPage().getLocale();
        String displayName = field.getDisplayName();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.getString("field-is-required", locale, displayName));
        }
        if (this._minimumLength > 0) {
            symbols.put("minimumLengthMessage", this.getString("field-too-short", locale, Integer.toString(this._minimumLength), displayName));
        }
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    private static final class StaticStringValidator
    extends StringValidator {
        private static final String UNSUPPORTED_MESSAGE = "Changes to property values are not allowed.";

        private StaticStringValidator(boolean required) {
            super(required);
        }

        public void setMinimumLength(int minimumLength) {
            throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
        }

        public void setRequired(boolean required) {
            throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
        }

        public void setClientScriptingEnabled(boolean clientScriptingEnabled) {
            throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
        }
    }
}

