/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;

public class RenderString
implements IRender {
    private String string;
    private boolean raw = false;

    public RenderString(String string) {
        this.string = string;
    }

    public RenderString(String string, boolean raw) {
        this.string = string;
        this.raw = raw;
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this.string == null) {
            return;
        }
        if (this.raw) {
            writer.printRaw(this.string);
        } else {
            writer.print(this.string);
        }
    }

    public String getString() {
        return this.string;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("RenderString@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        buffer.append(this.string);
        if (this.raw) {
            buffer.append(" (raw)");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

