/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.xml.DocumentParseException;
import net.sf.tapestry.util.xml.InvalidStringException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractDocumentParser
implements ErrorHandler,
EntityResolver {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$util$xml$AbstractDocumentParser == null ? (class$net$sf$tapestry$util$xml$AbstractDocumentParser = AbstractDocumentParser.class$("net.sf.tapestry.util.xml.AbstractDocumentParser")) : class$net$sf$tapestry$util$xml$AbstractDocumentParser));
    private DocumentBuilder _builder;
    private String _resourcePath;
    private Map _entities;
    protected PatternCompiler _patternCompiler;
    protected PatternMatcher _matcher;
    protected Map _compiledPatterns;
    public static final String SIMPLE_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    static /* synthetic */ Class class$net$sf$tapestry$util$xml$AbstractDocumentParser;

    protected void register(String publicId, String entityPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering " + publicId + " as " + entityPath));
        }
        if (this._entities == null) {
            this._entities = new HashMap();
        }
        this._entities.put(publicId, entityPath);
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    public void setResourcePath(String value) {
        this._resourcePath = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document parse(InputSource source, String resourcePath, String rootElementName) throws DocumentParseException {
        Document document;
        boolean error = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing " + source + " (" + resourcePath + ") for element " + (rootElementName != null ? rootElementName : "Unknown")));
        }
        try {
            try {
                if (this._builder == null) {
                    this._builder = this.constructBuilder();
                }
                Document document2 = this._builder.parse(source);
                error = false;
                if (rootElementName != null) {
                    this.validateRootElement(document2, rootElementName, resourcePath);
                }
                document = document2;
                Object var10_9 = null;
                if (!error) return document;
                if (this._builder == null) return document;
            }
            catch (SAXParseException ex) {
                throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.unable-to-parse", resourcePath, ex.getMessage()), resourcePath, ex);
            }
            catch (SAXException ex) {
                throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.unable-to-parse", resourcePath, ex.getMessage()), resourcePath, ex);
            }
            catch (IOException ex) {
                throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.unable-to-read", resourcePath, ex.getMessage()), resourcePath, ex);
            }
            catch (ParserConfigurationException ex) {
                throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.unable-to-construct-builder", ex.getMessage()), ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!error) throw throwable;
            if (this._builder == null) throw throwable;
            LOG.debug((Object)"Discarding builder due to parse error.");
            this._builder = null;
            throw throwable;
        }
        LOG.debug((Object)"Discarding builder due to parse error.");
        this._builder = null;
        return document;
    }

    protected void validateRootElement(Document document, String rootElementName, String resourcePath) throws DocumentParseException {
        Element root = document.getDocumentElement();
        if (!root.getTagName().equals(rootElementName)) {
            throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.incorrect-document-type", rootElementName, root.getTagName()), resourcePath, null);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String entityPath = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to resolve entity; publicId = " + publicId + " systemId = " + systemId));
        }
        if (this._entities != null) {
            entityPath = (String)this._entities.get(publicId);
        }
        if (entityPath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Entity not found, using " + systemId));
            }
            return null;
        }
        InputStream stream = this.getClass().getResourceAsStream(entityPath);
        InputSource result = new InputSource(stream);
        if (result != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved " + publicId + " as " + result + " (for " + entityPath + ")"));
        }
        return result;
    }

    protected boolean isElement(Node node, String elementName) throws DocumentParseException {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element element = (Element)node;
        return element.getTagName().equals(elementName);
    }

    protected String getValue(Node node) {
        StringBuffer buffer = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            Text text = (Text)child;
            buffer.append(text.getData());
            child = child.getNextSibling();
        }
        String result = buffer.toString().trim();
        return result;
    }

    protected String getId(Node node) throws DocumentParseException {
        String result = this.getValue(node);
        char[] array = result.toCharArray();
        boolean fail = false;
        int i = 0;
        while (i < array.length) {
            char ch = array[i];
            if (i == 0) {
                fail = !Character.isLetter(ch);
            } else {
                boolean bl = fail = !Character.isLetter(ch) && !Character.isDigit(ch) && ch != '-' && ch != '_';
            }
            if (fail) {
                throw new DocumentParseException(Tapestry.getString("AbstractDocumentParser.invalid-identifier", result, this.getNodePath(node.getParentNode())), this._resourcePath, null);
            }
            ++i;
        }
        return result;
    }

    protected String getNodePath(Node node) {
        int count = 0;
        int length = 0;
        String[] path = new String[10];
        while (node != null) {
            if (count == path.length) {
                String[] newPath = new String[count * 2];
                System.arraycopy(path, 0, newPath, 0, count);
                path = newPath;
            }
            String nodeName = node.getNodeName();
            path[count++] = nodeName;
            node = node.getParentNode();
            length += nodeName.length() + 1;
        }
        StringBuffer buffer = new StringBuffer(length);
        boolean addDot = false;
        int i = count - 1;
        while (i >= 0) {
            if (addDot) {
                buffer.append('.');
            }
            buffer.append(path[i]);
            addDot = true;
            --i;
        }
        return buffer.toString();
    }

    protected DocumentBuilder constructBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.getRequireValidatingParser());
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        DocumentBuilder result = factory.newDocumentBuilder();
        result.setErrorHandler(this);
        result.setEntityResolver(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Constructed new builder " + result));
        }
        return result;
    }

    protected boolean getRequireValidatingParser() {
        return true;
    }

    protected String getAttribute(Node node, String attributeName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node attributeNode = map.getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getNodeValue();
    }

    protected void validate(String value, String pattern, String errorKey) throws DocumentParseException {
        Pattern compiled;
        if (this._compiledPatterns == null) {
            this._compiledPatterns = new HashMap();
        }
        if ((compiled = (Pattern)this._compiledPatterns.get(pattern)) == null) {
            compiled = this.compilePattern(pattern);
            this._compiledPatterns.put(pattern, compiled);
        }
        if (this._matcher == null) {
            this._matcher = new Perl5Matcher();
        }
        if (this._matcher.matches(value, compiled)) {
            return;
        }
        throw new InvalidStringException(Tapestry.getString(errorKey, value), value, this.getResourcePath());
    }

    protected Pattern compilePattern(String pattern) {
        if (this._patternCompiler == null) {
            this._patternCompiler = new Perl5Compiler();
        }
        try {
            return this._patternCompiler.compile(pattern, 16);
        }
        catch (MalformedPatternException ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

