/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.tapestry.util.jdbc.IStatement;
import net.sf.tapestry.util.jdbc.ParameterizedStatement;
import net.sf.tapestry.util.jdbc.SimpleStatement;

public class StatementAssembly {
    private StringBuffer buffer = new StringBuffer();
    private List parameters;
    private int lineLength;
    private int maxLineLength = 80;
    private int indent = 5;

    public StatementAssembly() {
    }

    public StatementAssembly(int maxLineLength, int indent) {
        this.maxLineLength = maxLineLength;
        this.indent = indent;
    }

    public void clear() {
        this.buffer.setLength(0);
        this.lineLength = 0;
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getIndent() {
        return this.indent;
    }

    public void add(String text) {
        int textLength = text.length();
        if (this.lineLength + textLength > this.maxLineLength) {
            this.buffer.append('\n');
            int i = 0;
            while (i < this.indent) {
                this.buffer.append(' ');
                ++i;
            }
            this.lineLength = this.indent;
        }
        this.buffer.append(text);
        this.lineLength += textLength;
    }

    public void add(int value) {
        this.add(Integer.toString(value));
    }

    public void add(short value) {
        this.add(Short.toString(value));
    }

    public void add(float value) {
        this.add(Float.toString(value));
    }

    public void add(double value) {
        this.add(Double.toString(value));
    }

    public void add(long value) {
        this.add(Long.toString(value));
    }

    public void add(Object value) {
        this.add(value.toString());
    }

    public void add(boolean value) {
        this.add(value ? "1" : "0");
    }

    public void addSep(String text) {
        this.buffer.append(text);
        this.lineLength += text.length();
    }

    public void newLine() {
        if (this.buffer.length() != 0) {
            this.buffer.append('\n');
        }
        this.lineLength = 0;
    }

    public void newLine(String text) {
        if (this.buffer.length() != 0) {
            this.buffer.append('\n');
        }
        this.buffer.append(text);
        this.lineLength = text.length();
    }

    public void addList(String[] items, String seperator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(seperator);
            }
            this.add(items[i]);
            ++i;
        }
    }

    public void addList(Object[] items, String seperator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(seperator);
            }
            this.add(items[i].toString());
            ++i;
        }
    }

    public void addList(int[] items, String seperator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(seperator);
            }
            this.add(items[i]);
            ++i;
        }
    }

    public void addList(long[] items, String seperator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(seperator);
            }
            this.add(items[i]);
            ++i;
        }
    }

    public void addParameter(Object value) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(value);
        this.add("?");
    }

    public void addParameter(String text, Object value) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(value);
        this.add(text);
    }

    public IStatement createStatement(Connection connection) throws SQLException {
        String sql = this.buffer.toString();
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new SimpleStatement(sql, connection);
        }
        return new ParameterizedStatement(sql, connection, this.parameters);
    }

    public IStatement createStatement(Connection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        String sql = this.buffer.toString();
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new SimpleStatement(sql, connection, resultSetType, resultSetConcurrency);
        }
        return new ParameterizedStatement(sql, connection, this.parameters, resultSetType, resultSetConcurrency);
    }

    public String toString() {
        StringBuffer description = new StringBuffer(super.toString());
        description.append("[SQL=\n<");
        description.append((Object)this.buffer);
        description.append("\n>");
        if (this.parameters != null) {
            int count = this.parameters.size();
            int i = 0;
            while (i < count) {
                Object parameter = this.parameters.get(i);
                description.append(" ?");
                description.append(i + 1);
                description.append('=');
                if (parameter == null) {
                    description.append("null");
                } else {
                    description.append('(');
                    description.append(parameter.getClass().getName());
                    description.append(") ");
                    description.append(parameter);
                }
                ++i;
            }
        }
        description.append(']');
        return description.toString();
    }
}

