/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.exception;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.tapestry.util.exception.ExceptionDescription;
import net.sf.tapestry.util.exception.ExceptionProperty;

public class ExceptionAnalyzer {
    private List exceptionDescriptions;
    private List propertyDescriptions;
    private CharArrayWriter writer;
    private static final int LIST_SIZE = 3;
    private boolean exhaustive = false;
    private static final int SKIP_LEADING_WHITESPACE = 0;
    private static final int SKIP_T = 1;
    private static final int SKIP_OTHER_WHITESPACE = 2;
    static /* synthetic */ Class class$java$lang$Throwable;

    public boolean isExhaustive() {
        return this.exhaustive;
    }

    public void setExhaustive(boolean value) {
        this.exhaustive = value;
    }

    public ExceptionDescription[] analyze(Throwable exception) {
        if (this.writer == null) {
            this.writer = new CharArrayWriter();
        }
        if (this.propertyDescriptions == null) {
            this.propertyDescriptions = new ArrayList(3);
        }
        if (this.exceptionDescriptions == null) {
            this.exceptionDescriptions = new ArrayList(3);
        }
        while (exception != null) {
            exception = this.buildDescription(exception);
        }
        ExceptionDescription[] result = new ExceptionDescription[this.exceptionDescriptions.size()];
        result = this.exceptionDescriptions.toArray(result);
        this.exceptionDescriptions.clear();
        this.propertyDescriptions.clear();
        this.writer.reset();
        return result;
    }

    protected Throwable buildDescription(Throwable exception) {
        BeanInfo info;
        Throwable next = null;
        String[] stackTrace = null;
        this.propertyDescriptions.clear();
        String message = exception.getMessage();
        Class<?> exceptionClass = exception.getClass();
        try {
            info = Introspector.getBeanInfo(exceptionClass, class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionAnalyzer.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        }
        catch (IntrospectionException e) {
            return null;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            block12: {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                Class<?> type = descriptor.getPropertyType();
                Method method = descriptor.getReadMethod();
                if (method != null) {
                    Object value;
                    try {
                        value = method.invoke((Object)exception, null);
                    }
                    catch (Exception e) {
                        break block12;
                    }
                    if (!(value == null || message != null && message.equals(value))) {
                        if (value instanceof Throwable) {
                            if (next == null) {
                                next = (Throwable)value;
                            }
                        } else {
                            String stringValue = value.toString().trim();
                            if (stringValue.length() != 0) {
                                ExceptionProperty property = new ExceptionProperty(descriptor.getDisplayName(), value.toString());
                                this.propertyDescriptions.add(property);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (next == null || this.exhaustive) {
            stackTrace = this.getStackTrace(exception);
        }
        ExceptionProperty[] properties = new ExceptionProperty[this.propertyDescriptions.size()];
        ExceptionProperty[] propArray = this.propertyDescriptions.toArray(properties);
        ExceptionDescription description = new ExceptionDescription(exceptionClass.getName(), message, propArray, stackTrace);
        this.exceptionDescriptions.add(description);
        return next;
    }

    protected String[] getStackTrace(Throwable exception) {
        this.writer.reset();
        PrintWriter printWriter = new PrintWriter(this.writer);
        exception.printStackTrace(printWriter);
        printWriter.close();
        String fullTrace = this.writer.toString();
        this.writer.reset();
        StringReader stringReader = new StringReader(fullTrace);
        LineNumberReader lineReader = new LineNumberReader(stringReader);
        int lineNumber = 0;
        ArrayList<String> frames = new ArrayList<String>();
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (++lineNumber == 1) continue;
                frames.add(this.stripFrame(line));
            }
            lineReader.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        String[] result = new String[frames.size()];
        return frames.toArray(result);
    }

    private String stripFrame(String frame) {
        char[] array = frame.toCharArray();
        int i = 0;
        int state = 0;
        boolean more = true;
        while (more) {
            if (i == array.length) {
                return "";
            }
            char ch = array[i];
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        break;
                    }
                    if (ch == 'a') {
                        state = 1;
                        ++i;
                        break;
                    }
                    more = false;
                    break;
                }
                case 1: {
                    if (ch == 't') {
                        state = 2;
                        ++i;
                        break;
                    }
                    --i;
                    more = false;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(ch)) {
                        ++i;
                        break;
                    }
                    more = false;
                }
            }
        }
        if (i == 0) {
            return frame;
        }
        return frame.substring(i);
    }

    public void reportException(Throwable exception, PrintStream stream) {
        ExceptionDescription[] descriptions = this.analyze(exception);
        int i = 0;
        while (i < descriptions.length) {
            String message = descriptions[i].getMessage();
            if (message == null) {
                stream.println(descriptions[i].getExceptionClassName());
            } else {
                stream.println(descriptions[i].getExceptionClassName() + ": " + descriptions[i].getMessage());
            }
            ExceptionProperty[] properties = descriptions[i].getProperties();
            int j = 0;
            while (j < properties.length) {
                stream.println("   " + properties[j].getName() + ": " + properties[j].getValue());
                ++j;
            }
            if (i + 1 == descriptions.length) {
                String[] stackTrace = descriptions[i].getStackTrace();
                j = 0;
                while (j < stackTrace.length) {
                    stream.println(stackTrace[j]);
                    ++j;
                }
            } else {
                stream.println();
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

