/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.EnumToken;

public class Enum
implements Serializable {
    private static final long serialVersionUID = -2458528582889298111L;
    private transient String enumerationId;
    private static Map identity = new HashMap(23);

    public String getEnumerationId() {
        return this.enumerationId;
    }

    protected Enum(String enumerationId) {
        if (enumerationId == null) {
            throw new RuntimeException("Must provide non-null enumerationId.");
        }
        this.enumerationId = enumerationId;
        Enum.register(this);
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        buffer.append('[');
        buffer.append(this.enumerationId);
        buffer.append(']');
        return buffer.toString();
    }

    private static synchronized void register(Enum enum_) {
        EnumToken key = new EnumToken(enum_);
        if (identity.containsKey(key)) {
            throw new RuntimeException(Tapestry.getString("Enum.duplicate-registration", key));
        }
        identity.put(new EnumToken(enum_), enum_);
    }

    protected final Object readResolve() {
        Object result;
        EnumToken key = new EnumToken(this);
        Map map = identity;
        synchronized (map) {
            result = identity.get(key);
        }
        if (result == null) {
            throw new RuntimeException(Tapestry.getString("Enum.deserialize-error", key, this.getClass().getName()));
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.enumerationId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.enumerationId = in.readUTF();
    }
}

