/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.record;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.PageRecorderCommitException;
import net.sf.tapestry.record.ChangeKey;
import net.sf.tapestry.record.PageChange;
import net.sf.tapestry.record.PageRecorder;

public class SimplePageRecorder
extends PageRecorder
implements Externalizable {
    private static final long serialVersionUID = -2088018593972661079L;
    private static final int MAP_SIZE = 7;
    private Map changes;

    public void commit() throws PageRecorderCommitException {
        this.dirty = false;
        this.locked = true;
    }

    public boolean getHasChanges() {
        if (this.changes == null) {
            return false;
        }
        return this.changes.size() > 0;
    }

    public Collection getChanges() {
        if (this.changes == null) {
            return Collections.EMPTY_LIST;
        }
        int count = this.changes.size();
        ArrayList<PageChange> result = new ArrayList<PageChange>(count);
        Iterator i = this.changes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ChangeKey key = (ChangeKey)entry.getKey();
            Object value = entry.getValue();
            PageChange change = new PageChange(key.componentPath, key.propertyName, value);
            result.add(change);
        }
        return result;
    }

    protected void recordChange(String componentPath, String propertyName, Object newValue) {
        Object oldValue;
        ChangeKey key = new ChangeKey(componentPath, propertyName);
        if (this.changes == null) {
            this.changes = new HashMap(7);
        }
        if (newValue == (oldValue = this.changes.get(key))) {
            return;
        }
        try {
            if (oldValue != null && oldValue.equals(newValue)) {
                return;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.dirty = true;
        this.changes.put(key, newValue);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        if (count == 0) {
            return;
        }
        this.changes = new HashMap(7);
        int i = 0;
        while (i < count) {
            String componentPath = in.readBoolean() ? (String)in.readObject() : null;
            String propertyName = in.readUTF();
            Object rawValue = in.readObject();
            Object value = this.restoreValue(rawValue);
            this.changes.put(new ChangeKey(componentPath, propertyName), value);
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.changes == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(this.changes.size());
        Iterator i = this.changes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ChangeKey key = (ChangeKey)entry.getKey();
            out.writeBoolean(key.componentPath != null);
            if (key.componentPath != null) {
                out.writeObject(key.componentPath);
            }
            out.writeUTF(key.propertyName);
            out.writeObject(this.persistValue(entry.getValue()));
        }
    }
}

