/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.param;

import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.RequiredParameterException;
import net.sf.tapestry.form.Form;
import net.sf.tapestry.form.IFormComponent;
import net.sf.tapestry.param.IParameterConnector;
import net.sf.tapestry.spec.Direction;
import net.sf.tapestry.spec.ParameterSpecification;
import net.sf.tapestry.util.prop.OgnlUtils;
import ognl.ClassResolver;

public abstract class AbstractParameterConnector
implements IParameterConnector {
    private String _parameterName;
    private String _propertyName;
    private IBinding _binding;
    private IComponent _component;
    private boolean _required;
    private Object _clearValue;
    private Direction _direction;
    private IResourceResolver _resolver;
    private Object _expression;

    protected AbstractParameterConnector(IComponent component, String parameterName, IBinding binding) {
        this._component = component;
        this._parameterName = parameterName;
        this._binding = binding;
        this._resolver = component.getPage().getEngine().getResourceResolver();
        ParameterSpecification pspec = this._component.getSpecification().getParameter(this._parameterName);
        this._required = pspec.isRequired();
        this._propertyName = pspec.getPropertyName();
        this._direction = pspec.getDirection();
        this._clearValue = this.readCurrentPropertyValue();
    }

    private Object readCurrentPropertyValue() {
        return OgnlUtils.get(this._propertyName, (ClassResolver)this._resolver, (Object)this._component);
    }

    protected void setPropertyValue(Object value) {
        OgnlUtils.set(this._propertyName, (ClassResolver)this._resolver, (Object)this._component, value);
    }

    protected Object getBindingValue(Class requiredType) throws RequiredParameterException {
        Object result = requiredType == null ? this._binding.getObject() : this._binding.getObject(this._parameterName, requiredType);
        return result;
    }

    protected IBinding getBinding() {
        return this._binding;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        buffer.append(this._component.getExtendedId());
        buffer.append(' ');
        buffer.append(this._parameterName);
        buffer.append(' ');
        buffer.append(this._binding);
        buffer.append(' ');
        buffer.append(this._direction.getEnumerationId());
        if (this._required) {
            buffer.append(" required");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void resetParameter(IRequestCycle cycle) {
        IForm form;
        IFormComponent component;
        if (this._direction == Direction.FORM && cycle.isRewinding() && !(component = (IFormComponent)this._component).isDisabled() && (form = Form.get(cycle)) != null && form.isRewinding()) {
            Object value = this.readCurrentPropertyValue();
            this._binding.setObject(value);
        }
        this.setPropertyValue(this._clearValue);
    }

    protected boolean shouldSetPropertyValue(IRequestCycle cycle) {
        if (this._direction == Direction.IN) {
            return true;
        }
        return !cycle.isRewinding();
    }

    public abstract void setParameter(IRequestCycle var1) throws RequiredParameterException;
}

