/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.pageload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageLoader;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.ITemplateSource;
import net.sf.tapestry.PageLoaderException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.binding.ExpressionBinding;
import net.sf.tapestry.binding.StringBinding;
import net.sf.tapestry.spec.AssetSpecification;
import net.sf.tapestry.spec.AssetType;
import net.sf.tapestry.spec.BindingSpecification;
import net.sf.tapestry.spec.BindingType;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.ContainedComponent;
import net.sf.tapestry.spec.ParameterSpecification;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PageLoader
implements IPageLoader {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$pageload$PageLoader == null ? (class$net$sf$tapestry$pageload$PageLoader = PageLoader.class$("net.sf.tapestry.pageload.PageLoader")) : class$net$sf$tapestry$pageload$PageLoader));
    private IEngine _engine;
    private IResourceResolver _resolver;
    private ISpecificationSource _specificationSource;
    private IPageSource _pageSource;
    private Locale _locale;
    private int _count;
    private int _depth;
    private int _maxDepth;
    static /* synthetic */ Class class$net$sf$tapestry$pageload$PageLoader;

    public PageLoader(IPageSource pageSource) {
        this._pageSource = pageSource;
    }

    private void bind(IComponent container, IComponent component, ContainedComponent contained, Map propertyBindings) throws PageLoaderException {
        String name;
        ComponentSpecification spec = component.getSpecification();
        boolean formalOnly = !spec.getAllowInformalParameters();
        Iterator i = contained.getBindingNames().iterator();
        while (i.hasNext()) {
            String bindingValue;
            BindingSpecification bspec;
            BindingType type;
            IBinding binding;
            boolean isFormal;
            name = (String)i.next();
            boolean bl = isFormal = spec.getParameter(name) != null;
            if (formalOnly && !isFormal) {
                throw new PageLoaderException(Tapestry.getString("PageLoader.formal-parameters-only", component.getExtendedId(), name), component, null);
            }
            if (!isFormal && spec.isReservedParameterName(name) || (binding = this.convert(type = (bspec = contained.getBinding(name)).getType(), bindingValue = bspec.getValue(), container, propertyBindings)) == null) continue;
            component.setBinding(name, binding);
        }
        i = spec.getParameterNames().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            ParameterSpecification parameterSpec = spec.getParameter(name);
            if (!parameterSpec.isRequired() || component.getBinding(name) != null) continue;
            throw new PageLoaderException(Tapestry.getString("PageLoader.required-parameter-not-bound", name, component.getExtendedId()), component, null);
        }
    }

    private IBinding convert(BindingType type, String bindingValue, IComponent container, Map propertyBindings) {
        if (type == BindingType.DYNAMIC) {
            IBinding result = (IBinding)propertyBindings.get(bindingValue);
            if (result == null) {
                result = new ExpressionBinding(this._resolver, container, bindingValue);
                propertyBindings.put(bindingValue, result);
            }
            return result;
        }
        if (type == BindingType.STRING) {
            return new StringBinding(container, bindingValue);
        }
        if (type == BindingType.STATIC) {
            return this._pageSource.getStaticBinding(bindingValue);
        }
        if (type == BindingType.FIELD) {
            return this._pageSource.getFieldBinding(bindingValue);
        }
        return container.getBinding(bindingValue);
    }

    private void constructComponent(IRequestCycle cycle, IPage page, IComponent container, ComponentSpecification containerSpec, INamespace namespace) throws PageLoaderException {
        ++this._depth;
        if (this._depth > this._maxDepth) {
            this._maxDepth = this._depth;
        }
        ArrayList ids = new ArrayList(containerSpec.getComponentIds());
        int count = ids.size();
        int i = 0;
        while (i < count) {
            String id = (String)ids.get(i);
            ContainedComponent contained = containerSpec.getComponent(id);
            String type = contained.getType();
            ComponentResolver resolver = new ComponentResolver(namespace, type);
            ComponentSpecification componentSpecification = resolver.getSpecification();
            INamespace componentNamespace = resolver.getNamespace();
            IComponent component = this.instantiateComponent(page, container, id, componentSpecification, componentNamespace);
            container.addComponent(component);
            this.constructComponent(cycle, page, component, componentSpecification, componentNamespace);
            ++i;
        }
        this.addAssets(container, containerSpec);
        container.finishLoad(cycle, this, containerSpec);
        --this._depth;
    }

    private IComponent instantiateComponent(IPage page, IComponent container, String id, ComponentSpecification spec, INamespace namespace) throws PageLoaderException {
        IComponent result = null;
        String className = spec.getComponentClassName();
        Class componentClass = this._resolver.findClass(className);
        try {
            result = (IComponent)componentClass.newInstance();
            result.setNamespace(namespace);
            result.setSpecification(spec);
            result.setPage(page);
            result.setContainer(container);
            result.setId(id);
        }
        catch (ClassCastException ex) {
            throw new PageLoaderException(Tapestry.getString("PageLoader.class-not-component", className), container, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new PageLoaderException(Tapestry.getString("PageLoader.unable-to-instantiate", className), container, (Throwable)ex);
        }
        if (result instanceof IPage) {
            throw new PageLoaderException(Tapestry.getString("PageLoader.page-not-allowed", result.getExtendedId()), result);
        }
        ++this._count;
        return result;
    }

    private IPage instantiatePage(String name, INamespace namespace, ComponentSpecification spec) throws PageLoaderException {
        IPage result = null;
        String className = spec.getComponentClassName();
        Class pageClass = this._resolver.findClass(className);
        try {
            result = (IPage)pageClass.newInstance();
            result.setNamespace(namespace);
            result.setSpecification(spec);
            result.setName(name);
            result.setLocale(this._locale);
        }
        catch (ClassCastException ex) {
            throw new PageLoaderException(Tapestry.getString("PageLoader.class-not-page", className), name, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new PageLoaderException(Tapestry.getString("PageLoader.unable-to-instantiate", className), name, (Throwable)ex);
        }
        return result;
    }

    public IPage loadPage(String name, INamespace namespace, IRequestCycle cycle, ComponentSpecification specification) throws PageLoaderException {
        IPage page = null;
        this._engine = cycle.getEngine();
        this._locale = this._engine.getLocale();
        this._specificationSource = this._engine.getSpecificationSource();
        this._resolver = this._engine.getResourceResolver();
        this._count = 0;
        this._depth = 0;
        this._maxDepth = 0;
        try {
            page = this.instantiatePage(name, namespace, specification);
            page.attach(this._engine);
            this.constructComponent(cycle, page, page, specification, namespace);
            this.setBindings(page);
            Object var7_6 = null;
            this._locale = null;
            this._engine = null;
            this._specificationSource = null;
            this._resolver = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._locale = null;
            this._engine = null;
            this._specificationSource = null;
            this._resolver = null;
            throw throwable;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Loaded page " + page + " with " + this._count + " components (maximum depth " + this._maxDepth + ")"));
        }
        return page;
    }

    private void setBindings(IComponent container) throws PageLoaderException {
        Map components = container.getComponents();
        if (components.isEmpty()) {
            return;
        }
        ComponentSpecification containerSpec = container.getSpecification();
        HashMap propertyBindings = new HashMap();
        Iterator i = components.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String id = (String)e.getKey();
            IComponent component = (IComponent)e.getValue();
            ComponentSpecification spec = component.getSpecification();
            ContainedComponent contained = containerSpec.getComponent(id);
            this.bind(container, component, contained, propertyBindings);
            this.setBindings(component);
        }
    }

    private void addAssets(IComponent component, ComponentSpecification specification) {
        Iterator i = specification.getAssetNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            AssetSpecification assetSpec = specification.getAsset(name);
            IAsset asset = this.convert(assetSpec);
            component.addAsset(name, asset);
        }
    }

    private IAsset convert(AssetSpecification spec) {
        AssetType type = spec.getType();
        String path = spec.getPath();
        if (type == AssetType.EXTERNAL) {
            return this._pageSource.getExternalAsset(path);
        }
        if (type == AssetType.PRIVATE) {
            return this._pageSource.getPrivateAsset(path);
        }
        return this._pageSource.getContextAsset(path);
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ITemplateSource getTemplateSource() {
        return this._engine.getTemplateSource();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ComponentResolver {
        private INamespace _namespace;
        private ComponentSpecification _spec;

        private ComponentResolver(INamespace containerNamespace, String alias) {
            if (alias.startsWith("/")) {
                this._namespace = PageLoader.this._specificationSource.getApplicationNamespace();
                this._spec = PageLoader.this._specificationSource.getComponentSpecification(alias);
                return;
            }
            int colonx = alias.indexOf(58);
            if (colonx > 0) {
                String id = alias.substring(0, colonx);
                this._namespace = containerNamespace.getChildNamespace(id);
                String bareAlias = alias.substring(colonx + 1);
                this._spec = this._namespace.getComponentSpecification(bareAlias);
                return;
            }
            this._namespace = containerNamespace.containsAlias(alias) ? containerNamespace : PageLoader.this._specificationSource.getFrameworkNamespace();
            this._spec = this._namespace.getComponentSpecification(alias);
        }

        private INamespace getNamespace() {
            return this._namespace;
        }

        private ComponentSpecification getSpecification() {
            return this._spec;
        }
    }
}

