/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IUploadFile;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.multipart.IPart;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class UploadPart
implements IUploadFile,
IPart {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$multipart$UploadPart == null ? (class$net$sf$tapestry$multipart$UploadPart = UploadPart.class$("net.sf.tapestry.multipart.UploadPart")) : class$net$sf$tapestry$multipart$UploadPart));
    private byte[] _content;
    private File _contentFile;
    private String _filePath;
    private String _contentType;
    static /* synthetic */ Class class$net$sf$tapestry$multipart$UploadPart;

    UploadPart(String filePath, String contentType, byte[] content) {
        this._filePath = filePath;
        this._contentType = contentType;
        this._content = content;
    }

    UploadPart(String filePath, String contentType, File contentFile) {
        this._filePath = filePath;
        this._contentType = contentType;
        this._contentFile = contentFile;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public boolean isTruncated() {
        return false;
    }

    public InputStream getStream() {
        if (this._content != null) {
            return new ByteArrayInputStream(this._content);
        }
        try {
            return new FileInputStream(this._contentFile);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("UploadPart.unable-to-open-content-file", this._filePath, this._contentFile.getAbsolutePath()), ex);
        }
    }

    public void cleanup() {
        if (this._contentFile != null) {
            boolean success;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting upload file " + this._contentFile + "."));
            }
            if (!(success = this._contentFile.delete())) {
                LOG.warn((Object)Tapestry.getString("UploadPart.temporary-file-not-deleted", this._contentFile.getAbsolutePath()));
            }
            this._contentFile = null;
        }
    }

    public String getFileName() {
        File file = new File(this._filePath);
        return file.getName();
    }

    public String getContentType() {
        return this._contentType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

