/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.link;

import net.sf.tapestry.Gesture;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.link.AbstractServiceLink;

public abstract class GestureLink
extends AbstractServiceLink {
    private String _anchor;
    private String _scheme;
    private int _port;

    protected String getURL(IRequestCycle cycle) throws RequestCycleException {
        return this.buildURL(cycle, this.getServiceParameters(cycle));
    }

    protected Object[] getServiceParameters(IRequestCycle cycle) throws RequestCycleException {
        return null;
    }

    private String buildURL(IRequestCycle cycle, Object[] serviceParameters) throws RequestCycleException {
        String URL2 = null;
        String serviceName = this.getServiceName();
        IEngineService service = cycle.getEngine().getService(serviceName);
        if (service == null) {
            throw new RequestCycleException(Tapestry.getString("GestureLink.missing-service", serviceName), this);
        }
        Gesture g = service.buildGesture(cycle, this, serviceParameters);
        URL2 = this._scheme == null && this._port == 0 ? g.getURL() : g.getAbsoluteURL(this._scheme, null, this._port);
        if (this._anchor == null) {
            return URL2;
        }
        return URL2 + "#" + this._anchor;
    }

    protected abstract String getServiceName();

    public String getAnchor() {
        return this._anchor;
    }

    public void setAnchor(String anchor) {
        this._anchor = anchor;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }
}

