/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.components.Block;
import net.sf.tapestry.html.BasePage;
import net.sf.tapestry.inspector.View;

public class Inspector
extends BasePage {
    private View _view = View.SPECIFICATION;
    private String _inspectedPageName;
    private String _inspectedIdPath;
    private static final int MAP_SIZE = 7;
    private Map _blocks;

    public void detach() {
        this._view = View.SPECIFICATION;
        this._inspectedPageName = null;
        this._inspectedIdPath = null;
        super.detach();
    }

    public void finishLoad() {
        this._blocks = new HashMap(7);
        this._blocks.put(View.TEMPLATE, this.getComponent("templateBlock"));
        this._blocks.put(View.SPECIFICATION, this.getComponent("specificationBlock"));
        this._blocks.put(View.ENGINE, this.getComponent("engineBlock"));
        this._blocks.put(View.PROPERTIES, this.getComponent("propertiesBlock"));
        this._blocks.put(View.LOGGING, this.getComponent("loggingBlock"));
    }

    public View getView() {
        return this._view;
    }

    public void setView(View value) {
        this._view = value;
        this.fireObservedChange("view", value);
    }

    public String getInspectedPageName() {
        return this._inspectedPageName;
    }

    public void setInspectedPageName(String value) {
        this._inspectedPageName = value;
        this.fireObservedChange("inspectedPageName", value);
    }

    public String getInspectedIdPath() {
        return this._inspectedIdPath;
    }

    public void setInspectedIdPath(String value) {
        this._inspectedIdPath = value;
        this.fireObservedChange("inspectedIdPath", value);
    }

    public void selectComponent(String idPath) {
        this.setInspectedIdPath(idPath);
    }

    public void inspect(String pageName, IRequestCycle cycle) {
        this.setInspectedPageName(pageName);
        this.selectComponent((String)null);
        cycle.setPage(this);
    }

    public void selectComponent(IRequestCycle cycle) {
        Object[] parameters = cycle.getServiceParameters();
        String newIdPath = parameters == null ? null : (String)parameters[0];
        this.selectComponent(newIdPath);
    }

    public IPage getInspectedPage() {
        return this.getRequestCycle().getPage(this._inspectedPageName);
    }

    public IComponent getInspectedComponent() {
        return this.getInspectedPage().getNestedComponent(this._inspectedIdPath);
    }

    public String getInspectorTitle() {
        return "Tapestry Inspector: " + this.getEngine().getSpecification().getName();
    }

    public Block getBlockForView() {
        return (Block)this._blocks.get(this._view);
    }
}

