/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.RequiredParameterException;
import net.sf.tapestry.ScriptException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.html.Body;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Script
extends AbstractComponent {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$html$Script == null ? (class$net$sf$tapestry$html$Script = Script.class$("net.sf.tapestry.html.Script")) : class$net$sf$tapestry$html$Script));
    private String _scriptPath;
    private Map _baseSymbols;
    private Map _symbols;
    static /* synthetic */ Class class$net$sf$tapestry$html$Script;

    private Map getInputSymbols() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this._baseSymbols != null) {
            result.putAll(this._baseSymbols);
        }
        Iterator i = this.getBindingNames().iterator();
        while (i.hasNext()) {
            String bindingName = (String)i.next();
            if (this.getSpecification().getParameter(bindingName) != null) continue;
            IBinding binding = this.getBinding(bindingName);
            Object value = binding.getObject();
            result.put(bindingName, value);
        }
        return result;
    }

    private IScript getParsedScript(IRequestCycle cycle) throws RequiredParameterException {
        if (this._scriptPath == null) {
            throw new RequiredParameterException(this, "scriptPath", this.getBinding("scriptPath"));
        }
        IEngine engine = cycle.getEngine();
        IScriptSource source = engine.getScriptSource();
        return source.getScript(this._scriptPath);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (!cycle.isRewinding()) {
            ScriptSession session;
            Body body = Body.get(cycle);
            if (body == null) {
                throw new RequestCycleException(Tapestry.getString("Script.must-be-contained-by-body"), this);
            }
            this._symbols = this.getInputSymbols();
            try {
                session = this.getParsedScript(cycle).execute(this._symbols);
            }
            catch (ScriptException ex) {
                throw new RequestCycleException(this, (Throwable)ex);
            }
            body.process(session);
        }
        this.renderBody(writer, cycle);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public Map getBaseSymbols() {
        return this._baseSymbols;
    }

    public void setBaseSymbols(Map baseSymbols) {
        this._baseSymbols = baseSymbols;
    }

    public Map getSymbols() {
        return this._symbols;
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._symbols = null;
        super.cleanupAfterRender(cycle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

