/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IActionListener;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IDirect;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RenderOnlyPropertyException;
import net.sf.tapestry.RenderRewoundException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.StaleLinkException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.form.FormEventType;
import net.sf.tapestry.html.Body;
import net.sf.tapestry.valid.IValidationDelegate;

public class Form
extends AbstractComponent
implements IForm,
IDirect,
PageDetachListener {
    private String _method;
    private IActionListener _listener;
    private boolean _rewinding;
    private boolean _rendering;
    private String _name;
    private boolean _statefulMode = true;
    private boolean _direct = true;
    private IValidationDelegate _delegate;
    private IBinding _statefulBinding;
    private int _elementCount;
    private Map _events;
    private static final int EVENT_MAP_SIZE = 3;
    private Map _allocatorMap;

    public static IForm get(IRequestCycle cycle) {
        return (IForm)cycle.getAttribute("net.sf.tapestry.active.Form");
    }

    public boolean isRewinding() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public boolean isDirect() {
        return this._direct;
    }

    public boolean getRequiresSession() {
        if (this._statefulBinding == null) {
            return true;
        }
        return this._statefulBinding.getBoolean();
    }

    public String getElementId(IComponent component) {
        return this.getElementId(component.getId());
    }

    public String getElementId(String baseId) {
        if (this._allocatorMap == null) {
            this._allocatorMap = new HashMap();
        }
        String result = null;
        IdAllocator allocator = (IdAllocator)this._allocatorMap.get(baseId);
        if (allocator == null) {
            result = baseId;
            allocator = new IdAllocator(baseId);
        } else {
            result = allocator.nextId();
        }
        this._allocatorMap.put(result, allocator);
        ++this._elementCount;
        return result;
    }

    public String getName() {
        return this._name;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        boolean rewound;
        if (cycle.getAttribute("net.sf.tapestry.active.Form") != null) {
            throw new RequestCycleException(Tapestry.getString("Form.forms-may-not-nest"), this);
        }
        cycle.setAttribute("net.sf.tapestry.active.Form", this);
        String actionId = cycle.getNextActionId();
        this._name = "Form" + actionId;
        boolean renderForm = !cycle.isRewinding();
        this._rewinding = rewound = cycle.isRewound(this);
        Gesture g = this.getGesture(cycle, actionId);
        if (renderForm) {
            writer.begin("form");
            writer.attribute("method", this._method == null ? "post" : this._method);
            writer.attribute("name", this._name);
            writer.attribute("action", g.getBareURL());
            this.generateAttributes(writer, cycle);
            writer.println();
        }
        this.writeGestureParameters(writer, g, !renderForm);
        this._elementCount = 0;
        this._rendering = true;
        this.renderBody(writer, cycle);
        if (renderForm) {
            writer.beginEmpty("input");
            writer.attribute("type", "hidden");
            writer.attribute("name", this._name);
            writer.attribute("value", this._elementCount);
            writer.println();
            writer.end("form");
            this.emitEventHandlers(writer, cycle);
        }
        if (rewound) {
            String actual = cycle.getRequestContext().getParameter(this._name);
            if (actual == null || Integer.parseInt(actual) != this._elementCount) {
                throw new StaleLinkException(Tapestry.getString("Form.bad-element-count", this.getExtendedId()), this.getPage());
            }
            if (this._listener != null) {
                this._listener.actionTriggered(this, cycle);
            }
            throw new RenderRewoundException(this);
        }
        cycle.removeAttribute("net.sf.tapestry.active.Form");
    }

    public void addEventHandler(FormEventType type, String functionName) {
        Object value;
        if (this._events == null) {
            this._events = new HashMap(3);
        }
        if ((value = this._events.get(type)) == null) {
            this._events.put(type, functionName);
            return;
        }
        if (value instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(functionName);
            this._events.put(type, list);
            return;
        }
        List list = (List)value;
        list.add(functionName);
    }

    private void emitEventHandlers(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        StringBuffer buffer = null;
        if (this._events == null || this._events.isEmpty()) {
            return;
        }
        Body body = Body.get(cycle);
        if (body == null) {
            throw new RequestCycleException(Tapestry.getString("Form.needs-body-for-event-handlers"), this);
        }
        Iterator i = this._events.entrySet().iterator();
        while (i.hasNext()) {
            String finalFunctionName;
            Map.Entry entry = i.next();
            FormEventType type = (FormEventType)entry.getKey();
            Object value = entry.getValue();
            String formPath = "document." + this._name;
            String propertyName = type.getPropertyName();
            boolean combineWithAnd = type.getCombineUsingAnd();
            if (value instanceof String) {
                finalFunctionName = (String)value;
            } else {
                String compositeName = propertyName + "_" + this._name;
                if (buffer == null) {
                    buffer = new StringBuffer(200);
                }
                buffer.append("\nfunction ");
                buffer.append(compositeName);
                buffer.append("()\n{");
                List l = (List)value;
                int count = l.size();
                int j = 0;
                while (j < count) {
                    String functionName = (String)l.get(j);
                    if (j > 0) {
                        if (combineWithAnd) {
                            buffer.append(" &&");
                        } else {
                            buffer.append(";");
                        }
                    }
                    buffer.append("\n  ");
                    if (combineWithAnd) {
                        if (j == 0) {
                            buffer.append("return ");
                        } else {
                            buffer.append("  ");
                        }
                    }
                    buffer.append(functionName);
                    buffer.append("()");
                    ++j;
                }
                buffer.append(";\n}\n\n");
                finalFunctionName = compositeName;
            }
            body.addOtherInitialization(formPath + "." + propertyName + " = " + finalFunctionName + ";");
        }
        if (buffer != null) {
            body.addOtherScript(buffer.toString());
        }
    }

    public void rewind(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        this.render(writer, cycle);
    }

    public void trigger(IRequestCycle cycle) throws RequestCycleException {
        Object[] parameters = cycle.getServiceParameters();
        cycle.rewindForm(this, (String)parameters[0]);
    }

    private Gesture getGesture(IRequestCycle cycle, String actionId) {
        String serviceName = null;
        serviceName = this.isDirect() ? "direct" : "action";
        IEngine engine = cycle.getEngine();
        IEngineService service = engine.getService(serviceName);
        return service.buildGesture(cycle, this, new String[]{actionId});
    }

    private void writeGestureParameters(IMarkupWriter writer, Gesture g, boolean reserveOnly) {
        Object[] names = g.getParameterNames();
        int count = Tapestry.size(names);
        int i = 0;
        while (i < count) {
            Object name = names[i];
            this.getElementId((String)name);
            if (!reserveOnly) {
                this.writeHiddenFieldsForParameter(writer, g, (String)name);
            }
            ++i;
        }
    }

    private void writeHiddenFieldsForParameter(IMarkupWriter writer, Gesture g, String parameterName) {
        String[] values = g.getParameterValues(parameterName);
        int i = 0;
        while (i < values.length) {
            writer.beginEmpty("input");
            writer.attribute("type", "hidden");
            writer.attribute("name", parameterName);
            writer.attribute("value", values[i]);
            writer.println();
            ++i;
        }
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._elementCount = 0;
        this._events = null;
        this._allocatorMap = null;
        super.cleanupAfterRender(cycle);
    }

    public void pageDetached(PageEvent event) {
        this._delegate = null;
    }

    protected void finishLoad() {
        this.getPage().addPageDetachListener(this);
    }

    public IValidationDelegate getDelegate() {
        return this._delegate;
    }

    public void setDelegate(IValidationDelegate delegate) {
        this._delegate = delegate;
    }

    public void setDirect(boolean direct) {
        this._direct = direct;
    }

    public IActionListener getListener() {
        return this._listener;
    }

    public void setListener(IActionListener listener) {
        this._listener = listener;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public boolean isStateful() {
        if (this._statefulBinding == null) {
            return true;
        }
        return this._statefulBinding.getBoolean();
    }

    public IBinding getStatefulBinding() {
        return this._statefulBinding;
    }

    public void setStatefulBinding(IBinding statefulBinding) {
        this._statefulBinding = statefulBinding;
    }

    public boolean getStatefulMode() {
        return this._statefulMode;
    }

    public void setStatefulMode(boolean statefulMode) {
        this._statefulMode = statefulMode;
    }

    private static class IdAllocator {
        String baseId;
        int index;

        IdAllocator(String baseId) {
            this.baseId = baseId;
        }

        public String nextId() {
            return this.baseId + this.index++;
        }
    }
}

