/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.net.URL;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;

public class ResourceResolver
implements IResourceResolver {
    private Class resourceClass;
    private ClassLoader classLoader;

    public ResourceResolver(Object hook) {
        this.resourceClass = hook.getClass();
        this.classLoader = this.resourceClass.getClassLoader();
    }

    public URL getResource(String name) {
        URL result = this.resourceClass.getResource(name);
        if (result == null) {
            result = this.getClass().getResource(name);
        }
        return result;
    }

    public Class findClass(String name) {
        try {
            return Class.forName(name, true, this.classLoader);
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.getString("ResourceResolver.unable-to-load-class", name, this.classLoader, t.getMessage()), t);
        }
    }

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        return this.findClass(className);
    }
}

