/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRenderDescription;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.ITemplateSource;
import net.sf.tapestry.NoSuchComponentException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.parse.ComponentTemplate;
import net.sf.tapestry.parse.ITemplateParserDelegate;
import net.sf.tapestry.parse.TemplateParseException;
import net.sf.tapestry.parse.TemplateParser;
import net.sf.tapestry.parse.TemplateToken;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.util.MultiKey;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultTemplateSource
implements ITemplateSource,
IRenderDescription {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$engine$DefaultTemplateSource == null ? (class$net$sf$tapestry$engine$DefaultTemplateSource = DefaultTemplateSource.class$("net.sf.tapestry.engine.DefaultTemplateSource")) : class$net$sf$tapestry$engine$DefaultTemplateSource));
    private Map _cache = new HashMap();
    private Map _templates = new HashMap();
    private int _tokenCount;
    private static final int BUFFER_SIZE = 2000;
    private IResourceResolver _resolver;
    private TemplateParser _parser;
    static /* synthetic */ Class class$net$sf$tapestry$engine$DefaultTemplateSource;

    public DefaultTemplateSource(IResourceResolver resolver) {
        this._resolver = resolver;
    }

    public void reset() {
        this._cache = null;
        this._templates.clear();
        this._tokenCount = 0;
    }

    public ComponentTemplate getTemplate(IRequestCycle cycle, IComponent component) {
        Locale locale;
        ComponentSpecification specification = component.getSpecification();
        String specificationResourcePath = specification.getSpecificationResourcePath();
        MultiKey key = new MultiKey(new Object[]{specificationResourcePath, locale = component.getPage().getLocale()}, false);
        ComponentTemplate result = this.searchCache(key);
        if (result != null) {
            return result;
        }
        result = this.findTemplate(cycle, specificationResourcePath, component, locale);
        if (result == null) {
            String stringKey = locale == null ? "DefaultTemplateSource.no-template" : "DefaultTemplateSource.no-template-in-locale";
            throw new ApplicationRuntimeException(Tapestry.getString(stringKey, component.getExtendedId(), locale));
        }
        this.saveToCache(key, result);
        return result;
    }

    private synchronized ComponentTemplate searchCache(Object key) {
        if (this._cache == null) {
            return null;
        }
        return (ComponentTemplate)this._cache.get(key);
    }

    private synchronized void saveToCache(Object key, ComponentTemplate template) {
        if (this._cache == null) {
            this._cache = new HashMap();
        }
        this._cache.put(key, template);
    }

    private synchronized ComponentTemplate findTemplate(IRequestCycle cycle, String specificationResourcePath, IComponent component, Locale locale) {
        IAsset templateAsset = component.getAsset("$template");
        if (templateAsset != null) {
            return this.readTemplateFromAsset(cycle, component, templateAsset, locale);
        }
        return this.findStandardTemplate(specificationResourcePath, component, locale);
    }

    private synchronized ComponentTemplate readTemplateFromAsset(IRequestCycle cycle, IComponent component, IAsset asset, Locale locale) {
        InputStream stream = asset.getResourceAsStream(cycle, locale);
        char[] templateData = null;
        try {
            templateData = this.readTemplateStream(stream);
            stream.close();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("DefaultTemplateSource.unable-to-read-template", asset), ex);
        }
        return this.constructTokens(templateData, asset.toString(), component);
    }

    private synchronized ComponentTemplate findStandardTemplate(String specificationResourcePath, IComponent component, Locale locale) {
        String candidatePath = null;
        String language = null;
        String country = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for localized version of template for " + specificationResourcePath + " in locale " + locale.getDisplayName()));
        }
        int dotx = specificationResourcePath.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer(dotx + 20);
        buffer.append(specificationResourcePath.substring(0, dotx));
        int rawLength = buffer.length();
        int start = 2;
        if (locale != null) {
            country = locale.getCountry();
            if (country.length() > 0) {
                --start;
            }
            if ((language = locale.getLanguage()).length() > 0) {
                --start;
            }
        }
        ComponentTemplate result = null;
        int i = start;
        while (i < 3) {
            buffer.setLength(rawLength);
            if (i < 2) {
                buffer.append('_');
                buffer.append(language);
            }
            if (i == 0) {
                buffer.append('_');
                buffer.append(country);
            }
            buffer.append(".html");
            candidatePath = buffer.toString();
            result = (ComponentTemplate)this._templates.get(candidatePath);
            if (result != null) break;
            result = this.parseTemplate(candidatePath, component);
            if (result != null) {
                this._templates.put(candidatePath, result);
                break;
            }
            ++i;
        }
        return result;
    }

    private ComponentTemplate parseTemplate(String resourceName, IComponent component) {
        char[] templateData = this.readTemplate(resourceName);
        if (templateData == null) {
            return null;
        }
        return this.constructTokens(templateData, resourceName, component);
    }

    private ComponentTemplate constructTokens(char[] templateData, String resourceName, IComponent component) {
        TemplateToken[] tokens;
        if (this._parser == null) {
            this._parser = new TemplateParser();
        }
        ParserDelegate delegate = new ParserDelegate(component);
        try {
            tokens = this._parser.parse(templateData, delegate, resourceName);
        }
        catch (TemplateParseException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("DefaultTemplateSource.unable-to-parse-template", resourceName), ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsed " + tokens.length + " tokens from template"));
        }
        this._tokenCount += tokens.length;
        return new ComponentTemplate(templateData, tokens);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char[] readTemplate(String resourceName) {
        InputStream stream = null;
        URL url = this._resolver.getResource(resourceName);
        if (url == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading template " + resourceName + " from " + url));
        }
        try {
            try {
                stream = url.openStream();
                char[] cArray = this.readTemplateStream(stream);
                Object var6_6 = null;
                try {
                    if (stream == null) return cArray;
                    stream.close();
                    return cArray;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return cArray;
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("DefaultTemplateSource.unable-to-read-template", resourceName), ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
    }

    private char[] readTemplateStream(InputStream stream) throws IOException {
        char[] charBuffer = new char[2000];
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            int charsRead;
            while ((charsRead = reader.read(charBuffer, 0, 2000)) > 0) {
                buffer.append(charBuffer, 0, charsRead);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        int length = buffer.length();
        charBuffer = new char[length];
        buffer.getChars(0, length, charBuffer, 0);
        return charBuffer;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer("DefaultTemplateSource@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._cache != null) {
            buffer.append(this._cache.keySet());
        }
        if (this._tokenCount > 0) {
            buffer.append(", ");
            buffer.append(this._tokenCount);
            buffer.append(" tokens");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void renderDescription(IMarkupWriter writer) {
        writer.print("DefaultTemplateSource[");
        if (this._tokenCount > 0) {
            writer.print(this._tokenCount);
            writer.print(" tokens");
        }
        if (this._cache != null) {
            boolean first = true;
            Iterator i = this._cache.entrySet().iterator();
            while (i.hasNext()) {
                if (first) {
                    writer.begin("ul");
                    first = false;
                }
                Map.Entry e = i.next();
                Object key = e.getKey();
                ComponentTemplate template = (ComponentTemplate)e.getValue();
                writer.begin("li");
                writer.print(key.toString());
                writer.print(" (");
                writer.print(template.getTokenCount());
                writer.print(" tokens)");
                writer.println();
                writer.end();
            }
            if (!first) {
                writer.end();
                writer.beginEmpty("br");
            }
        }
        writer.print("]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParserDelegate
    implements ITemplateParserDelegate {
        IComponent _component;

        ParserDelegate(IComponent component) {
            this._component = component;
        }

        public boolean getKnownComponent(String componentId) {
            try {
                this._component.getComponent(componentId);
                return true;
            }
            catch (NoSuchComponentException ex) {
                return false;
            }
        }

        public boolean getAllowBody(String componentId) {
            return this._component.getComponent(componentId).getSpecification().getAllowBody();
        }
    }
}

