/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IComponentStrings;
import net.sf.tapestry.IComponentStringsSource;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.ComponentStrings;
import net.sf.tapestry.util.MultiKey;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultStringsSource
implements IComponentStringsSource {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$engine$DefaultStringsSource == null ? (class$net$sf$tapestry$engine$DefaultStringsSource = DefaultStringsSource.class$("net.sf.tapestry.engine.DefaultStringsSource")) : class$net$sf$tapestry$engine$DefaultStringsSource));
    private IResourceResolver resolver;
    private Properties emptyProperties = new Properties();
    private Map cache = new HashMap();
    private static final String SUFFIX = ".properties";
    static /* synthetic */ Class class$net$sf$tapestry$engine$DefaultStringsSource;

    public DefaultStringsSource(IResourceResolver resolver) {
        this.resolver = resolver;
    }

    protected synchronized Properties getLocalizedProperties(IComponent component) {
        Locale locale;
        if (component == null) {
            throw new IllegalArgumentException(Tapestry.getString("invalid-null-parameter", "component"));
        }
        String specificationPath = component.getSpecification().getSpecificationResourcePath();
        MultiKey key = this.buildKey(specificationPath, locale = component.getPage().getLocale());
        Properties result = (Properties)this.cache.get(key);
        if (result != null) {
            return result;
        }
        result = this.assembleProperties(specificationPath, locale);
        this.cache.put(key, result);
        return result;
    }

    private Properties assembleProperties(String path, Locale locale) {
        MultiKey key;
        Locale l;
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Assembling properties for " + path + " " + locale));
        }
        int dotx = path.indexOf(46);
        String basePath = path.substring(0, dotx);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Properties parent = (Properties)this.cache.get(path);
        if (parent == null) {
            parent = this.readProperties(basePath, null, null);
            if (parent == null) {
                parent = this.emptyProperties;
            }
            this.cache.put(path, parent);
        }
        Properties result = parent;
        if (!Tapestry.isNull(language)) {
            l = new Locale(language, "");
            key = this.buildKey(path, l);
            result = (Properties)this.cache.get(key);
            if (result == null) {
                result = this.readProperties(basePath, l, parent);
            }
            this.cache.put(key, result);
            parent = result;
        } else {
            language = "";
        }
        if (!Tapestry.isNull(country)) {
            l = new Locale(language, country);
            key = this.buildKey(path, l);
            result = (Properties)this.cache.get(key);
            if (result == null) {
                result = this.readProperties(basePath, l, parent);
            }
            this.cache.put(key, result);
            parent = result;
        } else {
            country = "";
        }
        if (!Tapestry.isNull(variant)) {
            l = new Locale(language, country, variant);
            key = this.buildKey(path, l);
            result = (Properties)this.cache.get(key);
            if (result == null) {
                result = this.readProperties(basePath, l, parent);
            }
            this.cache.put(key, result);
        }
        return result;
    }

    private MultiKey buildKey(String path, Locale locale) {
        return new MultiKey(new Object[]{path, locale.toString()}, false);
    }

    private Properties readProperties(String basePath, Locale locale, Properties parent) {
        StringBuffer buffer = new StringBuffer(basePath);
        if (locale != null) {
            buffer.append('_');
            buffer.append(locale.toString());
        }
        buffer.append(SUFFIX);
        String path = buffer.toString();
        URL propertiesURL = this.resolver.getResource(path);
        if (propertiesURL == null) {
            return parent;
        }
        Properties result = null;
        result = parent == null ? new Properties() : new Properties(parent);
        try {
            InputStream input = propertiesURL.openStream();
            result.load(input);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("ComponentPropertiesStore.unable-to-read-input", propertiesURL), ex);
        }
        return result;
    }

    public void reset() {
        this.cache.clear();
    }

    public IComponentStrings getStrings(IComponent component) {
        return new ComponentStrings(this.getLocalizedProperties(component));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

