/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.callback;

import net.sf.tapestry.IComponent;
import net.sf.tapestry.IDirect;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.callback.ICallback;

public class DirectCallback
implements ICallback {
    private static final long serialVersionUID = -8888847655917503471L;
    private String _pageName;
    private String _componentIdPath;
    private Object[] _parameters;

    public String toString() {
        StringBuffer buffer = new StringBuffer("DirectCallback[");
        buffer.append(this._pageName);
        buffer.append('/');
        buffer.append(this._componentIdPath);
        if (this._parameters != null) {
            int sep = 32;
            int i = 0;
            while (i < this._parameters.length) {
                buffer.append((char)sep);
                buffer.append(this._parameters[i]);
                sep = 47;
                ++i;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public DirectCallback(IDirect component, Object[] parameters) {
        this._pageName = component.getPage().getName();
        this._componentIdPath = component.getIdPath();
        this._parameters = parameters;
    }

    public void performCallback(IRequestCycle cycle) throws RequestCycleException {
        IPage page = cycle.getPage(this._pageName);
        IComponent component = page.getNestedComponent(this._componentIdPath);
        IDirect direct = null;
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new RequestCycleException(Tapestry.getString("DirectCallback.wrong-type", component.getExtendedId()), component, ex);
        }
        cycle.setServiceParameters(this._parameters);
        direct.trigger(cycle);
    }
}

