/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngineServiceView;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ResponseOutputStream;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.AbstractService;

public class AssetService
extends AbstractService {
    private String _servletPath;
    private static final Map _mimeTypes = new HashMap(17);
    private static final int BUFFER_SIZE = 10240;

    public Gesture buildGesture(IRequestCycle cycle, IComponent component, Object[] parameters) {
        if (Tapestry.size(parameters) != 1) {
            throw new ApplicationRuntimeException(Tapestry.getString("service-single-parameter", "asset"));
        }
        return this.assembleGesture(cycle, "asset", null, parameters, false);
    }

    public String getName() {
        return "asset";
    }

    private static String getMimeType(String path) {
        int dotx = path.lastIndexOf(46);
        String key = path.substring(dotx + 1).toLowerCase();
        String result = (String)_mimeTypes.get(key);
        if (result == null) {
            result = "text/plain";
        }
        return result;
    }

    public boolean service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws ServletException, IOException, RequestCycleException {
        Object[] parameters = this.getParameters(cycle);
        String resourcePath = (String)parameters[0];
        URL resourceURL = cycle.getEngine().getResourceResolver().getResource(resourcePath);
        if (resourceURL == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("missing-resource", resourcePath));
        }
        URLConnection resourceConnection = resourceURL.openConnection();
        ServletContext servletContext = cycle.getRequestContext().getServlet().getServletContext();
        this.writeAssetContent(engine, cycle, output, resourcePath, resourceConnection, servletContext);
        return false;
    }

    private void writeAssetContent(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output, String resourcePath, URLConnection resourceConnection, ServletContext servletContext) {
        String contentType = servletContext.getMimeType(resourcePath);
        int contentLength = resourceConnection.getContentLength();
        try {
            int bytesRead;
            if (contentLength > 0) {
                cycle.getRequestContext().getResponse().setContentLength(contentLength);
            }
            if (contentType == null || contentType.length() == 0) {
                contentType = AssetService.getMimeType(resourcePath);
            }
            output.setContentType(contentType);
            output.forceFlush();
            InputStream input = resourceConnection.getInputStream();
            byte[] buffer = new byte[10240];
            while ((bytesRead = input.read(buffer)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
            input.close();
        }
        catch (Throwable ex) {
            String title = Tapestry.getString("AssetService.exception-report-title", resourcePath);
            engine.reportException(title, ex);
        }
    }

    static {
        _mimeTypes.put("css", "text/css");
        _mimeTypes.put("gif", "image/gif");
        _mimeTypes.put("jpg", "image/jpeg");
        _mimeTypes.put("jpeg", "image/jpeg");
        _mimeTypes.put("htm", "text/html");
        _mimeTypes.put("html", "text/html");
    }
}

