/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.asset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.ApplicationServlet;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.StringSplitter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AssetExternalizer {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$asset$AssetExternalizer == null ? (class$net$sf$tapestry$asset$AssetExternalizer = AssetExternalizer.class$("net.sf.tapestry.asset.AssetExternalizer")) : class$net$sf$tapestry$asset$AssetExternalizer));
    private IResourceResolver _resolver;
    private File _assetDir;
    private String _URL;
    private Map _resources = new HashMap();
    private static final int BUFFER_SIZE = 2048;
    static /* synthetic */ Class class$net$sf$tapestry$asset$AssetExternalizer;

    protected AssetExternalizer(IRequestCycle cycle) {
        this._resolver = cycle.getEngine().getResourceResolver();
        String directory = System.getProperty("net.sf.tapestry.asset.dir");
        if (directory == null) {
            return;
        }
        this._URL = System.getProperty("net.sf.tapestry.asset.URL");
        if (this._URL == null) {
            return;
        }
        this._assetDir = new File(directory);
        LOG.debug((Object)("Initialized with directory " + this._assetDir + " mapped to " + this._URL));
    }

    protected void externalize(String resourcePath) throws IOException {
        int bytesRead;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Externalizing " + resourcePath));
        }
        File file = this._assetDir;
        StringSplitter splitter = new StringSplitter('/');
        String[] path = splitter.splitToArray(resourcePath);
        int i = 0;
        while (i < path.length - 1) {
            file = new File(file, path[i]);
            ++i;
        }
        file.mkdirs();
        file = new File(file, path[path.length - 1]);
        if (file.exists()) {
            return;
        }
        URL inputURL = this._resolver.getResource(resourcePath);
        if (inputURL == null) {
            throw new IOException(Tapestry.getString("missing-resource", resourcePath));
        }
        InputStream in = inputURL.openStream();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[2048];
        while ((bytesRead = in.read(buffer, 0, 2048)) >= 0) {
            ((OutputStream)out).write(buffer, 0, bytesRead);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static AssetExternalizer get(IRequestCycle cycle) {
        ApplicationServlet servlet = cycle.getRequestContext().getServlet();
        ServletContext context = servlet.getServletContext();
        String servletName = servlet.getServletName();
        String attributeName = "net.sf.tapestry.AssetExternalizer." + servletName;
        AssetExternalizer result = (AssetExternalizer)context.getAttribute(attributeName);
        if (result == null) {
            result = new AssetExternalizer(cycle);
            context.setAttribute(attributeName, (Object)result);
        }
        return result;
    }

    public String getURL(String resourcePath) {
        if (this._assetDir == null) {
            return null;
        }
        Map map = this._resources;
        synchronized (map) {
            String result = (String)this._resources.get(resourcePath);
            if (result != null) {
                String string = result;
                return string;
            }
            try {
                this.externalize(resourcePath);
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("AssetExternalizer.externalize-failure", resourcePath, this._assetDir), ex);
            }
            result = this._URL + resourcePath;
            this._resources.put(resourcePath, result);
            String string = result;
            return string;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

