/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.tapestry.ApplicationServlet;
import net.sf.tapestry.DecodedRequest;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRenderDescription;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IRequestDecoder;
import net.sf.tapestry.IUploadFile;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.multipart.MultipartDecoder;
import net.sf.tapestry.spec.IApplicationSpecification;
import net.sf.tapestry.util.StringSplitter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RequestContext
implements IRender {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$RequestContext == null ? (class$net$sf$tapestry$RequestContext = RequestContext.class$("net.sf.tapestry.RequestContext")) : class$net$sf$tapestry$RequestContext));
    public static final String REQUEST_DECODER_EXTENSION_NAME = "net.sf.tapestry.request-decoder";
    private HttpSession _session;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ApplicationServlet _servlet;
    private MultipartDecoder _decoder;
    private DecodedRequest _decodedRequest;
    private Map _cookieMap;
    private String[] _pathInfo;
    private boolean _evenRow;
    private static BitSet _safe = new BitSet(256);
    private static final char[] HEX;
    static /* synthetic */ Class class$net$sf$tapestry$RequestContext;

    public RequestContext(ApplicationServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._servlet = servlet;
        this._request = request;
        this._response = response;
        if (this._request != null && MultipartDecoder.isMultipartRequest(request)) {
            this._decoder = new MultipartDecoder(request);
        }
    }

    public void addCookie(String name, String value) {
        this.addCookie(new Cookie(name, value));
    }

    public void addCookie(Cookie cookie) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding cookie " + cookie));
        }
        this._response.addCookie(cookie);
        if (this._cookieMap == null) {
            this.readCookieMap();
        }
        this._cookieMap.put(cookie.getName(), cookie);
    }

    private void buildPathInfo() {
        String raw = this._request.getPathInfo();
        if (raw == null) {
            this._pathInfo = new String[0];
            return;
        }
        StringSplitter splitter = new StringSplitter('/');
        this._pathInfo = splitter.splitToArray(raw);
    }

    private void datePair(IMarkupWriter writer, String name, long value) {
        this.pair(writer, name, new Date(value));
    }

    public static String encodeColor(Color color) {
        char[] buffer = new char[7];
        buffer[0] = 35;
        int component = color.getRed();
        buffer[1] = HEX[component >> 4];
        buffer[2] = HEX[component & 0xF];
        component = color.getGreen();
        buffer[3] = HEX[component >> 4];
        buffer[4] = HEX[component & 0xF];
        component = color.getBlue();
        buffer[5] = HEX[component >> 4];
        buffer[6] = HEX[component & 0xF];
        return new String(buffer);
    }

    private DecodedRequest getDecodedRequest() {
        if (this._decodedRequest != null) {
            return this._decodedRequest;
        }
        IApplicationSpecification spec = this._servlet.getApplicationSpecification();
        IRequestDecoder decoder = null;
        decoder = !spec.checkExtension(REQUEST_DECODER_EXTENSION_NAME) ? new DefaultRequestDecoder() : (IRequestDecoder)spec.getExtension(REQUEST_DECODER_EXTENSION_NAME);
        this._decodedRequest = decoder.decodeRequest(this._request);
        return this._decodedRequest;
    }

    public String getScheme() {
        return this.getDecodedRequest().getScheme();
    }

    public String getServerName() {
        return this.getDecodedRequest().getServerName();
    }

    public int getServerPort() {
        return this.getDecodedRequest().getServerPort();
    }

    public String getRequestURI() {
        return this.getDecodedRequest().getRequestURI();
    }

    public void forward(String path) throws ServletException, IOException {
        RequestDispatcher dispatcher = this._servlet.getServletContext().getRequestDispatcher(path);
        dispatcher.forward((ServletRequest)this._request, (ServletResponse)this._response);
    }

    public String getAbsoluteURL(String URI2) {
        String scheme = this.getScheme();
        String server = this.getServerName();
        int port = this.getServerPort();
        if (scheme.equals("http") && port == 80) {
            port = 0;
        }
        return this.getAbsoluteURL(URI2, scheme, server, port);
    }

    public String getAbsoluteURL(String URI2, String scheme, String server, int port) {
        StringBuffer buffer = new StringBuffer();
        if (URI2.indexOf(58) >= 0) {
            return URI2;
        }
        if (URI2.substring(0, 1).equals("//")) {
            buffer.append(scheme);
            buffer.append(':');
            buffer.append(URI2);
            return buffer.toString();
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(server);
        if (port > 0) {
            buffer.append(':');
            buffer.append(port);
        }
        if (URI2.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(URI2);
        return buffer.toString();
    }

    public Cookie getCookie(String name) {
        if (this._cookieMap == null) {
            this.readCookieMap();
        }
        return (Cookie)this._cookieMap.get(name);
    }

    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getParameter(String name) {
        if (this._decoder != null) {
            return this._decoder.getString(name);
        }
        return this._request.getParameter(name);
    }

    public String[] getParameters(String name) {
        if (this._decoder != null) {
            return this._decoder.getStrings(name);
        }
        return this._request.getParameterValues(name);
    }

    public IUploadFile getUploadFile(String name) {
        if (this._decoder == null) {
            return null;
        }
        return this._decoder.getUploadFile(name);
    }

    public void cleanup() {
        if (this._decoder != null) {
            this._decoder.cleanup();
        }
    }

    public String getPathInfo(int index) {
        if (this._pathInfo == null) {
            this.buildPathInfo();
        }
        try {
            return this._pathInfo[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public int getPathInfoCount() {
        if (this._pathInfo == null) {
            this.buildPathInfo();
        }
        return this._pathInfo.length;
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    private String getRowClass() {
        String result = this._evenRow ? "even" : "odd";
        this._evenRow = !this._evenRow;
        return result;
    }

    public ApplicationServlet getServlet() {
        return this._servlet;
    }

    public HttpSession getSession() {
        if (this._session == null) {
            this._session = this._request.getSession(false);
        }
        return this._session;
    }

    public HttpSession createSession() {
        if (this._session == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Creating HttpSession");
            }
            this._session = this._request.getSession(true);
        }
        return this._session;
    }

    private void header(IMarkupWriter writer, String valueName, String dataName) {
        writer.begin("tr");
        writer.attribute("class", "request-context-header");
        writer.begin("th");
        writer.print(valueName);
        writer.end();
        writer.begin("th");
        writer.print(dataName);
        writer.end("tr");
        this._evenRow = true;
    }

    private void object(IMarkupWriter writer, String objectName) {
        writer.begin("span");
        writer.attribute("class", "request-context-object");
        writer.print(objectName);
        writer.end();
    }

    private void pair(IMarkupWriter writer, String name, int value) {
        this.pair(writer, name, Integer.toString(value));
    }

    private void pair(IMarkupWriter writer, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof IRenderDescription) {
            IRenderDescription renderValue = (IRenderDescription)value;
            writer.begin("tr");
            writer.attribute("class", this.getRowClass());
            writer.begin("th");
            writer.print(name);
            writer.end();
            writer.begin("td");
            renderValue.renderDescription(writer);
            writer.end("tr");
            return;
        }
        this.pair(writer, name, value.toString());
    }

    private void pair(IMarkupWriter writer, String name, String value) {
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        writer.begin("tr");
        writer.attribute("class", this.getRowClass());
        writer.begin("th");
        writer.print(name);
        writer.end();
        writer.begin("td");
        writer.print(value);
        writer.end("tr");
    }

    private void pair(IMarkupWriter writer, String name, boolean value) {
        this.pair(writer, name, value ? "yes" : "no");
    }

    private void readCookieMap() {
        this._cookieMap = new HashMap();
        Cookie[] cookies = this._request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                this._cookieMap.put(cookies[i].getName(), cookies[i]);
                ++i;
            }
        }
    }

    public void redirect(String path) throws IOException {
        String absolutePath = this.getAbsoluteURL(path);
        String encodedURL = this._response.encodeRedirectURL(absolutePath);
        this._response.sendRedirect(encodedURL);
    }

    private void section(IMarkupWriter writer, String sectionName) {
        writer.begin("tr");
        writer.attribute("class", "request-context-section");
        writer.begin("th");
        writer.attribute("colspan", 2);
        writer.print(sectionName);
        writer.end("tr");
    }

    private List getSorted(Enumeration e) {
        ArrayList result = new ArrayList();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        Collections.sort(result);
        return result;
    }

    public void write(IMarkupWriter writer) {
        writer.begin("table");
        writer.attribute("class", "request-context-border");
        writer.begin("tr");
        writer.begin("td");
        HttpSession session = this.getSession();
        if (session != null) {
            this.object(writer, "Session");
            writer.begin("table");
            writer.attribute("class", "request-context-object");
            this.section(writer, "Properties");
            this.header(writer, "Name", "Value");
            this.pair(writer, "id", session.getId());
            this.datePair(writer, "creationTime", session.getCreationTime());
            this.datePair(writer, "lastAccessedTime", session.getLastAccessedTime());
            this.pair(writer, "maxInactiveInterval", session.getMaxInactiveInterval());
            this.pair(writer, "new", session.isNew());
            List names = this.getSorted(session.getAttributeNames());
            int count = names.size();
            int i = 0;
            while (i < count) {
                if (i == 0) {
                    this.section(writer, "Attributes");
                    this.header(writer, "Name", "Value");
                }
                String name = (String)names.get(i);
                this.pair(writer, name, session.getAttribute(name));
                ++i;
            }
            writer.end();
        }
        this.object(writer, "Request");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        if (this._pathInfo == null) {
            this.buildPathInfo();
        }
        int i = 0;
        while (i < this._pathInfo.length) {
            if (i == 0) {
                this.section(writer, "Path Info");
                this.header(writer, "Index", "Value");
            }
            this.pair(writer, Integer.toString(i), this._pathInfo[i]);
            ++i;
        }
        List parameters = this.getSorted(this._request.getParameterNames());
        int count = parameters.size();
        int i2 = 0;
        while (i2 < count) {
            if (i2 == 0) {
                this.section(writer, "Parameters");
                this.header(writer, "Name", "Value(s)");
            }
            String name = (String)parameters.get(i2);
            String[] values = this._request.getParameterValues(name);
            writer.begin("tr");
            writer.attribute("class", this.getRowClass());
            writer.begin("th");
            writer.print(name);
            writer.end();
            writer.begin("td");
            if (values.length > 1) {
                writer.begin("ul");
            }
            int j = 0;
            while (j < values.length) {
                if (values.length > 1) {
                    writer.beginEmpty("li");
                }
                writer.print(values[j]);
                ++j;
            }
            writer.end("tr");
            ++i2;
        }
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "authType", this._request.getAuthType());
        this.pair(writer, "characterEncoding", this._request.getCharacterEncoding());
        this.pair(writer, "contentLength", this._request.getContentLength());
        this.pair(writer, "contentType", this._request.getContentType());
        this.pair(writer, "method", this._request.getMethod());
        this.pair(writer, "pathInfo", this._request.getPathInfo());
        this.pair(writer, "pathTranslated", this._request.getPathTranslated());
        this.pair(writer, "protocol", this._request.getProtocol());
        this.pair(writer, "queryString", this._request.getQueryString());
        this.pair(writer, "remoteAddr", this._request.getRemoteAddr());
        this.pair(writer, "remoteHost", this._request.getRemoteHost());
        this.pair(writer, "remoteUser", this._request.getRemoteUser());
        this.pair(writer, "requestedSessionId", this._request.getRequestedSessionId());
        this.pair(writer, "requestedSessionIdFromCookie", this._request.isRequestedSessionIdFromCookie());
        this.pair(writer, "requestedSessionIdFromURL", this._request.isRequestedSessionIdFromURL());
        this.pair(writer, "requestedSessionIdValid", this._request.isRequestedSessionIdValid());
        this.pair(writer, "requestURI", this._request.getRequestURI());
        this.pair(writer, "scheme", this._request.getScheme());
        this.pair(writer, "serverName", this._request.getServerName());
        this.pair(writer, "serverPort", this._request.getServerPort());
        this.pair(writer, "contextPath", this._request.getContextPath());
        this.pair(writer, "servletPath", this._request.getServletPath());
        List headers = this.getSorted(this._request.getHeaderNames());
        count = headers.size();
        int i3 = 0;
        while (i3 < count) {
            if (i3 == 0) {
                this.section(writer, "Headers");
                this.header(writer, "Name", "Value");
            }
            String name = (String)headers.get(i3);
            String value = this._request.getHeader(name);
            this.pair(writer, name, value);
            ++i3;
        }
        List attributes = this.getSorted(this._request.getAttributeNames());
        count = attributes.size();
        int i4 = 0;
        while (i4 < count) {
            if (i4 == 0) {
                this.section(writer, "Attributes");
                this.header(writer, "Name", "Value");
            }
            String name = (String)attributes.get(i4);
            this.pair(writer, name, this._request.getAttribute(name));
            ++i4;
        }
        Cookie[] cookies = this._request.getCookies();
        if (cookies != null) {
            int i5 = 0;
            while (i5 < cookies.length) {
                if (i5 == 0) {
                    this.section(writer, "Cookies");
                    this.header(writer, "Name", "Value");
                }
                Cookie cookie = cookies[i5];
                this.pair(writer, cookie.getName(), cookie.getValue());
                ++i5;
            }
        }
        writer.end();
        this.object(writer, "Servlet");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "servlet", (Object)this._servlet);
        this.pair(writer, "servletInfo", this._servlet.getServletInfo());
        ServletConfig config = this._servlet.getServletConfig();
        List names = this.getSorted(config.getInitParameterNames());
        count = names.size();
        int i6 = 0;
        while (i6 < count) {
            if (i6 == 0) {
                this.section(writer, "Init Parameters");
                this.header(writer, "Name", "Value");
            }
            String name = (String)names.get(i6);
            this.pair(writer, name, config.getInitParameter(name));
            ++i6;
        }
        writer.end();
        ServletContext context = config.getServletContext();
        this.object(writer, "Servlet Context");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "majorVersion", context.getMajorVersion());
        this.pair(writer, "minorVersion", context.getMinorVersion());
        this.pair(writer, "serverInfo", context.getServerInfo());
        names = this.getSorted(context.getInitParameterNames());
        count = names.size();
        int i7 = 0;
        while (i7 < count) {
            if (i7 == 0) {
                this.section(writer, "Initial Parameters");
                this.header(writer, "Name", "Value");
            }
            String name = (String)names.get(i7);
            this.pair(writer, name, context.getInitParameter(name));
            ++i7;
        }
        names = this.getSorted(context.getAttributeNames());
        count = names.size();
        int i8 = 0;
        while (i8 < count) {
            if (i8 == 0) {
                this.section(writer, "Attributes");
                this.header(writer, "Name", "Value");
            }
            String name = (String)names.get(i8);
            this.pair(writer, name, context.getAttribute(name));
            ++i8;
        }
        writer.end();
        this.writeSystemProperties(writer);
        writer.end("table");
    }

    private void writeSystemProperties(IMarkupWriter writer) {
        Properties properties = null;
        this.object(writer, "JVM System Properties");
        try {
            properties = System.getProperties();
        }
        catch (SecurityException se) {
            writer.print("<p>");
            writer.print(se.toString());
            return;
        }
        String pathSeparator = System.getProperty("path.separator", ";");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        ArrayList names = new ArrayList(((Hashtable)properties).keySet());
        Collections.sort(names);
        int count = names.size();
        int i = 0;
        while (i < count) {
            String name;
            String property;
            if (i == 0) {
                this.header(writer, "Name", "Value");
            }
            if ((property = properties.getProperty(name = (String)names.get(i))).indexOf(pathSeparator) > 0 && name.endsWith(".path")) {
                writer.begin("tr");
                writer.attribute("class", this.getRowClass());
                writer.begin("th");
                writer.print(name);
                writer.end();
                writer.begin("td");
                writer.begin("ul");
                StringTokenizer tokenizer = new StringTokenizer(property, pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    writer.beginEmpty("li");
                    writer.print(tokenizer.nextToken());
                }
                writer.end("tr");
            } else {
                this.pair(writer, name, property);
            }
            ++i;
        }
        writer.end();
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (!cycle.isRewinding()) {
            this.write(writer);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            _safe.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            _safe.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            _safe.set(i);
            ++i;
        }
        _safe.set(46);
        _safe.set(45);
        _safe.set(95);
        _safe.set(42);
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static class DefaultRequestDecoder
    implements IRequestDecoder {
        private DefaultRequestDecoder() {
        }

        public DecodedRequest decodeRequest(HttpServletRequest request) {
            DecodedRequest result = new DecodedRequest();
            result.setRequestURI(request.getRequestURI());
            result.setScheme(request.getScheme());
            result.setServerName(request.getServerName());
            result.setServerPort(request.getServerPort());
            return result;
        }
    }
}

