/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import net.sf.tapestry.IComponent;
import net.sf.tapestry.IPage;

public class PageLoaderException
extends Exception {
    private Throwable rootCause;
    private String pageName;
    private transient IComponent component;

    public PageLoaderException(String message, Throwable rootCause) {
        this(message, (IComponent)null, rootCause);
    }

    public PageLoaderException(String message, IComponent component, Throwable rootCause) {
        super(message);
        IPage page;
        this.rootCause = rootCause;
        this.component = component;
        if (component != null && (page = component.getPage()) != null) {
            this.pageName = page.getName();
        }
    }

    public PageLoaderException(String message, IComponent component) {
        this(message, component, null);
    }

    public PageLoaderException(String message, String pageName, Throwable rootCause) {
        this(message, (IComponent)null, rootCause);
        this.pageName = pageName;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public String getPageName() {
        return this.pageName;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }
}

