/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.Serializable;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;

public class ComponentAddress
implements Serializable {
    private String m_strPageName;
    private String m_strIdPath;

    public ComponentAddress(IComponent objComponent) {
        this.init(objComponent);
    }

    public ComponentAddress(String strPageName, String strIdPath) {
        this.m_strPageName = strPageName;
        this.m_strIdPath = strIdPath;
    }

    private void init(IComponent objComponent) {
        IPage objPage = objComponent.getPage();
        INamespace objNamespace = objPage.getNamespace();
        String strNamespace = objNamespace.getExtendedId();
        strNamespace = strNamespace == null ? "" : strNamespace + ":";
        this.m_strPageName = strNamespace + objPage.getName();
        this.m_strIdPath = objComponent.getIdPath();
    }

    public IComponent findComponent(IRequestCycle objCycle) {
        IPage objPage = objCycle.getPage(this.m_strPageName);
        return objPage.getNestedComponent(this.m_strIdPath);
    }

    public String getIdPath() {
        return this.m_strIdPath;
    }

    public String getPageName() {
        return this.m_strPageName;
    }

    public int hashCode() {
        return this.m_strPageName.hashCode() * 31 + this.m_strIdPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentAddress)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ComponentAddress objAddress = (ComponentAddress)obj;
        return this.getPageName().equals(objAddress.getPageName()) && this.getIdPath().equals(objAddress.getIdPath());
    }
}

