/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.ResourceResolver;
import net.sf.tapestry.parse.SpecificationParser;
import net.sf.tapestry.spec.IApplicationSpecification;
import net.sf.tapestry.util.exception.ExceptionAnalyzer;
import net.sf.tapestry.util.pool.Pool;
import net.sf.tapestry.util.xml.DocumentParseException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ApplicationServlet
extends HttpServlet {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$ApplicationServlet == null ? (class$net$sf$tapestry$ApplicationServlet = ApplicationServlet.class$("net.sf.tapestry.ApplicationServlet")) : class$net$sf$tapestry$ApplicationServlet));
    private static final String LOCALE_COOKIE_NAME = "net.sf.tapestry.locale";
    private Pool _enginePool = new Pool();
    private IApplicationSpecification _specification;
    private String _attributeName;
    static /* synthetic */ Class class$net$sf$tapestry$ApplicationServlet;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestContext context;
        block16: {
            block15: {
                context = null;
                try {
                    try {
                        context = new RequestContext(this, request, response);
                        IEngine engine = this.getEngine(context);
                        if (engine == null) {
                            throw new ServletException(Tapestry.getString("ApplicationServlet.could-not-locate-engine"));
                        }
                        boolean dirty = engine.service(context);
                        HttpSession session = context.getSession();
                        if (session != null) {
                            block14: {
                                try {
                                    boolean forceStore;
                                    boolean bl = forceStore = engine.isStateful() && session.getAttribute(this._attributeName) == null;
                                    if (forceStore || dirty) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Storing " + engine + " into session as " + this._attributeName));
                                        }
                                        engine.setRefreshing(true);
                                        session.setAttribute(this._attributeName, (Object)engine);
                                        engine.setRefreshing(false);
                                    }
                                }
                                catch (IllegalStateException ex) {
                                    if (!LOG.isDebugEnabled()) break block14;
                                    LOG.debug((Object)"Session invalidated.");
                                }
                            }
                            Object var9_11 = null;
                            if (context == null) return;
                            context.cleanup();
                            return;
                        }
                        if (engine.isStateful()) {
                            LOG.error((Object)("Engine " + engine + " is stateful even though there is no session.  Discarding the engine."));
                            break block15;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Returning " + engine + " to pool."));
                        }
                        this._enginePool.store(engine.getLocale(), engine);
                        break block16;
                    }
                    catch (ServletException ex) {
                        this.log("ServletException", ex);
                        this.show((Exception)((Object)ex));
                        throw ex;
                    }
                    catch (IOException ex) {
                        this.log("IOException", ex);
                        this.show(ex);
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (context == null) throw throwable;
                    context.cleanup();
                    throw throwable;
                }
            }
            Object var9_12 = null;
            if (context == null) return;
            context.cleanup();
            return;
        }
        Object var9_13 = null;
        if (context == null) return;
        context.cleanup();
    }

    protected void show(Exception ex) {
        System.err.println("\n\n**********************************************************\n\n");
        new ExceptionAnalyzer().reportException(ex, System.err);
        System.err.println("\n**********************************************************\n");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    public IApplicationSpecification getApplicationSpecification() {
        return this._specification;
    }

    protected IEngine getEngine(RequestContext context) throws ServletException {
        Locale locale;
        IEngine engine = null;
        HttpSession session = context.getSession();
        if (session != null) {
            engine = (IEngine)session.getAttribute(this._attributeName);
            if (engine != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Retrieved " + engine + " from session " + session.getId() + "."));
                }
                return engine;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Session exists, but doesn't contain an engine.");
            }
        }
        if ((engine = (IEngine)this._enginePool.retrieve(locale = this.getLocaleFromRequest(context))) == null) {
            engine = this.createEngine(context);
            engine.setLocale(locale);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using pooled engine " + engine + " (from locale " + locale + ")."));
        }
        return engine;
    }

    protected Locale getLocaleFromRequest(RequestContext context) throws ServletException {
        Cookie cookie = context.getCookie(LOCALE_COOKIE_NAME);
        if (cookie != null) {
            return Tapestry.getLocale(cookie.getValue());
        }
        return context.getRequest().getLocale();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setupLogging();
        this._specification = this.constructApplicationSpecification();
        this._attributeName = "net.sf.tapestry.engine." + config.getServletName();
    }

    protected IApplicationSpecification constructApplicationSpecification() throws ServletException {
        String path = this.getApplicationSpecificationPath();
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (stream == null) {
            throw new ServletException(Tapestry.getString("ApplicationServlet.could-not-load-spec", path));
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading application specification from " + path));
            }
            IApplicationSpecification iApplicationSpecification = this.parseApplicationSpecification(stream, path);
            Object var5_4 = null;
            this.close(stream);
            return iApplicationSpecification;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close(stream);
            throw throwable;
        }
    }

    protected IApplicationSpecification parseApplicationSpecification(InputStream stream, String path) throws ServletException {
        try {
            SpecificationParser parser = new SpecificationParser();
            return parser.parseApplicationSpecification(stream, path, new ResourceResolver((Object)this));
        }
        catch (DocumentParseException ex) {
            this.show(ex);
            throw new ServletException(Tapestry.getString("ApplicationServlet.could-not-parse-spec", path), (Throwable)ex);
        }
    }

    protected void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setupLogging() throws ServletException {
        Level level = Level.ERROR;
        String value = System.getProperty("net.sf.tapestry.root-logging-level");
        if (value != null) {
            level = Level.toLevel((String)value, (Level)Level.ERROR);
            Logger root = LogManager.getRootLogger();
            root.setLevel(level);
        }
    }

    protected String getApplicationSpecificationPath() throws ServletException {
        throw new ServletException(Tapestry.getString("ApplicationServlet.get-app-path-not-overriden", ((Object)((Object)this)).getClass().getName()));
    }

    protected IEngine createEngine(RequestContext context) throws ServletException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            String className = this._specification.getEngineClassName();
            if (className == null) {
                throw new ServletException(Tapestry.getString("ApplicationServlet.no-engine-class"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating engine from class " + className));
            }
            Class<?> engineClass = Class.forName(className, true, classLoader);
            IEngine result = (IEngine)engineClass.newInstance();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created engine " + result));
            }
            return result;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void writeLocaleCookie(Locale locale, IEngine engine, RequestContext cycle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing locale cookie " + locale));
        }
        Cookie cookie = new Cookie(LOCALE_COOKIE_NAME, locale.toString());
        cookie.setPath(engine.getServletPath());
        cycle.addCookie(cookie);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

